/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.Action;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.ui.ContextAnalyzer;
import org.netbeans.modules.refactoring.java.ui.CopyClassRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.MoveClassUI;
import org.netbeans.modules.refactoring.java.ui.RenameRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.SafeDeleteUI;
import org.netbeans.modules.refactoring.java.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.PasteType;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    public void doRename(Lookup lookup) {
        Runnable task = ContextAnalyzer.createTask(lookup, RenameRefactoringUI.factory(lookup));
        ScanDialog.runWhenScanFinished((Runnable)task, (String)RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.renameAction()));
    }

    static String getActionName(Action action) {
        String arg = (String)action.getValue("Name");
        arg = arg.replace("&", "");
        return arg.replace("...", "");
    }

    public boolean canRename(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        TreePathHandle tph = (TreePathHandle)n.getLookup().lookup(TreePathHandle.class);
        if (tph != null) {
            return JavaRefactoringUtils.isRefactorable(tph.getFileObject());
        }
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob == null) {
            return false;
        }
        FileObject fo = dob.getPrimaryFile();
        if (JavaRefactoringUtils.isRefactorable(fo)) {
            return true;
        }
        return dob instanceof DataFolder && RefactoringUtils.isFileInOpenProject(fo) && JavaRefactoringUtils.isOnSourceClasspath(fo) && !RefactoringUtils.isClasspathRoot(fo);
    }

    public void doCopy(Lookup lookup) {
        Runnable task = ContextAnalyzer.createTask(lookup, CopyClassRefactoringUI.factory(lookup));
        ScanDialog.runWhenScanFinished((Runnable)task, (String)RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.copyAction()));
    }

    public boolean canCopy(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        ExplorerContext drop = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        FileObject fo = RefactoringActionsProvider.getTarget(lookup);
        if (fo != null) {
            if (!fo.isFolder()) {
                return false;
            }
            if (!JavaRefactoringUtils.isOnSourceClasspath(fo)) {
                return false;
            }
            HashSet<DataFolder> folders = new HashSet<DataFolder>();
            boolean jdoFound = false;
            for (Node n : nodes) {
                DataObject dob = (DataObject)n.getLookup().lookup(DataObject.class);
                if (dob == null) {
                    return false;
                }
                if (!JavaRefactoringUtils.isOnSourceClasspath(dob.getPrimaryFile())) {
                    return false;
                }
                if (dob instanceof DataFolder) {
                    if (FileUtil.getRelativePath((FileObject)dob.getPrimaryFile(), (FileObject)fo) != null) {
                        return false;
                    }
                    folders.add((DataFolder)dob);
                    continue;
                }
                if (!RefactoringUtils.isJavaFile(dob.getPrimaryFile())) continue;
                jdoFound = true;
            }
            if (jdoFound) {
                return true;
            }
            for (DataFolder fold : folders) {
                Enumeration e = fold.children(true);
                while (e.hasMoreElements()) {
                    if (!RefactoringUtils.isJavaFile(((DataObject)e.nextElement()).getPrimaryFile())) continue;
                    return true;
                }
            }
            return false;
        }
        boolean result = false;
        block3: for (Node n : nodes) {
            DataObject dob = (DataObject)n.getCookie(DataObject.class);
            if (dob == null) {
                return false;
            }
            if (dob instanceof DataFolder) {
                if (drop == null) {
                    return false;
                }
                if (!JavaRefactoringUtils.isOnSourceClasspath(dob.getPrimaryFile()) || RefactoringUtils.isClasspathRoot(dob.getPrimaryFile())) {
                    return false;
                }
                LinkedList<DataFolder> folders = new LinkedList<DataFolder>();
                folders.add((DataFolder)dob);
                while (!folders.isEmpty()) {
                    DataFolder fold = (DataFolder)folders.remove();
                    Enumeration e = fold.children(true);
                    while (e.hasMoreElements()) {
                        if (RefactoringUtils.isJavaFile(((DataObject)e.nextElement()).getPrimaryFile())) {
                            result = true;
                            continue block3;
                        }
                        if (!(e instanceof DataFolder)) continue;
                        folders.add((DataFolder)e);
                    }
                }
            }
            if (!RefactoringUtils.isJavaFile(dob.getPrimaryFile()) || ClassPath.getClassPath((FileObject)dob.getPrimaryFile(), (String)"classpath/source") == null) continue;
            result = true;
        }
        return result;
    }

    public boolean canFindUsages(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        if (n.getLookup().lookup(TreePathHandle.class) != null) {
            return true;
        }
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        return dob != null && RefactoringUtils.isJavaFile(dob.getPrimaryFile()) && !"package-info".equals(dob.getName());
    }

    public void doFindUsages(Lookup lookup) {
        Runnable task = ContextAnalyzer.createTask(lookup, WhereUsedQueryUI.factory());
        task.run();
    }

    public boolean canDelete(Lookup lookup) {
        if (SourceUtils.isScanInProgress()) {
            return false;
        }
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (RefactoringActionsProvider.isSelectionHeterogeneous(nodes)) {
            return false;
        }
        for (Node n : nodes) {
            TreePathHandle tph = (TreePathHandle)n.getLookup().lookup(TreePathHandle.class);
            if (tph != null) {
                return JavaRefactoringUtils.isRefactorable(tph.getFileObject());
            }
            DataObject dataObject = (DataObject)n.getCookie(DataObject.class);
            if (dataObject == null) {
                return false;
            }
            FileObject fileObject = dataObject.getPrimaryFile();
            if (RefactoringActionsProvider.isRefactorableFolder(dataObject)) {
                return true;
            }
            if (JavaRefactoringUtils.isRefactorable(fileObject)) continue;
            return false;
        }
        return !nodes.isEmpty();
    }

    public void doDelete(Lookup lookup) {
        Runnable task = ContextAnalyzer.createTask(lookup, SafeDeleteUI.factory(lookup));
        ScanDialog.runWhenScanFinished((Runnable)task, (String)RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.safeDeleteAction()));
    }

    public static FileObject getTarget(Lookup look) {
        ExplorerContext drop = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (drop == null) {
            return null;
        }
        Node n = drop.getTargetNode();
        if (n == null) {
            return null;
        }
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob != null) {
            return dob.getPrimaryFile();
        }
        return null;
    }

    public static PasteType getPaste(Lookup look) {
        ExplorerContext drop = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (drop == null) {
            return null;
        }
        Transferable orig = drop.getTransferable();
        if (orig == null) {
            return null;
        }
        Node n = drop.getTargetNode();
        if (n == null) {
            return null;
        }
        PasteType[] pt = n.getPasteTypes(orig);
        if (pt.length == 1) {
            return null;
        }
        return pt[1];
    }

    static String getName(Lookup look) {
        ExplorerContext ren = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (ren == null) {
            return null;
        }
        return ren.getNewName();
    }

    public boolean canMove(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        ExplorerContext drop = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        FileObject fo = RefactoringActionsProvider.getTarget(lookup);
        if (fo != null) {
            if (!fo.isFolder()) {
                return false;
            }
            if (!JavaRefactoringUtils.isOnSourceClasspath(fo)) {
                return false;
            }
            HashSet<DataFolder> folders = new HashSet<DataFolder>();
            boolean jdoFound = false;
            for (Node n : nodes) {
                DataObject dob = (DataObject)n.getCookie(DataObject.class);
                if (dob == null) {
                    return false;
                }
                if (!JavaRefactoringUtils.isOnSourceClasspath(dob.getPrimaryFile())) {
                    return false;
                }
                if (dob instanceof DataFolder) {
                    if (FileUtil.getRelativePath((FileObject)dob.getPrimaryFile(), (FileObject)fo) != null) {
                        return false;
                    }
                    folders.add((DataFolder)dob);
                    continue;
                }
                if (!RefactoringUtils.isJavaFile(dob.getPrimaryFile())) continue;
                jdoFound = true;
            }
            if (jdoFound) {
                return true;
            }
            for (DataFolder fold : folders) {
                Enumeration e = fold.children(true);
                while (e.hasMoreElements()) {
                    if (!RefactoringUtils.isJavaFile(((DataObject)e.nextElement()).getPrimaryFile())) continue;
                    return true;
                }
            }
            return false;
        }
        boolean result = false;
        block3: for (Node n : nodes) {
            DataObject dob = (DataObject)n.getCookie(DataObject.class);
            if (dob == null) {
                return false;
            }
            if (dob instanceof DataFolder) {
                if (drop == null) {
                    return false;
                }
                if (!JavaRefactoringUtils.isOnSourceClasspath(dob.getPrimaryFile()) || RefactoringUtils.isClasspathRoot(dob.getPrimaryFile())) {
                    return false;
                }
                LinkedList<DataFolder> folders = new LinkedList<DataFolder>();
                folders.add((DataFolder)dob);
                while (!folders.isEmpty()) {
                    DataFolder fold = (DataFolder)folders.remove();
                    Enumeration e = fold.children(true);
                    while (e.hasMoreElements()) {
                        if (RefactoringUtils.isJavaFile(((DataObject)e.nextElement()).getPrimaryFile())) {
                            result = true;
                            continue block3;
                        }
                        if (!(e instanceof DataFolder)) continue;
                        folders.add((DataFolder)e);
                    }
                }
            }
            if (!JavaRefactoringUtils.isOnSourceClasspath(dob.getPrimaryFile())) {
                return false;
            }
            if (!RefactoringUtils.isJavaFile(dob.getPrimaryFile())) continue;
            result = true;
        }
        return result;
    }

    public void doMove(Lookup lookup) {
        Runnable task = ContextAnalyzer.createTask(lookup, MoveClassUI.factory(lookup));
        ScanDialog.runWhenScanFinished((Runnable)task, (String)RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.moveAction()));
    }

    private static boolean isSelectionHeterogeneous(Collection<? extends Node> nodes) {
        boolean folderSelected = false;
        boolean nonFolderNodeSelected = false;
        for (Node node : nodes) {
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject == null) continue;
            if (RefactoringActionsProvider.isRefactorableFolder(dataObject)) {
                if (folderSelected || nonFolderNodeSelected) {
                    return true;
                }
                folderSelected = true;
                continue;
            }
            nonFolderNodeSelected = true;
        }
        return false;
    }

    private static boolean isRefactorableFolder(DataObject dataObject) {
        FileObject[] children;
        FileObject fileObject = dataObject.getPrimaryFile();
        if (!(Boolean.TRUE.equals(fileObject.getAttribute("isRemoteAndSlow")) || (children = fileObject.getChildren()) != null && children.length > 0)) {
            return false;
        }
        return dataObject instanceof DataFolder && RefactoringUtils.isFileInOpenProject(fileObject) && JavaRefactoringUtils.isOnSourceClasspath(fileObject) && !RefactoringUtils.isClasspathRoot(fileObject);
    }
}

