/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.ui.MoveClassPanel;
import org.netbeans.modules.refactoring.java.ui.MoveClassUI;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class MoveClassesUI
implements RefactoringUI,
RefactoringUIBypass {
    private List<FileObject> resources;
    private Set<FileObject> javaObjects;
    private MoveClassPanel panel;
    private MoveRefactoring refactoring;
    private String targetPkgName = "";
    private boolean disable;
    private FileObject targetFolder;
    private PasteType pasteType;

    static final String getString(String key) {
        return NbBundle.getMessage(MoveClassUI.class, (String)key);
    }

    public MoveClassesUI(Set<FileObject> javaObjects) {
        this(javaObjects, null, null);
    }

    public MoveClassesUI(Set<FileObject> javaObjects, FileObject targetFolder, PasteType paste) {
        this.disable = targetFolder != null;
        this.targetFolder = targetFolder;
        this.javaObjects = javaObjects;
        this.pasteType = paste;
        if (!this.disable) {
            this.resources = new ArrayList<FileObject>(javaObjects);
        }
    }

    public String getName() {
        return MoveClassesUI.getString("LBL_MoveClasses");
    }

    public String getDescription() {
        return this.getName();
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            ClassPath cp;
            String pkgName = null;
            if (this.targetFolder != null && (cp = ClassPath.getClassPath((FileObject)this.targetFolder, (String)"classpath/source")) != null) {
                pkgName = cp.getResourceName(this.targetFolder, '.', false);
            }
            this.panel = new MoveClassPanel(parent, pkgName != null ? pkgName : MoveClassesUI.getDOPackageName(this.javaObjects.iterator().next().getParent()), MoveClassesUI.getString("LBL_MoveClassesHeadline"), MoveClassesUI.getString("LBL_MoveWithoutReferences"), this.targetFolder != null ? this.targetFolder : this.javaObjects.iterator().next(), this.disable, this.getNodes());
        }
        return this.panel;
    }

    private static String getDOPackageName(FileObject f) {
        ClassPath cp = ClassPath.getClassPath((FileObject)f, (String)"classpath/source");
        if (cp != null) {
            return cp.getResourceName(f, '.', false);
        }
        Logger.getLogger("org.netbeans.modules.refactoring.java").info("Cannot find classpath for " + f.getPath());
        return f.getName();
    }

    private String packageName() {
        return this.targetPkgName.trim().length() == 0 ? MoveClassesUI.getString("LBL_DefaultPackage") : this.targetPkgName.trim();
    }

    private Problem setParameters(boolean checkOnly) {
        if (this.panel == null) {
            return null;
        }
        URL url = URLMapper.findURL((FileObject)this.panel.getRootFolder(), (int)1);
        try {
            this.refactoring.setTarget(Lookups.singleton((Object)new URL(url.toExternalForm() + this.panel.getPackageName().replace('.', '/'))));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (checkOnly) {
            return this.refactoring.fastCheckParameters();
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    public AbstractRefactoring getRefactoring() {
        if (this.refactoring == null) {
            if (this.disable) {
                this.refactoring = new MoveRefactoring(Lookups.fixed((Object[])this.javaObjects.toArray()));
                this.refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor(this.javaObjects.toArray(new FileObject[this.javaObjects.size()])));
            } else {
                this.refactoring = new MoveRefactoring(Lookups.fixed((Object[])this.resources.toArray()));
                this.refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor(this.resources.toArray(new FileObject[this.resources.size()])));
            }
        }
        return this.refactoring;
    }

    private final Vector getNodes() {
        Vector<Node> result = new Vector<Node>(this.javaObjects.size());
        LinkedList<FileObject> q = new LinkedList<FileObject>(this.javaObjects);
        while (!q.isEmpty()) {
            FileObject f = q.removeFirst();
            if (!VisibilityQuery.getDefault().isVisible(f)) continue;
            DataObject d = null;
            try {
                d = DataObject.find((FileObject)f);
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
            if (d instanceof DataFolder) {
                for (DataObject o : ((DataFolder)d).getChildren()) {
                    q.addLast(o.getPrimaryFile());
                }
                continue;
            }
            result.add(d.getNodeDelegate());
        }
        return result;
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.refactoring.java.ui.MoveClassesUI");
    }

    public boolean isRefactoringBypassRequired() {
        return this.panel != null && this.panel.isRefactoringBypassRequired();
    }

    public void doRefactoringBypass() throws IOException {
        this.pasteType.paste();
    }
}

