/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.java.api.IntroduceLocalExtensionRefactoring;
import org.netbeans.modules.refactoring.java.ui.MoveClassPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class IntroduceLocalExtensionPanel
extends JPanel
implements CustomRefactoringPanel,
DocumentListener {
    private static final String REPLACEALL = "replaceall.introduceLocalExtension";
    private static final String WRAP = "wrap.introduceLocalExtension";
    private static final String EQUALITY = "equality.introduceLocalExtension";
    private final ListCellRenderer GROUP_CELL_RENDERER = new MoveClassPanel.GroupCellRenderer();
    private final ListCellRenderer PROJECT_CELL_RENDERER = new MoveClassPanel.ProjectCellRenderer();
    private final String typeName;
    private final Icon icon;
    private final String startPackage;
    private Project project;
    private SourceGroup[] groups;
    private final TreePathHandle tph;
    private String newName;
    private boolean initialized = false;
    private final ChangeListener parent;
    private JRadioButton btnDelegate;
    private JRadioButton btnGenerate;
    private JRadioButton btnSeperate;
    private JRadioButton btnSubtype;
    private JRadioButton btnWrap;
    private ButtonGroup btngroupEquality;
    private ButtonGroup btngroupType;
    private JCheckBox chkReplace;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel labelLocation;
    private JLabel labelNewName;
    private JLabel labelPackage;
    private JLabel labelProject;
    private JTextField newNameField;
    private JComboBox packageComboBox;
    private JComboBox projectsComboBox;
    private JComboBox rootComboBox;

    public IntroduceLocalExtensionPanel(String typeName, Icon icon, String newName, String startPackage, TreePathHandle tph, ChangeListener parent) {
        this.startPackage = startPackage;
        this.typeName = typeName;
        this.icon = icon;
        this.newName = newName;
        this.tph = tph;
        this.parent = parent;
        this.initComponents();
        this.rootComboBox.setRenderer(this.GROUP_CELL_RENDERER);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.projectsComboBox.setRenderer(this.PROJECT_CELL_RENDERER);
        this.enableEqualityRadioButtons();
    }

    public String getNewName() {
        return this.newNameField.getText();
    }

    public String getPackageName() {
        String packageName = this.packageComboBox.getEditor().getItem().toString();
        return packageName;
    }

    public FileObject getRootFolder() {
        SourceGroup sourceGroup = (SourceGroup)this.rootComboBox.getSelectedItem();
        return sourceGroup != null ? sourceGroup.getRootFolder() : null;
    }

    public boolean getWrap() {
        return this.btnWrap.isSelected();
    }

    public boolean getReplace() {
        return this.chkReplace.isSelected();
    }

    public IntroduceLocalExtensionRefactoring.Equality getEquality() {
        IntroduceLocalExtensionRefactoring.Equality[] values;
        int equality = RefactoringModule.getOption(EQUALITY, IntroduceLocalExtensionRefactoring.Equality.DELEGATE.ordinal());
        if (equality < (values = IntroduceLocalExtensionRefactoring.Equality.values()).length && equality >= 0) {
            return values[equality];
        }
        return IntroduceLocalExtensionRefactoring.Equality.DELEGATE;
    }

    private void initComponents() {
        this.btngroupType = new ButtonGroup();
        this.btngroupEquality = new ButtonGroup();
        this.newNameField = new JTextField();
        this.projectsComboBox = new JComboBox();
        this.labelLocation = new JLabel();
        this.rootComboBox = new JComboBox();
        this.labelPackage = new JLabel();
        this.packageComboBox = new JComboBox();
        this.labelProject = new JLabel();
        this.labelNewName = new JLabel();
        this.jPanel1 = new JPanel();
        this.btnWrap = new JRadioButton();
        this.btnSubtype = new JRadioButton();
        this.chkReplace = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.btnDelegate = new JRadioButton();
        this.btnGenerate = new JRadioButton();
        this.btnSeperate = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.newNameField.setText(NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.newNameField.text"));
        this.projectsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceLocalExtensionPanel.this.projectsComboBoxItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.labelLocation.text"));
        this.rootComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceLocalExtensionPanel.this.rootComboBoxItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.labelPackage, (String)NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.labelPackage.text"));
        this.packageComboBox.setEditable(true);
        Mnemonics.setLocalizedText((JLabel)this.labelProject, (String)NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.labelProject.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelNewName, (String)NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.labelNewName.text"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.jPanel1.border.title")));
        this.btngroupType.add(this.btnWrap);
        this.btnWrap.setSelected(RefactoringModule.getOption(WRAP, Boolean.TRUE));
        this.btnWrap.setText(NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.btnWrap.text"));
        this.btnWrap.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceLocalExtensionPanel.this.btnWrapItemStateChanged(evt);
            }
        });
        this.btngroupType.add(this.btnSubtype);
        this.btnSubtype.setSelected(Boolean.valueOf(RefactoringModule.getOption(WRAP, Boolean.TRUE)) == false);
        this.btnSubtype.setText(NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.btnSubtype.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnWrap).addComponent(this.btnSubtype)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnWrap).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSubtype)));
        this.chkReplace.setSelected(RefactoringModule.getOption(REPLACEALL, Boolean.TRUE));
        Mnemonics.setLocalizedText((AbstractButton)this.chkReplace, (String)NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.chkReplace.text"));
        this.chkReplace.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceLocalExtensionPanel.this.chkReplaceItemStateChanged(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.jPanel2.border.title")));
        this.btngroupEquality.add(this.btnDelegate);
        this.btnDelegate.setSelected(this.getEquality() == IntroduceLocalExtensionRefactoring.Equality.DELEGATE);
        this.btnDelegate.setText(NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.btnDelegate.text"));
        this.btnDelegate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceLocalExtensionPanel.this.btnDelegateItemStateChanged(evt);
            }
        });
        this.btngroupEquality.add(this.btnGenerate);
        this.btnGenerate.setSelected(this.getEquality() == IntroduceLocalExtensionRefactoring.Equality.GENERATE);
        this.btnGenerate.setText(NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.btnGenerate.text"));
        this.btnGenerate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceLocalExtensionPanel.this.btnGenerateItemStateChanged(evt);
            }
        });
        this.btngroupEquality.add(this.btnSeperate);
        this.btnSeperate.setSelected(this.getEquality() == IntroduceLocalExtensionRefactoring.Equality.SEPARATE);
        this.btnSeperate.setText(NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.btnSeperate.text"));
        this.btnSeperate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceLocalExtensionPanel.this.btnSeperateItemStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnDelegate).addComponent(this.btnGenerate).addComponent(this.btnSeperate));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.btnDelegate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGenerate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSeperate)));
        this.jLabel1.setText(NbBundle.getMessage(IntroduceLocalExtensionPanel.class, (String)"IntroduceLocalExtensionPanel.jLabel1.text"));
        this.jLabel2.setIcon(this.icon);
        this.jLabel2.setText(this.typeName);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelPackage, -2, 86, -2).addGap(7, 7, 7).addComponent(this.packageComboBox, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.labelNewName, -2, 87, -2).addGap(6, 6, 6).addComponent(this.newNameField)).addGroup(layout.createSequentialGroup().addComponent(this.labelProject, -2, 55, -2).addGap(38, 38, 38).addComponent(this.projectsComboBox, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.labelLocation, -2, 66, -2).addGap(27, 27, 27).addComponent(this.rootComboBox, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkReplace).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2))).addGap(0, 70, Short.MAX_VALUE))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGap(17, 17, 17)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.labelNewName)).addComponent(this.newNameField, -2, 25, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.labelProject)).addComponent(this.projectsComboBox, -2, -1, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.labelLocation)).addComponent(this.rootComboBox, -2, -1, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.labelPackage)).addComponent(this.packageComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.chkReplace))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void projectsComboBoxItemStateChanged(ItemEvent evt) {
        this.project = (Project)this.projectsComboBox.getSelectedItem();
        this.updateRoots();
        this.updatePackages();
        this.fireChange();
    }

    private void rootComboBoxItemStateChanged(ItemEvent evt) {
        this.updatePackages();
        this.fireChange();
    }

    private void chkReplaceItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(REPLACEALL, b);
        this.parent.stateChanged(null);
    }

    private void btnWrapItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(WRAP, b);
        this.parent.stateChanged(null);
        this.enableEqualityRadioButtons();
    }

    private void btnDelegateItemStateChanged(ItemEvent evt) {
        boolean b;
        boolean bl = b = evt.getStateChange() == 1;
        if (b) {
            RefactoringModule.setOption(EQUALITY, IntroduceLocalExtensionRefactoring.Equality.DELEGATE.ordinal());
            this.parent.stateChanged(null);
        }
    }

    private void btnGenerateItemStateChanged(ItemEvent evt) {
        boolean b;
        boolean bl = b = evt.getStateChange() == 1;
        if (b) {
            RefactoringModule.setOption(EQUALITY, IntroduceLocalExtensionRefactoring.Equality.GENERATE.ordinal());
            this.parent.stateChanged(null);
        }
    }

    private void btnSeperateItemStateChanged(ItemEvent evt) {
        boolean b;
        boolean bl = b = evt.getStateChange() == 1;
        if (b) {
            RefactoringModule.setOption(EQUALITY, IntroduceLocalExtensionRefactoring.Equality.SEPARATE.ordinal());
            this.parent.stateChanged(null);
        }
    }

    private void updatePackages() {
        SourceGroup g = (SourceGroup)this.rootComboBox.getSelectedItem();
        this.packageComboBox.setModel(g != null ? PackageView.createListView((SourceGroup)g) : new DefaultComboBoxModel());
    }

    private void updateRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.groups = sources.getSourceGroups("java");
        int preselectedItem = 0;
        FileObject fo = this.tph.getFileObject();
        for (int i = 0; i < this.groups.length; ++i) {
            if (fo == null) continue;
            try {
                if (!this.groups[i].contains(fo)) continue;
                preselectedItem = i;
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        if (this.groups.length > 0) {
            this.rootComboBox.setSelectedIndex(preselectedItem);
        }
    }

    private void enableEqualityRadioButtons() {
        boolean wrap = RefactoringModule.getOption(WRAP, Boolean.TRUE);
        Enumeration<AbstractButton> elements = this.btngroupEquality.getElements();
        while (elements.hasMoreElements()) {
            AbstractButton abstractButton = elements.nextElement();
            abstractButton.setEnabled(wrap);
        }
    }

    public void initialize() {
        Component textField;
        if (this.initialized) {
            return;
        }
        FileObject fo = this.tph.getFileObject();
        Project fileOwner = fo != null ? FileOwnerQuery.getOwner((FileObject)fo) : null;
        this.project = fileOwner != null ? fileOwner : OpenProjects.getDefault().getOpenProjects()[0];
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        Arrays.sort(openProjects, new MoveClassPanel.ProjectByDisplayNameComparator());
        DefaultComboBoxModel<Project> projectsModel = new DefaultComboBoxModel<Project>(openProjects);
        this.projectsComboBox.setModel(projectsModel);
        this.projectsComboBox.setSelectedItem(this.project);
        this.updateRoots();
        this.updatePackages();
        if (this.startPackage != null) {
            this.packageComboBox.setSelectedItem(this.startPackage);
        }
        if (this.newName != null) {
            FileObject fob;
            do {
                if ((fob = fo.getParent().getFileObject(this.newName + ".java")) == null) continue;
                this.newName = this.newName + "1";
            } while (fob != null);
            this.newNameField.setText(this.newName);
            this.newNameField.setSelectionStart(0);
            this.newNameField.setSelectionEnd(this.newNameField.getText().length());
        }
        if ((textField = this.packageComboBox.getEditor().getEditorComponent()) instanceof JTextField) {
            ((JTextField)textField).getDocument().addDocumentListener(this);
        }
        this.newNameField.getDocument().addDocumentListener(this);
        JavaSource source = JavaSource.forFileObject((FileObject)this.tph.getFileObject());
        try {
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController info) {
                    try {
                        info.toPhase(JavaSource.Phase.RESOLVED);
                        Element klass = IntroduceLocalExtensionPanel.this.tph.resolveElement((CompilationInfo)info);
                        if (klass != null && klass.getModifiers().contains((Object)Modifier.FINAL)) {
                            IntroduceLocalExtensionPanel.this.btnWrap.setSelected(true);
                            Enumeration<AbstractButton> buttons = IntroduceLocalExtensionPanel.this.btngroupType.getElements();
                            while (buttons.hasMoreElements()) {
                                buttons.nextElement().setEnabled(false);
                            }
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }

                public void cancel() {
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.initialized = true;
    }

    public Component getComponent() {
        return this;
    }

    private void fireChange() {
        this.parent.stateChanged(null);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireChange();
    }
}

