/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.ui.JavaRefactoringUIFactory;
import org.netbeans.modules.refactoring.java.ui.RefactoringActionsProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class ContextAnalyzer {
    private static final Set<TypeKind> NOT_ACCEPTED_TYPES = EnumSet.of(TypeKind.ERROR, TypeKind.NONE, TypeKind.OTHER, TypeKind.VOID);
    public static ShowUI SHOW = new ShowUI(){

        @Override
        public void show(RefactoringUI ui, TopComponent activetc) {
            if (ui != null) {
                UI.openRefactoringUI((RefactoringUI)ui, (TopComponent)activetc);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRenameKeyword"));
            }
        }
    };

    public static Runnable createTask(Lookup context, final JavaRefactoringUIFactory factory) {
        EditorCookie ec = (EditorCookie)context.lookup(EditorCookie.class);
        Runnable task = ContextAnalyzer.isFromEditor(ec) ? new TextComponentTask(ec){

            @Override
            protected RefactoringUI createRefactoringUI(TreePathHandle selectedElement, int startOffset, int endOffset, CompilationInfo info) {
                FileObject[] file;
                TreePathHandle[] handles;
                if (selectedElement != null) {
                    handles = new TreePathHandle[]{selectedElement};
                    file = new FileObject[]{selectedElement.getFileObject()};
                } else {
                    handles = new TreePathHandle[]{};
                    file = new FileObject[]{info.getFileObject()};
                }
                return factory.create(info, handles, file, new NonRecursiveFolder[0]);
            }
        } : (ContextAnalyzer.nodeHandle(context) ? new TreePathHandleTask(new HashSet(context.lookupAll(Node.class)), false){
            RefactoringUI ui;
            private boolean created;

            @Override
            protected void treePathHandleResolved(TreePathHandle handle, CompilationInfo javac) {
                if (this.size() == 1) {
                    this.ui = factory.create(javac, new TreePathHandle[]{handle}, null, new NonRecursiveFolder[0]);
                    this.created = true;
                }
            }

            @Override
            protected RefactoringUI createRefactoringUI(Collection<TreePathHandle> handles) {
                if (!this.created) {
                    this.ui = factory.create(null, handles.toArray(new TreePathHandle[handles.size()]), null, new NonRecursiveFolder[0]);
                }
                return this.ui;
            }
        } : new NodeToFileObjectTask(new HashSet(context.lookupAll(Node.class))){
            RefactoringUI ui;
            private boolean created;
            {
                super(x0);
                this.created = false;
            }

            @Override
            protected void nodeTranslated(Node node, Collection<TreePathHandle> handles, CompilationInfo javac) {
                if (this.size() == 1) {
                    this.ui = factory.create(javac, handles.toArray(new TreePathHandle[1]), new FileObject[]{handles.iterator().next().getFileObject()}, new NonRecursiveFolder[0]);
                    this.created = true;
                }
            }

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] selectedElements, Collection<TreePathHandle> handles) {
                if (!this.created) {
                    this.ui = factory.create(null, handles.toArray(new TreePathHandle[handles.size()]), selectedElements, this.pkg.toArray(new NonRecursiveFolder[this.pkg.size()]));
                }
                return this.ui;
            }
        });
        return task;
    }

    private static boolean isFromEditor(EditorCookie ec) {
        TopComponent activetc;
        return ec != null && ec.getOpenedPanes() != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    public static boolean canRefactorSingle(Lookup lookup, boolean notOnlyFile, boolean onlyFromEditor) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        Node node = (Node)nodes.iterator().next();
        TreePathHandle tph = (TreePathHandle)node.getLookup().lookup(TreePathHandle.class);
        if (tph != null) {
            if (JavaRefactoringUtils.isRefactorable(tph.getFileObject())) {
                return !onlyFromEditor || ContextAnalyzer.isFromEditor((EditorCookie)lookup.lookup(EditorCookie.class));
            }
            return false;
        }
        DataObject dObj = (DataObject)node.getLookup().lookup(DataObject.class);
        if (null == dObj) {
            return false;
        }
        FileObject fileObj = dObj.getPrimaryFile();
        if (null == fileObj || !JavaRefactoringUtils.isRefactorable(fileObj)) {
            return false;
        }
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (ContextAnalyzer.isFromEditor(ec)) {
            return true;
        }
        return !notOnlyFile;
    }

    static TreePath validateSelection(CompilationInfo ci, int start, int end) {
        return ContextAnalyzer.validateSelection(ci, start, end, NOT_ACCEPTED_TYPES);
    }

    public static TreePath validateSelection(CompilationInfo ci, int start, int end, Set<TypeKind> ignoredTypes) {
        for (TreePath tp = ci.getTreeUtilities().pathFor((start + end) / 2 + 1); tp != null; tp = tp.getParentPath()) {
            Tree leaf = tp.getLeaf();
            if (!ExpressionTree.class.isAssignableFrom(leaf.getKind().asInterface()) && (leaf.getKind() != Tree.Kind.VARIABLE || ((VariableTree)leaf).getInitializer() == null)) continue;
            long treeStart = ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), leaf);
            long treeEnd = ci.getTrees().getSourcePositions().getEndPosition(ci.getCompilationUnit(), leaf);
            if (treeStart != (long)start || treeEnd != (long)end) continue;
            TypeMirror type = ci.getTrees().getTypeMirror(tp);
            if (type != null && type.getKind() == TypeKind.ERROR) {
                type = ci.getTrees().getOriginalType((ErrorType)type);
            }
            if (type == null || ignoredTypes.contains((Object)type.getKind()) || tp.getLeaf().getKind() == Tree.Kind.ASSIGNMENT || tp.getLeaf().getKind() == Tree.Kind.ANNOTATION) continue;
            if (!ContextAnalyzer.isInsideClass(tp)) {
                return null;
            }
            TreePath candidate = tp;
            for (tp = tp.getParentPath(); tp != null; tp = tp.getParentPath()) {
                switch (tp.getLeaf().getKind()) {
                    case VARIABLE: {
                        VariableTree vt = (VariableTree)tp.getLeaf();
                        if (vt.getInitializer() == leaf) {
                            return candidate;
                        }
                        return null;
                    }
                    case NEW_CLASS: {
                        NewClassTree nct = (NewClassTree)tp.getLeaf();
                        if (!nct.getIdentifier().equals(candidate.getLeaf())) break;
                        for (ExpressionTree expressionTree : nct.getArguments()) {
                            if (expressionTree != leaf) continue;
                            return candidate;
                        }
                        return null;
                    }
                }
                leaf = tp.getLeaf();
            }
            return candidate;
        }
        return null;
    }

    private static boolean isInsideClass(TreePath tp) {
        while (tp != null) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
                return true;
            }
            tp = tp.getParentPath();
        }
        return false;
    }

    private static boolean nodeHandle(Lookup lookup) {
        Node n = (Node)lookup.lookup(Node.class);
        return n != null && n.getLookup().lookup(TreePathHandle.class) != null;
    }

    private static abstract class NodeToElementTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private Node node;
        private RefactoringUI ui;

        public NodeToElementTask(Collection<? extends Node> nodes) {
            assert (nodes.size() == 1);
            this.node = nodes.iterator().next();
        }

        public void cancel() {
        }

        public void run(CompilationController info) throws Exception {
            info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            CompilationUnitTree unit = info.getCompilationUnit();
            if (unit.getTypeDecls().isEmpty()) {
                this.ui = this.createRefactoringUI(null, (CompilationInfo)info);
            } else {
                TreePathHandle representedObject = TreePathHandle.create((TreePath)TreePath.getPath(unit, unit.getTypeDecls().get(0)), (CompilationInfo)info);
                this.ui = this.createRefactoringUI(representedObject, (CompilationInfo)info);
            }
        }

        @Override
        public final void run() {
            DataObject o = (DataObject)this.node.getCookie(DataObject.class);
            JavaSource source = JavaSource.forFileObject((FileObject)o.getPrimaryFile());
            assert (source != null);
            try {
                source.runUserActionTask((Task)this, true);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_NoTypeDecls"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(TreePathHandle var1, CompilationInfo var2);
    }

    private static abstract class NodeToFileObjectTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private Collection<? extends Node> nodes;
        public ArrayList<NonRecursiveFolder> pkg;
        Collection<TreePathHandle> handles = new ArrayList<TreePathHandle>();
        private Node currentNode;

        public NodeToFileObjectTask(Collection<? extends Node> nodes) {
            this.nodes = nodes;
        }

        protected int size() {
            return this.nodes.size();
        }

        public void cancel() {
        }

        public void run(CompilationController info) throws Exception {
            info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            ArrayList<TreePathHandle> handlesPerNode = new ArrayList<TreePathHandle>();
            CompilationUnitTree unit = info.getCompilationUnit();
            ArrayList<TreePathHandle> publicHandles = new ArrayList<TreePathHandle>();
            ArrayList<TreePathHandle> sameNameHandles = new ArrayList<TreePathHandle>();
            for (Tree tree : unit.getTypeDecls()) {
                TreePathHandle representedObject;
                Element e = info.getTrees().getElement(TreePath.getPath(unit, tree));
                if (e == null || !e.getKind().isClass() && !e.getKind().isInterface()) continue;
                if (e.getSimpleName().toString().equals(info.getFileObject().getName())) {
                    representedObject = TreePathHandle.create((TreePath)TreePath.getPath(unit, tree), (CompilationInfo)info);
                    sameNameHandles.add(representedObject);
                }
                if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                representedObject = TreePathHandle.create((TreePath)TreePath.getPath(unit, tree), (CompilationInfo)info);
                publicHandles.add(representedObject);
            }
            if (!publicHandles.isEmpty()) {
                handlesPerNode.addAll(publicHandles);
            } else {
                handlesPerNode.addAll(sameNameHandles);
            }
            if (!handlesPerNode.isEmpty()) {
                this.handles.addAll(handlesPerNode);
                this.nodeTranslated(this.currentNode, handlesPerNode, (CompilationInfo)info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileObject[] fobs = new FileObject[this.nodes.size()];
            this.pkg = new ArrayList();
            int i = 0;
            for (Node node : this.nodes) {
                NonRecursiveFolder nonrecursivefolder;
                DataObject dob = (DataObject)node.getCookie(DataObject.class);
                if (dob == null) continue;
                fobs[i] = dob.getPrimaryFile();
                if (RefactoringUtils.isJavaFile(fobs[i])) {
                    JavaSource source = JavaSource.forFileObject((FileObject)fobs[i]);
                    assert (source != null);
                    try {
                        this.currentNode = node;
                        source.runUserActionTask((Task)this, true);
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        this.currentNode = null;
                    }
                }
                if ((nonrecursivefolder = (NonRecursiveFolder)node.getLookup().lookup(NonRecursiveFolder.class)) != null) {
                    this.pkg.add(nonrecursivefolder);
                }
                ++i;
            }
            RefactoringUI ui = this.createRefactoringUI(fobs, this.handles);
            if (ui != null) {
                UI.openRefactoringUI((RefactoringUI)ui);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_NoTypeDecls"));
            }
        }

        protected void nodeTranslated(Node node, Collection<TreePathHandle> handles, CompilationInfo javac) {
        }

        protected abstract RefactoringUI createRefactoringUI(FileObject[] var1, Collection<TreePathHandle> var2);
    }

    public static interface ShowUI {
        public void show(RefactoringUI var1, TopComponent var2);
    }

    private static abstract class TextComponentTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private JTextComponent textC;
        private int caret;
        private int start;
        private int end;
        private RefactoringUI ui;
        private boolean selection;

        public TextComponentTask(EditorCookie ec) {
            this.textC = ec.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            boolean bl = this.selection = this.start != this.end && (this.start != -1 || this.end != -1);
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        public void cancel() {
        }

        public void run(final CompilationController cc) throws Exception {
            cc.toPhase(JavaSource.Phase.RESOLVED);
            final int c = this.selection ? this.start : this.caret;
            final TreePath[] selectedElement = new TreePath[]{null};
            Document doc = cc.getDocument();
            doc.render(new Runnable(){

                @Override
                public void run() {
                    selectedElement[0] = ContextAnalyzer.validateSelection((CompilationInfo)cc, TextComponentTask.this.start, TextComponentTask.this.end);
                    if (selectedElement[0] == null) {
                        TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)cc.getTokenHierarchy(), (int)c);
                        int adjustedCaret = c;
                        ts.move(c);
                        if (ts.moveNext() && ts.token() != null && ts.token().id() == JavaTokenId.IDENTIFIER) {
                            adjustedCaret = ts.offset() + ts.token().length() / 2 + 1;
                        }
                        selectedElement[0] = cc.getTreeUtilities().pathFor(adjustedCaret);
                    }
                }
            });
            if (selectedElement[0].getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                List<? extends Tree> decls = cc.getCompilationUnit().getTypeDecls();
                if (!decls.isEmpty()) {
                    TreePath path = TreePath.getPath(cc.getCompilationUnit(), decls.get(0));
                    if (path != null && cc.getTrees().getElement(path) != null) {
                        selectedElement[0] = path;
                    }
                } else {
                    selectedElement[0] = null;
                }
            }
            this.ui = this.createRefactoringUI(selectedElement[0] != null ? TreePathHandle.create((TreePath)selectedElement[0], (CompilationInfo)cc) : null, this.start, this.end, (CompilationInfo)cc);
        }

        @Override
        public final void run() {
            try {
                JavaSource source = JavaSource.forDocument((Document)this.textC.getDocument());
                source.runUserActionTask((Task)this, true);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
                return;
            }
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            SHOW.show(this.ui, activetc);
        }

        protected abstract RefactoringUI createRefactoringUI(TreePathHandle var1, int var2, int var3, CompilationInfo var4);
    }

    private static abstract class TreePathHandleTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private Collection<TreePathHandle> handles = new ArrayList<TreePathHandle>();
        private TreePathHandle current;
        boolean renameFile;

        public TreePathHandleTask(Collection<? extends Node> nodes) {
            this(nodes, false);
        }

        public int size() {
            return this.handles.size();
        }

        public TreePathHandleTask(Collection<? extends Node> nodes, boolean useFirstHandle) {
            for (Node node : nodes) {
                TreePathHandle temp = (TreePathHandle)node.getLookup().lookup(TreePathHandle.class);
                if (temp == null) continue;
                this.handles.add(temp);
                if (!useFirstHandle) continue;
                break;
            }
        }

        public TreePathHandleTask(TreePathHandle tph) {
            this.handles.add(tph);
        }

        public void cancel() {
        }

        public void run(CompilationController info) throws Exception {
            info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            Element el = this.current.resolveElement((CompilationInfo)info);
            if (el != null && el instanceof TypeElement && !((TypeElement)el).getNestingKind().isNested() && info.getFileObject().getName().equals(el.getSimpleName().toString())) {
                this.renameFile = true;
            }
            this.treePathHandleResolved(this.current, (CompilationInfo)info);
        }

        @Override
        public void run() {
            for (TreePathHandle handle : this.handles) {
                FileObject f = handle.getFileObject();
                if (f == null) {
                    TopComponent top = (TopComponent)EditorRegistry.lastFocusedComponent().getParent().getParent().getParent().getParent();
                    f = (FileObject)top.getLookup().lookup(FileObject.class);
                }
                this.current = handle;
                JavaSource source = JavaSource.forFileObject((FileObject)f);
                assert (source != null);
                try {
                    source.runUserActionTask((Task)this, true);
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            RefactoringUI ui = this.createRefactoringUI(this.handles);
            if (ui != null) {
                UI.openRefactoringUI((RefactoringUI)ui, (TopComponent)activetc);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRenameKeyword"));
            }
        }

        protected void treePathHandleResolved(TreePathHandle handle, CompilationInfo javac) {
        }

        protected abstract RefactoringUI createRefactoringUI(Collection<TreePathHandle> var1);
    }
}

