/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.spi.ui;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.spi.ui.JavaRefactoringActionDelegate;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

final class JavaRefactoringGlobalAction
extends NodeAction {
    private final JavaRefactoringActionDelegate delegate;

    public JavaRefactoringGlobalAction(String name, JavaRefactoringActionDelegate delegate) {
        this.setName(name);
        this.delegate = delegate;
    }

    public final String getName() {
        return (String)this.getValue("Name");
    }

    protected void setName(String name) {
        this.putValue("Name", name);
    }

    protected void setMnemonic(char m) {
        this.putValue("MnemonicKey", new Integer(m));
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Lookup context) {
        return this.delegate.isEnabled(context);
    }

    public void performAction(Lookup context) {
        EditorCookie ec = JavaRefactoringGlobalAction.getEditorCookie(context);
        if (ec != null) {
            new TextComponentRunnable(ec, this.delegate).run();
        }
    }

    protected Lookup getLookup(Node[] n) {
        InstanceContent ic = new InstanceContent();
        for (Node node : n) {
            ic.add((Object)node);
        }
        AbstractLookup result = new AbstractLookup((AbstractLookup.Content)ic);
        EditorCookie tc = JavaRefactoringGlobalAction.getEditorCookie((Lookup)result);
        if (tc != null) {
            ic.add((Object)tc);
        }
        ic.add(new Hashtable(0));
        return result;
    }

    static EditorCookie getEditorCookie(Lookup context) {
        TopComponent activetc;
        Node n;
        EditorCookie ck = (EditorCookie)context.lookup(EditorCookie.class);
        if (ck == null && (n = (Node)context.lookup(Node.class)) != null && (ck = (EditorCookie)n.getLookup().lookup(EditorCookie.class)) != null && !((activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane)) {
            ck = null;
        }
        return ck;
    }

    public final void performAction(Node[] activatedNodes) {
        this.performAction(this.getLookup(activatedNodes));
    }

    protected boolean enable(Node[] activatedNodes) {
        return this.enable(this.getLookup(activatedNodes));
    }

    protected boolean asynchronous() {
        return false;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ContextAction(actionContext);
    }

    protected class ContextAction
    implements Action,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar {
        Lookup context;

        public ContextAction(Lookup context) {
            this.context = context;
        }

        @Override
        public Object getValue(String arg0) {
            return JavaRefactoringGlobalAction.this.getValue(arg0);
        }

        @Override
        public void putValue(String arg0, Object arg1) {
            JavaRefactoringGlobalAction.this.putValue(arg0, arg1);
        }

        @Override
        public void setEnabled(boolean arg0) {
            JavaRefactoringGlobalAction.this.setEnabled(arg0);
        }

        @Override
        public boolean isEnabled() {
            return JavaRefactoringGlobalAction.this.enable(this.context);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener arg0) {
            JavaRefactoringGlobalAction.this.addPropertyChangeListener(arg0);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener arg0) {
            JavaRefactoringGlobalAction.this.removePropertyChangeListener(arg0);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JavaRefactoringGlobalAction.this.performAction(this.context);
        }

        public JMenuItem getMenuPresenter() {
            if (this.isMethodOverridden(JavaRefactoringGlobalAction.this, "getMenuPresenter")) {
                return JavaRefactoringGlobalAction.this.getMenuPresenter();
            }
            return new Actions.MenuItem((Action)this, true);
        }

        public JMenuItem getPopupPresenter() {
            if (this.isMethodOverridden(JavaRefactoringGlobalAction.this, "getPopupPresenter")) {
                return JavaRefactoringGlobalAction.this.getPopupPresenter();
            }
            return new Actions.MenuItem((Action)this, false);
        }

        public Component getToolbarPresenter() {
            if (this.isMethodOverridden(JavaRefactoringGlobalAction.this, "getToolbarPresenter")) {
                return JavaRefactoringGlobalAction.this.getToolbarPresenter();
            }
            JButton button = new JButton();
            Actions.connect((AbstractButton)button, (Action)this);
            return button;
        }

        private boolean isMethodOverridden(NodeAction d, String name) {
            try {
                Method m = d.getClass().getMethod(name, new Class[0]);
                return m.getDeclaringClass() != CallableSystemAction.class;
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Error searching for method " + name + " in " + d);
            }
        }
    }

    private static final class TextComponentRunnable
    implements Runnable,
    CancellableTask<CompilationController> {
        private final JTextComponent textC;
        private final int caret;
        private final int start;
        private final int end;
        private RefactoringUI ui;
        private final JavaRefactoringActionDelegate delegate;

        public TextComponentRunnable(EditorCookie ec, JavaRefactoringActionDelegate delegate) {
            this.delegate = delegate;
            this.textC = ec.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        @Override
        public final void run() {
            try {
                JavaSource source = JavaSource.forDocument((Document)this.textC.getDocument());
                source.runUserActionTask((Task)this, false);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                return;
            }
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)activetc);
            } else {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)this.delegate.getErrorMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
        }

        public void cancel() {
        }

        public void run(CompilationController cc) throws Exception {
            List<? extends Tree> decls;
            TreePath selectedElement = null;
            cc.toPhase(JavaSource.Phase.RESOLVED);
            selectedElement = cc.getTreeUtilities().pathFor(this.caret);
            if (selectedElement.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT && !(decls = cc.getCompilationUnit().getTypeDecls()).isEmpty()) {
                selectedElement = TreePath.getPath(cc.getCompilationUnit(), decls.get(0));
            }
            this.ui = this.delegate.createRefactoringUI(TreePathHandle.create((TreePath)selectedElement, (CompilationInfo)cc), this.start, this.end, (CompilationInfo)cc);
        }
    }
}

