/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.spi;

import com.sun.source.tree.CompilationUnitTree;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.java.spi.JavaModificationResult;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.netbeans.modules.refactoring.spi.ModificationResult;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class JavaRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin {
    @Deprecated
    protected volatile boolean cancelRequest = false;
    protected final AtomicBoolean cancelRequested = new AtomicBoolean();
    private volatile CancellableTask currentTask;
    private WorkingTask workingTask = new WorkingTask();

    public static Transaction createTransaction(@NonNull Collection<org.netbeans.api.java.source.ModificationResult> modifications) {
        return new RefactoringCommit(JavaRefactoringPlugin.createJavaModifications(modifications));
    }

    private static Collection<ModificationResult> createJavaModifications(Collection<org.netbeans.api.java.source.ModificationResult> modifications) {
        LinkedList<ModificationResult> result = new LinkedList<ModificationResult>();
        for (org.netbeans.api.java.source.ModificationResult r : modifications) {
            result.add(new JavaModificationResult(r));
        }
        return result;
    }

    protected Problem preCheck(CompilationController javac) throws IOException {
        return null;
    }

    protected Problem checkParameters(CompilationController javac) throws IOException {
        return null;
    }

    protected Problem fastCheckParameters(CompilationController javac) throws IOException {
        return null;
    }

    protected abstract JavaSource getJavaSource(Phase var1);

    public Problem preCheck() {
        this.cancelRequest = false;
        this.cancelRequested.set(false);
        return this.workingTask.run(Phase.PRECHECK);
    }

    public Problem checkParameters() {
        return this.workingTask.run(Phase.CHECKPARAMETERS);
    }

    public Problem fastCheckParameters() {
        return this.workingTask.run(Phase.FASTCHECKPARAMETERS);
    }

    public void cancelRequest() {
        this.cancelRequest = true;
        this.cancelRequested.set(true);
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
    }

    protected ClasspathInfo getClasspathInfo(AbstractRefactoring refactoring) {
        ClasspathInfo cpInfo = (ClasspathInfo)refactoring.getContext().lookup(ClasspathInfo.class);
        if (cpInfo == null) {
            Collection handles = refactoring.getRefactoringSource().lookupAll(TreePathHandle.class);
            cpInfo = !handles.isEmpty() ? RefactoringUtils.getClasspathInfoFor(handles.toArray(new TreePathHandle[handles.size()])) : JavaRefactoringUtils.getClasspathInfoFor(new FileObject[]{null});
            refactoring.getContext().add((Object)cpInfo);
        }
        return cpInfo;
    }

    protected static Problem createProblem(Problem result, boolean isFatal, String message) {
        Problem problem = new Problem(isFatal, message);
        return JavaPluginUtils.chainProblems(result, problem);
    }

    protected static Problem isElementAvail(TreePathHandle e, CompilationInfo info) {
        String elName;
        if (e == null) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElNotAvail"));
        }
        Element el = e.resolveElement(info);
        String string = elName = el != null ? el.getSimpleName().toString() : null;
        if (el == null || el.asType().getKind() == TypeKind.ERROR || "<error>".equals(elName)) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElementNotResolved"));
        }
        if ("this".equals(elName) || "super".equals(elName)) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"ERR_CannotRefactorThis", (Object)el.getSimpleName()));
        }
        return null;
    }

    private Iterable<? extends List<FileObject>> groupByRoot(Iterable<? extends FileObject> data) {
        HashMap<FileObject, LinkedList<FileObject>> result = new HashMap<FileObject, LinkedList<FileObject>>();
        for (FileObject fileObject : data) {
            FileObject root;
            if (this.cancelRequested.get()) {
                return Collections.emptyList();
            }
            ClassPath cp = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (cp == null || (root = cp.findOwnerRoot(fileObject)) == null) continue;
            LinkedList<FileObject> subr = (LinkedList<FileObject>)result.get(root);
            if (subr == null) {
                subr = new LinkedList<FileObject>();
                result.put(root, subr);
            }
            subr.add(fileObject);
        }
        return result.values();
    }

    protected final Collection<org.netbeans.api.java.source.ModificationResult> processFiles(Set<FileObject> files, CancellableTask<WorkingCopy> task) throws IOException {
        return this.processFiles(files, task, null);
    }

    protected final Collection<org.netbeans.api.java.source.ModificationResult> processFiles(Set<FileObject> files, CancellableTask<WorkingCopy> task, ClasspathInfo info) throws IOException {
        return this.processFiles(files, task, info, true);
    }

    protected final void queryFiles(Set<FileObject> files, CancellableTask<? extends CompilationController> task) throws IOException {
        this.processFiles(files, task, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<org.netbeans.api.java.source.ModificationResult> processFiles(Set<FileObject> files, CancellableTask<? extends CompilationController> task, ClasspathInfo info, boolean modification) throws IOException {
        this.currentTask = task;
        LinkedList<org.netbeans.api.java.source.ModificationResult> results = new LinkedList<org.netbeans.api.java.source.ModificationResult>();
        try {
            Iterable<? extends List<FileObject>> work = this.groupByRoot(files);
            for (List<FileObject> list : work) {
                if (this.cancelRequested.get()) {
                    List<org.netbeans.api.java.source.ModificationResult> list2 = Collections.emptyList();
                    return list2;
                }
                JavaSource javaSource = JavaSource.create((ClasspathInfo)(info == null ? ClasspathInfo.create((FileObject)list.get(0)) : info), list);
                if (modification) {
                    results.add(javaSource.runModificationTask(task));
                    continue;
                }
                javaSource.runUserActionTask((Task)this.currentTask, true);
            }
        }
        finally {
            this.currentTask = null;
        }
        return results;
    }

    protected final Problem createAndAddElements(Set<FileObject> files, CancellableTask<WorkingCopy> task, RefactoringElementsBag elements, AbstractRefactoring refactoring, ClasspathInfo info) {
        try {
            Collection<org.netbeans.api.java.source.ModificationResult> results = this.processFiles(files, task, info);
            elements.registerTransaction(JavaRefactoringPlugin.createTransaction(results));
            for (org.netbeans.api.java.source.ModificationResult result : results) {
                for (FileObject jfo : result.getModifiedFileObjects()) {
                    for (ModificationResult.Difference dif : result.getDifferences(jfo)) {
                        elements.add(refactoring, (RefactoringElementImplementation)DiffElement.create(dif, jfo, result));
                    }
                }
            }
        }
        catch (IOException e) {
            return this.createProblemAndLog(null, e);
        }
        return null;
    }

    protected final Problem createAndAddElements(Set<FileObject> files, CancellableTask<WorkingCopy> task, RefactoringElementsBag elements, AbstractRefactoring refactoring) {
        return this.createAndAddElements(files, task, elements, refactoring, null);
    }

    protected final Problem createProblemAndLog(Problem p, Throwable t) {
        Problem newProblem;
        Throwable cause = t.getCause();
        if (cause != null && (cause.getClass().getName().equals("org.netbeans.api.java.source.JavaSource$InsufficientMemoryException") || cause.getCause() != null && cause.getCause().getClass().getName().equals("org.netbeans.api.java.source.JavaSource$InsufficientMemoryException"))) {
            newProblem = new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_OutOfMemory"));
        } else {
            String msg = NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ExceptionThrown", (Object)t.toString());
            newProblem = new Problem(true, msg);
        }
        Exceptions.printStackTrace((Throwable)t);
        if (p == null) {
            return newProblem;
        }
        Problem problem = p;
        while (problem.getNext() != null) {
            problem = problem.getNext();
        }
        problem.setNext(newProblem);
        return p;
    }

    protected static enum Phase {
        PRECHECK,
        FASTCHECKPARAMETERS,
        CHECKPARAMETERS,
        PREPARE;

    }

    protected class TransformTask
    implements CancellableTask<WorkingCopy> {
        private RefactoringVisitor visitor;
        private TreePathHandle treePathHandle;

        public TransformTask(RefactoringVisitor visitor, TreePathHandle searchedItem) {
            this.visitor = visitor;
            this.treePathHandle = searchedItem;
        }

        public void cancel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(WorkingCopy compiler) throws IOException {
            try {
                try {
                    this.visitor.setWorkingCopy(compiler);
                }
                catch (ToPhaseException e) {
                    JavaRefactoringPlugin.this.fireProgressListenerStep();
                    return;
                }
                CompilationUnitTree cu = compiler.getCompilationUnit();
                if (cu == null) {
                    ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + compiler);
                    return;
                }
                Element el = null;
                if (this.treePathHandle != null && (el = this.treePathHandle.resolveElement((CompilationInfo)compiler)) == null) {
                    ErrorManager.getDefault().log(16, "Cannot resolve " + this.treePathHandle + "in " + compiler.getFileObject().getPath());
                    return;
                }
                this.visitor.scan(compiler.getCompilationUnit(), el);
            }
            finally {
                JavaRefactoringPlugin.this.fireProgressListenerStep();
            }
        }
    }

    private class WorkingTask
    implements Task<CompilationController> {
        private Phase whatRun;
        private Problem problem;

        private WorkingTask() {
        }

        private Problem run(Phase s) {
            this.whatRun = s;
            this.problem = null;
            JavaSource js = JavaRefactoringPlugin.this.getJavaSource(s);
            if (js == null) {
                return null;
            }
            try {
                js.runUserActionTask((Task)this, true);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return this.problem;
        }

        public void run(CompilationController javac) throws Exception {
            switch (this.whatRun) {
                case PRECHECK: {
                    this.problem = JavaRefactoringPlugin.this.preCheck(javac);
                    break;
                }
                case CHECKPARAMETERS: {
                    this.problem = JavaRefactoringPlugin.this.checkParameters(javac);
                    break;
                }
                case FASTCHECKPARAMETERS: {
                    this.problem = JavaRefactoringPlugin.this.fastCheckParameters(javac);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

