/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.ReplaceConstructorWithFactoryRefactoring;
import org.netbeans.modules.refactoring.java.plugins.ReplaceConstructorWithBuilderPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.spi.java.hints.support.TransformationSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ReplaceConstructorWithFactoryPlugin
implements RefactoringPlugin {
    private final ReplaceConstructorWithFactoryRefactoring replaceConstructorRefactoring;
    private final AtomicBoolean cancel = new AtomicBoolean();

    public ReplaceConstructorWithFactoryPlugin(ReplaceConstructorWithFactoryRefactoring replaceConstructorRefactoring) {
        this.replaceConstructorRefactoring = replaceConstructorRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        String factoryName = this.replaceConstructorRefactoring.getFactoryName();
        if (factoryName == null || factoryName.length() == 0) {
            return new Problem(true, "No factory method name specified.");
        }
        if (!SourceVersion.isIdentifier(factoryName)) {
            return new Problem(true, factoryName + " is not an identifier.");
        }
        return null;
    }

    public final Problem prepare(RefactoringElementsBag refactoringElements) {
        this.cancel.set(false);
        final TreePathHandle constr = (TreePathHandle)this.replaceConstructorRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
        final String[] ruleCode = new String[1];
        final String[] toCode = new String[1];
        try {
            ModificationResult mod = JavaSource.forFileObject((FileObject)constr.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy parameter) throws Exception {
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath constrPath = constr.resolve((CompilationInfo)parameter);
                    MethodTree constructor = (MethodTree)constrPath.getLeaf();
                    TypeElement parent = (TypeElement)parameter.getTrees().getElement(constrPath.getParentPath());
                    TreeMaker make = parameter.getTreeMaker();
                    StringBuilder parameters = new StringBuilder();
                    StringBuilder constraints = new StringBuilder();
                    StringBuilder realParameters = new StringBuilder();
                    int count = 1;
                    for (VariableTree variableTree : constructor.getParameters()) {
                        if (count > 1) {
                            parameters.append(", ");
                            constraints.append(" && ");
                            realParameters.append(", ");
                        }
                        realParameters.append(variableTree.getName());
                        parameters.append("$").append(count);
                        constraints.append("$").append(count).append(" instanceof ").append(parameter.getTrees().getTypeMirror(new TreePath(new TreePath(constrPath, variableTree), variableTree.getType())));
                        ++count;
                    }
                    EnumSet<Modifier> factoryMods = EnumSet.of(Modifier.STATIC);
                    factoryMods.addAll(constructor.getModifiers().getFlags());
                    MethodTree methodTree = make.Method(make.Modifiers(factoryMods), (CharSequence)ReplaceConstructorWithFactoryPlugin.this.replaceConstructorRefactoring.getFactoryName(), (Tree)make.QualIdent((Element)parent), Collections.emptyList(), constructor.getParameters(), Collections.emptyList(), "{ return new " + parent.getSimpleName() + "(" + realParameters + "); }", null);
                    parameter.rewrite(constrPath.getParentPath().getLeaf(), (Tree)GeneratorUtilities.get((WorkingCopy)parameter).insertClassMember((ClassTree)constrPath.getParentPath().getLeaf(), (Tree)methodTree));
                    EnumSet<Modifier> constructorMods = EnumSet.of(Modifier.PRIVATE);
                    parameter.rewrite((Tree)constructor.getModifiers(), (Tree)make.Modifiers(constructorMods));
                    StringBuilder rule = new StringBuilder();
                    rule.append("new ").append(parent.getQualifiedName()).append("(").append((CharSequence)parameters).append(")");
                    if (constraints.length() > 0) {
                        rule.append(" :: ").append((CharSequence)constraints);
                    }
                    ruleCode[0] = rule.toString();
                    toCode[0] = parent.getQualifiedName() + "." + ReplaceConstructorWithFactoryPlugin.this.replaceConstructorRefactoring.getFactoryName() + "(" + parameters + ")";
                    toCode[0] = toCode[0] + ";;";
                }
            });
            ArrayList<ModificationResult> results = new ArrayList<ModificationResult>();
            results.add(mod);
            results.addAll(TransformationSupport.create((String)(ruleCode[0] + " => " + toCode[0])).setCancel(this.cancel).processAllProjects());
            ReplaceConstructorWithBuilderPlugin.createAndAddElements(this.replaceConstructorRefactoring, refactoringElements, results);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public void cancelRequest() {
        this.cancel.set(true);
    }
}

