/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.matching.Occurrence;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.ReplaceConstructorWithBuilderRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.spi.java.hints.support.TransformationSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ReplaceConstructorWithBuilderPlugin
implements RefactoringPlugin {
    private final ReplaceConstructorWithBuilderRefactoring replaceConstructorWithBuilder;
    private final AtomicBoolean cancel = new AtomicBoolean();

    public ReplaceConstructorWithBuilderPlugin(ReplaceConstructorWithBuilderRefactoring refactoring) {
        this.replaceConstructorWithBuilder = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        String name;
        String builderName = this.replaceConstructorWithBuilder.getBuilderName();
        if (builderName == null || builderName.length() == 0) {
            return new Problem(true, NbBundle.getMessage(ReplaceConstructorWithBuilderPlugin.class, (String)"ERR_NoFactory"));
        }
        if (!SourceVersion.isName(builderName)) {
            return new Problem(true, NbBundle.getMessage(ReplaceConstructorWithBuilderPlugin.class, (String)"ERR_NotIdentifier", (Object)builderName));
        }
        TreePathHandle constr = (TreePathHandle)this.replaceConstructorWithBuilder.getRefactoringSource().lookup(TreePathHandle.class);
        ClassPath classPath = ClassPath.getClassPath((FileObject)constr.getFileObject(), (String)"classpath/source");
        FileObject resource = classPath.findResource(name = this.replaceConstructorWithBuilder.getBuilderName().replace(".", "/") + ".java");
        if (resource != null) {
            return new Problem(true, NbBundle.getMessage(ReplaceConstructorWithBuilderPlugin.class, (String)"ERR_FileExists", (Object)name));
        }
        Problem problem = null;
        for (ReplaceConstructorWithBuilderRefactoring.Setter set : this.replaceConstructorWithBuilder.getSetters()) {
            if (!set.isOptional() || set.getDefaultValue() != null) continue;
            problem = JavaPluginUtils.chainProblems(problem, new Problem(false, NbBundle.getMessage(ReplaceConstructorWithBuilderPlugin.class, (String)"WRN_NODEFAULT", (Object)set.getVarName())));
        }
        return problem;
    }

    public final Problem prepare(RefactoringElementsBag refactoringElements) {
        this.cancel.set(false);
        final TreePathHandle constr = (TreePathHandle)this.replaceConstructorWithBuilder.getRefactoringSource().lookup(TreePathHandle.class);
        final String[] ruleCode = new String[1];
        String[] toCode = new String[1];
        final String[] parentSimpleName = new String[1];
        try {
            ModificationResult mod = JavaSource.forFileObject((FileObject)constr.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath constrPath = constr.resolve((CompilationInfo)workingCopy);
                    MethodTree constructor = (MethodTree)constrPath.getLeaf();
                    TypeElement parent = (TypeElement)workingCopy.getTrees().getElement(constrPath.getParentPath());
                    parentSimpleName[0] = parent.getSimpleName().toString();
                    TreeMaker make = workingCopy.getTreeMaker();
                    StringBuilder parameters = new StringBuilder();
                    StringBuilder constraints = new StringBuilder();
                    StringBuilder realParameters = new StringBuilder();
                    int count = 1;
                    for (VariableTree variableTree : constructor.getParameters()) {
                        if (count > 1) {
                            parameters.append(", ");
                            constraints.append(" && ");
                            realParameters.append(", ");
                        }
                        realParameters.append(variableTree.getName());
                        parameters.append("$").append(count);
                        constraints.append("$").append(count).append(" instanceof ").append(workingCopy.getTrees().getTypeMirror(new TreePath(new TreePath(constrPath, variableTree), variableTree.getType())));
                        ++count;
                    }
                    ArrayList<Tree> members = new ArrayList<Tree>();
                    String string = ReplaceConstructorWithBuilderPlugin.this.replaceConstructorWithBuilder.getBuilderName().substring(ReplaceConstructorWithBuilderPlugin.this.replaceConstructorWithBuilder.getBuilderName().lastIndexOf(46) + 1);
                    StringBuilder args = null;
                    for (ReplaceConstructorWithBuilderRefactoring.Setter set : ReplaceConstructorWithBuilderPlugin.this.replaceConstructorWithBuilder.getSetters()) {
                        members.add(make.Variable(make.Modifiers(Collections.singleton(Modifier.PRIVATE)), (CharSequence)set.getVarName(), (Tree)make.QualIdent(set.getType()), set.getDefaultValue() == null ? null : make.Identifier((CharSequence)set.getDefaultValue())));
                        if (args == null) {
                            args = new StringBuilder();
                        } else {
                            args.append(", ");
                        }
                        args.append(set.getVarName());
                    }
                    members.add(make.Constructor(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{}"));
                    for (ReplaceConstructorWithBuilderRefactoring.Setter set : ReplaceConstructorWithBuilderPlugin.this.replaceConstructorWithBuilder.getSetters()) {
                        members.add(make.Method(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)set.getName(), make.Type(string), Collections.emptyList(), Collections.singletonList(make.Variable(make.Modifiers(Collections.emptySet()), (CharSequence)set.getVarName(), (Tree)make.QualIdent(set.getType()), null)), Collections.emptyList(), "{this." + set.getVarName() + " = " + set.getVarName() + ";\nreturn this;}", null));
                    }
                    for (ReplaceConstructorWithBuilderRefactoring.Setter set : ReplaceConstructorWithBuilderPlugin.this.replaceConstructorWithBuilder.getSetters()) {
                    }
                    members.add(make.Method(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)("create" + parent.getSimpleName()), make.Type(parent.asType()), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{return new " + parent.getSimpleName() + "(" + (args == null ? "" : args) + ");}", null));
                    ClassTree builder = make.Class(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)string, Collections.EMPTY_LIST, null, Collections.EMPTY_LIST, members);
                    FileObject root = ClassPath.getClassPath((FileObject)constr.getFileObject(), (String)"classpath/source").findOwnerRoot(constr.getFileObject());
                    CompilationUnitTree builderUnit = make.CompilationUnit(root, ReplaceConstructorWithBuilderPlugin.this.replaceConstructorWithBuilder.getBuilderName().replace('.', '/') + ".java", Collections.EMPTY_LIST, Collections.singletonList(builder));
                    workingCopy.rewrite(null, (Tree)builderUnit);
                    StringBuilder rule = new StringBuilder();
                    rule.append("new ").append(parent.getQualifiedName()).append("(").append((CharSequence)parameters).append(")");
                    if (constraints.length() > 0) {
                        rule.append(" :: ").append((CharSequence)constraints);
                    }
                    rule.append(";;");
                    ruleCode[0] = rule.toString();
                }
            });
            ArrayList<ModificationResult> results = new ArrayList<ModificationResult>();
            results.add(mod);
            results.addAll(TransformationSupport.create((String)ruleCode[0], (TransformationSupport.Transformer)new TransformationSupport.Transformer(){

                public void transform(WorkingCopy copy, Occurrence occurrence) {
                    TreeMaker make = copy.getTreeMaker();
                    ExpressionTree expression = make.NewClass(null, Collections.EMPTY_LIST, make.QualIdent(ReplaceConstructorWithBuilderPlugin.this.replaceConstructorWithBuilder.getBuilderName()), Collections.EMPTY_LIST, null);
                    int i = 0;
                    for (ReplaceConstructorWithBuilderRefactoring.Setter set : ReplaceConstructorWithBuilderPlugin.this.replaceConstructorWithBuilder.getSetters()) {
                        Tree value = ((TreePath)occurrence.getVariables().get("$" + ++i)).getLeaf();
                        if (set.isOptional() && ReplaceConstructorWithBuilderPlugin.this.treeEquals(copy, value, set.getDefaultValue())) continue;
                        expression = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(expression, (CharSequence)set.getName()), Collections.singletonList((ExpressionTree)value));
                    }
                    MethodInvocationTree create = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(expression, (CharSequence)("create" + parentSimpleName[0])), Collections.emptyList());
                    copy.rewrite(occurrence.getOccurrenceRoot().getLeaf(), (Tree)create);
                }
            }).setCancel(this.cancel).processAllProjects());
            ReplaceConstructorWithBuilderPlugin.createAndAddElements(this.replaceConstructorWithBuilder, refactoringElements, results);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static void createAndAddElements(AbstractRefactoring refactoring, RefactoringElementsBag elements, Collection<ModificationResult> results) {
        elements.registerTransaction(JavaRefactoringPlugin.createTransaction(results));
        for (ModificationResult result : results) {
            for (FileObject jfo : result.getModifiedFileObjects()) {
                for (ModificationResult.Difference diff : result.getDifferences(jfo)) {
                    elements.add(refactoring, (RefactoringElementImplementation)DiffElement.create(diff, jfo, result));
                }
            }
        }
    }

    private boolean treeEquals(WorkingCopy copy, Tree value, String defaultValue) {
        ExpressionTree parseExpression;
        if (defaultValue == null) {
            return false;
        }
        defaultValue = defaultValue.trim();
        if (value instanceof LiteralTree && (parseExpression = copy.getTreeUtilities().parseExpression(defaultValue, new SourcePositions[1])) instanceof LiteralTree) {
            return ((LiteralTree)value).getValue().equals(((LiteralTree)parseExpression).getValue());
        }
        return defaultValue.equals(value.toString());
    }

    public void cancelRequest() {
        this.cancel.set(true);
    }
}

