/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.RenameTransformer;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RenameRefactoringPlugin
extends JavaRefactoringPlugin {
    private TreePathHandle treePathHandle = null;
    private Collection<ExecutableElement> overriddenByMethods = null;
    private Collection<ExecutableElement> overridesMethods = null;
    private boolean doCheckName = true;
    private RenameRefactoring refactoring;
    private Set<ElementHandle<ExecutableElement>> allMethods = new HashSet<ElementHandle<ExecutableElement>>();

    public RenameRefactoringPlugin(RenameRefactoring rename) {
        this.refactoring = rename;
        TreePathHandle tph = (TreePathHandle)rename.getRefactoringSource().lookup(TreePathHandle.class);
        if (tph != null) {
            this.treePathHandle = tph;
        } else {
            JavaSource source = JavaSource.forFileObject((FileObject)((FileObject)rename.getRefactoringSource().lookup(FileObject.class)));
            try {
                source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController co) throws Exception {
                        co.toPhase(JavaSource.Phase.RESOLVED);
                        CompilationUnitTree cut = co.getCompilationUnit();
                        for (Tree tree : cut.getTypeDecls()) {
                            Element e = co.getTrees().getElement(TreePath.getPath(cut, tree));
                            if (e == null || !e.getSimpleName().toString().equals(co.getFileObject().getName())) continue;
                            RenameRefactoringPlugin.this.treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(cut, tree), (CompilationInfo)co);
                            RenameRefactoringPlugin.this.refactoring.getContext().add((Object)co);
                            break;
                        }
                    }
                }, false);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        if (this.treePathHandle == null) {
            return null;
        }
        switch (p) {
            case PRECHECK: 
            case FASTCHECKPARAMETERS: {
                return JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
            }
            case CHECKPARAMETERS: {
                if (this.treePathHandle == null) {
                    return null;
                }
                ClasspathInfo cpInfo = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
                JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
                return source;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected Problem preCheck(CompilationController info) throws IOException {
        Problem preCheckProblem = null;
        this.fireProgressListenerStart(1, 4);
        info.toPhase(JavaSource.Phase.RESOLVED);
        Element el = this.treePathHandle.resolveElement((CompilationInfo)info);
        preCheckProblem = RenameRefactoringPlugin.isElementAvail(this.treePathHandle, (CompilationInfo)info);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        preCheckProblem = JavaPluginUtils.isSourceElement(el, (CompilationInfo)info);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        switch (el.getKind()) {
            case METHOD: {
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                this.overriddenByMethods = JavaRefactoringUtils.getOverridingMethods((ExecutableElement)el, (CompilationInfo)info, this.cancelRequested);
                this.fireProgressListenerStep();
                if (el.getModifiers().contains((Object)Modifier.NATIVE)) {
                    preCheckProblem = RenameRefactoringPlugin.createProblem(preCheckProblem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_RenameNative", (Object)el));
                }
                if (!this.overriddenByMethods.isEmpty()) {
                    String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_IsOverridden")).format(new Object[]{info.getElementUtilities().enclosingTypeElement(el).getSimpleName().toString()});
                    preCheckProblem = RenameRefactoringPlugin.createProblem(preCheckProblem, false, msg);
                    for (ExecutableElement method : this.overriddenByMethods) {
                        if (JavaRefactoringUtils.getOverriddenMethods(method, (CompilationInfo)info).size() <= 1) continue;
                        preCheckProblem = RenameRefactoringPlugin.createProblem(preCheckProblem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_IsOverriddenOverrides", (Object)method));
                        break;
                    }
                }
                for (ExecutableElement e : this.overriddenByMethods) {
                    if (!e.getModifiers().contains((Object)Modifier.NATIVE)) continue;
                    preCheckProblem = RenameRefactoringPlugin.createProblem(preCheckProblem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_RenameNative", (Object)e));
                }
                this.overridesMethods = JavaRefactoringUtils.getOverriddenMethods((ExecutableElement)el, (CompilationInfo)info);
                this.fireProgressListenerStep();
                if (this.overridesMethods.isEmpty()) break;
                boolean fatal = false;
                for (ExecutableElement method : this.overridesMethods) {
                    ElementHandle handle;
                    if (method.getModifiers().contains((Object)Modifier.NATIVE)) {
                        preCheckProblem = RenameRefactoringPlugin.createProblem(preCheckProblem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_RenameNative", (Object)method));
                    }
                    if (!RefactoringUtils.isFromLibrary((ElementHandle<? extends Element>)(handle = ElementHandle.create((Element)method)), info.getClasspathInfo())) continue;
                    fatal = true;
                    break;
                }
                String msg = fatal ? RenameRefactoringPlugin.getString("ERR_Overrides_Fatal") : RenameRefactoringPlugin.getString("ERR_Overrides");
                preCheckProblem = RenameRefactoringPlugin.createProblem(preCheckProblem, fatal, msg);
                break;
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                Element hiddenField = this.hides(el, el.getSimpleName().toString(), (CompilationInfo)info);
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                if (hiddenField == null) break;
                String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_Hides")).format(new Object[]{info.getElementUtilities().enclosingTypeElement(hiddenField)});
                preCheckProblem = RenameRefactoringPlugin.createProblem(preCheckProblem, false, msg);
                break;
            }
            case PACKAGE: {
                break;
            }
            case LOCAL_VARIABLE: {
                break;
            }
            case CLASS: 
            case INTERFACE: 
            case ANNOTATION_TYPE: 
            case ENUM: {
                break;
            }
        }
        this.fireProgressListenerStop();
        return preCheckProblem;
    }

    @Override
    protected Problem fastCheckParameters(CompilationController info) throws IOException {
        Problem fastCheckProblem = null;
        info.toPhase(JavaSource.Phase.RESOLVED);
        TreePath treePath = this.treePathHandle.resolve((CompilationInfo)info);
        Element element = this.treePathHandle.resolveElement((CompilationInfo)info);
        ElementKind kind = element.getKind();
        String newName = this.refactoring.getNewName();
        String oldName = element.getSimpleName().toString();
        if (oldName.equals(newName)) {
            boolean nameNotChanged = true;
            if (kind.isClass() && !((TypeElement)element).getNestingKind().isNested()) {
                nameNotChanged = info.getFileObject().getName().contentEquals(((TypeElement)element).getSimpleName());
            }
            if (nameNotChanged) {
                fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, true, RenameRefactoringPlugin.getString("ERR_NameNotChanged"));
                return fastCheckProblem;
            }
        }
        if (!Utilities.isJavaIdentifier((String)newName)) {
            String s = kind == ElementKind.PACKAGE ? RenameRefactoringPlugin.getString("ERR_InvalidPackage") : RenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
            String msg = new MessageFormat(s).format(new Object[]{newName});
            fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, true, msg);
            return fastCheckProblem;
        }
        if ((kind.isClass() || kind.isInterface()) && !((TypeElement)element).getNestingKind().isNested()) {
            FileObject existing;
            TypeElement typeElement = (TypeElement)element;
            ElementHandle handle = ElementHandle.create((Element)typeElement);
            FileObject primFile = SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo());
            FileObject folder = primFile.getParent();
            if (this.doCheckName) {
                String oldfqn = typeElement.getQualifiedName().toString();
                String newFqn = oldfqn.substring(0, oldfqn.lastIndexOf(oldName));
                String pkgname = oldfqn;
                int i = pkgname.indexOf(46);
                pkgname = i >= 0 ? pkgname.substring(0, i) : "";
                if (RefactoringUtils.typeExists(newFqn, (CompilationInfo)info)) {
                    String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassClash")).format(new Object[]{newName, pkgname});
                    fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, true, msg);
                    return fastCheckProblem;
                }
                Enumeration enumeration = folder.getFolders(false);
                while (enumeration.hasMoreElements()) {
                    FileObject subfolder = (FileObject)enumeration.nextElement();
                    if (!subfolder.getName().equals(newName)) continue;
                    String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassPackageClash")).format(new Object[]{newName, pkgname});
                    fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, true, msg);
                    return fastCheckProblem;
                }
            }
            if ((existing = folder.getFileObject(newName, primFile.getExt())) != null && primFile != existing) {
                String msg = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)newName, (Object)folder.getPath());
                fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, true, msg);
            }
        } else if (kind == ElementKind.LOCAL_VARIABLE || kind == ElementKind.PARAMETER) {
            String msg = RefactoringUtils.variableClashes(newName, treePath, (CompilationInfo)info);
            if (msg != null) {
                fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, true, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_LocVariableClash", (Object)msg));
                return fastCheckProblem;
            }
        } else {
            String msg = this.clashes(element, newName, (CompilationInfo)info);
            if (msg != null) {
                fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, true, msg);
                return fastCheckProblem;
            }
        }
        if (newName.contains("$")) {
            fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_DollarWarning"));
        }
        if ((kind.isClass() || kind.isInterface()) && !Character.isUpperCase(newName.charAt(0))) {
            fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_UpperCaseWarning"));
        }
        return fastCheckProblem;
    }

    @Override
    protected Problem checkParameters(CompilationController info) throws IOException {
        Problem checkProblem = null;
        int steps = 0;
        if (this.overriddenByMethods != null) {
            steps += this.overriddenByMethods.size();
        }
        if (this.overridesMethods != null) {
            steps += this.overridesMethods.size();
        }
        this.fireProgressListenerStart(2, 8 + 3 * steps);
        info.toPhase(JavaSource.Phase.RESOLVED);
        Element element = this.treePathHandle.resolveElement((CompilationInfo)info);
        this.fireProgressListenerStep();
        this.fireProgressListenerStep();
        if (element.getKind() == ElementKind.METHOD) {
            checkProblem = this.checkMethodForOverriding((ExecutableElement)element, this.refactoring.getNewName(), checkProblem, (CompilationInfo)info);
            this.fireProgressListenerStep();
            this.fireProgressListenerStep();
        } else if (element.getKind().isField()) {
            this.fireProgressListenerStep();
            this.fireProgressListenerStep();
            Element hiddenField = this.hides(element, this.refactoring.getNewName(), (CompilationInfo)info);
            this.fireProgressListenerStep();
            this.fireProgressListenerStep();
            this.fireProgressListenerStep();
            if (hiddenField != null) {
                String msg = RefactoringUtils.isWeakerAccess(element.getModifiers(), hiddenField.getModifiers()) ? RenameRefactoringPlugin.getString("ERR_WillHidePrivate", RefactoringUtils.getAccess(element.getModifiers()), RefactoringUtils.getAccess(hiddenField.getModifiers()), info.getElementUtilities().enclosingTypeElement(hiddenField).toString()) : new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillHide")).format(new Object[]{info.getElementUtilities().enclosingTypeElement(hiddenField).toString()});
                checkProblem = RenameRefactoringPlugin.createProblem(checkProblem, false, msg);
            }
        }
        this.fireProgressListenerStop();
        return checkProblem;
    }

    private Problem checkMethodForOverriding(ExecutableElement m, String newName, Problem problem, CompilationInfo info) {
        ElementUtilities ut = info.getElementUtilities();
        this.fireProgressListenerStep();
        problem = this.willOverride(m, newName, problem, info);
        this.fireProgressListenerStep();
        return problem;
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo cpInfo = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
        final LinkedHashSet<FileObject> set = new LinkedHashSet<FileObject>();
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
        try {
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void run(CompilationController info) throws Exception {
                    ClassIndex idx = info.getClasspathInfo().getClassIndex();
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    Element el = RenameRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)info);
                    ElementKind kind = el.getKind();
                    ElementHandle enclosingType = el instanceof TypeElement ? ElementHandle.create((Element)((TypeElement)el)) : ElementHandle.create((Element)info.getElementUtilities().enclosingTypeElement(el));
                    set.add(SourceUtils.getFile((Element)el, (ClasspathInfo)info.getClasspathInfo()));
                    if (el.getModifiers().contains((Object)Modifier.PRIVATE)) {
                        if (kind == ElementKind.METHOD) {
                            RenameRefactoringPlugin.this.allMethods.add(ElementHandle.create((Element)((ExecutableElement)el)));
                        }
                    } else if (kind.isField()) {
                        set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    } else if (el instanceof TypeElement) {
                        set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    } else if (kind == ElementKind.METHOD) {
                        RenameRefactoringPlugin.this.allMethods.add(ElementHandle.create((Element)((ExecutableElement)el)));
                        for (ExecutableElement e : JavaRefactoringUtils.getOverridingMethods((ExecutableElement)el, (CompilationInfo)info, RenameRefactoringPlugin.this.cancelRequested)) {
                            RenameRefactoringPlugin.this.addMethods(e, set, (CompilationInfo)info, idx);
                        }
                        for (ExecutableElement ov : JavaRefactoringUtils.getOverriddenMethods((ExecutableElement)el, (CompilationInfo)info)) {
                            RenameRefactoringPlugin.this.addMethods(ov, set, (CompilationInfo)info, idx);
                            for (ExecutableElement e : JavaRefactoringUtils.getOverridingMethods(ov, (CompilationInfo)info, RenameRefactoringPlugin.this.cancelRequested)) {
                                RenameRefactoringPlugin.this.addMethods(e, set, (CompilationInfo)info, idx);
                            }
                        }
                        set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    }
                }
            }, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return set;
    }

    private void addMethods(ExecutableElement e, Set set, CompilationInfo info, ClassIndex idx) {
        ElementHandle handle = ElementHandle.create((Element)e);
        set.add(SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo()));
        ElementHandle encl = ElementHandle.create((Element)info.getElementUtilities().enclosingTypeElement((Element)e));
        set.addAll(idx.getResources(encl, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        this.allMethods.add((ElementHandle<ExecutableElement>)handle);
    }

    public Problem prepare(RefactoringElementsBag elements) {
        if (this.treePathHandle == null) {
            return null;
        }
        Set<FileObject> a = this.getRelevantFiles();
        this.fireProgressListenerStart(3, a.size());
        JavaRefactoringPlugin.TransformTask transform = new JavaRefactoringPlugin.TransformTask(this, new RenameTransformer(this.refactoring.getNewName(), this.allMethods, this.refactoring.isSearchInComments()), this.treePathHandle);
        Problem problem = this.createAndAddElements(a, transform, elements, (AbstractRefactoring)this.refactoring);
        this.fireProgressListenerStop();
        return problem;
    }

    private static int getAccessLevel(Element e) {
        Set<Modifier> access = e.getModifiers();
        if (access.contains((Object)Modifier.PUBLIC)) {
            return 3;
        }
        if (access.contains((Object)Modifier.PROTECTED)) {
            return 2;
        }
        if (!access.contains((Object)Modifier.PRIVATE)) {
            return 1;
        }
        return 0;
    }

    private Problem willOverride(ExecutableElement method, String name, Problem problem, CompilationInfo info) {
        boolean isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
        TypeElement jc = (TypeElement)method.getEnclosingElement();
        LinkedList supertypes = new LinkedList();
        ElementUtilities ut = info.getElementUtilities();
        Elements elements = info.getElements();
        Element m = null;
        for (ExecutableElement ee : ElementFilter.methodsIn(elements.getAllMembers(jc))) {
            if (!ee.getSimpleName().contentEquals(name) || !info.getTypes().isSubsignature((ExecutableType)ee.asType(), (ExecutableType)method.asType())) continue;
            m = ee;
            break;
        }
        if (m != null) {
            String msg;
            if (m.getModifiers().contains((Object)Modifier.FINAL)) {
                msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride_final")).format(new Object[]{method.getSimpleName(), method.getEnclosingElement().getSimpleName(), m.getSimpleName(), m.getEnclosingElement().getSimpleName()});
                return RenameRefactoringPlugin.createProblem(problem, true, msg);
            }
            if (RenameRefactoringPlugin.getAccessLevel(m) > RenameRefactoringPlugin.getAccessLevel(method)) {
                msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride_access")).format(new Object[]{method.getSimpleName(), method.getEnclosingElement().getSimpleName(), m.getSimpleName(), m.getEnclosingElement().getSimpleName()});
                return RenameRefactoringPlugin.createProblem(problem, true, msg);
            }
            if (m.getModifiers().contains((Object)Modifier.STATIC) != method.getModifiers().contains((Object)Modifier.STATIC)) {
                msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride_static")).format(new Object[]{isStatic ? RenameRefactoringPlugin.getString("LBL_static") : RenameRefactoringPlugin.getString("LBL_instance"), method.getSimpleName(), method.getEnclosingElement().getSimpleName(), m.getModifiers().contains((Object)Modifier.STATIC) ? RenameRefactoringPlugin.getString("LBL_static") : RenameRefactoringPlugin.getString("LBL_instance"), m.getSimpleName(), m.getEnclosingElement().getSimpleName()});
                return RenameRefactoringPlugin.createProblem(problem, true, msg);
            }
            msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride")).format(new Object[]{method.getSimpleName(), method.getEnclosingElement().getSimpleName(), m.getSimpleName(), m.getEnclosingElement().getSimpleName()});
            return RenameRefactoringPlugin.createProblem(problem, false, msg);
        }
        return problem;
    }

    private Element hides(Element field, String name, CompilationInfo info) {
        Elements elements = info.getElements();
        ElementUtilities utils = info.getElementUtilities();
        TypeElement jc = utils.enclosingTypeElement(field);
        for (Element element : elements.getAllMembers(jc)) {
            if (!element.getKind().isField() || !element.getSimpleName().toString().equals(name) || ((Object)element.getEnclosingElement()).equals(field.getEnclosingElement())) continue;
            return element;
        }
        return null;
    }

    private String clashes(Element feature, String newName, CompilationInfo info) {
        block4: {
            ElementKind kind;
            Element dc;
            block5: {
                ElementUtilities utils;
                block3: {
                    utils = info.getElementUtilities();
                    dc = feature.getEnclosingElement();
                    kind = feature.getKind();
                    if (!kind.isClass() && !kind.isInterface()) break block3;
                    for (TypeElement current : ElementFilter.typesIn(dc.getEnclosedElements())) {
                        if (!current.getSimpleName().toString().equals(newName)) continue;
                        return new MessageFormat(RenameRefactoringPlugin.getString("ERR_InnerClassClash")).format(new Object[]{newName, dc.getSimpleName()});
                    }
                    break block4;
                }
                if (kind != ElementKind.METHOD) break block5;
                if (utils.alreadyDefinedIn((CharSequence)newName, (ExecutableType)feature.asType(), (TypeElement)dc)) {
                    return new MessageFormat(RenameRefactoringPlugin.getString("ERR_MethodClash")).format(new Object[]{newName, dc.getSimpleName()});
                }
                break block4;
            }
            if (!kind.isField()) break block4;
            for (VariableElement current : ElementFilter.fieldsIn(dc.getEnclosedElements())) {
                if (!current.getSimpleName().toString().equals(newName)) continue;
                return new MessageFormat(RenameRefactoringPlugin.getString("ERR_FieldClash")).format(new Object[]{newName, dc.getSimpleName()});
            }
        }
        return null;
    }

    private static String getString(String ... value) {
        return NbBundle.getMessage(RenameRefactoringPlugin.class, (String)value[0], (Object[])Arrays.copyOfRange(value, 1, value.length));
    }
}

