/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.util.Collection;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGrip;

final class OverriddenAbsMethodFinder
implements CancellableTask<CompilationController> {
    private final TreePathHandle methodHandle;
    Collection<ElementGrip> refactoringElements;

    OverriddenAbsMethodFinder(TreePathHandle methodPathHandle, Collection<ElementGrip> refacElemsColl) {
        this.refactoringElements = refacElemsColl;
        this.methodHandle = methodPathHandle;
    }

    public void cancel() {
    }

    public void run(CompilationController compilationController) throws Exception {
        ExecutableElement implementingMethod = (ExecutableElement)this.methodHandle.resolveElement((CompilationInfo)compilationController);
        Collection<ExecutableElement> overriddenMethods = JavaRefactoringUtils.getOverriddenMethods(implementingMethod, (CompilationInfo)compilationController);
        for (ExecutableElement overriddenMethod : overriddenMethods) {
            if (!overriddenMethod.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            this.refactoringElements.add(new ElementGrip(overriddenMethod, (CompilationInfo)compilationController));
        }
    }
}

