/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.SourceUtilsEx;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveFileRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MoveTransformer
extends RefactoringVisitor {
    private FileObject originalFolder;
    private MoveFileRefactoringPlugin move;
    private Set<Element> elementsToImport;
    private Set<ImportTree> importToRemove;
    private Set<String> importToAdd;
    private boolean isThisFileMoving;
    private boolean isThisFileReferencingOldPackage = false;
    private Problem problem;
    private boolean moveToDefaulPackageProblem = false;
    private String originalPackage;
    private SourceUtilsEx.Cache cacheOfSrcFiles = new SourceUtilsEx.Cache();
    private final Set<ElementHandle<TypeElement>> classes2Move;

    public Problem getProblem() {
        return this.problem;
    }

    public MoveTransformer(MoveFileRefactoringPlugin move) {
        this.move = move;
        this.classes2Move = move.classes;
    }

    @Override
    public void setWorkingCopy(WorkingCopy copy) throws ToPhaseException {
        super.setWorkingCopy(copy);
        this.originalFolder = this.workingCopy.getFileObject().getParent();
        this.originalPackage = RefactoringUtils.getPackageName(this.originalFolder);
        this.isThisFileMoving = this.move.filesToMove.contains(this.workingCopy.getFileObject());
        this.elementsToImport = new HashSet<Element>();
        this.isThisFileReferencingOldPackage = false;
        this.importToRemove = new HashSet<ImportTree>();
        this.importToAdd = new HashSet<String>();
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, Element p) {
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            if (el != null) {
                if (this.isElementMoving(el)) {
                    String newPackageName = this.getTargetPackageName(el);
                    if (!"".equals(newPackageName)) {
                        MemberSelectTree nju = this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)newPackageName), el);
                        this.rewrite(node, nju);
                    } else if (!this.moveToDefaulPackageProblem) {
                        this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_MovingClassToDefaultPackage"));
                        this.moveToDefaulPackageProblem = true;
                    }
                } else if (this.isThisFileMoving) {
                    if (el.getKind() != ElementKind.PACKAGE) {
                        TypeElement enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(el);
                        EnumSet<Modifier> neededMods = EnumSet.of(Modifier.PUBLIC);
                        TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, this.getCurrentPath(), true, true, true, true, false);
                        if (enclosingClassPath != null) {
                            Element enclosingClass = this.workingCopy.getTrees().getElement(enclosingClassPath);
                            if (enclosingTypeElement != null && enclosingClass != null && this.workingCopy.getTypes().isSubtype(enclosingClass.asType(), enclosingTypeElement.asType())) {
                                neededMods = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
                            }
                        }
                        if (this.getPackageOf(el).toString().equals(this.originalPackage) && (!this.containsAnyOf(el, neededMods) || enclosingTypeElement != null && !this.containsAnyOf(enclosingTypeElement, neededMods)) && !this.move.filesToMove.contains(this.getFileObject(el))) {
                            this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature2", (Object)this.workingCopy.getFileObject().getName(), (Object)el, (Object)this.getTypeElement(el).getSimpleName()));
                        }
                    }
                } else if (el.getKind() != ElementKind.PACKAGE) {
                    TypeElement enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(el);
                    EnumSet<Modifier> neededMods = EnumSet.of(Modifier.PUBLIC);
                    TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, this.getCurrentPath(), true, true, true, true, false);
                    if (enclosingClassPath != null) {
                        Element enclosingClass = this.workingCopy.getTrees().getElement(enclosingClassPath);
                        if (enclosingTypeElement != null && enclosingClass != null && this.workingCopy.getTypes().isSubtype(enclosingClass.asType(), enclosingTypeElement.asType())) {
                            neededMods = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
                        }
                    }
                    if (this.getPackageOf(el).toString().equals(this.originalPackage) && (!this.containsAnyOf(el, neededMods) || enclosingTypeElement != null && !this.containsAnyOf(enclosingTypeElement, neededMods)) && this.move.filesToMove.contains(this.getFileObject(el))) {
                        this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature", (Object)this.workingCopy.getFileObject().getName(), (Object)el, (Object)this.getTypeElement(el).getSimpleName()));
                    }
                }
            } else if (this.isPackageRename() && "*".equals(node.getIdentifier().toString())) {
                ExpressionTree exprTree = node.getExpression();
                TreePath exprPath = this.workingCopy.getTrees().getPath(this.workingCopy.getCompilationUnit(), exprTree);
                Element elem = this.workingCopy.getTrees().getElement(exprPath);
                if (elem != null && elem.getKind() == ElementKind.PACKAGE && this.isThisPackageMoving((PackageElement)elem)) {
                    String newPackageName = this.getTargetPackageName(elem);
                    MemberSelectTree nju = this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)newPackageName), (CharSequence)"*");
                    this.rewrite(node, nju);
                }
            }
        }
        return (Tree)super.visitMemberSelect(node, p);
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, Element p) {
        Element el;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (el = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null) {
            if (!this.isThisFileMoving) {
                if (this.isElementMoving(el)) {
                    String targetPackageName = this.getTargetPackageName(el);
                    if (!RefactoringUtils.getPackageName(this.workingCopy.getCompilationUnit()).equals(targetPackageName)) {
                        this.elementsToImport.add(el);
                    }
                } else if (el.getKind() != ElementKind.PACKAGE) {
                    TypeElement enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(el);
                    EnumSet<Modifier> neededMods = EnumSet.of(Modifier.PUBLIC);
                    TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, this.getCurrentPath(), true, true, true, true, false);
                    if (enclosingClassPath != null) {
                        Element enclosingClass = this.workingCopy.getTrees().getElement(enclosingClassPath);
                        if (enclosingTypeElement != null && enclosingClass != null && this.workingCopy.getTypes().isSubtype(enclosingClass.asType(), enclosingTypeElement.asType())) {
                            neededMods = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
                        }
                    }
                    if (this.getPackageOf(el).toString().equals(this.originalPackage) && (!this.containsAnyOf(el, neededMods) || enclosingTypeElement != null && !this.containsAnyOf(enclosingTypeElement, neededMods)) && this.move.filesToMove.contains(this.getFileObject(el))) {
                        this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature", (Object)this.workingCopy.getFileObject().getName(), (Object)el, (Object)this.getTypeElement(el).getSimpleName()));
                    }
                }
            } else {
                Boolean[] isElementMoving = new Boolean[1];
                if (this.isTopLevelClass(el) && !this.isElementMoving(el, isElementMoving) && this.getPackageOf(el).toString().equals(this.originalPackage)) {
                    this.importToAdd.add(el.toString());
                    this.isThisFileReferencingOldPackage = true;
                }
                if (el.getKind() != ElementKind.PACKAGE) {
                    TypeElement enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(el);
                    EnumSet<Modifier> neededMods = EnumSet.of(Modifier.PUBLIC);
                    TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, this.getCurrentPath(), true, true, true, true, false);
                    if (enclosingClassPath != null) {
                        Element enclosingClass = this.workingCopy.getTrees().getElement(enclosingClassPath);
                        if (enclosingTypeElement != null && enclosingClass != null && this.workingCopy.getTypes().isSubtype(enclosingClass.asType(), enclosingTypeElement.asType())) {
                            neededMods = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
                        }
                    }
                    if (!(!this.getPackageOf(el).toString().equals(this.originalPackage) || this.containsAnyOf(el, neededMods) && (enclosingTypeElement == null || this.containsAnyOf(enclosingTypeElement, neededMods)) || this.isElementMoving(el, isElementMoving) || this.move.filesToMove.contains(this.getFileObject(el)))) {
                        this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature2", (Object)this.workingCopy.getFileObject().getName(), (Object)el, (Object)this.getTypeElement(el).getSimpleName()));
                    }
                }
            }
        }
        return (Tree)super.visitIdentifier(node, p);
    }

    private FileObject getFileObject(Element el) {
        return SourceUtilsEx.getFile(el, this.workingCopy.getClasspathInfo(), this.cacheOfSrcFiles);
    }

    private boolean isThisPackageMoving(PackageElement el) {
        return this.move.packageNames.contains(el.getQualifiedName().toString());
    }

    private String getTargetPackageName(Element el) {
        return this.move.getTargetPackageName(this.getFileObject(el));
    }

    private TypeElement getTypeElement(Element e) {
        TypeElement t = this.workingCopy.getElementUtilities().enclosingTypeElement(e);
        if (t == null && (e.getKind().isClass() || e.getKind().isInterface())) {
            return (TypeElement)e;
        }
        return t;
    }

    static final Problem createProblem(Problem result, boolean isFatal, String message) {
        Problem problem = new Problem(isFatal, message);
        if (result == null) {
            return problem;
        }
        problem.setNext(result);
        return problem;
    }

    private PackageElement getPackageOf(Element el) {
        while (el.getKind() != ElementKind.PACKAGE) {
            el = el.getEnclosingElement();
        }
        return (PackageElement)el;
    }

    private boolean isPackageRename() {
        return this.move.isRenameRefactoring;
    }

    private boolean isElementMoving(Element el, Boolean[] cache) {
        if (cache[0] == null) {
            cache[0] = this.isElementMoving(el);
        }
        return cache[0];
    }

    private boolean isElementMoving(Element el) {
        ElementKind kind = el.getKind();
        if (!kind.isClass() && !kind.isInterface()) {
            return false;
        }
        ElementHandle elHandle = ElementHandle.create((Element)el);
        return this.classes2Move.contains(elHandle);
    }

    private boolean isTopLevelClass(Element el) {
        return (el.getKind().isClass() || el.getKind().isInterface()) && el.getEnclosingElement().getKind() == ElementKind.PACKAGE;
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        Tree result = (Tree)super.visitCompilationUnit(node, p);
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return result;
        }
        CompilationUnitTree cut = node;
        List<? extends ImportTree> imports = cut.getImports();
        if (!this.importToRemove.isEmpty()) {
            ArrayList<? extends ImportTree> temp = new ArrayList<ImportTree>(imports);
            temp.removeAll(this.importToRemove);
            imports = temp;
        }
        if (this.isThisFileMoving) {
            String newPckg = this.move.getTargetPackageName(this.workingCopy.getFileObject());
            if (node.getPackageName() != null && !"".equals(newPckg)) {
                if (this.importToRemove.isEmpty()) {
                    this.rewrite(node.getPackageName(), this.make.Identifier((CharSequence)newPckg));
                } else {
                    cut = this.make.CompilationUnit(node.getPackageAnnotations(), (ExpressionTree)this.make.Identifier((CharSequence)newPckg), imports, node.getTypeDecls(), node.getSourceFile());
                }
            } else {
                cut = this.make.CompilationUnit(node.getPackageAnnotations(), (ExpressionTree)("".equals(newPckg) ? null : this.make.Identifier((CharSequence)newPckg)), imports, node.getTypeDecls(), node.getSourceFile());
            }
            if (this.isThisFileReferencingOldPackage) {
                ExpressionTree newPackageName = cut.getPackageName();
                if (newPackageName != null) {
                    try {
                        cut = RefactoringUtils.addImports(cut, new LinkedList<String>(this.importToAdd), this.make);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else if (!this.moveToDefaulPackageProblem) {
                    this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_MovingClassToDefaultPackage"));
                    this.moveToDefaulPackageProblem = true;
                }
            }
        } else if (!this.importToRemove.isEmpty()) {
            cut = this.make.CompilationUnit(node.getPackageName(), imports, node.getTypeDecls(), node.getSourceFile());
        }
        for (Element el : this.elementsToImport) {
            String newPackageName = this.getTargetPackageName(el);
            if ("".equals(newPackageName)) continue;
            cut = this.insertImport(cut, newPackageName + "." + el.getSimpleName(), el, newPackageName);
        }
        this.rewrite(node, cut);
        return result;
    }

    private CompilationUnitTree insertImport(CompilationUnitTree node, String imp, Element orig, String targetPkgOfOrig) {
        for (ImportTree importTree : node.getImports()) {
            if (importTree.getQualifiedIdentifier().toString().equals(imp) || importTree.getQualifiedIdentifier().toString().equals(((TypeElement)orig).getQualifiedName().toString())) {
                return node;
            }
            if (orig == null || !importTree.getQualifiedIdentifier().toString().equals(this.getPackageOf(orig).getQualifiedName() + ".*") || !this.isPackageRename()) continue;
            this.rewrite(importTree.getQualifiedIdentifier(), this.make.Identifier((CharSequence)(targetPkgOfOrig + ".*")));
            return node;
        }
        CompilationUnitTree nju = this.make.insertCompUnitImport(node, 0, this.make.Import((Tree)this.make.Identifier((CharSequence)imp), false));
        return nju;
    }

    @Override
    public Tree visitImport(ImportTree node, Element p) {
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            Element packageElement;
            MemberSelectTree memberSelect;
            Tree qualifiedIdentifier = node.getQualifiedIdentifier();
            Element el = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getQualifiedIdentifier()));
            if (el != null) {
                String cuPackageName;
                String newPackageName;
                if (this.isElementMoving(el) && !"".equals(newPackageName = this.getTargetPackageName(el)) && (cuPackageName = RefactoringUtils.getPackageName(this.workingCopy.getCompilationUnit())).equals(newPackageName)) {
                    this.importToRemove.add(node);
                    return node;
                }
            } else if (qualifiedIdentifier.getKind() == Tree.Kind.MEMBER_SELECT && (memberSelect = (MemberSelectTree)qualifiedIdentifier).getIdentifier().contentEquals("*") && (packageElement = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), memberSelect.getExpression()))).getKind() == ElementKind.PACKAGE) {
                PackageElement pakketje = (PackageElement)packageElement;
                if (this.isThisPackageMoving(pakketje)) {
                    this.importToRemove.add(node);
                } else if (this.move.packages.contains(ElementHandle.create((Element)pakketje))) {
                    boolean packageWillBeEmpty = true;
                    List<? extends Element> enclosedElements = pakketje.getEnclosedElements();
                    for (Element element : enclosedElements) {
                        if (!this.isElementMoving(element)) {
                            packageWillBeEmpty = false;
                            break;
                        }
                        String targetPackageName = this.getTargetPackageName(element);
                        if (!pakketje.getQualifiedName().contentEquals(targetPackageName)) continue;
                        packageWillBeEmpty = false;
                        break;
                    }
                    if (packageWillBeEmpty) {
                        this.importToRemove.add(node);
                    }
                }
            }
        }
        return (Tree)super.visitImport(node, p);
    }

    private boolean containsAnyOf(Element el, EnumSet<Modifier> neededMods) {
        for (Modifier mod : neededMods) {
            if (!el.getModifiers().contains((Object)mod)) continue;
            return true;
        }
        return false;
    }
}

