/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaMoveMembersProperties;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.InlineRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveMembersTransformer;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MoveMembersRefactoringPlugin
extends JavaRefactoringPlugin {
    private final MoveRefactoring refactoring;
    private final JavaMoveMembersProperties properties;

    public MoveMembersRefactoringPlugin(MoveRefactoring moveRefactoring) {
        this.refactoring = moveRefactoring;
        this.properties = (JavaMoveMembersProperties)moveRefactoring.getContext().lookup(JavaMoveMembersProperties.class);
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        TreePathHandle source = this.properties.getPreSelectedMembers()[0];
        if (source != null && source.getFileObject() != null) {
            switch (p) {
                case CHECKPARAMETERS: 
                case FASTCHECKPARAMETERS: 
                case PRECHECK: 
                case PREPARE: {
                    ClasspathInfo cpInfo = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
                    return JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{source.getFileObject()});
                }
            }
        }
        return null;
    }

    @Override
    protected ClasspathInfo getClasspathInfo(AbstractRefactoring refactoring) {
        TreePathHandle target;
        ArrayList<TreePathHandle> handles = new ArrayList<TreePathHandle>(refactoring.getRefactoringSource().lookupAll(TreePathHandle.class));
        Lookup targetLookup = this.refactoring.getTarget();
        if (targetLookup != null && (target = (TreePathHandle)targetLookup.lookup(TreePathHandle.class)) != null) {
            handles.add(target);
        }
        ClasspathInfo cpInfo = !handles.isEmpty() ? RefactoringUtils.getClasspathInfoFor(handles.toArray(new TreePathHandle[handles.size()])) : JavaRefactoringUtils.getClasspathInfoFor(this.properties.getPreSelectedMembers()[0].getFileObject());
        refactoring.getContext().add((Object)cpInfo);
        return cpInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Problem preCheck(CompilationController info) throws IOException {
        info.toPhase(JavaSource.Phase.RESOLVED);
        Problem preCheckProblem = MoveMembersRefactoringPlugin.isElementAvail(this.properties.getPreSelectedMembers()[0], (CompilationInfo)info);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        Element element = this.properties.getPreSelectedMembers()[0].resolveElement((CompilationInfo)info);
        TreePath path = info.getTrees().getPath(element);
        if (path == null) return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_MoveFromClass"));
        TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)info, path, true, true, true, true, false);
        if (enclosingClassPath == null) return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_MoveFromClass"));
        Element typeElement = info.getTrees().getElement(enclosingClassPath);
        if (typeElement != null && typeElement.getKind().isClass() && enclosingClassPath.getLeaf().getKind() != Tree.Kind.INTERFACE) return preCheckProblem;
        return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_MoveFromClass"));
    }

    @Override
    protected Problem checkParameters(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.RESOLVED);
        return null;
    }

    @Override
    protected Problem fastCheckParameters(CompilationController javac) throws IOException {
        TreePathHandle target;
        javac.toPhase(JavaSource.Phase.RESOLVED);
        Collection source = this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class);
        if (source.isEmpty()) {
            return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_NothingSelected"));
        }
        Lookup targetLookup = this.refactoring.getTarget();
        if (targetLookup == null || (target = (TreePathHandle)targetLookup.lookup(TreePathHandle.class)) == null) {
            return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_NoTarget"));
        }
        if (target.getFileObject() == null || !JavaRefactoringUtils.isOnSourceClasspath(target.getFileObject())) {
            return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_MoveToLibrary"));
        }
        TreePathHandle sourceTph = (TreePathHandle)source.iterator().next();
        if (sourceTph.getFileObject() == null || !JavaRefactoringUtils.isOnSourceClasspath(sourceTph.getFileObject())) {
            return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_MoveFromLibrary"));
        }
        for (TreePathHandle treePathHandle : source) {
            VariableElement var;
            Element element = treePathHandle.resolveElement((CompilationInfo)javac);
            if (element.getKind() == ElementKind.FIELD && (var = (VariableElement)element).asType().getKind() == TypeKind.TYPEVAR) {
                return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_MoveGenericField"));
            }
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement method = (ExecutableElement)element;
            if (method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_MoveAbstractMember", (Object)element.getSimpleName()));
            }
            Collection<ExecutableElement> overridenMethods = JavaRefactoringUtils.getOverriddenMethods(method, (CompilationInfo)javac);
            Collection<ExecutableElement> overridingMethods = JavaRefactoringUtils.getOverridingMethods(method, (CompilationInfo)javac, this.cancelRequested);
            if (overridenMethods.size() <= 0 && overridingMethods.size() <= 0) continue;
            return new Problem(true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_MoveMethodPolymorphic", (Object)method.getSimpleName()));
        }
        TreePath targetPath = target.resolve((CompilationInfo)javac);
        if (targetPath == null) {
            return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_TargetNotResolved"));
        }
        TreePath targetClass = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)javac, targetPath, true, true, true, true, true);
        TypeMirror targetType = javac.getTrees().getTypeMirror(targetClass);
        if (targetType == null) {
            return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_TargetNotResolved"));
        }
        Problem p = this.checkProjectDeps(sourceTph.getFileObject(), target.getFileObject());
        if (p != null) {
            return p;
        }
        TreePath sourceClass = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)javac, sourceTph.resolve((CompilationInfo)javac), true, true, true, true, true);
        TypeMirror sourceType = javac.getTrees().getTypeMirror(sourceClass);
        if (((Object)sourceType).equals(targetType)) {
            return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_MoveToSameClass"));
        }
        if (javac.getTypes().isSubtype(sourceType, targetType)) {
            return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_MoveToSuperClass"));
        }
        if (javac.getTypes().isSubtype(targetType, sourceType)) {
            return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_MoveToSubClass"));
        }
        Element targetElement = target.resolveElement((CompilationInfo)javac);
        PackageElement targetPackage = (PackageElement)javac.getElementUtilities().outermostTypeElement(targetElement).getEnclosingElement();
        Element sourceElement = sourceTph.resolveElement((CompilationInfo)javac);
        PackageElement sourcePackage = (PackageElement)javac.getElementUtilities().outermostTypeElement(sourceElement).getEnclosingElement();
        if (targetPackage.isUnnamed() && !sourcePackage.isUnnamed()) {
            return new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_MovingMemberToDefaultPackage"));
        }
        for (TreePathHandle treePathHandle : source) {
            Element element = treePathHandle.resolveElement((CompilationInfo)javac);
            List<? extends Element> enclosedElements = targetElement.getEnclosedElements();
            switch (element.getKind()) {
                case FIELD: {
                    enclosedElements = ElementFilter.fieldsIn(enclosedElements);
                    break;
                }
                case METHOD: {
                    enclosedElements = ElementFilter.methodsIn(enclosedElements);
                    break;
                }
                case CONSTRUCTOR: {
                    enclosedElements = ElementFilter.constructorsIn(enclosedElements);
                    break;
                }
                default: {
                    enclosedElements = ElementFilter.typesIn(enclosedElements);
                }
            }
            for (Element element2 : enclosedElements) {
                if (!element.getSimpleName().contentEquals(element2.getSimpleName())) continue;
                p = JavaPluginUtils.chainProblems(p, new Problem(true, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_PullUp_MemberAlreadyExists", (Object)element.getSimpleName())));
            }
        }
        return p;
    }

    private Set<FileObject> getRelevantFiles() {
        final LinkedHashSet<FileObject> set = new LinkedHashSet<FileObject>();
        ClasspathInfo cpInfo = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
        final ClassIndex idx = cpInfo.getClassIndex();
        final Collection tphs = this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class);
        TreePathHandle target = (TreePathHandle)this.refactoring.getTarget().lookup(TreePathHandle.class);
        FileObject file = target.getFileObject();
        JavaSource source = JavaPluginUtils.createSource(file, cpInfo, target);
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController info) throws Exception {
                info.toPhase(JavaSource.Phase.RESOLVED);
                HashSet<ClassIndex.SearchScope> searchScopeType = new HashSet<ClassIndex.SearchScope>(1);
                searchScopeType.add(ClassIndex.SearchScope.SOURCE);
                for (TreePathHandle tph : tphs) {
                    set.add(tph.getFileObject());
                    Element el = tph.resolveElement((CompilationInfo)info);
                    if (el.getKind() == ElementKind.METHOD) {
                        set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), searchScopeType));
                    }
                    if (!el.getKind().isField()) continue;
                    set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), searchScopeType));
                }
            }
        };
        try {
            source.runUserActionTask((Task)task, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        set.remove(file);
        set.add(file);
        return set;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        this.fireProgressListenerStart(3, -1);
        Set<FileObject> relevantFiles = this.getRelevantFiles();
        Problem p = null;
        TreePathHandle targetHandle = (TreePathHandle)this.refactoring.getTarget().lookup(TreePathHandle.class);
        this.fireProgressListenerStep(relevantFiles.size());
        MoveMembersTransformer transformer = new MoveMembersTransformer(this.refactoring);
        JavaRefactoringPlugin.TransformTask task = new JavaRefactoringPlugin.TransformTask(this, transformer, targetHandle);
        Problem prob = this.createAndAddElements(relevantFiles, task, refactoringElements, (AbstractRefactoring)this.refactoring, this.getClasspathInfo((AbstractRefactoring)this.refactoring));
        prob = JavaPluginUtils.chainProblems(prob, transformer.getProblem());
        this.fireProgressListenerStop();
        return prob != null ? prob : JavaPluginUtils.chainProblems(transformer.getProblem(), p);
    }

    private Problem checkProjectDeps(FileObject sourceFile, FileObject targetFile) {
        HashSet<FileObject> sourceRoots = new HashSet<FileObject>();
        ClassPath cp = ClassPath.getClassPath((FileObject)sourceFile, (String)"classpath/source");
        if (cp != null) {
            FileObject root = cp.findOwnerRoot(sourceFile);
            sourceRoots.add(root);
        }
        FileObject targetRoot = null;
        ClassPath targetCp = ClassPath.getClassPath((FileObject)targetFile, (String)"classpath/source");
        if (targetCp != null) {
            targetRoot = targetCp.findOwnerRoot(targetFile);
        }
        if (!sourceRoots.isEmpty() && targetRoot != null) {
            URL targetUrl = URLMapper.findURL((FileObject)targetRoot, (int)1);
            Project targetProject = FileOwnerQuery.getOwner((FileObject)targetRoot);
            Set deps = SourceUtils.getDependentRoots((URL)targetUrl);
            for (FileObject sourceRoot : sourceRoots) {
                URL sourceUrl = URLMapper.findURL((FileObject)sourceRoot, (int)0);
                if (deps.contains(sourceUrl)) continue;
                Project sourceProject = FileOwnerQuery.getOwner((FileObject)sourceRoot);
                for (FileObject affected : this.getRelevantFiles()) {
                    if (!FileOwnerQuery.getOwner((FileObject)affected).equals(sourceProject) || sourceProject.equals(targetProject)) continue;
                    assert (sourceProject != null);
                    assert (targetProject != null);
                    String sourceName = ProjectUtils.getInformation((Project)sourceProject).getDisplayName();
                    String targetName = ProjectUtils.getInformation((Project)targetProject).getDisplayName();
                    return new Problem(false, NbBundle.getMessage(MoveMembersRefactoringPlugin.class, (String)"ERR_MemberMissingProjectDeps", (Object)sourceName, (Object)targetName));
                }
            }
        }
        return null;
    }
}

