/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MoveClassTransformer
extends RefactoringVisitor {
    private Problem problem;
    private final ElementHandle<TypeElement> elementHandle;
    private final URL targetURL;
    private boolean inMovingClass;
    private Set<Element> elementsToImport;
    private Set<Element> elementsAlreadyImported;
    private final String targetPackageName;
    private boolean moveToDefaulPackageProblem = false;
    private String originalPackage;
    private HashSet<ImportTree> importToRemove;
    private HashSet<String> importToAdd;
    private boolean isThisFileReferencingOldPackage = false;

    public MoveClassTransformer(ElementHandle<TypeElement> elementHandle, URL targetURL) {
        this.elementHandle = elementHandle;
        this.targetURL = targetURL;
        this.targetPackageName = RefactoringUtils.getPackageName(targetURL);
    }

    Problem getProblem() {
        return this.problem;
    }

    @Override
    public void setWorkingCopy(WorkingCopy workingCopy) throws ToPhaseException {
        super.setWorkingCopy(workingCopy);
        this.elementsAlreadyImported = new HashSet<Element>();
        this.originalPackage = this.getPackageOf(this.elementHandle.resolve((CompilationInfo)workingCopy)).getQualifiedName().toString();
        this.elementsToImport = new HashSet<Element>();
        this.importToRemove = new HashSet();
        this.importToAdd = new HashSet();
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        Tree result = (Tree)super.visitCompilationUnit(node, p);
        List<? extends Tree> typeDecls = node.getTypeDecls();
        CompilationUnitTree cut = node;
        for (Tree tree : typeDecls) {
            TypeMirror type = this.workingCopy.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), tree));
            TypeMirror sourceType = ((TypeElement)this.elementHandle.resolve((CompilationInfo)this.workingCopy)).asType();
            if (type == null || sourceType == null || !this.workingCopy.getTypes().isSameType(type, sourceType)) continue;
            cut = this.make.removeCompUnitTypeDecl(cut, tree);
            try {
                FileObject targetRoot = RefactoringUtils.getClassPathRoot(this.targetURL);
                FileObject target = this.getOrCreateFolder(this.targetURL);
                String relativePath = FileUtil.getRelativePath((FileObject)targetRoot, (FileObject)target);
                LinkedList<ImportTree> imports = new LinkedList<ImportTree>();
                if (this.isThisFileReferencingOldPackage) {
                    ExpressionTree newPackageName = cut.getPackageName();
                    if (newPackageName != null) {
                        for (String importToAddItem : this.importToAdd) {
                            imports.add(this.make.Import((Tree)this.make.QualIdent(importToAddItem), false));
                        }
                    } else if (!this.moveToDefaulPackageProblem) {
                        this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_MovingClassToDefaultPackage")));
                        this.moveToDefaulPackageProblem = true;
                    }
                }
                GeneratorUtilities.get((WorkingCopy)this.workingCopy).importComments(tree, node);
                String cuPath = relativePath + "/" + ((ClassTree)tree).getSimpleName() + ".java";
                CompilationUnitTree compilationUnit = JavaPluginUtils.createCompilationUnit(targetRoot, cuPath, tree, this.workingCopy, this.make);
                compilationUnit = (CompilationUnitTree)GeneratorUtilities.get((WorkingCopy)this.workingCopy).importFQNs((Tree)compilationUnit);
                this.rewrite(null, compilationUnit);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return result;
        }
        List<? extends ImportTree> imports = cut.getImports();
        if (!this.importToRemove.isEmpty()) {
            ArrayList<? extends ImportTree> arrayList = new ArrayList<ImportTree>(imports);
            arrayList.removeAll(this.importToRemove);
            imports = arrayList;
        }
        if (!this.inMovingClass && !this.importToRemove.isEmpty()) {
            cut = this.make.CompilationUnit(cut.getPackageName(), imports, cut.getTypeDecls(), cut.getSourceFile());
        }
        for (Element el : this.elementsToImport) {
            if ("".equals(this.targetPackageName)) continue;
            cut = this.insertImport(cut, this.targetPackageName + '.' + el.getSimpleName());
        }
        this.rewrite(node, cut);
        return result;
    }

    @Override
    public Tree visitClass(ClassTree node, Element p) {
        Element element = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        if (this.isTopLevelClass(element)) {
            this.inMovingClass = element == this.elementHandle.resolve((CompilationInfo)this.workingCopy);
        }
        return (Tree)super.visitClass(node, p);
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, Element p) {
        Element el;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (el = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null) {
            if (this.isElementMoving(el)) {
                this.elementsAlreadyImported.add(el);
                String newPackageName = this.targetPackageName;
                if (!"".equals(newPackageName)) {
                    MemberSelectTree nju = this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)newPackageName), el);
                    this.rewrite(node, nju);
                } else if (!this.moveToDefaulPackageProblem) {
                    this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_MovingClassToDefaultPackage")));
                    this.moveToDefaulPackageProblem = true;
                }
            } else if (this.inMovingClass) {
                if (el.getKind() != ElementKind.PACKAGE) {
                    TypeElement outermostTypeElement;
                    TypeElement enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(el);
                    EnumSet<Modifier> neededMods = EnumSet.of(Modifier.PUBLIC);
                    TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, this.getCurrentPath(), true, true, true, true, false);
                    Element enclosingClass = this.workingCopy.getTrees().getElement(enclosingClassPath);
                    if (enclosingTypeElement != null && enclosingClass != null && this.workingCopy.getTypes().isSubtype(enclosingClass.asType(), enclosingTypeElement.asType())) {
                        neededMods = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
                    }
                    if ((outermostTypeElement = this.workingCopy.getElementUtilities().outermostTypeElement(el)) == null && (el.getKind().isClass() || el.getKind().isInterface())) {
                        outermostTypeElement = (TypeElement)el;
                    }
                    if (!(this.targetPackageName.equals(this.originalPackage) || !this.getPackageOf(el).toString().equals(this.originalPackage) || this.containsAnyOf(el, neededMods) && (enclosingTypeElement == null || this.containsAnyOf(enclosingTypeElement, neededMods)) || this.isElementMoving(outermostTypeElement))) {
                        this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature2", (Object)this.workingCopy.getFileObject().getName(), (Object)el, (Object)outermostTypeElement.getSimpleName())));
                    }
                }
            } else if (el.getKind() != ElementKind.PACKAGE) {
                TypeElement outermostTypeElement;
                TypeElement enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(el);
                EnumSet<Modifier> neededMods = EnumSet.of(Modifier.PUBLIC);
                TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, this.getCurrentPath(), true, true, true, true, false);
                Element enclosingClass = this.workingCopy.getTrees().getElement(enclosingClassPath);
                if (enclosingTypeElement != null && enclosingClass != null && this.workingCopy.getTypes().isSubtype(enclosingClass.asType(), enclosingTypeElement.asType())) {
                    neededMods = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
                }
                if ((outermostTypeElement = this.workingCopy.getElementUtilities().outermostTypeElement(el)) == null && (el.getKind().isClass() || el.getKind().isInterface())) {
                    outermostTypeElement = (TypeElement)el;
                }
                if (!this.targetPackageName.equals(this.originalPackage) && this.getPackageOf(el).toString().equals(this.originalPackage) && (!this.containsAnyOf(el, neededMods) || enclosingTypeElement != null && !this.containsAnyOf(enclosingTypeElement, neededMods)) && this.isElementMoving(outermostTypeElement)) {
                    this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature", (Object)this.workingCopy.getFileObject().getName(), (Object)el, (Object)outermostTypeElement.getSimpleName())));
                }
            }
        }
        return (Tree)super.visitMemberSelect(node, p);
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, Element p) {
        Element el;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (el = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null) {
            if (!this.inMovingClass) {
                if (this.isElementMoving(el)) {
                    if (!this.elementsAlreadyImported.contains(el) && !RefactoringUtils.getPackageName(this.workingCopy.getCompilationUnit()).equals(this.targetPackageName)) {
                        this.elementsToImport.add(el);
                    }
                } else if (el.getKind() != ElementKind.PACKAGE) {
                    TypeElement outermostTypeElement;
                    TypeElement enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(el);
                    EnumSet<Modifier> neededMods = EnumSet.of(Modifier.PUBLIC);
                    TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, this.getCurrentPath(), true, true, true, true, false);
                    Element enclosingClass = this.workingCopy.getTrees().getElement(enclosingClassPath);
                    if (enclosingTypeElement != null && enclosingClass != null && this.workingCopy.getTypes().isSubtype(enclosingClass.asType(), enclosingTypeElement.asType())) {
                        neededMods = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
                    }
                    if ((outermostTypeElement = this.workingCopy.getElementUtilities().outermostTypeElement(el)) == null && (el.getKind().isClass() || el.getKind().isInterface())) {
                        outermostTypeElement = (TypeElement)el;
                    }
                    if (!this.targetPackageName.equals(this.originalPackage) && this.getPackageOf(el).toString().equals(this.originalPackage) && (!this.containsAnyOf(el, neededMods) || enclosingTypeElement != null && !this.containsAnyOf(enclosingTypeElement, neededMods)) && this.isElementMoving(outermostTypeElement)) {
                        this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature", (Object)this.workingCopy.getFileObject().getName(), (Object)el, (Object)outermostTypeElement.getSimpleName())));
                    }
                }
            } else {
                if (this.isTopLevelClass(el) && !this.isElementMoving(el) && this.getPackageOf(el).toString().equals(this.originalPackage)) {
                    this.importToAdd.add(el.toString());
                    this.isThisFileReferencingOldPackage = true;
                }
                if (el.getKind() != ElementKind.PACKAGE) {
                    TypeElement outermostTypeElement;
                    TypeElement enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(el);
                    EnumSet<Modifier> neededMods = EnumSet.of(Modifier.PUBLIC);
                    TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, this.getCurrentPath(), true, true, true, true, false);
                    if (enclosingClassPath != null) {
                        Element enclosingClass = this.workingCopy.getTrees().getElement(enclosingClassPath);
                        if (enclosingTypeElement != null && enclosingClass != null && this.workingCopy.getTypes().isSubtype(enclosingClass.asType(), enclosingTypeElement.asType())) {
                            neededMods = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
                        }
                    }
                    if ((outermostTypeElement = this.workingCopy.getElementUtilities().outermostTypeElement(el)) == null && (el.getKind().isClass() || el.getKind().isInterface())) {
                        outermostTypeElement = (TypeElement)el;
                    }
                    if (!(this.targetPackageName.equals(this.originalPackage) || !this.getPackageOf(el).toString().equals(this.originalPackage) || this.containsAnyOf(el, neededMods) && (enclosingTypeElement == null || this.containsAnyOf(enclosingTypeElement, neededMods)) || this.isElementMoving(outermostTypeElement))) {
                        this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature2", (Object)this.workingCopy.getFileObject().getName(), (Object)el, (Object)outermostTypeElement.getSimpleName())));
                    }
                }
            }
        }
        return (Tree)super.visitIdentifier(node, p);
    }

    @Override
    public Tree visitImport(ImportTree node, Element p) {
        String cuPackageName;
        Element el;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (el = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getQualifiedIdentifier()))) != null && this.isElementMoving(el) && !"".equals(this.targetPackageName) && (cuPackageName = RefactoringUtils.getPackageName(this.workingCopy.getCompilationUnit())).equals(this.targetPackageName)) {
            this.importToRemove.add(node);
            return node;
        }
        return (Tree)super.visitImport(node, p);
    }

    private boolean isElementMoving(Element el) {
        ElementKind kind = el.getKind();
        if (!kind.isClass() && !kind.isInterface()) {
            return false;
        }
        TypeElement resolved = (TypeElement)this.elementHandle.resolve((CompilationInfo)this.workingCopy);
        return el == resolved;
    }

    private PackageElement getPackageOf(Element el) {
        while (el.getKind() != ElementKind.PACKAGE) {
            el = el.getEnclosingElement();
        }
        return (PackageElement)el;
    }

    private boolean containsAnyOf(Element el, EnumSet<Modifier> neededMods) {
        for (Modifier mod : neededMods) {
            if (!el.getModifiers().contains((Object)mod)) continue;
            return true;
        }
        return false;
    }

    private boolean isTopLevelClass(Element el) {
        return (el.getKind().isClass() || el.getKind().isInterface()) && el.getEnclosingElement().getKind() == ElementKind.PACKAGE;
    }

    private CompilationUnitTree insertImport(CompilationUnitTree node, String imp) {
        for (ImportTree importTree : node.getImports()) {
            if (!importTree.getQualifiedIdentifier().toString().equals(imp)) continue;
            return node;
        }
        CompilationUnitTree nju = this.make.insertCompUnitImport(node, 0, this.make.Import((Tree)this.make.Identifier((CharSequence)imp), false));
        return nju;
    }

    private FileObject getOrCreateFolder(URL url) throws IOException {
        try {
            FileObject result = URLMapper.findFileObject((URL)url);
            if (result != null) {
                return result;
            }
            File f = new File(url.toURI());
            result = FileUtil.createFolder((File)f);
            return result;
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }
}

