/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveClassTransformer;
import org.netbeans.modules.refactoring.java.plugins.MoveFileRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MoveClassRefactoringPlugin
extends JavaRefactoringPlugin {
    private final MoveRefactoring moveRefactoring;
    private Set<ElementHandle<TypeElement>> elementHandles;
    private Set<ElementHandle<TypeElement>> handlesToMove;

    public MoveClassRefactoringPlugin(MoveRefactoring moveRefactoring) {
        this.moveRefactoring = moveRefactoring;
        this.elementHandles = new HashSet<ElementHandle<TypeElement>>();
        this.handlesToMove = new HashSet<ElementHandle<TypeElement>>();
    }

    @Override
    public Problem preCheck() {
        this.cancelRequest = false;
        this.cancelRequested.set(false);
        Problem preCheckProblem = null;
        for (TreePathHandle tph : this.moveRefactoring.getRefactoringSource().lookupAll(TreePathHandle.class)) {
            ElementHandle elementHandle = tph.getElementHandle();
            if (elementHandle == null || !elementHandle.getKind().isClass() && !elementHandle.getKind().isClass()) {
                preCheckProblem = MoveClassRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(MoveClassRefactoringPlugin.class, (String)"ERR_NotClass"));
                continue;
            }
            FileObject file = tph.getFileObject();
            if (RefactoringUtils.isFileInOpenProject(file)) continue;
            preCheckProblem = MoveClassRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_ProjectNotOpened", (Object)FileUtil.getFileDisplayName((FileObject)file)));
        }
        return preCheckProblem;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        try {
            for (TreePathHandle tph : this.moveRefactoring.getRefactoringSource().lookupAll(TreePathHandle.class)) {
                String targetPackageName;
                FileObject f = tph.getFileObject();
                if (!RefactoringUtils.isJavaFile(f)) {
                    return new Problem(true, NbBundle.getMessage(MoveClassRefactoringPlugin.class, (String)"ERR_NotJava", (Object)f));
                }
                URL targetUrl = (URL)this.moveRefactoring.getTarget().lookup(URL.class);
                String string = targetPackageName = targetUrl != null ? RefactoringUtils.getPackageName(targetUrl) : null;
                if (targetPackageName == null || !RefactoringUtils.isValidPackageName(targetPackageName)) {
                    String s = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage");
                    String msg = new MessageFormat(s).format(new Object[]{targetPackageName});
                    return new Problem(true, msg);
                }
                FileObject targetRoot = RefactoringUtils.getClassPathRoot(targetUrl);
                FileObject targetF = targetRoot.getFileObject(targetPackageName.replace('.', '/'));
                if (targetF != null && !targetF.canWrite()) {
                    return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_PackageIsReadOnly")).format(new Object[]{targetPackageName}));
                }
                String fileName = f.getName();
                if (targetF == null) continue;
                FileObject[] children = targetF.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (!children[i].getName().equals(fileName) || !"java".equals(children[i].getExt()) || children[i].equals(f) || children[i].isVirtual()) continue;
                    return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_ClassToMoveClashes")).format(new Object[]{fileName}));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.fastCheckParameters();
    }

    @Override
    protected Problem fastCheckParameters(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        for (TreePathHandle tph : this.moveRefactoring.getRefactoringSource().lookupAll(TreePathHandle.class)) {
            Element resolveElement;
            FileObject f = tph.getFileObject();
            URL targetUrl = (URL)this.moveRefactoring.getTarget().lookup(URL.class);
            FileObject targetRoot = RefactoringUtils.getClassPathRoot(targetUrl);
            String targetPackageName = RefactoringUtils.getPackageName(targetUrl);
            FileObject targetF = targetRoot.getFileObject(targetPackageName.replace('.', '/'));
            if (!f.getParent().equals(targetF) || !(resolveElement = tph.resolveElement((CompilationInfo)javac)).getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            return new Problem(true, NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_CannotMovePublicIntoSamePackage"));
        }
        return super.fastCheckParameters(javac);
    }

    private Set<FileObject> getRelevantFiles(TreePathHandle tph) {
        ClasspathInfo cpInfo = this.getClasspathInfo((AbstractRefactoring)this.moveRefactoring);
        ClassIndex idx = cpInfo.getClassIndex();
        HashSet<FileObject> set = new HashSet<FileObject>();
        this.elementHandles.clear();
        ElementHandle elementHandle = tph.getElementHandle();
        this.handlesToMove.add((ElementHandle<TypeElement>)elementHandle);
        set.add(SourceUtils.getFile((ElementHandle)elementHandle, (ClasspathInfo)cpInfo));
        Set files = idx.getResources(elementHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
        set.addAll(files);
        Set handles = idx.getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
        this.elementHandles.addAll(handles);
        return set;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        switch (p) {
            case FASTCHECKPARAMETERS: {
                ClasspathInfo cpInfo = this.getClasspathInfo((AbstractRefactoring)this.moveRefactoring);
                TreePathHandle tph = (TreePathHandle)this.moveRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
                return JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{tph.getFileObject()});
            }
        }
        TreePathHandle tph = (TreePathHandle)this.moveRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
        return JavaSource.forFileObject((FileObject)tph.getFileObject());
    }

    public Problem prepare(RefactoringElementsBag elements) {
        this.fireProgressListenerStart(3, -1);
        TreePathHandle tph = (TreePathHandle)this.moveRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
        Set<FileObject> a = this.getRelevantFiles(tph);
        Problem p = this.checkProjectDeps(a);
        this.fireProgressListenerStep(a.size());
        MoveClassTransformer transformer = new MoveClassTransformer((ElementHandle<TypeElement>)tph.getElementHandle(), (URL)this.moveRefactoring.getTarget().lookup(URL.class));
        JavaRefactoringPlugin.TransformTask task = new JavaRefactoringPlugin.TransformTask(this, transformer, null);
        Problem prob = this.createAndAddElements(a, task, elements, (AbstractRefactoring)this.moveRefactoring);
        this.fireProgressListenerStop();
        return prob != null ? prob : JavaPluginUtils.chainProblems(p, transformer.getProblem());
    }

    private Problem checkProjectDeps(Set<FileObject> a) {
        ClasspathInfo cpInfo = this.getClasspathInfo((AbstractRefactoring)this.moveRefactoring);
        HashSet<FileObject> sourceRoots = new HashSet<FileObject>();
        for (TreePathHandle tph : this.moveRefactoring.getRefactoringSource().lookupAll(TreePathHandle.class)) {
            FileObject file = tph.getFileObject();
            ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
            if (cp == null) continue;
            FileObject root = cp.findOwnerRoot(file);
            sourceRoots.add(root);
        }
        URL target = (URL)this.moveRefactoring.getTarget().lookup(URL.class);
        if (target == null) {
            return null;
        }
        try {
            FileObject r = RefactoringUtils.getClassPathRoot(target);
            URL targetUrl = URLMapper.findURL((FileObject)r, (int)1);
            Project targetProject = FileOwnerQuery.getOwner((FileObject)r);
            Set deps = SourceUtils.getDependentRoots((URL)targetUrl);
            for (FileObject sourceRoot : sourceRoots) {
                URL sourceUrl = URLMapper.findURL((FileObject)sourceRoot, (int)0);
                if (deps.contains(sourceUrl)) continue;
                Project sourceProject = FileOwnerQuery.getOwner((FileObject)sourceRoot);
                for (ElementHandle<TypeElement> affected : this.elementHandles) {
                    FileObject affectedFile = SourceUtils.getFile(affected, (ClasspathInfo)cpInfo);
                    if (!FileOwnerQuery.getOwner((FileObject)affectedFile).equals(sourceProject) || this.handlesToMove.contains(affected) || sourceProject.equals(targetProject)) continue;
                    assert (sourceProject != null);
                    assert (targetProject != null);
                    String sourceName = ProjectUtils.getInformation((Project)sourceProject).getDisplayName();
                    String targetName = ProjectUtils.getInformation((Project)targetProject).getDisplayName();
                    return MoveClassRefactoringPlugin.createProblem(null, false, NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_MissingProjectDeps", (Object)sourceName, (Object)targetName));
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }
}

