/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.javadoc.Doc;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.IntroduceLocalExtensionRefactoring;
import org.netbeans.modules.refactoring.java.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class IntroduceLocalExtensionTransformer
extends RefactoringVisitor {
    private final IntroduceLocalExtensionRefactoring refactoring;
    private Problem problem;
    private String fqn;
    private boolean initialized;
    private final Map<ElementHandle<Element>, String[]> getterSetterMap;
    public static final String CLASS_FIELD_PREFIX = "_";
    private static final Map<Acceptor, String> EQUALS_PATTERNS = new LinkedHashMap<Acceptor, String>();
    private static final Map<Acceptor, String> HASH_CODE_PATTERNS;
    static int randomNumber;

    public IntroduceLocalExtensionTransformer(IntroduceLocalExtensionRefactoring refactoring) {
        this.refactoring = refactoring;
        this.initialized = false;
        this.getterSetterMap = new HashMap<ElementHandle<Element>, String[]>();
    }

    @Override
    public Tree scan(Tree tree, Element p) {
        if (!this.initialized) {
            String packageName = this.refactoring.getPackageName();
            FileObject sourceRoot = this.refactoring.getSourceRoot();
            String name = this.refactoring.getNewName();
            boolean wrap = this.refactoring.getWrap();
            this.fqn = packageName + '.' + name;
            GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
            TypeElement source = (TypeElement)((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getElementHandle().resolve((CompilationInfo)this.workingCopy);
            ArrayList<TypeParameterTree> newTypeParams = new ArrayList<TypeParameterTree>(source.getTypeParameters().size());
            this.transformTypeParameters(source.getTypeParameters(), this.make, genUtils, newTypeParams);
            List<Tree> implementsList = wrap ? this.addInterfaces(source) : Collections.EMPTY_LIST;
            ArrayList<Tree> members = new ArrayList<Tree>();
            this.addConstructors(source, members);
            if (wrap) {
                Tree type = this.make.Type(source.asType());
                VariableTree field = this.make.Variable(this.make.Modifiers(EnumSet.of(Modifier.PRIVATE)), (CharSequence)"delegate", type, null);
                members.add(0, field);
                this.addFields(source, genUtils, members);
            }
            if (wrap) {
                this.addMembers(source, genUtils, members);
                this.createEquals(source, genUtils, members);
            }
            ClassTree newClassTree = this.make.Class(this.make.Modifiers(source.getModifiers()), (CharSequence)name, newTypeParams, wrap ? null : this.make.Type(source.asType()), implementsList, members);
            String relativePath = this.fqn.replace('.', '/') + ".java";
            CompilationUnitTree newCompilation = JavaPluginUtils.createCompilationUnit(sourceRoot, relativePath, newClassTree, this.workingCopy, this.make);
            this.workingCopy.rewrite(null, (Tree)newCompilation);
            this.initialized = true;
        }
        return (Tree)super.scan(tree, p);
    }

    private void addFields(TypeElement source, GeneratorUtilities genUtils, List<Tree> members) throws IllegalStateException {
        for (VariableElement field : ElementFilter.fieldsIn(this.workingCopy.getElements().getAllMembers(source))) {
            if (field.getModifiers().contains((Object)Modifier.NATIVE) || !field.getModifiers().contains((Object)Modifier.PUBLIC) || ((Object)field.getEnclosingElement()).equals(this.workingCopy.getElements().getTypeElement("java.lang.Object"))) continue;
            if (field.getModifiers().contains((Object)Modifier.FINAL) && field.getModifiers().contains((Object)Modifier.STATIC)) {
                VariableTree variable = this.make.Variable(field, this.make.QualIdent((Element)field));
                members.add(0, variable);
                continue;
            }
            String getterName = EncapsulateFieldRefactoringPlugin.computeGetterName(field);
            String setterName = EncapsulateFieldRefactoringPlugin.computeSetterName(field);
            MethodTree[] createdGetterAndSetter = this.createGetterAndSetter(field, getterName, setterName, field.getModifiers());
            ElementHandle fieldHandle = ElementHandle.create((Element)field);
            this.getterSetterMap.put((ElementHandle<Element>)fieldHandle, new String[]{getterName, setterName});
            members.addAll(Arrays.asList(createdGetterAndSetter));
        }
    }

    private MethodTree[] createGetterAndSetter(VariableElement field, String getterName, String setterName, Set<Modifier> useModifiers) {
        String longName;
        String fieldName = field.getSimpleName().toString();
        boolean staticMod = field.getModifiers().contains((Object)Modifier.STATIC);
        String string = longName = staticMod ? "delegate." : "this.delegate." + fieldName;
        String parName = staticMod ? "a" + IntroduceLocalExtensionTransformer.getCapitalizedName(field) : (Utilities.isJavaIdentifier((String)IntroduceLocalExtensionTransformer.stripPrefix(fieldName)) ? IntroduceLocalExtensionTransformer.stripPrefix(fieldName) : fieldName);
        String getterBody = "{return delegate." + fieldName + ";}";
        StringBuilder setterBody = new StringBuilder();
        setterBody.append("{");
        setterBody.append(longName).append(" = ").append(parName).append(";");
        setterBody.append("}");
        HashSet<Modifier> mods = new HashSet<Modifier>(useModifiers);
        if (staticMod) {
            mods.add(Modifier.STATIC);
        }
        VariableTree fieldTree = (VariableTree)this.workingCopy.getTrees().getTree(field);
        MethodTree[] result = new MethodTree[2];
        ExecutableElement getterElm = null;
        if (getterName != null) {
            getterElm = EncapsulateFieldRefactoringPlugin.findMethod((CompilationInfo)this.workingCopy, (TypeElement)field.getEnclosingElement(), getterName, Collections.emptyList(), false);
        }
        if (getterElm == null && getterName != null) {
            MethodTree getter;
            result[0] = getter = this.make.Method(this.make.Modifiers(mods), (CharSequence)getterName, fieldTree.getType(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), getterBody, null);
            String jdText = null;
            String prefix = jdText == null ? "" : jdText + "\n";
            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)(prefix + "@return the " + field.getSimpleName()));
            this.make.addComment((Tree)getter, comment, true);
        }
        ExecutableElement setterElm = null;
        if (setterName != null) {
            setterElm = EncapsulateFieldRefactoringPlugin.findMethod((CompilationInfo)this.workingCopy, (TypeElement)field.getEnclosingElement(), setterName, Collections.singletonList(field), false);
        }
        if (setterElm == null && setterName != null) {
            MethodTree setter;
            VariableTree paramTree = this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)parName, fieldTree.getType(), null);
            result[1] = setter = this.make.Method(this.make.Modifiers(mods), (CharSequence)setterName, (Tree)this.make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.singletonList(paramTree), Collections.emptyList(), setterBody.toString(), null);
            String jdText = null;
            String prefix = jdText == null ? "" : jdText + "\n";
            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)(prefix + String.format("@param %s the %s to set", parName, fieldName)));
            this.make.addComment((Tree)setter, comment, true);
        }
        return result;
    }

    private void addMembers(TypeElement source, GeneratorUtilities genUtils, List<Tree> members) throws IllegalStateException {
        for (ExecutableElement method : ElementFilter.methodsIn(this.workingCopy.getElements().getAllMembers(source))) {
            if (method.getModifiers().contains((Object)Modifier.NATIVE) || !method.getModifiers().contains((Object)Modifier.PUBLIC) || ((Object)method.getEnclosingElement()).equals(this.workingCopy.getElements().getTypeElement("java.lang.Object")) || method.getReturnType().getKind() == TypeKind.BOOLEAN && method.getSimpleName().contentEquals("equals") || method.getReturnType().getKind() == TypeKind.INT && method.getSimpleName().contentEquals("hashCode")) continue;
            this.addMember(source, method, genUtils, members);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createEquals(TypeElement source, GeneratorUtilities genUtils, List<Tree> members) throws IllegalStateException {
        LinkedList<Tree> newTypeParams = new LinkedList<Tree>();
        for (TypeParameterElement typeParameterElement : source.getTypeParameters()) {
            newTypeParams.add(this.make.Type(typeParameterElement.asType()));
        }
        TypeMirror sourceType = source.asType();
        Tree tree = this.make.Type(this.refactoring.getNewName());
        Tree newSimpleTypeTree = this.make.Type(this.refactoring.getNewName());
        if (sourceType.getKind() == TypeKind.DECLARED && !newTypeParams.isEmpty()) {
            ExpressionTree expressionTree = (ExpressionTree)((Object)this.make.ParameterizedType(tree, newTypeParams));
        }
        IntroduceLocalExtensionRefactoring.Equality equality = this.refactoring.getEquality();
        switch (equality) {
            case SEPARATE: {
                void var6_9;
                BlockTree body = this.make.Block(Collections.singletonList(this.make.Return((ExpressionTree)this.make.MethodInvocation(Collections.EMPTY_LIST, (ExpressionTree)this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)"this.delegate"), (CharSequence)"equals"), Collections.singletonList(this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)"o"), (CharSequence)"delegate"))))), false);
                MethodTree method = this.make.Method(this.make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)("equals" + this.refactoring.getNewName()), (Tree)this.make.PrimitiveType(TypeKind.BOOLEAN), Collections.EMPTY_LIST, Collections.singletonList(this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"o", (Tree)var6_9, null)), Collections.EMPTY_LIST, body, null, false);
                members.add(method);
            }
            case DELEGATE: {
                LinkedList<StatementTree> statements = new LinkedList<StatementTree>();
                statements.add(this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"target", this.make.Type("Object"), (ExpressionTree)this.make.Identifier((CharSequence)"o")));
                statements.add(this.make.If((ExpressionTree)this.make.InstanceOf((ExpressionTree)this.make.Identifier((CharSequence)"o"), newSimpleTypeTree), (StatementTree)this.make.Block(Collections.singletonList(this.make.ExpressionStatement((ExpressionTree)this.make.Assignment((ExpressionTree)this.make.Identifier((CharSequence)"target"), (ExpressionTree)this.make.MemberSelect((ExpressionTree)this.make.Parenthesized((ExpressionTree)this.make.TypeCast(newSimpleTypeTree, (ExpressionTree)this.make.Identifier((CharSequence)"o"))), (CharSequence)"delegate")))), false), null));
                statements.add(this.make.Return((ExpressionTree)this.make.MethodInvocation(Collections.EMPTY_LIST, (ExpressionTree)this.make.Identifier((CharSequence)"this.delegate.equals"), Collections.singletonList(this.make.Identifier((CharSequence)"target")))));
                BlockTree body = this.make.Block(statements, false);
                MethodTree method = this.make.Method(this.make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)"equals", (Tree)this.make.PrimitiveType(TypeKind.BOOLEAN), Collections.EMPTY_LIST, Collections.singletonList(this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"o", this.make.Type("Object"), null)), Collections.EMPTY_LIST, body, null, false);
                members.add(method);
                body = this.make.Block(Collections.singletonList(this.make.Return((ExpressionTree)this.make.MethodInvocation(Collections.EMPTY_LIST, (ExpressionTree)this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)"this.delegate"), (CharSequence)"hashCode"), Collections.EMPTY_LIST))), false);
                method = this.make.Method(this.make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)"hashCode", (Tree)this.make.PrimitiveType(TypeKind.INT), Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, body, null, false);
                members.add(method);
                break;
            }
            case GENERATE: {
                void var6_9;
                MethodTree equalsMethod = this.createEqualsMethod(this.workingCopy, (DeclaredType)sourceType, (Tree)var6_9);
                MethodTree hashMethod = this.createHashCodeMethod(this.workingCopy, (DeclaredType)sourceType);
                members.add(equalsMethod);
                members.add(hashMethod);
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addMember(TypeElement source, ExecutableElement method, GeneratorUtilities genUtils, List<Tree> members) throws IllegalStateException {
        StatementTree statement;
        ArrayList<IdentifierTree> paramList = new ArrayList<IdentifierTree>();
        for (VariableElement variableElement : method.getParameters()) {
            ExpressionTree identifier = this.workingCopy.getTypes().isSameType(variableElement.asType(), source.asType()) ? this.make.MemberSelect((ExpressionTree)this.make.Identifier((Element)variableElement), (CharSequence)"delegate") : this.make.Identifier((Element)variableElement);
            paramList.add((IdentifierTree)identifier);
        }
        ArrayList<IdentifierTree> typeArguments = new ArrayList<IdentifierTree>();
        List<? extends TypeParameterElement> list = method.getTypeParameters();
        for (TypeParameterElement typeParameterElement : list) {
            IdentifierTree identifier = this.make.Identifier((Element)typeParameterElement);
            typeArguments.add(identifier);
        }
        MemberSelectTree memberSelect = method.getModifiers().contains((Object)Modifier.STATIC) ? this.make.MemberSelect(this.make.QualIdent((Element)source), (Element)method) : this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)"delegate"), (Element)method);
        MethodInvocationTree methodInvocationTree = this.make.MethodInvocation(typeArguments, (ExpressionTree)memberSelect, paramList);
        TypeMirror methodReturnTypeMirror = method.getReturnType();
        Tree methodReturnType = this.make.Type(method.getReturnType());
        boolean hasReturn = true;
        Types types = this.workingCopy.getTypes();
        if (types.isSameType(methodReturnTypeMirror, types.getNoType(TypeKind.VOID))) {
            hasReturn = false;
        }
        if (hasReturn) {
            void var9_13;
            if (this.workingCopy.getTypes().isSameType(methodReturnTypeMirror, source.asType())) {
                DeclaredType declaredType = (DeclaredType)methodReturnTypeMirror;
                List<? extends TypeMirror> returntypeArguments = declaredType.getTypeArguments();
                LinkedList<ExpressionTree> returntypes = new LinkedList<ExpressionTree>();
                for (TypeMirror typeMirror : returntypeArguments) {
                    returntypes.add((ExpressionTree)this.make.Type(typeMirror));
                }
                ExpressionTree ident = this.make.QualIdent(this.fqn);
                if (!returntypes.isEmpty()) {
                    ident = (ExpressionTree)((Object)this.make.ParameterizedType((Tree)ident, returntypes));
                }
                methodReturnType = ident;
                NewClassTree newClassTree = this.make.NewClass(null, Collections.EMPTY_LIST, ident, Collections.singletonList(methodInvocationTree), null);
            }
            statement = this.make.Return((ExpressionTree)var9_13);
        } else {
            statement = this.make.ExpressionStatement((ExpressionTree)methodInvocationTree);
        }
        ModifiersTree modifiers = this.make.Modifiers(method.getModifiers());
        ArrayList<TypeParameterTree> newTypeParams = new ArrayList<TypeParameterTree>(list.size());
        this.transformTypeParameters(list, this.make, genUtils, newTypeParams);
        List<? extends VariableElement> parameters = method.getParameters();
        ArrayList<VariableTree> newParameters = new ArrayList<VariableTree>(parameters.size());
        for (VariableElement variableElement : parameters) {
            if (this.workingCopy.getTypes().isSameType(variableElement.asType(), source.asType())) {
                ExpressionTree ident = this.make.QualIdent(this.fqn);
                if (variableElement.asType().getKind() == TypeKind.DECLARED) {
                    DeclaredType declaredType = (DeclaredType)variableElement.asType();
                    List<? extends TypeMirror> arguments = declaredType.getTypeArguments();
                    ArrayList<Tree> newArguments = new ArrayList<Tree>(arguments.size());
                    for (TypeMirror typeMirror : arguments) {
                        newArguments.add(this.make.Type(typeMirror));
                    }
                    if (!newArguments.isEmpty()) {
                        ident = (ExpressionTree)((Object)this.make.ParameterizedType((Tree)ident, newArguments));
                    }
                }
                newParameters.add(this.make.Variable(this.make.Modifiers(variableElement.getModifiers()), (CharSequence)variableElement.getSimpleName(), (Tree)ident, null));
                continue;
            }
            newParameters.add(this.make.Variable(variableElement, null));
        }
        List<? extends TypeMirror> thrownTypes = method.getThrownTypes();
        ArrayList<ExpressionTree> arrayList = new ArrayList<ExpressionTree>(thrownTypes.size());
        for (TypeMirror typeMirror : thrownTypes) {
            arrayList.add((ExpressionTree)this.make.Type(typeMirror));
        }
        MethodTree newMethod = this.make.Method(modifiers, (CharSequence)method.getSimpleName(), methodReturnType, newTypeParams, newParameters, arrayList, this.make.Block(Collections.singletonList(statement), false), null, method.isVarArgs());
        newMethod = (MethodTree)genUtils.importFQNs((Tree)newMethod);
        Doc doc = this.workingCopy.getElementUtilities().javaDocFor((Element)method);
        if (!doc.getRawCommentText().isEmpty()) {
            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)doc.getRawCommentText());
            this.make.addComment((Tree)newMethod, comment, true);
        }
        members.add(newMethod);
    }

    private List<Tree> addInterfaces(TypeElement source) {
        ArrayList<Tree> implementsList = new ArrayList<Tree>();
        HashSet<String> implemented = new HashSet<String>();
        TypeElement typeElement = source;
        while (typeElement != null) {
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                Tree type = this.make.Type(typeMirror);
                if (typeMirror.getKind() == TypeKind.DECLARED) {
                    DeclaredType declaredType = (DeclaredType)typeMirror;
                    List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                    LinkedList<Tree> newTypeParams = new LinkedList<Tree>();
                    for (TypeMirror typeMirror2 : typeArguments) {
                        Element element = this.workingCopy.getTypes().asElement(typeMirror2);
                        if (source.equals(element)) {
                            newTypeParams.add(this.make.QualIdent(this.fqn));
                            continue;
                        }
                        newTypeParams.add(this.make.Type(typeMirror2));
                    }
                    if (!newTypeParams.isEmpty()) {
                        type = this.make.ParameterizedType((Tree)this.make.QualIdent(declaredType.asElement()), newTypeParams);
                    }
                }
                if (!implemented.add(((Object)typeMirror).toString())) continue;
                implementsList.add(type);
            }
            TypeMirror superclass = typeElement.getSuperclass();
            if (superclass.getKind() != TypeKind.NONE) {
                typeElement = (TypeElement)this.workingCopy.getTypes().asElement(superclass);
                continue;
            }
            typeElement = null;
        }
        return implementsList;
    }

    private void transformTypeParameters(List<? extends TypeParameterElement> source, TreeMaker make, GeneratorUtilities genUtils, List<TypeParameterTree> newTypeParams) {
        for (TypeParameterElement typeParameterElement : source) {
            List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
            ArrayList<ExpressionTree> newBounds = new ArrayList<ExpressionTree>(bounds.size());
            for (TypeMirror typeMirror : bounds) {
                TypeMirror typeObject = this.workingCopy.getElements().getTypeElement("java.lang.Object").asType();
                if (this.workingCopy.getTypes().isSameType(typeMirror, typeObject)) continue;
                ExpressionTree type = (ExpressionTree)make.Type(typeMirror);
                newBounds.add(type);
            }
            TypeParameterTree typeParameterTree = make.TypeParameter((CharSequence)typeParameterElement.getSimpleName(), newBounds);
            if (!typeParameterTree.getBounds().isEmpty()) {
                typeParameterTree = (TypeParameterTree)genUtils.importFQNs((Tree)typeParameterTree);
            }
            newTypeParams.add(typeParameterTree);
        }
    }

    private void addConstructors(TypeElement origClass, List<Tree> members) {
        GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
        Tree type = this.make.Type(origClass.asType());
        VariableTree parameter = this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"delegate", type, null);
        EnumSet<Modifier> modifiers = EnumSet.copyOf(origClass.getModifiers());
        modifiers.remove((Object)Modifier.STATIC);
        modifiers.remove((Object)Modifier.FINAL);
        if (this.refactoring.getWrap()) {
            AssignmentTree assignment = this.make.Assignment((ExpressionTree)this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)"this"), (CharSequence)"delegate"), (ExpressionTree)this.make.Identifier((CharSequence)"delegate"));
            ExpressionStatementTree statement = this.make.ExpressionStatement((ExpressionTree)assignment);
            BlockTree block = this.make.Block(Collections.singletonList(statement), false);
            MethodTree newConstr = this.make.Method(this.make.Modifiers(modifiers), (CharSequence)this.refactoring.getNewName(), null, Collections.EMPTY_LIST, Collections.singletonList(parameter), Collections.EMPTY_LIST, block, null);
            newConstr = (MethodTree)genUtils.importFQNs((Tree)newConstr);
            members.add(newConstr);
        }
        for (ExecutableElement constr : ElementFilter.constructorsIn(origClass.getEnclosedElements())) {
            ExpressionTree expression;
            if (this.workingCopy.getElementUtilities().isSynthetic((Element)constr)) continue;
            List<? extends TypeParameterElement> typeParameters = constr.getTypeParameters();
            ArrayList<TypeParameterTree> newTypeParams = new ArrayList<TypeParameterTree>(typeParameters.size());
            this.transformTypeParameters(typeParameters, this.make, genUtils, newTypeParams);
            ArrayList<IdentifierTree> newTypeArguments = new ArrayList<IdentifierTree>();
            for (TypeParameterElement typeParameterElement : typeParameters) {
                IdentifierTree identifierTree = this.make.Identifier((Element)typeParameterElement);
                newTypeArguments.add(identifierTree);
            }
            ArrayList<IdentifierTree> newArguments = new ArrayList<IdentifierTree>();
            for (VariableElement variableElement : constr.getParameters()) {
                IdentifierTree identifier = this.make.Identifier((Element)variableElement);
                newArguments.add(identifier);
            }
            List<? extends VariableElement> list = constr.getParameters();
            ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>(typeParameters.size());
            for (VariableElement variableElement : list) {
                VariableTree var = this.make.Variable(variableElement, null);
                arrayList.add(var);
            }
            List<? extends TypeMirror> thrownTypes = constr.getThrownTypes();
            ArrayList<ExpressionTree> arrayList2 = new ArrayList<ExpressionTree>(thrownTypes.size());
            for (TypeMirror typeMirror : thrownTypes) {
                Tree thrownType = this.make.Type(typeMirror);
                arrayList2.add((ExpressionTree)thrownType);
            }
            if (this.refactoring.getWrap()) {
                NewClassTree newClassTree = this.make.NewClass(null, newTypeArguments, this.make.QualIdent((Element)origClass), newArguments, null);
                expression = this.make.Assignment((ExpressionTree)this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)"this"), (CharSequence)"delegate"), (ExpressionTree)newClassTree);
            } else {
                expression = this.make.MethodInvocation(newTypeArguments, (ExpressionTree)this.make.Identifier((CharSequence)"super"), newArguments);
            }
            ExpressionStatementTree expressionStatementTree = this.make.ExpressionStatement(expression);
            BlockTree block = this.make.Block(Collections.singletonList(expressionStatementTree), false);
            MethodTree newConstr = this.make.Method(this.make.Modifiers(constr.getModifiers()), (CharSequence)this.refactoring.getNewName(), null, newTypeParams, arrayList, arrayList2, block, null);
            newConstr = (MethodTree)genUtils.importFQNs((Tree)newConstr);
            Doc javadoc = this.workingCopy.getElementUtilities().javaDocFor((Element)constr);
            if (!javadoc.getRawCommentText().isEmpty()) {
                Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)javadoc.getRawCommentText());
                this.make.addComment((Tree)newConstr, comment, true);
            }
            members.add(newConstr);
        }
    }

    @Override
    public Tree visitClass(ClassTree node, Element p) {
        Element element = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        if (((Object)p).equals(element)) {
            return node;
        }
        return (Tree)super.visitClass(node, p);
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, Element p) {
        if (!this.refactoring.getReplace()) {
            return (Tree)super.visitIdentifier(node, p);
        }
        TreePath typePath = new TreePath(this.getCurrentPath(), node);
        this.rewriteType(typePath, p, node);
        return (Tree)super.visitIdentifier(node, p);
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree node, Element p) {
        if (!this.refactoring.getReplace()) {
            return (Tree)super.visitMethodInvocation(node, p);
        }
        TreePath currentPath = this.getCurrentPath();
        TypeMirror returnType = this.workingCopy.getTrees().getTypeMirror(currentPath);
        Element typeElement = this.workingCopy.getTypes().asElement(returnType);
        if (((Object)p).equals(typeElement)) {
            ExpressionTree methodSelect = node.getMethodSelect();
            if (methodSelect.getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree selectTree = (MemberSelectTree)methodSelect;
                TreePath methodSelectPath = this.workingCopy.getTrees().getPath(this.workingCopy.getCompilationUnit(), selectTree.getExpression());
                TypeMirror methodSelectType = this.workingCopy.getTrees().getTypeMirror(methodSelectPath);
                if (this.workingCopy.getTypes().isSameType(methodSelectType, returnType)) {
                    return (Tree)super.visitMethodInvocation(node, p);
                }
            }
            DeclaredType declaredType = (DeclaredType)returnType;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            LinkedList<ExpressionTree> types = new LinkedList<ExpressionTree>();
            for (TypeMirror typeMirror : typeArguments) {
                types.add((ExpressionTree)this.make.Type(typeMirror));
            }
            ExpressionTree ident = this.make.QualIdent(this.fqn);
            if (!types.isEmpty()) {
                ident = (ExpressionTree)((Object)this.make.ParameterizedType((Tree)ident, types));
            }
            NewClassTree newClass = this.make.NewClass(null, Collections.EMPTY_LIST, ident, Collections.singletonList(node), null);
            this.rewrite(node, newClass);
        }
        return (Tree)super.visitMethodInvocation(node, p);
    }

    private void rewriteType(TreePath typePath, Element p, Tree typeTree) {
        Element element = this.workingCopy.getTrees().getElement(typePath);
        if (((Object)p).equals(element)) {
            List<? extends Tree> typeArguments;
            ExpressionTree ident = this.make.QualIdent(this.fqn);
            if (typeTree.getKind() == Tree.Kind.PARAMETERIZED_TYPE && !(typeArguments = ((ParameterizedTypeTree)typeTree).getTypeArguments()).isEmpty()) {
                ident = (ExpressionTree)((Object)this.make.ParameterizedType((Tree)ident, typeArguments));
            }
            this.rewrite(typeTree, ident);
        }
    }

    @Override
    public Tree visitAssignment(AssignmentTree node, Element p) {
        ElementHandle handle;
        String[] getterSetter;
        Element enclosingElement;
        if (!this.refactoring.getReplace()) {
            return (Tree)super.visitAssignment(node, p);
        }
        ExpressionTree variable = node.getVariable();
        boolean isArray = false;
        while (variable.getKind() == Tree.Kind.ARRAY_ACCESS) {
            isArray = true;
            this.scan((Tree)((ArrayAccessTree)variable).getIndex(), p);
            variable = ((ArrayAccessTree)variable).getExpression();
        }
        Element el = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), variable));
        if (el != null && (enclosingElement = el.getEnclosingElement()) != null && ((Object)enclosingElement).equals(p) && (isArray || this.checkAssignmentInsideExpression()) && (getterSetter = this.getterSetterMap.get(handle = ElementHandle.create((Element)el))) != null) {
            if (isArray) {
                ExpressionTree invkgetter = this.createGetterInvokation(variable, getterSetter[0]);
                this.rewrite(variable, invkgetter);
            } else {
                ExpressionTree setter = this.createMemberSelection(variable, getterSetter[1]);
                Trees trees = this.workingCopy.getTrees();
                ExpressionTree expTree = node.getExpression();
                TreePath varPath = trees.getPath(this.workingCopy.getCompilationUnit(), variable);
                TreePath expPath = trees.getPath(this.workingCopy.getCompilationUnit(), expTree);
                TypeMirror varType = trees.getTypeMirror(varPath);
                TypeMirror expType = trees.getTypeMirror(expPath);
                ExpressionTree newExpTree = this.workingCopy.getTypes().isSubtype(expType, varType) ? expTree : this.make.TypeCast(this.make.Type(varType), expTree);
                MethodInvocationTree invksetter = this.make.MethodInvocation(Collections.emptyList(), setter, Collections.singletonList(newExpTree));
                this.rewrite(node, invksetter);
            }
        }
        return this.scan((Tree)node.getExpression(), p);
    }

    @Override
    public Tree visitCompoundAssignment(CompoundAssignmentTree node, Element p) {
        ElementHandle handle;
        String[] getterSetter;
        Element enclosingElement;
        if (!this.refactoring.getReplace()) {
            return (Tree)super.visitCompoundAssignment(node, p);
        }
        ExpressionTree variable = node.getVariable();
        boolean isArray = false;
        while (variable.getKind() == Tree.Kind.ARRAY_ACCESS) {
            isArray = true;
            variable = ((ArrayAccessTree)variable).getExpression();
        }
        Element el = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), variable));
        if (el != null && (enclosingElement = el.getEnclosingElement()) != null && ((Object)enclosingElement).equals(p) && (isArray || this.checkAssignmentInsideExpression()) && (getterSetter = this.getterSetterMap.get(handle = ElementHandle.create((Element)el))) != null) {
            if (isArray) {
                ExpressionTree invkgetter = this.createGetterInvokation(variable, getterSetter[0]);
                this.rewrite(variable, invkgetter);
            } else {
                ExpressionTree setter = this.createMemberSelection(variable, getterSetter[1]);
                String s = node.getKind().name();
                s = s.substring(0, s.length() - "_ASSIGNMENT".length());
                Tree.Kind operator = Tree.Kind.valueOf(s);
                ExpressionTree invkgetter = this.createGetterInvokation(variable, getterSetter[0]);
                Trees trees = this.workingCopy.getTrees();
                ExpressionTree expTree = node.getExpression();
                TreePath varPath = trees.getPath(this.workingCopy.getCompilationUnit(), variable);
                TreePath expPath = trees.getPath(this.workingCopy.getCompilationUnit(), expTree);
                TypeMirror varType = trees.getTypeMirror(varPath);
                BinaryTree expTreeFake = this.make.Binary(operator, variable, expTree);
                TypeMirror expType = this.workingCopy.getTreeUtilities().attributeTree((Tree)expTreeFake, trees.getScope(expPath));
                ExpressionTree newExpTree = this.make.Binary(operator, invkgetter, expTree);
                if (!this.workingCopy.getTypes().isSubtype(expType, varType)) {
                    newExpTree = this.make.TypeCast(this.make.Type(varType), (ExpressionTree)this.make.Parenthesized(newExpTree));
                }
                MethodInvocationTree invksetter = this.make.MethodInvocation(Collections.emptyList(), setter, Collections.singletonList(newExpTree));
                this.rewrite(node, invksetter);
            }
        }
        return this.scan((Tree)node.getExpression(), p);
    }

    @Override
    public Tree visitUnary(UnaryTree node, Element p) {
        ElementHandle handle;
        String[] getterSetter;
        Element enclosingElement;
        boolean isArrayOrImmutable;
        if (!this.refactoring.getReplace()) {
            return (Tree)super.visitUnary(node, p);
        }
        ExpressionTree t = node.getExpression();
        Tree.Kind kind = node.getKind();
        boolean bl = isArrayOrImmutable = kind != Tree.Kind.POSTFIX_DECREMENT && kind != Tree.Kind.POSTFIX_INCREMENT && kind != Tree.Kind.PREFIX_DECREMENT && kind != Tree.Kind.PREFIX_INCREMENT;
        while (t.getKind() == Tree.Kind.ARRAY_ACCESS) {
            isArrayOrImmutable = true;
            t = ((ArrayAccessTree)t).getExpression();
        }
        Element el = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), t));
        if (el != null && (enclosingElement = el.getEnclosingElement()) != null && ((Object)enclosingElement).equals(p) && (isArrayOrImmutable || this.checkAssignmentInsideExpression()) && (getterSetter = this.getterSetterMap.get(handle = ElementHandle.create((Element)el))) != null) {
            ExpressionTree invkgetter = this.createGetterInvokation(t, getterSetter[0]);
            if (isArrayOrImmutable) {
                this.rewrite(t, invkgetter);
            } else {
                ExpressionTree setter = this.createMemberSelection(node.getExpression(), getterSetter[1]);
                Tree.Kind operator = kind == Tree.Kind.POSTFIX_INCREMENT || kind == Tree.Kind.PREFIX_INCREMENT ? Tree.Kind.PLUS : Tree.Kind.MINUS;
                Trees trees = this.workingCopy.getTrees();
                ExpressionTree expTree = node.getExpression();
                TreePath varPath = trees.getPath(this.workingCopy.getCompilationUnit(), expTree);
                TypeMirror varType = trees.getTypeMirror(varPath);
                PrimitiveType expType = this.workingCopy.getTypes().getPrimitiveType(TypeKind.INT);
                ExpressionTree newExpTree = this.make.Binary(operator, invkgetter, (ExpressionTree)this.make.Literal((Object)1));
                if (!this.workingCopy.getTypes().isSubtype(expType, varType)) {
                    newExpTree = this.make.TypeCast(this.make.Type(varType), (ExpressionTree)this.make.Parenthesized(newExpTree));
                }
                MethodInvocationTree invksetter = this.make.MethodInvocation(Collections.emptyList(), setter, Collections.singletonList(newExpTree));
                this.rewrite(node, invksetter);
            }
        }
        return null;
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, Element p) {
        ElementHandle handle;
        String[] getterSetter;
        Element enclosingElement;
        if (!this.refactoring.getReplace()) {
            return (Tree)super.visitMemberSelect(node, p);
        }
        Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        if (el != null && (enclosingElement = el.getEnclosingElement()) != null && ((Object)enclosingElement).equals(p) && (getterSetter = this.getterSetterMap.get(handle = ElementHandle.create((Element)el))) != null) {
            ExpressionTree nodeNew = this.createGetterInvokation(node, getterSetter[0]);
            this.rewrite(node, nodeNew);
        }
        return (Tree)super.visitMemberSelect(node, p);
    }

    private boolean checkAssignmentInsideExpression() {
        Tree exp1 = this.getCurrentPath().getLeaf();
        Tree parent = this.getCurrentPath().getParentPath().getLeaf();
        if (parent.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateInsideAssignment", (Object)exp1.toString(), (Object)parent.toString(), (Object)FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject()))));
            return false;
        }
        return true;
    }

    private ExpressionTree createGetterInvokation(ExpressionTree current, String getterName) {
        ExpressionTree getter = this.createMemberSelection(current, getterName);
        MethodInvocationTree invkgetter = this.make.MethodInvocation(Collections.emptyList(), getter, Collections.emptyList());
        return invkgetter;
    }

    private ExpressionTree createMemberSelection(ExpressionTree node, String name) {
        ExpressionTree selector;
        if (node.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree select = (MemberSelectTree)node;
            selector = this.make.MemberSelect(select.getExpression(), (CharSequence)name);
        } else {
            selector = this.make.Identifier((CharSequence)name);
        }
        return selector;
    }

    private static String stripPrefix(String identifierString) {
        String stripped = identifierString.startsWith(CLASS_FIELD_PREFIX) && identifierString.length() > 1 ? identifierString.substring(CLASS_FIELD_PREFIX.length()) : identifierString;
        return stripped;
    }

    private static StringBuilder getCapitalizedName(VariableElement field) {
        StringBuilder name = new StringBuilder(IntroduceLocalExtensionTransformer.stripPrefix(field.getSimpleName().toString()));
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        name.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        return name;
    }

    private String trimNewLines(String javadoc) {
        int st;
        if (javadoc == null) {
            return null;
        }
        int len = javadoc.length();
        int off = 0;
        char[] val = javadoc.toCharArray();
        for (st = 0; st < len && Character.isWhitespace(val[off + st]); ++st) {
        }
        while (st < len && Character.isWhitespace(val[off + len - 1])) {
            --len;
        }
        return st > 0 || len < val.length ? javadoc.substring(st, len) : javadoc;
    }

    Problem getProblem() {
        return this.problem;
    }

    private MethodTree createEqualsMethod(WorkingCopy wc, DeclaredType type, Tree typeTree) {
        TreeMaker make = wc.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        TypeElement objElement = wc.getElements().getTypeElement("java.lang.Object");
        List<VariableTree> params = Collections.singletonList(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"obj", objElement != null ? make.Type(objElement.asType()) : make.Identifier((CharSequence)"Object"), null));
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>();
        statements.add(make.If((ExpressionTree)make.Binary(Tree.Kind.EQUAL_TO, (ExpressionTree)make.Identifier((CharSequence)"obj"), (ExpressionTree)make.Identifier((CharSequence)"null")), (StatementTree)make.Return((ExpressionTree)make.Identifier((CharSequence)"false")), null));
        statements.add(make.If((ExpressionTree)make.Binary(Tree.Kind.NOT_EQUAL_TO, (ExpressionTree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.Identifier((CharSequence)"getClass"), Collections.emptyList()), (ExpressionTree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"obj"), (CharSequence)"getClass"), Collections.emptyList())), (StatementTree)make.Return((ExpressionTree)make.Identifier((CharSequence)"false")), null));
        statements.add(make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"other", typeTree, (ExpressionTree)make.TypeCast(typeTree, (ExpressionTree)make.Identifier((CharSequence)"obj"))));
        ExpressionTree condition = IntroduceLocalExtensionTransformer.prepareExpression(wc, EQUALS_PATTERNS, type, "delegate");
        statements.add(make.If(condition, (StatementTree)make.Return((ExpressionTree)make.Identifier((CharSequence)"false")), null));
        statements.add(make.Return((ExpressionTree)make.Identifier((CharSequence)"true")));
        BlockTree body = make.Block(statements, false);
        ModifiersTree modifiers = IntroduceLocalExtensionTransformer.prepareModifiers(wc, mods, make);
        return make.Method(modifiers, (CharSequence)"equals", (Tree)make.PrimitiveType(TypeKind.BOOLEAN), Collections.emptyList(), params, Collections.emptyList(), body, null);
    }

    private MethodTree createHashCodeMethod(WorkingCopy wc, DeclaredType type) {
        int multiplyNumber;
        int startNumber;
        TreeMaker make = wc.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        Integer number = (Integer)this.refactoring.getContext().lookup(Integer.class);
        if (number != null) {
            startNumber = number;
            multiplyNumber = number;
        } else {
            startNumber = IntroduceLocalExtensionTransformer.generatePrimeNumber(2, 10);
            multiplyNumber = IntroduceLocalExtensionTransformer.generatePrimeNumber(10, 100);
        }
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>();
        statements.add(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"hash", (Tree)make.PrimitiveType(TypeKind.INT), (ExpressionTree)make.Literal((Object)startNumber)));
        DeclaredType tm = type;
        ExpressionTree variableRead = IntroduceLocalExtensionTransformer.prepareExpression(wc, HASH_CODE_PATTERNS, tm, "delegate");
        statements.add(make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)make.Identifier((CharSequence)"hash"), (ExpressionTree)make.Binary(Tree.Kind.PLUS, (ExpressionTree)make.Binary(Tree.Kind.MULTIPLY, (ExpressionTree)make.Literal((Object)multiplyNumber), (ExpressionTree)make.Identifier((CharSequence)"hash")), variableRead))));
        statements.add(make.Return((ExpressionTree)make.Identifier((CharSequence)"hash")));
        BlockTree body = make.Block(statements, false);
        ModifiersTree modifiers = IntroduceLocalExtensionTransformer.prepareModifiers(wc, mods, make);
        return make.Method(modifiers, (CharSequence)"hashCode", (Tree)make.PrimitiveType(TypeKind.INT), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
    }

    private static boolean isPrimeNumber(int n) {
        int squareRoot = (int)Math.sqrt(n) + 1;
        if (n % 2 == 0) {
            return false;
        }
        for (int cntr = 3; cntr < squareRoot; ++cntr) {
            if (n % cntr != 0) continue;
            return false;
        }
        return true;
    }

    private static int generatePrimeNumber(int lowerLimit, int higherLimit) {
        if (randomNumber > 0) {
            return randomNumber;
        }
        Random r = new Random(System.currentTimeMillis());
        int proposed = r.nextInt(higherLimit - lowerLimit) + lowerLimit;
        while (!IntroduceLocalExtensionTransformer.isPrimeNumber(proposed)) {
            ++proposed;
        }
        if (proposed > higherLimit) {
            --proposed;
            while (!IntroduceLocalExtensionTransformer.isPrimeNumber(proposed)) {
                --proposed;
            }
        }
        return proposed;
    }

    private static ModifiersTree prepareModifiers(WorkingCopy wc, Set<Modifier> mods, TreeMaker make) {
        TypeElement override;
        LinkedList<AnnotationTree> annotations = new LinkedList<AnnotationTree>();
        if (IntroduceLocalExtensionTransformer.supportsOverride((CompilationInfo)wc) && (override = wc.getElements().getTypeElement("java.lang.Override")) != null) {
            annotations.add(wc.getTreeMaker().Annotation((Tree)wc.getTreeMaker().QualIdent((Element)override), Collections.emptyList()));
        }
        ModifiersTree modifiers = make.Modifiers(mods, annotations);
        return modifiers;
    }

    private static boolean supportsOverride(CompilationInfo info) {
        return SourceVersion.RELEASE_5.compareTo(info.getSourceVersion()) <= 0 && info.getElements().getTypeElement("java.lang.Override") != null;
    }

    private static KindOfType detectKind(CompilationInfo info, TypeMirror tm) {
        if (tm.getKind().isPrimitive()) {
            return KindOfType.valueOf(tm.getKind().name());
        }
        if (tm.getKind() == TypeKind.ARRAY) {
            return ((ArrayType)tm).getComponentType().getKind().isPrimitive() ? KindOfType.ARRAY_PRIMITIVE : KindOfType.ARRAY;
        }
        if (tm.getKind() == TypeKind.DECLARED) {
            Types t = info.getTypes();
            TypeElement en = info.getElements().getTypeElement("java.lang.Enum");
            if (en != null && t.isSubtype(tm, t.erasure(en.asType()))) {
                return KindOfType.ENUM;
            }
            if (((DeclaredType)tm).asElement().getKind().isClass() && ((TypeElement)((DeclaredType)tm).asElement()).getQualifiedName().contentEquals("java.lang.String")) {
                return KindOfType.STRING;
            }
        }
        return KindOfType.OTHER;
    }

    private static String choosePattern(CompilationInfo info, TypeMirror tm, Map<Acceptor, String> patterns) {
        for (Map.Entry<Acceptor, String> e : patterns.entrySet()) {
            if (!e.getKey().accept(info, tm)) continue;
            return e.getValue();
        }
        throw new IllegalStateException();
    }

    private static ExpressionTree prepareExpression(WorkingCopy wc, Map<Acceptor, String> patterns, TypeMirror tm, String ve) {
        String pattern = IntroduceLocalExtensionTransformer.choosePattern((CompilationInfo)wc, tm, patterns);
        assert (pattern != null);
        String conditionText = MapFormat.format((String)pattern, Collections.singletonMap("VAR", ve));
        ExpressionTree exp = wc.getTreeUtilities().parseExpression(conditionText, new SourcePositions[1]);
        exp = (ExpressionTree)GeneratorUtilities.get((WorkingCopy)wc).importFQNs((Tree)exp);
        return exp;
    }

    static {
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.BOOLEAN, KindOfType.BYTE, KindOfType.SHORT, KindOfType.INT, KindOfType.LONG, KindOfType.CHAR), "this.{VAR} != other.{VAR}");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.FLOAT), "java.lang.Float.floatToIntBits(this.{VAR}) != java.lang.Float.floatToIntBits(other.{VAR})");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.DOUBLE), "java.lang.Double.doubleToLongBits(this.{VAR}) != java.lang.Double.doubleToLongBits(other.{VAR})");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.ENUM), "this.{VAR} != other.{VAR}");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.ARRAY_PRIMITIVE), "! java.util.Arrays.equals(this.{VAR}, other.{VAR}");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.ARRAY), "! java.util.Arrays.deepEquals(this.{VAR}, other.{VAR}");
        EQUALS_PATTERNS.put(new MethodExistsAcceptor("java.util.Objects", "equals", SourceVersion.RELEASE_7), "! java.util.Objects.equals(this.{VAR}, other.{VAR})");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.STRING), "(this.{VAR} == null) ? (other.{VAR} != null) : !this.{VAR}.equals(other.{VAR})");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.OTHER), "this.{VAR} != other.{VAR} && (this.{VAR} == null || !this.{VAR}.equals(other.{VAR}))");
        HASH_CODE_PATTERNS = new LinkedHashMap<Acceptor, String>();
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.BYTE, KindOfType.SHORT, KindOfType.INT, KindOfType.CHAR), "this.{VAR}");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.LONG), "(int) (this.{VAR} ^ (this.{VAR} >>> 32))");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.FLOAT), "java.lang.Float.floatToIntBits(this.{VAR})");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.DOUBLE), "(int) (Double.doubleToLongBits(this.{VAR}) ^ (Double.doubleToLongBits(this.{VAR}) >>> 32))");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.BOOLEAN), "(this.{VAR} ? 1 : 0)");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.ENUM), "(this.{VAR} != null ? this.{VAR}.hashCode() : 0)");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.ARRAY_PRIMITIVE), "java.util.Arrays.hashCode(this.{VAR}");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.ARRAY), "java.util.Arrays.deepHashCode(this.{VAR}");
        HASH_CODE_PATTERNS.put(new MethodExistsAcceptor("java.util.Objects", "hashCode", SourceVersion.RELEASE_7), "java.util.Objects.hashCode(this.{VAR})");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.STRING), "(this.{VAR} != null ? this.{VAR}.hashCode() : 0)");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.OTHER), "(this.{VAR} != null ? this.{VAR}.hashCode() : 0)");
        randomNumber = -1;
    }

    private static interface Acceptor {
        public boolean accept(CompilationInfo var1, TypeMirror var2);
    }

    private static enum KindOfType {
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        CHAR,
        FLOAT,
        DOUBLE,
        ENUM,
        ARRAY_PRIMITIVE,
        ARRAY,
        STRING,
        OTHER;

    }

    private static final class MethodExistsAcceptor
    implements Acceptor {
        private final String fqn;
        private final String methodName;
        private final SourceVersion minimalVersion;

        public MethodExistsAcceptor(String fqn, String methodName) {
            this(fqn, methodName, null);
        }

        public MethodExistsAcceptor(String fqn, String methodName, SourceVersion minimalVersion) {
            this.fqn = fqn;
            this.methodName = methodName;
            this.minimalVersion = minimalVersion;
        }

        @Override
        public boolean accept(CompilationInfo info, TypeMirror tm) {
            if (this.minimalVersion != null && this.minimalVersion.compareTo(info.getSourceVersion()) > 0) {
                return false;
            }
            TypeElement clazz = info.getElements().getTypeElement(this.fqn);
            if (clazz == null) {
                return false;
            }
            for (ExecutableElement m : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
                if (!m.getSimpleName().contentEquals(this.methodName)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class SimpleAcceptor
    implements Acceptor {
        private final Set<KindOfType> kinds;

        public SimpleAcceptor(KindOfType kind) {
            this.kinds = EnumSet.of(kind);
        }

        public SimpleAcceptor(KindOfType kind, KindOfType ... moreKinds) {
            this.kinds = EnumSet.of(kind);
            this.kinds.addAll(Arrays.asList(moreKinds));
        }

        @Override
        public boolean accept(CompilationInfo info, TypeMirror tm) {
            return this.kinds.contains((Object)IntroduceLocalExtensionTransformer.detectKind(info, tm));
        }
    }
}

