/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.Pair;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.InlineRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveMembersTransformer;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class InlineMethodTransformer
extends RefactoringVisitor {
    private Trees trees;
    private MethodTree methodTree;
    private boolean hasParameters;
    private boolean initialized = false;
    private Problem problem;
    private HashMap<Tree, Tree> original2Translated;
    private Deque<Map<Tree, List<StatementTree>>> queue;
    private final TreePathHandle tph;

    public InlineMethodTransformer(TreePathHandle tph) {
        this.tph = tph;
        this.queue = new LinkedList<Map<Tree, List<StatementTree>>>();
    }

    public Problem getProblem() {
        return this.problem;
    }

    @Override
    public Tree scan(Tree tree, Element p) {
        if (!this.initialized) {
            this.initialized = true;
            this.trees = this.workingCopy.getTrees();
            this.methodTree = (MethodTree)this.trees.getTree(p);
            this.hasParameters = this.methodTree.getParameters().size() > 0;
        }
        return (Tree)super.scan(tree, p);
    }

    @Override
    public Tree visitClass(ClassTree node, Element p) {
        TreePath classPath = this.getCurrentPath();
        ClassTree classTree = node;
        for (Tree tree : classTree.getMembers()) {
            TreePath memberPath = new TreePath(classPath, tree);
            Element element = this.workingCopy.getTrees().getElement(memberPath);
            if (!((Object)p).equals(element)) continue;
            classTree = this.make.removeClassMember(classTree, tree);
            break;
        }
        if (classPath.getParentPath().getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            this.original2Translated.put(node, classTree);
            return (Tree)super.visitClass(node, p);
        }
        this.original2Translated = new HashMap();
        Tree value = (Tree)super.visitClass(node, p);
        classTree = (ClassTree)this.workingCopy.getTreeUtilities().translate((Tree)classTree, this.original2Translated);
        this.rewrite(node, classTree);
        return value;
    }

    @Override
    public Tree visitBlock(BlockTree node, Element p) {
        this.queue.add(new HashMap());
        Tree value = (Tree)super.visitBlock(node, p);
        Map<Tree, List<StatementTree>> original2TranslatedForBlock = this.queue.pollLast();
        LinkedList<StatementTree> newStatementList = new LinkedList<StatementTree>();
        if (!original2TranslatedForBlock.isEmpty()) {
            for (StatementTree statementTree : node.getStatements()) {
                List<StatementTree> stats = original2TranslatedForBlock.get(statementTree);
                if (stats != null) {
                    newStatementList.addAll(stats);
                    continue;
                }
                newStatementList.add(statementTree);
            }
            BlockTree newBlock = this.make.Block(newStatementList, node.isStatic());
            this.original2Translated.put(node, newBlock);
        }
        return value;
    }

    @Override
    public Tree visitMethod(MethodTree node, Element p) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return node;
        }
        return (Tree)super.visitMethod(node, p);
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree node, Element methodElement) {
        TreePath methodInvocationPath = this.getCurrentPath();
        ExecutableElement el = (ExecutableElement)this.trees.getElement(methodInvocationPath);
        if (((Object)methodElement).equals(el)) {
            Element element;
            Tree methodInvocation;
            LinkedList<StatementTree> newStatementList = new LinkedList<StatementTree>();
            HashMap<Tree, Tree> original2TranslatedBody = new HashMap<Tree, Tree>();
            TypeElement bodyEnclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(methodElement);
            TreePath findEnclosingClass = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, methodInvocationPath, true, true, true, true, true);
            Element invocationEnclosingTypeElement = this.workingCopy.getTrees().getElement(findEnclosingClass);
            boolean inSameClass = bodyEnclosingTypeElement.equals(invocationEnclosingTypeElement);
            boolean inStatic = !methodElement.getModifiers().contains((Object)Modifier.STATIC) && this.isInStaticContext(methodInvocationPath);
            TreePath statementPath = this.findCorrespondingStatement(methodInvocationPath);
            StatementTree statementTree = (StatementTree)statementPath.getLeaf();
            BlockTree body = this.methodTree.getBody();
            this.scanForNameClash(methodInvocationPath, body, methodElement);
            if (this.problem != null && this.problem.isFatal()) {
                return node;
            }
            if (this.hasParameters) {
                this.replaceParametersWithArguments(original2TranslatedBody, el, node, body);
            }
            body = (BlockTree)this.workingCopy.getTreeUtilities().translate((Tree)body, original2TranslatedBody);
            TreePath methodPath = this.trees.getPath(methodElement);
            TreePath bodyPath = new TreePath(methodPath, this.methodTree.getBody());
            Scope scope = this.workingCopy.getTrees().getScope(methodInvocationPath);
            ExpressionTree methodSelect = node.getMethodSelect();
            methodSelect = methodSelect.getKind() == Tree.Kind.MEMBER_SELECT ? ((MemberSelectTree)methodSelect).getExpression() : null;
            for (int i = 0; i < body.getStatements().size() - 1; ++i) {
                StatementTree statement = body.getStatements().get(i);
                if (!inSameClass || inStatic) {
                    statement = (StatementTree)this.fixReferences(statement, new TreePath(bodyPath, statement), el, scope, methodSelect);
                    if (!inSameClass) {
                        statement = (StatementTree)GeneratorUtilities.get((WorkingCopy)this.workingCopy).importFQNs((Tree)statement);
                    }
                }
                newStatementList.add(statement);
            }
            Tree parent = methodInvocationPath.getParentPath().getLeaf();
            Tree grandparent = null;
            if (parent.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                methodInvocation = node;
            } else {
                grandparent = methodInvocationPath.getParentPath().getParentPath().getLeaf();
                switch (grandparent.getKind()) {
                    case FOR_LOOP: 
                    case ENHANCED_FOR_LOOP: 
                    case WHILE_LOOP: 
                    case DO_WHILE_LOOP: 
                    case IF: {
                        methodInvocation = grandparent;
                        break;
                    }
                    default: {
                        methodInvocation = parent;
                    }
                }
            }
            Tree lastStatement = body.getStatements().size() > 0 ? (Tree)body.getStatements().get(body.getStatements().size() - 1) : null;
            if (lastStatement != null && (!inSameClass || inStatic)) {
                lastStatement = this.fixReferences(lastStatement, new TreePath(bodyPath, lastStatement), el, scope, methodSelect);
                if (!inSameClass) {
                    lastStatement = GeneratorUtilities.get((WorkingCopy)this.workingCopy).importFQNs(lastStatement);
                }
            }
            if ((lastStatement = this.translateLastStatement(body, parent, grandparent, newStatementList, lastStatement)) != null) {
                StatementTree translate = (StatementTree)this.workingCopy.getTreeUtilities().translate((Tree)statementTree, Collections.singletonMap(methodInvocation, lastStatement));
                newStatementList.add(translate);
            }
            if ((element = this.workingCopy.getTrees().getElement(statementPath)) != null && element.getKind() == ElementKind.FIELD) {
                if (newStatementList.size() != 1) {
                    SourcePositions positions = this.workingCopy.getTrees().getSourcePositions();
                    long startPosition = positions.getStartPosition(this.workingCopy.getCompilationUnit(), node);
                    long lineNumber = this.workingCopy.getCompilationUnit().getLineMap().getLineNumber(startPosition);
                    String source = FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject()) + ':' + lineNumber;
                    this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(InlineMethodTransformer.class, (String)"WRN_InlineMethodMultipleLines", (Object)source)));
                } else {
                    this.rewrite(statementTree, (Tree)newStatementList.get(0));
                }
            } else {
                Map<Tree, List<StatementTree>> original2TranslatedForBlock = this.queue.getLast();
                original2TranslatedForBlock.put(statementTree, newStatementList);
            }
        }
        return (Tree)super.visitMethodInvocation(node, methodElement);
    }

    private boolean isInStaticContext(TreePath methodInvocationPath) {
        TreePath parent;
        for (parent = methodInvocationPath.getParentPath(); parent != null && parent.getLeaf().getKind() != Tree.Kind.METHOD; parent = parent.getParentPath()) {
        }
        return parent != null && ((MethodTree)parent.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC);
    }

    private Tree fixReferences(Tree tree, TreePath treePath, final ExecutableElement method, final Scope scope, final ExpressionTree methodSelect) {
        final HashMap orig2trans = new HashMap();
        final ElementUtilities elementUtilities = this.workingCopy.getElementUtilities();
        final TypeElement bodyEnclosingTypeElement = elementUtilities.enclosingTypeElement((Element)method);
        TreePathScanner<Void, ExecutableElement> idScan = new TreePathScanner<Void, ExecutableElement>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, ExecutableElement p) {
                TreePath currentPath = this.getCurrentPath();
                if (currentPath.getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
                    return (Void)super.visitIdentifier(node, p);
                }
                Element el = InlineMethodTransformer.this.trees.getElement(currentPath);
                if (el != null) {
                    DeclaredType declaredType = InlineMethodTransformer.this.workingCopy.getTypes().getDeclaredType(scope.getEnclosingClass(), new TypeMirror[0]);
                    if (methodSelect != null && el.getEnclosingElement() != method && !InlineMethodTransformer.this.workingCopy.getTrees().isAccessible(scope, el, declaredType)) {
                        InlineMethodTransformer.this.problem = JavaPluginUtils.chainProblems(InlineMethodTransformer.this.problem, new Problem(false, NbBundle.getMessage(MoveMembersTransformer.class, (String)"WRN_InlineNotAccessible", (Object)el, (Object)declaredType)));
                    }
                    TypeElement invocationEnclosingTypeElement = elementUtilities.enclosingTypeElement(el);
                    if (el.getKind() != ElementKind.LOCAL_VARIABLE && bodyEnclosingTypeElement.equals(invocationEnclosingTypeElement)) {
                        if (el.getModifiers().contains((Object)Modifier.STATIC)) {
                            ExpressionTree newTree = InlineMethodTransformer.this.make.QualIdent(el);
                            orig2trans.put(node, newTree);
                        } else {
                            MemberSelectTree newTree = InlineMethodTransformer.this.make.MemberSelect(methodSelect, el);
                            orig2trans.put(node, newTree);
                        }
                    }
                }
                return (Void)super.visitIdentifier(node, p);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, ExecutableElement p) {
                TreePath currentPath = this.getCurrentPath();
                if (currentPath.getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
                    return (Void)super.visitMethodInvocation(node, p);
                }
                Element el = InlineMethodTransformer.this.trees.getElement(currentPath);
                if (el != null) {
                    TypeElement invocationEnclosingTypeElement;
                    DeclaredType declaredType = InlineMethodTransformer.this.workingCopy.getTypes().getDeclaredType(scope.getEnclosingClass(), new TypeMirror[0]);
                    if (methodSelect != null && el.getEnclosingElement() != method && !InlineMethodTransformer.this.workingCopy.getTrees().isAccessible(scope, el, declaredType)) {
                        InlineMethodTransformer.this.problem = JavaPluginUtils.chainProblems(InlineMethodTransformer.this.problem, new Problem(false, NbBundle.getMessage(MoveMembersTransformer.class, (String)"WRN_InlineNotAccessible", (Object)el, (Object)declaredType)));
                    }
                    if (bodyEnclosingTypeElement.equals(invocationEnclosingTypeElement = elementUtilities.enclosingTypeElement(el))) {
                        if (el.getModifiers().contains((Object)Modifier.STATIC)) {
                            ExpressionTree newTree = InlineMethodTransformer.this.make.QualIdent(el);
                            orig2trans.put(node.getMethodSelect(), newTree);
                        } else {
                            ExpressionTree methodInvocationSelect = node.getMethodSelect();
                            if (methodInvocationSelect.getKind() == Tree.Kind.MEMBER_SELECT) {
                                ExpressionTree expression = ((MemberSelectTree)methodInvocationSelect).getExpression();
                                String isThis = expression.toString();
                                if (isThis.equals("this") || isThis.endsWith(".this")) {
                                    orig2trans.put(expression, methodSelect);
                                } else {
                                    MemberSelectTree newTree = InlineMethodTransformer.this.make.MemberSelect(methodSelect, el);
                                    orig2trans.put(node, newTree);
                                }
                            } else {
                                MemberSelectTree newTree = InlineMethodTransformer.this.make.MemberSelect(methodSelect, el);
                                orig2trans.put(methodInvocationSelect, newTree);
                            }
                        }
                    }
                }
                return (Void)super.visitMethodInvocation(node, p);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree node, ExecutableElement p) {
                TreePath currentPath = this.getCurrentPath();
                Element el = InlineMethodTransformer.this.trees.getElement(currentPath);
                if (el != null) {
                    TypeElement invocationEnclosingTypeElement;
                    DeclaredType declaredType = InlineMethodTransformer.this.workingCopy.getTypes().getDeclaredType(scope.getEnclosingClass(), new TypeMirror[0]);
                    if (methodSelect != null && el.getEnclosingElement() != method && !InlineMethodTransformer.this.workingCopy.getTrees().isAccessible(scope, el, declaredType)) {
                        InlineMethodTransformer.this.problem = JavaPluginUtils.chainProblems(InlineMethodTransformer.this.problem, new Problem(false, NbBundle.getMessage(MoveMembersTransformer.class, (String)"WRN_InlineNotAccessible", (Object)el, (Object)declaredType)));
                    }
                    if (bodyEnclosingTypeElement.equals(invocationEnclosingTypeElement = elementUtilities.enclosingTypeElement(el))) {
                        if (el.getModifiers().contains((Object)Modifier.STATIC)) {
                            ExpressionTree newTree = InlineMethodTransformer.this.make.QualIdent(el);
                            orig2trans.put(node, newTree);
                        } else {
                            ExpressionTree expression = node.getExpression();
                            String isThis = expression.toString();
                            if (isThis.equals("this") || isThis.endsWith(".this")) {
                                if (methodSelect == null) {
                                    MemberSelectTree memberSelect = InlineMethodTransformer.this.make.MemberSelect(InlineMethodTransformer.this.workingCopy.getTreeUtilities().parseExpression(bodyEnclosingTypeElement.getSimpleName() + ".this", new SourcePositions[1]), el);
                                    orig2trans.put(node, memberSelect);
                                } else {
                                    orig2trans.put(expression, methodSelect);
                                }
                            } else if (methodSelect != null) {
                                MemberSelectTree newTree = InlineMethodTransformer.this.make.MemberSelect(methodSelect, el);
                                orig2trans.put(node, newTree);
                            }
                        }
                    }
                }
                return (Void)super.visitMemberSelect(node, p);
            }
        };
        idScan.scan(treePath, method);
        Tree result = this.workingCopy.getTreeUtilities().translate(tree, orig2trans);
        return result;
    }

    private void scanForNameClash(final TreePath methodInvocationPath, BlockTree body, Element p) {
        TreeScanner<Void, ExecutableElement> nameClashScanner = new TreeScanner<Void, ExecutableElement>(){

            @Override
            public Void visitVariable(VariableTree node, ExecutableElement p) {
                String msg;
                Element variable;
                TreePath path = InlineMethodTransformer.this.trees.getPath(InlineMethodTransformer.this.workingCopy.getCompilationUnit(), node);
                if (!(path == null || (variable = InlineMethodTransformer.this.trees.getElement(path)).getKind() == ElementKind.PARAMETER && p.getParameters().contains((VariableElement)variable) || (msg = RefactoringUtils.variableClashes(node.getName().toString(), methodInvocationPath, (CompilationInfo)InlineMethodTransformer.this.workingCopy)) == null)) {
                    InlineMethodTransformer.this.problem = MoveTransformer.createProblem(InlineMethodTransformer.this.problem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineMethodNameClash", (Object)msg));
                }
                return (Void)super.visitVariable(node, p);
            }
        };
        nameClashScanner.scan(body, (ExecutableElement)p);
    }

    private TreePath findCorrespondingStatement(TreePath methodInvocationPath) {
        TreePath statementPath;
        block3: for (statementPath = methodInvocationPath; statementPath != null; statementPath = statementPath.getParentPath()) {
            if (statementPath.getParentPath() == null) continue;
            switch (statementPath.getParentPath().getLeaf().getKind()) {
                case BLOCK: 
                case CLASS: {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        return statementPath;
    }

    private void replaceParametersWithArguments(final HashMap<Tree, Tree> original2TranslatedBody, ExecutableElement el, MethodInvocationTree node, BlockTree body) {
        Element resolved = this.tph.getElementHandle().resolve((CompilationInfo)this.workingCopy);
        final CompilationUnitTree compilationUnitTree = this.workingCopy.getTrees().getPath(resolved).getCompilationUnit();
        TreeScanner<Void, Pair<Element, ExpressionTree>> idScan = new TreeScanner<Void, Pair<Element, ExpressionTree>>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Pair<Element, ExpressionTree> p) {
                TreePath currentPath = InlineMethodTransformer.this.trees.getPath(compilationUnitTree, node);
                Element el = InlineMethodTransformer.this.trees.getElement(currentPath);
                if (((Object)((Element)p.first)).equals(el)) {
                    original2TranslatedBody.put(node, p.second);
                }
                return (Void)super.visitIdentifier(node, p);
            }
        };
        for (int i = 0; i < el.getParameters().size(); ++i) {
            ExpressionTree argument = node.getArguments().get(i);
            Element element = el.getParameters().get(i);
            Pair<Element, ExpressionTree> pair = Pair.of(element, argument);
            idScan.scan(body, pair);
        }
    }

    private Tree translateLastStatement(BlockTree body, Tree parent, Tree grandparent, List<StatementTree> newStatementList, Tree lastStatement) {
        Tree result = lastStatement;
        if (parent.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            if (result != null) {
                switch (result.getKind()) {
                    case EXPRESSION_STATEMENT: {
                        result = ((ExpressionStatementTree)result).getExpression();
                        break;
                    }
                    case RETURN: {
                        result = ((ReturnTree)result).getExpression();
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            if (result != null && result.getKind() == Tree.Kind.RETURN) {
                result = this.make.ExpressionStatement(((ReturnTree)result).getExpression());
            }
            switch (grandparent.getKind()) {
                case FOR_LOOP: {
                    ForLoopTree forLoopTree = (ForLoopTree)grandparent;
                    StatementTree statement = forLoopTree.getStatement();
                    if (statement == parent) {
                        this.addResultToStatementList(result, newStatementList);
                        statement = this.make.Block(newStatementList, false);
                        newStatementList.clear();
                    }
                    List<? extends ExpressionStatementTree> updates = forLoopTree.getUpdate();
                    LinkedList<ExpressionStatementTree> newUpdates = new LinkedList<ExpressionStatementTree>();
                    for (ExpressionStatementTree expressionStatementTree : updates) {
                        if (expressionStatementTree == parent) {
                            this.addResultToStatementList(result, newStatementList);
                            for (StatementTree statementTree : newStatementList) {
                                if (statementTree.getKind() != Tree.Kind.EXPRESSION_STATEMENT) break;
                                newUpdates.add((ExpressionStatementTree)statementTree);
                            }
                            newStatementList.clear();
                            continue;
                        }
                        newUpdates.add(expressionStatementTree);
                    }
                    List<? extends StatementTree> initializers = forLoopTree.getInitializer();
                    LinkedList<StatementTree> linkedList = new LinkedList<StatementTree>();
                    for (StatementTree statementTree : initializers) {
                        if (statementTree == parent) {
                            this.addResultToStatementList(result, newStatementList);
                            for (StatementTree statementTree1 : newStatementList) {
                                if (statementTree1.getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
                                    linkedList.add((ExpressionStatementTree)statementTree1);
                                    continue;
                                }
                                if (statementTree1.getKind() != Tree.Kind.VARIABLE) break;
                                linkedList.add((VariableTree)statementTree1);
                            }
                            newStatementList.clear();
                            continue;
                        }
                        linkedList.add(statementTree);
                    }
                    result = this.make.ForLoop(linkedList, forLoopTree.getCondition(), newUpdates, statement);
                    break;
                }
                case ENHANCED_FOR_LOOP: {
                    EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)grandparent;
                    StatementTree statement = enhancedForLoopTree.getStatement();
                    if (statement == parent) {
                        this.addResultToStatementList(result, newStatementList);
                        statement = this.make.Block(newStatementList, false);
                        newStatementList.clear();
                    }
                    result = this.make.EnhancedForLoop(enhancedForLoopTree.getVariable(), enhancedForLoopTree.getExpression(), statement);
                    break;
                }
                case WHILE_LOOP: {
                    WhileLoopTree whileLoopTree = (WhileLoopTree)grandparent;
                    StatementTree statement = whileLoopTree.getStatement();
                    if (statement == parent) {
                        this.addResultToStatementList(result, newStatementList);
                        statement = this.make.Block(newStatementList, false);
                        newStatementList.clear();
                    }
                    result = this.make.WhileLoop(whileLoopTree.getCondition(), statement);
                    break;
                }
                case DO_WHILE_LOOP: {
                    DoWhileLoopTree doWhileLoopTree = (DoWhileLoopTree)grandparent;
                    StatementTree statement = doWhileLoopTree.getStatement();
                    if (statement == parent) {
                        this.addResultToStatementList(result, newStatementList);
                        statement = this.make.Block(newStatementList, false);
                        newStatementList.clear();
                    }
                    result = this.make.DoWhileLoop(doWhileLoopTree.getCondition(), statement);
                    break;
                }
                case IF: {
                    StatementTree elseStatement;
                    IfTree ifTree = (IfTree)grandparent;
                    StatementTree thenStatement = ifTree.getThenStatement();
                    if (thenStatement == parent) {
                        this.addResultToStatementList(result, newStatementList);
                        thenStatement = this.make.Block(newStatementList, false);
                        newStatementList.clear();
                    }
                    if ((elseStatement = ifTree.getElseStatement()) == parent) {
                        this.addResultToStatementList(result, newStatementList);
                        elseStatement = this.make.Block(newStatementList, false);
                        newStatementList.clear();
                    }
                    result = this.make.If(ifTree.getCondition(), thenStatement, elseStatement);
                }
            }
        }
        return result;
    }

    private void addResultToStatementList(Tree result, List<StatementTree> newStatementList) {
        if (result != null) {
            newStatementList.add((StatementTree)result);
        }
    }
}

