/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.javadoc.Doc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.ChangeParamsJavaDocTransformer;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.netbeans.modules.refactoring.java.ui.ChangeParametersPanel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ChangeParamsTransformer
extends RefactoringVisitor {
    private static final Set<Modifier> ALL_ACCESS_MODIFIERS = EnumSet.of(Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC);
    private static final int NOPOS = -2;
    private Set<ElementHandle<ExecutableElement>> allMethods;
    private boolean synthConstructor;
    private Boolean constructorRefactoring;
    private final ChangeParametersRefactoring.ParameterInfo[] paramInfos;
    private Collection<? extends Modifier> newModifiers;
    private String returnType;
    private boolean compatible;
    private final ChangeParametersPanel.Javadoc javaDoc;
    private final TreePathHandle refactoringSource;
    private MethodTree origMethod;
    private Problem problem;
    private LinkedList<ClassTree> problemClasses = new LinkedList();

    public ChangeParamsTransformer(ChangeParametersRefactoring.ParameterInfo[] paramInfo, Collection<? extends Modifier> newModifiers, String returnType, boolean compatible, ChangeParametersPanel.Javadoc javaDoc, Set<ElementHandle<ExecutableElement>> am, TreePathHandle refactoringSource) {
        this.paramInfos = paramInfo;
        this.newModifiers = newModifiers;
        this.returnType = returnType;
        this.compatible = compatible;
        this.javaDoc = javaDoc;
        this.allMethods = am;
        this.refactoringSource = refactoringSource;
    }

    public Problem getProblem() {
        return this.problem;
    }

    @Override
    public void setWorkingCopy(WorkingCopy workingCopy) throws ToPhaseException {
        super.setWorkingCopy(workingCopy);
        if (this.origMethod == null && workingCopy.getFileObject().equals(this.refactoringSource.getFileObject())) {
            TreePath resolvedPath = this.refactoringSource.resolve((CompilationInfo)workingCopy);
            TreePath meth = JavaPluginUtils.findMethod(resolvedPath);
            this.origMethod = (MethodTree)meth.getLeaf();
        }
    }

    private void checkNewModifier(TreePath tree, Element p) throws MissingResourceException {
        ClassTree classTree = (ClassTree)JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, tree, true, true, true, true, false).getLeaf();
        if (!this.problemClasses.contains(classTree) && !this.newModifiers.contains((Object)Modifier.PUBLIC)) {
            Element el = this.workingCopy.getTrees().getElement(this.workingCopy.getTrees().getPath(this.workingCopy.getCompilationUnit(), classTree));
            TypeElement enclosingTypeElement1 = this.workingCopy.getElementUtilities().outermostTypeElement(el);
            TypeElement enclosingTypeElement2 = this.workingCopy.getElementUtilities().outermostTypeElement(p);
            if (!this.workingCopy.getTypes().isSameType(enclosingTypeElement1.asType(), enclosingTypeElement2.asType())) {
                if (this.newModifiers.contains((Object)Modifier.PRIVATE)) {
                    this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(ChangeParamsTransformer.class, (String)"ERR_StrongAccMod", (Object)((Object)Modifier.PRIVATE), (Object)enclosingTypeElement1));
                    this.problemClasses.add(classTree);
                } else {
                    PackageElement package1 = this.workingCopy.getElements().getPackageOf(el);
                    PackageElement package2 = this.workingCopy.getElements().getPackageOf(p);
                    if (!((Object)package1.getQualifiedName()).equals(package2.getQualifiedName())) {
                        if (this.newModifiers.contains((Object)Modifier.PROTECTED)) {
                            if (!this.workingCopy.getTypes().isSubtype(enclosingTypeElement1.asType(), enclosingTypeElement2.asType())) {
                                this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(ChangeParamsTransformer.class, (String)"ERR_StrongAccMod", (Object)((Object)Modifier.PROTECTED), (Object)enclosingTypeElement1));
                                this.problemClasses.add(classTree);
                            }
                        } else {
                            this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(ChangeParamsTransformer.class, (String)"ERR_StrongAccMod", (Object)"<default>", (Object)enclosingTypeElement1));
                            this.problemClasses.add(classTree);
                        }
                    }
                }
            }
        }
    }

    private void init() {
        if (this.constructorRefactoring == null) {
            Element el;
            ElementHandle<ExecutableElement> handle = this.allMethods.iterator().next();
            this.constructorRefactoring = handle.getKind() == ElementKind.CONSTRUCTOR;
            this.synthConstructor = this.constructorRefactoring != false && (el = handle.resolve((CompilationInfo)this.workingCopy)) != null && this.workingCopy.getElementUtilities().isSynthetic(el);
        }
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        this.init();
        return (Tree)super.visitCompilationUnit(node, p);
    }

    @Override
    public Tree visitClass(ClassTree node, Element p) {
        if (this.compatible) {
            List<? extends Tree> members = node.getMembers();
            for (int i = 0; i < members.size(); ++i) {
                ExecutableElement element;
                Tree tree = members.get(i);
                if (!tree.getKind().equals((Object)Tree.Kind.METHOD) || !((Object)p).equals(element = (ExecutableElement)this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), tree)))) continue;
                List<ExpressionTree> paramList = this.getNewCompatibleArguments();
                MethodInvocationTree methodInvocation = this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)(this.constructorRefactoring != false ? this.make.Identifier((CharSequence)"this") : this.make.Identifier((Element)element)), paramList);
                TypeMirror methodReturnType = element.getReturnType();
                boolean hasReturn = true;
                Types types = this.workingCopy.getTypes();
                if (types.isSameType(methodReturnType, types.getNoType(TypeKind.VOID))) {
                    hasReturn = false;
                }
                StatementTree statement = null;
                statement = hasReturn ? this.make.Return((ExpressionTree)methodInvocation) : this.make.ExpressionStatement((ExpressionTree)methodInvocation);
                GeneratorUtilities genutils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
                tree = genutils.importComments(tree, this.workingCopy.getCompilationUnit());
                BlockTree body = this.make.Block(Collections.singletonList(statement), false);
                BlockTree oldBody = ((MethodTree)tree).getBody();
                genutils.copyComments((Tree)oldBody, (Tree)body, true);
                genutils.copyComments((Tree)oldBody, (Tree)body, false);
                MethodTree newMethod = this.make.Method(element, body);
                genutils.copyComments(tree, (Tree)newMethod, true);
                genutils.copyComments(tree, (Tree)newMethod, false);
                ClassTree addMember = this.make.insertClassMember(node, i, (Tree)newMethod);
                this.rewrite(node, addMember);
            }
        }
        return (Tree)super.visitClass(node, p);
    }

    @Override
    public Tree visitNewClass(NewClassTree tree, Element p) {
        if (this.constructorRefactoring.booleanValue() && !this.compatible && !this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            ExecutableElement constructor = (ExecutableElement)p;
            Trees trees = this.workingCopy.getTrees();
            Element el = trees.getElement(this.getCurrentPath());
            if ((el = this.resolveAnonymousClassConstructor(el, tree, trees)) != null && this.isMethodMatch(el, p)) {
                List<ExpressionTree> arguments = this.getNewArguments(tree.getArguments(), false, constructor);
                NewClassTree nju = this.make.NewClass(tree.getEnclosingExpression(), tree.getTypeArguments(), tree.getIdentifier(), arguments, tree.getClassBody());
                this.rewrite(tree, nju);
            }
        }
        return (Tree)super.visitNewClass(tree, p);
    }

    private Element resolveAnonymousClassConstructor(Element el, NewClassTree tree, Trees trees) {
        Tree t;
        if (el != null && tree.getClassBody() != null && (t = trees.getTree(el)) != null && t.getKind() == Tree.Kind.METHOD) {
            MethodTree constructorTree = (MethodTree)t;
            Tree superCall = constructorTree.getBody().getStatements().get(0);
            TreePath superCallPath = trees.getPath(this.getCurrentPath().getCompilationUnit(), ((ExpressionStatementTree)superCall).getExpression());
            el = trees.getElement(superCallPath);
        }
        return el;
    }

    private List<ExpressionTree> getNewCompatibleArguments() {
        ArrayList<ExpressionTree> arguments = new ArrayList<ExpressionTree>();
        ChangeParametersRefactoring.ParameterInfo[] pi = this.paramInfos;
        for (int i = 0; i < pi.length; ++i) {
            int originalIndex = pi[i].getOriginalIndex();
            String value = originalIndex < 0 ? pi[i].getDefaultValue() : pi[i].getName();
            SourcePositions[] pos = new SourcePositions[1];
            ExpressionTree vt = this.workingCopy.getTreeUtilities().parseExpression(value, pos);
            arguments.add(vt);
        }
        return arguments;
    }

    private List<ExpressionTree> getNewArguments(List<? extends ExpressionTree> currentArguments, boolean passThrough, ExecutableElement method) {
        ArrayList<ExpressionTree> arguments = new ArrayList<ExpressionTree>();
        ChangeParametersRefactoring.ParameterInfo[] pi = this.paramInfos;
        for (int i = 0; i < pi.length; ++i) {
            ExpressionTree vt;
            int originalIndex = pi[i].getOriginalIndex();
            if (originalIndex < 0) {
                String value;
                SourcePositions[] pos = new SourcePositions[1];
                if (passThrough) {
                    value = pi[i].getName();
                    vt = this.workingCopy.getTreeUtilities().parseExpression(value, pos);
                } else {
                    value = pi[i].getDefaultValue();
                    if (i == pi.length - 1 && pi[i].getType().endsWith("...")) {
                        MethodInvocationTree parsedExpression = (MethodInvocationTree)this.workingCopy.getTreeUtilities().parseExpression("method(" + value + ")", pos);
                        for (ExpressionTree expressionTree : parsedExpression.getArguments()) {
                            arguments.add(this.translateExpression(expressionTree, currentArguments, method));
                        }
                        break;
                    }
                    vt = this.translateExpression(this.workingCopy.getTreeUtilities().parseExpression(value, pos), currentArguments, method);
                }
            } else {
                if (i == pi.length - 1 && pi[i].getType().endsWith("...") && method.isVarArgs() && method.getParameters().size() - 1 == originalIndex) {
                    for (int j = originalIndex; j < currentArguments.size(); ++j) {
                        arguments.add(currentArguments.get(j));
                    }
                    break;
                }
                vt = currentArguments.get(originalIndex);
            }
            arguments.add(vt);
        }
        return arguments;
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree tree, Element p) {
        if (!(!this.constructorRefactoring.booleanValue() && this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) || this.compatible)) {
            ExecutableElement method = (ExecutableElement)p;
            Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            if (el != null && this.isMethodMatch(el, method)) {
                if (this.newModifiers != null) {
                    this.checkNewModifier(this.getCurrentPath(), method);
                }
                TreePath enclosingMethod = JavaPluginUtils.findMethod(this.getCurrentPath());
                Element enclosingElement = this.workingCopy.getTrees().getElement(enclosingMethod);
                boolean passThrough = false;
                if (this.isMethodMatch(enclosingElement, method)) {
                    passThrough = true;
                }
                List<ExpressionTree> arguments = this.getNewArguments(tree.getArguments(), passThrough, method);
                MethodInvocationTree nju = this.make.MethodInvocation(tree.getTypeArguments(), tree.getMethodSelect(), arguments);
                if (this.constructorRefactoring.booleanValue() && this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                    this.rewriteSyntheticConstructor(nju);
                } else {
                    this.rewrite(tree, nju);
                }
            }
        }
        return (Tree)super.visitMethodInvocation(tree, p);
    }

    private void rewriteSyntheticConstructor(MethodInvocationTree nju) {
        TreePath constructorPath;
        for (constructorPath = this.getCurrentPath(); constructorPath != null && constructorPath.getLeaf().getKind() != Tree.Kind.METHOD; constructorPath = constructorPath.getParentPath()) {
        }
        if (constructorPath != null) {
            MethodTree constrTree = (MethodTree)constructorPath.getLeaf();
            BlockTree body = constrTree.getBody();
            body = this.make.removeBlockStatement(body, 0);
            body = this.make.insertBlockStatement(body, 0, (StatementTree)this.make.ExpressionStatement((ExpressionTree)nju));
            if (this.workingCopy.getTreeUtilities().isSynthetic(constructorPath)) {
                MethodTree njuConstructor = this.make.Method(this.make.Modifiers(constrTree.getModifiers().getFlags(), constrTree.getModifiers().getAnnotations()), (CharSequence)constrTree.getName(), constrTree.getReturnType(), constrTree.getTypeParameters(), constrTree.getParameters(), constrTree.getThrows(), body, (ExpressionTree)constrTree.getDefaultValue());
                this.rewrite(constrTree, njuConstructor);
            } else {
                this.rewrite(constrTree.getBody(), body);
            }
        }
    }

    @Override
    public Tree visitMethod(MethodTree tree, Element p) {
        if (this.constructorRefactoring.booleanValue() && this.isSyntheticConstructorOfAnnonymousClass(this.workingCopy.getTrees().getElement(this.getCurrentPath()))) {
            return tree;
        }
        this.renameDeclIfMatch(this.getCurrentPath(), tree, p);
        return (Tree)super.visitMethod(tree, p);
    }

    private void renameDeclIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (!this.synthConstructor && this.workingCopy.getTreeUtilities().isSynthetic(path)) {
            return;
        }
        GeneratorUtilities genutils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
        MethodTree current = !this.compatible ? (MethodTree)genutils.importComments((Tree)((MethodTree)tree), this.workingCopy.getCompilationUnit()) : (MethodTree)tree;
        Element el = this.workingCopy.getTrees().getElement(path);
        if (this.isMethodMatch(el, elementToFind)) {
            ExecutableElement exEl;
            String oldReturnType;
            List<? extends VariableTree> currentParameters = current.getParameters();
            ArrayList<VariableTree> newParameters = new ArrayList<VariableTree>(this.paramInfos.length);
            ChangeParametersRefactoring.ParameterInfo[] p = this.paramInfos;
            for (int i = 0; i < p.length; ++i) {
                VariableTree vt;
                int originalIndex = p[i].getOriginalIndex();
                if (originalIndex < 0) {
                    boolean isVarArgs = i == p.length - 1 && p[i].getType().endsWith("...");
                    vt = this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)p[i].getName(), (Tree)this.make.Identifier((CharSequence)(isVarArgs ? p[i].getType().replace("...", "") : p[i].getType())), null);
                } else {
                    String newType;
                    VariableTree originalVt = currentParameters.get(originalIndex);
                    boolean isVarArgs = i == p.length - 1 && p[i].getType().endsWith("...");
                    String string = newType = isVarArgs ? p[i].getType().replace("...", "") : p[i].getType();
                    Tree typeTree = this.origMethod != null ? (p[i].getType().equals(this.origMethod.getParameters().get(originalIndex).getType().toString()) ? originalVt.getType() : this.make.Identifier((CharSequence)newType)) : this.make.Identifier((CharSequence)newType);
                    vt = this.make.Variable(originalVt.getModifiers(), (CharSequence)originalVt.getName(), typeTree, originalVt.getInitializer());
                }
                newParameters.add(vt);
            }
            HashSet<Modifier> modifiers = new HashSet<Modifier>(current.getModifiers().getFlags());
            if (this.newModifiers != null && !el.getEnclosingElement().getKind().isInterface()) {
                modifiers.removeAll(ALL_ACCESS_MODIFIERS);
                modifiers.addAll(this.newModifiers);
            }
            boolean applyNewReturnType = false;
            if (this.returnType != null && !this.returnType.equals(oldReturnType = ((Object)(exEl = (ExecutableElement)el).getReturnType()).toString())) {
                applyNewReturnType = true;
            }
            for (VariableTree vt : newParameters) {
                PackageElement packageOf;
                Set declaredTypes = this.workingCopy.getClasspathInfo().getClassIndex().getDeclaredTypes(vt.getType().toString(), ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class));
                HashSet declaredTypesMirr = new HashSet(declaredTypes);
                TypeElement type = null;
                for (ElementHandle typeName : declaredTypes) {
                    TypeElement te = this.workingCopy.getElements().getTypeElement(typeName.getQualifiedName());
                    if (te == null) {
                        Logger.getLogger(ChangeParamsTransformer.class.getName()).log(Level.INFO, "Cannot resolve type element \"{0}\".", typeName);
                        continue;
                    }
                    if (!te.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                    declaredTypesMirr.remove(typeName);
                }
                if (declaredTypesMirr.size() == 1) {
                    ElementHandle typeName = (ElementHandle)declaredTypesMirr.iterator().next();
                    TypeElement te = this.workingCopy.getElements().getTypeElement(typeName.getQualifiedName());
                    if (te == null) {
                        Logger.getLogger(ChangeParamsTransformer.class.getName()).log(Level.INFO, "Cannot resolve type element \"{0}\".", typeName);
                        continue;
                    }
                    type = te;
                }
                if (type == null || (packageOf = this.workingCopy.getElements().getPackageOf(type)).getQualifiedName().toString().equals("java.lang")) continue;
                try {
                    SourceUtils.resolveImport((CompilationInfo)this.workingCopy, (TreePath)path, (String)type.getQualifiedName().toString());
                }
                catch (NullPointerException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            MethodTree nju = this.make.Method(this.make.Modifiers(modifiers, current.getModifiers().getAnnotations()), (CharSequence)current.getName(), applyNewReturnType ? this.make.Type(this.returnType) : current.getReturnType(), current.getTypeParameters(), newParameters, current.getThrows(), current.getBody(), (ExpressionTree)current.getDefaultValue(), p.length > 0 && p[p.length - 1].getType().endsWith("..."));
            genutils.copyComments((Tree)current, (Tree)nju, true);
            genutils.copyComments((Tree)current, (Tree)nju, false);
            if (this.synthConstructor) {
                Comment comment = null;
                switch (this.javaDoc) {
                    case UPDATE: {
                        comment = ChangeParamsJavaDocTransformer.updateJavadoc((ExecutableElement)el, this.paramInfos, this.workingCopy);
                        List comments = this.workingCopy.getTreeUtilities().getComments((Tree)nju, true);
                        if (comments.isEmpty()) {
                            comment = null;
                            break;
                        }
                        if (((Comment)comments.get(0)).isDocComment()) {
                            this.make.removeComment((Tree)nju, 0, true);
                            break;
                        }
                        comment = null;
                        break;
                    }
                    case GENERATE: {
                        String returnTypeString;
                        Tree returnType = nju.getReturnType();
                        if (this.returnType == null) {
                            boolean hasReturn = false;
                            if (returnType != null && returnType.getKind().equals((Object)Tree.Kind.PRIMITIVE_TYPE) && !((PrimitiveTypeTree)returnType).getPrimitiveTypeKind().equals((Object)TypeKind.VOID)) {
                                hasReturn = true;
                            }
                            returnTypeString = hasReturn ? returnType.toString() : null;
                        } else {
                            returnTypeString = this.returnType.equals("void") ? null : this.returnType;
                        }
                        comment = ChangeParamsJavaDocTransformer.generateJavadoc(newParameters, returnTypeString, current);
                    }
                }
                if (comment != null) {
                    this.make.addComment((Tree)nju, comment, true);
                }
            }
            this.rewrite(tree, nju);
        }
    }

    private boolean isMethodMatch(Element method, Element p) {
        if (this.compatible) {
            return (method.getKind() == ElementKind.METHOD || method.getKind() == ElementKind.CONSTRUCTOR) && method == p;
        }
        if ((method.getKind() == ElementKind.METHOD || method.getKind() == ElementKind.CONSTRUCTOR) && this.allMethods != null) {
            for (ElementHandle<ExecutableElement> mh : this.allMethods) {
                ExecutableElement baseMethod = (ExecutableElement)mh.resolve((CompilationInfo)this.workingCopy);
                if (baseMethod == null) {
                    Logger.getLogger("org.netbeans.modules.refactoring.java").info("ChangeParamsTransformer cannot resolve " + mh);
                    continue;
                }
                if (!baseMethod.equals(method) && !this.workingCopy.getElements().overrides((ExecutableElement)method, baseMethod, this.workingCopy.getElementUtilities().enclosingTypeElement((Element)baseMethod))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSyntheticConstructorOfAnnonymousClass(Element el) {
        if (el != null && el.getKind() == ElementKind.CONSTRUCTOR && this.workingCopy.getElementUtilities().isSynthetic(el)) {
            Element enclosingElement = el.getEnclosingElement();
            return enclosingElement != null && enclosingElement.getKind().isClass() && ((TypeElement)enclosingElement).getNestingKind() == NestingKind.ANONYMOUS;
        }
        return false;
    }

    private String tagsToString(List<Tag> tags) {
        StringBuilder sb = new StringBuilder();
        for (Tag tag : tags) {
            sb.append(tag.name()).append(" ").append(tag.text()).append("\n");
        }
        return sb.toString();
    }

    private ExpressionTree translateExpression(ExpressionTree expressionTree, final List<? extends ExpressionTree> currentArguments, ExecutableElement p) {
        final HashMap original2Translated = new HashMap();
        boolean changed = false;
        do {
            original2Translated.clear();
            TreeScanner<Void, Void> idScan = new TreeScanner<Void, Void>(){

                @Override
                public Void visitIdentifier(IdentifierTree node, Void p) {
                    String name = node.getName().toString();
                    if (ChangeParamsTransformer.this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.MEMBER_SELECT) {
                        for (int i = 0; i < ChangeParamsTransformer.this.paramInfos.length; ++i) {
                            ChangeParametersRefactoring.ParameterInfo parameterInfo = ChangeParamsTransformer.this.paramInfos[i];
                            if (parameterInfo.getOriginalIndex() < 0 || !parameterInfo.getName().equals(name)) continue;
                            original2Translated.put(node, currentArguments.get(parameterInfo.getOriginalIndex()));
                        }
                    }
                    return (Void)super.visitIdentifier(node, p);
                }
            };
            idScan.scan(expressionTree, null);
            expressionTree = (ExpressionTree)this.workingCopy.getTreeUtilities().translate((Tree)expressionTree, original2Translated);
            original2Translated.clear();
            TreeScanner<Boolean, ExecutableElement> methodScanner = new TreeScanner<Boolean, ExecutableElement>(){

                @Override
                public Boolean visitMethodInvocation(MethodInvocationTree node, ExecutableElement p) {
                    Element el;
                    boolean changed = false;
                    TreePath path = ChangeParamsTransformer.this.workingCopy.getTrees().getPath(ChangeParamsTransformer.this.workingCopy.getCompilationUnit(), node);
                    if (path != null && (el = ChangeParamsTransformer.this.workingCopy.getTrees().getElement(path)) != null && ChangeParamsTransformer.this.isMethodMatch(el, p)) {
                        List arguments = ChangeParamsTransformer.this.getNewArguments(node.getArguments(), false, p);
                        MethodInvocationTree nju = ChangeParamsTransformer.this.make.MethodInvocation(node.getTypeArguments(), node.getMethodSelect(), arguments);
                        original2Translated.put(node, nju);
                        changed = true;
                    }
                    return (Boolean)super.visitMethodInvocation(node, p) != false || changed;
                }

                @Override
                public Boolean reduce(Boolean r1, Boolean r2) {
                    return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
                }
            };
            boolean bl = changed = methodScanner.scan(expressionTree, p) == Boolean.TRUE;
            if (!changed) continue;
            expressionTree = (ExpressionTree)this.workingCopy.getTreeUtilities().translate((Tree)expressionTree, original2Translated);
        } while (changed);
        return expressionTree;
    }

    private static class ParamTagImpl
    implements ParamTag {
        private final String name;
        private final String comment;
        private final Doc holder;

        public ParamTagImpl(String name, String comment, Doc holder) {
            this.name = name;
            this.comment = comment;
            this.holder = holder;
        }

        public String parameterName() {
            return this.name;
        }

        public String parameterComment() {
            return this.comment;
        }

        public boolean isTypeParameter() {
            return false;
        }

        public String name() {
            return "@param";
        }

        public Doc holder() {
            return this.holder;
        }

        public String kind() {
            return this.name();
        }

        public String text() {
            return this.parameterName() + " " + this.parameterComment();
        }

        public Tag[] inlineTags() {
            return null;
        }

        public Tag[] firstSentenceTags() {
            return null;
        }

        public SourcePosition position() {
            return null;
        }
    }
}

