/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.ChangeParamsJavaDocTransformer;
import org.netbeans.modules.refactoring.java.plugins.ChangeParamsTransformer;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.ChangeParametersPanel;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class ChangeParametersPlugin
extends JavaRefactoringPlugin {
    private ChangeParametersRefactoring refactoring;
    private TreePathHandle treePathHandle;
    private RenameRefactoring[] renameDelegates;
    private boolean inited;
    private Set<ElementHandle<ExecutableElement>> allMethods;

    public ChangeParametersPlugin(ChangeParametersRefactoring refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    public Problem checkParameters() {
        this.initDelegates();
        Problem p = null;
        for (RenameRefactoring renameRefactoring : this.renameDelegates) {
            if ((p = JavaPluginUtils.chainProblems(p, renameRefactoring.fastCheckParameters())) == null || !p.isFatal()) continue;
            return p;
        }
        return p;
    }

    @Override
    public Problem fastCheckParameters(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.RESOLVED);
        ChangeParametersRefactoring.ParameterInfo[] paramTable = this.refactoring.getParameterInfo();
        ExecutableElement method = (ExecutableElement)this.treePathHandle.resolveElement((CompilationInfo)javac);
        Problem p = null;
        boolean isConstructor = method.getKind() == ElementKind.CONSTRUCTOR;
        Checks check = new Checks(javac);
        p = check.methodName(p, this.refactoring.getMethodName());
        TypeElement enclosingTypeElement = javac.getElementUtilities().enclosingTypeElement((Element)method);
        List<? extends Element> allMembers = javac.getElements().getAllMembers(enclosingTypeElement);
        if (!isConstructor) {
            p = check.returnType(p, this.refactoring.getReturnType(), method, enclosingTypeElement);
            p = check.duplicateSignature(p, paramTable, method, enclosingTypeElement, allMembers);
            p = check.accessModifiers(p, this.refactoring.getModifiers() != null ? this.refactoring.getModifiers() : method.getModifiers(), method, enclosingTypeElement, paramTable, this.cancelRequested);
        } else {
            p = check.duplicateConstructor(p, paramTable, method, enclosingTypeElement, allMembers);
        }
        for (int i = 0; i < paramTable.length; ++i) {
            ChangeParametersRefactoring.ParameterInfo parameterInfo = paramTable[i];
            p = check.checkParameterName(p, parameterInfo.getName());
            if (parameterInfo.getOriginalIndex() == -1) {
                p = check.defaultValue(p, parameterInfo.getDefaultValue());
            }
            p = check.duplicateParamName(p, paramTable, i);
            p = check.duplicateLocalName(p, paramTable, i, method);
            p = check.parameterType(p, paramTable, i, method, enclosingTypeElement);
        }
        return p;
    }

    private static String newParMessage(String par) {
        return new MessageFormat(ChangeParametersPlugin.getString("ERR_newpar")).format(new Object[]{ChangeParametersPlugin.getString(par)});
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ChangeParametersPlugin.class, (String)key);
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        final LinkedHashSet<FileObject> set = new LinkedHashSet<FileObject>();
        TreePathHandle tph = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        set.add(tph.getFileObject());
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{tph.getFileObject()});
        try {
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void run(CompilationController info) throws Exception {
                    ElementHandle encl;
                    ElementHandle handle;
                    ClassIndex idx = info.getClasspathInfo().getClassIndex();
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    ElementUtilities elmUtils = info.getElementUtilities();
                    ExecutableElement el = (ExecutableElement)ChangeParametersPlugin.this.treePathHandle.resolveElement((CompilationInfo)info);
                    ElementHandle methodHandle = ElementHandle.create((Element)el);
                    ElementHandle enclosingType = ElementHandle.create((Element)elmUtils.enclosingTypeElement((Element)el));
                    ChangeParametersPlugin.this.allMethods = new HashSet();
                    ChangeParametersPlugin.this.allMethods.add(methodHandle);
                    for (ExecutableElement e : JavaRefactoringUtils.getOverridingMethods(el, (CompilationInfo)info, ChangeParametersPlugin.this.cancelRequested)) {
                        handle = ElementHandle.create((Element)e);
                        set.add(SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo()));
                        encl = ElementHandle.create((Element)elmUtils.enclosingTypeElement((Element)e));
                        set.addAll(idx.getResources(encl, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        ChangeParametersPlugin.this.allMethods.add(ElementHandle.create((Element)e));
                    }
                    for (ExecutableElement e : JavaRefactoringUtils.getOverriddenMethods(el, (CompilationInfo)info)) {
                        handle = ElementHandle.create((Element)e);
                        set.add(SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo()));
                        encl = ElementHandle.create((Element)elmUtils.enclosingTypeElement((Element)e));
                        set.addAll(idx.getResources(encl, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        ChangeParametersPlugin.this.allMethods.add(ElementHandle.create((Element)e));
                    }
                    set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    set.add(SourceUtils.getFile((ElementHandle)methodHandle, (ClasspathInfo)info.getClasspathInfo()));
                }
            }, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return set;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        Set<FileObject> a = this.getRelevantFiles();
        this.fireProgressListenerStart(3, a.size() * 2 + 1);
        Problem problem = null;
        if (!a.isEmpty()) {
            this.initDelegates();
            this.fireProgressListenerStep();
            ChangeParamsTransformer changeParamsTransformer = new ChangeParamsTransformer(this.refactoring.getParameterInfo(), this.refactoring.getModifiers(), this.refactoring.getReturnType(), this.refactoring.isOverloadMethod(), (ChangeParametersPanel.Javadoc)((Object)this.refactoring.getContext().lookup(ChangeParametersPanel.Javadoc.class)), this.allMethods, this.treePathHandle);
            ChangeParamsJavaDocTransformer changeJavaDocParamsTransformer = new ChangeParamsJavaDocTransformer(this.refactoring.getParameterInfo(), this.refactoring.getReturnType(), this.refactoring.isOverloadMethod(), (ChangeParametersPanel.Javadoc)((Object)this.refactoring.getContext().lookup(ChangeParametersPanel.Javadoc.class)), this.allMethods, this.treePathHandle);
            for (RenameRefactoring renameRefactoring : this.renameDelegates) {
                if ((problem = JavaPluginUtils.chainProblems(problem, renameRefactoring.prepare(elements.getSession()))) == null || !problem.isFatal()) continue;
                this.fireProgressListenerStop();
                return problem;
            }
            JavaRefactoringPlugin.TransformTask transformJavadoc = new JavaRefactoringPlugin.TransformTask(this, changeJavaDocParamsTransformer, this.treePathHandle);
            problem = JavaPluginUtils.chainProblems(problem, this.createAndAddElements(a, transformJavadoc, elements, this.refactoring));
            JavaRefactoringPlugin.TransformTask transform = new JavaRefactoringPlugin.TransformTask(this, changeParamsTransformer, this.treePathHandle);
            problem = JavaPluginUtils.chainProblems(problem, this.createAndAddElements(a, transform, elements, this.refactoring));
            problem = JavaPluginUtils.chainProblems(problem, changeParamsTransformer.getProblem());
        }
        this.fireProgressListenerStop();
        return problem;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        switch (p) {
            case CHECKPARAMETERS: 
            case FASTCHECKPARAMETERS: 
            case PRECHECK: 
            case PREPARE: {
                ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
                return JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
            }
        }
        return null;
    }

    @Override
    public Problem preCheck(CompilationController info) throws IOException {
        this.fireProgressListenerStart(1, 4);
        Problem preCheckProblem = null;
        info.toPhase(JavaSource.Phase.RESOLVED);
        preCheckProblem = ChangeParametersPlugin.isElementAvail(this.treePathHandle, (CompilationInfo)info);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        Element el = this.treePathHandle.resolveElement((CompilationInfo)info);
        if (el.getKind() != ElementKind.METHOD && el.getKind() != ElementKind.CONSTRUCTOR) {
            preCheckProblem = ChangeParametersPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_ChangeParamsWrongType"));
            return preCheckProblem;
        }
        preCheckProblem = JavaPluginUtils.isSourceElement(el, (CompilationInfo)info);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        if (info.getElementUtilities().enclosingTypeElement(el).getKind() == ElementKind.ANNOTATION_TYPE) {
            preCheckProblem = new Problem(true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_MethodsInAnnotationsNotSupported"));
            return preCheckProblem;
        }
        for (ExecutableElement e : JavaRefactoringUtils.getOverriddenMethods((ExecutableElement)el, (CompilationInfo)info)) {
            ElementHandle handle = ElementHandle.create((Element)e);
            if (!RefactoringUtils.isFromLibrary((ElementHandle<? extends Element>)handle, info.getClasspathInfo())) continue;
            preCheckProblem = ChangeParametersPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_CannnotRefactorLibrary", (Object)el));
        }
        this.fireProgressListenerStop();
        return preCheckProblem;
    }

    private void initDelegates() {
        if (this.inited) {
            return;
        }
        final LinkedList renameRefactoringsList = new LinkedList();
        try {
            this.getJavaSource(JavaRefactoringPlugin.Phase.PREPARE).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController javac) throws Exception {
                    javac.toPhase(JavaSource.Phase.RESOLVED);
                    ExecutableElement method = (ExecutableElement)ChangeParametersPlugin.this.treePathHandle.resolveElement((CompilationInfo)javac);
                    List<? extends VariableElement> parameters = method.getParameters();
                    ChangeParametersRefactoring.ParameterInfo[] paramTable = ChangeParametersPlugin.this.refactoring.getParameterInfo();
                    for (int i = 0; i < paramTable.length; ++i) {
                        VariableElement variable;
                        ChangeParametersRefactoring.ParameterInfo param = paramTable[i];
                        int origIndex = param.getOriginalIndex();
                        if (origIndex == -1 || (variable = parameters.get(origIndex)).getSimpleName().contentEquals(param.getName())) continue;
                        TreePath path = javac.getTrees().getPath(variable);
                        RenameRefactoring renameRefactoring = new RenameRefactoring(Lookups.singleton((Object)TreePathHandle.create((TreePath)path, (CompilationInfo)javac)));
                        renameRefactoring.setNewName(param.getName());
                        renameRefactoring.setSearchInComments(true);
                        renameRefactoringsList.add(renameRefactoring);
                    }
                    if (ChangeParametersPlugin.this.refactoring.getMethodName() != null && !method.getSimpleName().toString().equals(ChangeParametersPlugin.this.refactoring.getMethodName())) {
                        RenameRefactoring renameRefactoring = new RenameRefactoring(Lookups.singleton((Object)TreePathHandle.create((Element)method, (CompilationInfo)javac)));
                        renameRefactoring.setNewName(ChangeParametersPlugin.this.refactoring.getMethodName());
                        renameRefactoring.setSearchInComments(true);
                        renameRefactoringsList.add(renameRefactoring);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.renameDelegates = renameRefactoringsList.toArray(new RenameRefactoring[0]);
        this.inited = true;
    }

    static class Checks {
        protected CompilationController javac;

        public Checks(CompilationController javac) {
            this.javac = javac;
        }

        Problem methodName(Problem p, String methodName) {
            if (methodName != null && !Utilities.isJavaIdentifier((String)methodName)) {
                p = ChangeParametersPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_InvalidIdentifier", (Object)methodName));
            }
            return p;
        }

        Problem defaultValue(Problem p, String defaultValue) {
            if (defaultValue == null || defaultValue.length() < 1) {
                p = ChangeParametersPlugin.createProblem(p, true, ChangeParametersPlugin.newParMessage("ERR_pardefv"));
            }
            return p;
        }

        Problem checkParameterName(Problem p, String s) {
            if (s == null || s.length() < 1) {
                p = ChangeParametersPlugin.createProblem(p, true, ChangeParametersPlugin.newParMessage("ERR_parname"));
            } else if (!Utilities.isJavaIdentifier((String)s)) {
                p = ChangeParametersPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_InvalidIdentifier", (Object)s));
            }
            return p;
        }

        Problem duplicateParamName(Problem p, ChangeParametersRefactoring.ParameterInfo[] paramTable, int index) {
            String name = paramTable[index].getName();
            for (int j = 0; j < paramTable.length; ++j) {
                ChangeParametersRefactoring.ParameterInfo pInfo = paramTable[j];
                if (!pInfo.getName().equals(name) || index == j) continue;
                p = ChangeParametersPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_ParamAlreadyUsed", (Object)name));
            }
            return p;
        }

        Problem returnType(Problem p, String returnType, ExecutableElement method, TypeElement enclosingTypeElement) {
            if (returnType != null && returnType.length() < 1) {
                p = ChangeParametersPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_NoReturn", (Object)returnType));
            } else if (returnType != null) {
                TypeMirror parseType;
                TypeElement typeElement = this.javac.getElements().getTypeElement(returnType);
                TypeMirror typeMirror = parseType = typeElement == null ? null : typeElement.asType();
                if (parseType == null) {
                    boolean isGenericType = false;
                    List<? extends TypeParameterElement> typeParameters = method.getTypeParameters();
                    for (TypeParameterElement typeParameterElement : typeParameters) {
                        TypeParameterTree tpTree = (TypeParameterTree)this.javac.getTrees().getTree(typeParameterElement);
                        if (!returnType.equals(tpTree.getName().toString())) continue;
                        isGenericType = true;
                    }
                    if (!(isGenericType || (parseType = this.javac.getTreeUtilities().parseType(returnType, enclosingTypeElement)) != null && parseType.getKind() != TypeKind.ERROR)) {
                        p = ChangeParametersPlugin.createProblem(p, false, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"WRN_canNotResolveReturn", (Object)returnType));
                    }
                }
            }
            return p;
        }

        Problem duplicateSignature(Problem p, ChangeParametersRefactoring.ParameterInfo[] paramTable, ExecutableElement method, TypeElement enclosingTypeElement, List<? extends Element> allMembers) {
            List<ExecutableElement> methods = ElementFilter.methodsIn(allMembers);
            for (ExecutableElement exMethod : methods) {
                if (exMethod.equals(method) || !((Object)exMethod.getSimpleName()).equals(method.getSimpleName()) || exMethod.getParameters().size() != paramTable.length) continue;
                boolean sameParameters = true;
                boolean wideningConversion = true;
                for (int j = 0; j < exMethod.getParameters().size(); ++j) {
                    TypeMirror exType = exMethod.getParameters().get(j).asType();
                    String type = paramTable[j].getType();
                    TypeMirror paramType = this.javac.getTreeUtilities().parseType(type, enclosingTypeElement);
                    if (this.javac.getTypes().isSameType(exType, paramType)) continue;
                    sameParameters = false;
                    if (exType.getKind().isPrimitive() && paramType.getKind().isPrimitive()) {
                        switch (exType.getKind()) {
                            case DOUBLE: {
                                if (paramType.getKind().equals((Object)TypeKind.FLOAT)) break;
                            }
                            case FLOAT: {
                                if (paramType.getKind().equals((Object)TypeKind.LONG)) break;
                            }
                            case LONG: {
                                if (paramType.getKind().equals((Object)TypeKind.INT)) break;
                            }
                            case INT: {
                                if (paramType.getKind().equals((Object)TypeKind.SHORT)) break;
                            }
                            case SHORT: {
                                if (paramType.getKind().equals((Object)TypeKind.BYTE)) break;
                            }
                            case BYTE: {
                                wideningConversion = false;
                            }
                        }
                        continue;
                    }
                    wideningConversion = false;
                }
                if (sameParameters) {
                    p = ChangeParametersPlugin.createProblem(p, false, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_existingMethod", (Object)exMethod.toString(), (Object)enclosingTypeElement.getQualifiedName()));
                    continue;
                }
                if (!wideningConversion) continue;
                p = ChangeParametersPlugin.createProblem(p, false, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"WRN_wideningConversion", (Object)exMethod.toString(), (Object)enclosingTypeElement.getQualifiedName()));
            }
            return p;
        }

        Problem parameterType(Problem p, ChangeParametersRefactoring.ParameterInfo[] paramTable, int index, ExecutableElement method, TypeElement enclosingTypeElement) {
            String type = paramTable[index].getType();
            String name = paramTable[index].getName();
            String[] split = type.split(" ");
            type = split[split.length - 1];
            TypeMirror parseType = null;
            if (type == null || type.length() < 1) {
                p = ChangeParametersPlugin.createProblem(p, true, ChangeParametersPlugin.newParMessage("ERR_partype"));
            } else {
                TypeElement typeElement = this.javac.getElements().getTypeElement(type);
                TypeMirror typeMirror = parseType = typeElement == null ? null : typeElement.asType();
                if (parseType == null) {
                    boolean isGenericType = false;
                    List<? extends TypeParameterElement> typeParameters = method.getTypeParameters();
                    for (TypeParameterElement typeParameterElement : typeParameters) {
                        TypeParameterTree tpTree = (TypeParameterTree)this.javac.getTrees().getTree(typeParameterElement);
                        if (!type.equals(tpTree.getName().toString())) continue;
                        isGenericType = true;
                    }
                    if (!(isGenericType || (parseType = this.javac.getTreeUtilities().parseType(type, enclosingTypeElement)) != null && parseType.getKind() != TypeKind.ERROR)) {
                        p = ChangeParametersPlugin.createProblem(p, false, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"WRN_canNotResolve", (Object)type, (Object)name));
                    }
                }
            }
            int originalIndex = paramTable[index].getOriginalIndex();
            if (parseType != null && originalIndex > -1) {
                VariableElement parameterElement = method.getParameters().get(originalIndex);
                if (!this.javac.getTypes().isAssignable(parseType, parameterElement.asType())) {
                    if (type != null && type.endsWith("...") && parameterElement.asType().getKind() == TypeKind.ARRAY) {
                        ArrayType arrayType = (ArrayType)parameterElement.asType();
                        if (!this.javac.getTypes().isAssignable(parseType, arrayType.getComponentType())) {
                            p = ChangeParametersPlugin.createProblem(p, false, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"WRN_isNotAssignable", (Object)((Object)parameterElement.asType()).toString(), (Object)type));
                        }
                    } else {
                        p = ChangeParametersPlugin.createProblem(p, false, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"WRN_isNotAssignable", (Object)((Object)parameterElement.asType()).toString(), (Object)type));
                    }
                }
            }
            if (type != null && type.endsWith("...") && index != paramTable.length - 1) {
                p = ChangeParametersPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_VarargsFinalPosition", (Object[])new Object[0]));
            }
            return p;
        }

        Problem duplicateLocalName(Problem p, ChangeParametersRefactoring.ParameterInfo[] paramTable, int index, ExecutableElement method) {
            String name = paramTable[index].getName();
            int originalIndex = paramTable[index].getOriginalIndex();
            final VariableElement parameterElement = originalIndex == -1 ? null : method.getParameters().get(originalIndex);
            TreeScanner<Boolean, String> scanner = new TreeScanner<Boolean, String>(){

                @Override
                public Boolean visitVariable(VariableTree vt, String p) {
                    super.visitVariable(vt, p);
                    TreePath path = Checks.this.javac.getTrees().getPath(Checks.this.javac.getCompilationUnit(), vt);
                    Element element = Checks.this.javac.getTrees().getElement(path);
                    return vt.getName().contentEquals(p) && !((Object)element).equals(parameterElement);
                }

                @Override
                public Boolean reduce(Boolean left, Boolean right) {
                    return left != null && left != false || right != null && right != false;
                }
            };
            if (((Boolean)scanner.scan(this.javac.getTrees().getTree(method), name)).booleanValue() && !this.isParameterBeingRemoved(method, name, paramTable)) {
                p = ChangeParametersPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_NameAlreadyUsed", (Object)name));
            }
            return p;
        }

        Problem duplicateConstructor(Problem p, ChangeParametersRefactoring.ParameterInfo[] paramTable, ExecutableElement method, TypeElement enclosingTypeElement, List<? extends Element> allMembers) {
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(allMembers);
            for (ExecutableElement constructor : constructors) {
                if (constructor.equals(method) || constructor.getParameters().size() != paramTable.length) continue;
                boolean sameParameters = true;
                for (int j = 0; j < constructor.getParameters().size(); ++j) {
                    TypeMirror exType = constructor.getParameters().get(j).asType();
                    String type = paramTable[j].getType();
                    TypeMirror paramType = this.javac.getTreeUtilities().parseType(type, enclosingTypeElement);
                    if (this.javac.getTypes().isSameType(exType, paramType)) continue;
                    sameParameters = false;
                }
                if (!sameParameters) continue;
                p = ChangeParametersPlugin.createProblem(p, false, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_existingConstructor", (Object)constructor.toString(), (Object)enclosingTypeElement.getQualifiedName()));
            }
            return p;
        }

        private Problem accessModifiers(Problem p, Set<Modifier> modifiers, ExecutableElement method, TypeElement enclosingTypeElement, ChangeParametersRefactoring.ParameterInfo[] paramTable, AtomicBoolean cancel) {
            List<ExecutableElement> allMethods = this.findDuplicateSubMethods(enclosingTypeElement, method, paramTable, cancel);
            if (!allMethods.isEmpty()) {
                Collection<ExecutableElement> overridingMethods = JavaRefactoringUtils.getOverridingMethods(method, (CompilationInfo)this.javac, cancel);
                boolean willBeOverriden = false;
                for (ExecutableElement executableElement : allMethods) {
                    if (overridingMethods.contains(executableElement)) continue;
                    willBeOverriden = true;
                    break;
                }
                if (willBeOverriden) {
                    p = ChangeParametersPlugin.createProblem(p, false, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"WRN_MethodIsOverridden", (Object)enclosingTypeElement.toString()));
                }
            }
            for (ExecutableElement exMethod : allMethods) {
                if (this.javac.getTypes().isSameType(exMethod.getReturnType(), method.getReturnType())) continue;
                p = ChangeParametersPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_existingReturnType", (Object)exMethod.getSimpleName(), (Object)exMethod.getEnclosingElement().getSimpleName(), (Object)((Object)method.getReturnType()).toString(), (Object)((Object)exMethod.getReturnType()).toString(), (Object[])new Object[0]));
            }
            for (ExecutableElement exMethod : allMethods) {
                if (modifiers.contains((Object)Modifier.PRIVATE) || !RefactoringUtils.isWeakerAccess(exMethod.getModifiers(), modifiers)) continue;
                p = ChangeParametersPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_WeakerAccess", (Object)exMethod.getSimpleName(), (Object)exMethod.getEnclosingElement().getSimpleName()));
            }
            return p;
        }

        private List<ExecutableElement> findDuplicateSubMethods(TypeElement enclosingTypeElement, ExecutableElement method, ChangeParametersRefactoring.ParameterInfo[] paramTable, AtomicBoolean cancel) {
            LinkedList<ExecutableElement> returnmethods = new LinkedList<ExecutableElement>();
            Set<ElementHandle<TypeElement>> subTypes = RefactoringUtils.getImplementorsAsHandles(this.javac.getClasspathInfo().getClassIndex(), this.javac.getClasspathInfo(), enclosingTypeElement, cancel);
            for (ElementHandle<TypeElement> elementHandle : subTypes) {
                TypeElement subtype = (TypeElement)elementHandle.resolve((CompilationInfo)this.javac);
                if (subtype == null) continue;
                List<ExecutableElement> methods = ElementFilter.methodsIn(this.javac.getElements().getAllMembers(subtype));
                for (ExecutableElement exMethod : methods) {
                    if (exMethod.equals(method) || !((Object)exMethod.getSimpleName()).equals(method.getSimpleName()) || exMethod.getParameters().size() != paramTable.length) continue;
                    boolean sameParameters = true;
                    for (int j = 0; j < exMethod.getParameters().size(); ++j) {
                        TypeMirror exType = exMethod.getParameters().get(j).asType();
                        String type = paramTable[j].getType();
                        TypeMirror paramType = this.javac.getTreeUtilities().parseType(type, enclosingTypeElement);
                        if (this.javac.getTypes().isSameType(exType, paramType)) continue;
                        sameParameters = false;
                    }
                    if (!sameParameters) continue;
                    returnmethods.add(exMethod);
                }
            }
            return returnmethods;
        }

        boolean isParameterBeingRemoved(ExecutableElement method, String s, ChangeParametersRefactoring.ParameterInfo[] paramTable) {
            boolean beingRemoved = false;
            for (int j = 0; j < method.getParameters().size(); ++j) {
                VariableElement variable = method.getParameters().get(j);
                if (!variable.getSimpleName().contentEquals(s)) continue;
                boolean isInNewList = false;
                for (ChangeParametersRefactoring.ParameterInfo parameterInfo : paramTable) {
                    if (parameterInfo.getOriginalIndex() != j) continue;
                    isInNewList = true;
                }
                beingRemoved = !isInNewList;
                break;
            }
            return beingRemoved;
        }
    }
}

