/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.callhierarchy;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.awt.EventQueue;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeMirror;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ScanUtils;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.callhierarchy.Call;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyTopComponent;
import org.netbeans.modules.refactoring.java.plugins.FindUsagesVisitor;
import org.netbeans.modules.refactoring.java.plugins.JavaWhereUsedQueryPlugin;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

final class CallHierarchyTasks {
    private static final RequestProcessor RP = new RequestProcessor("Call Hierarchy Processor", 1);
    private static final Object LOCK = new Object();
    private static CancellableTask CURR_TASK;

    CallHierarchyTasks() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Object object = LOCK;
        synchronized (object) {
            if (CURR_TASK != null) {
                CURR_TASK.cancel();
            }
        }
    }

    public static void findCallers(Call c, boolean includeTest, boolean searchAll, Runnable resultHandler) {
        CallHierarchyTasks.stop();
        RP.post((Runnable)new CallersTask(c, resultHandler, includeTest, searchAll));
    }

    public static void findCallees(Call c, Runnable resultHandler) {
        CallHierarchyTasks.stop();
        CalleesTask t = new CalleesTask(c, resultHandler);
        RP.post((Runnable)t);
    }

    public static void resolveRoot(Lookup lookup, boolean isCallerGraph, Task<Call> rootCallback) {
        JavaSource js = null;
        RootResolver resolver = null;
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (ec != null) {
            JEditorPane[] openedPanes = ec.getOpenedPanes();
            StyledDocument doc = ec.getDocument();
            js = JavaSource.forDocument((Document)doc);
            resolver = new RootResolver(openedPanes[0].getCaretPosition(), isCallerGraph);
        }
        CallHierarchyTasks.postResolveRoot(js, resolver, rootCallback);
    }

    static void resolveRoot(TreePathHandle selection, boolean isCallerGraph, Task<Call> rootCallback) {
        JavaSource js = JavaSource.forFileObject((FileObject)selection.getFileObject());
        if (js == null) {
            Logger.getLogger(CallHierarchyTasks.class.getName()).log(Level.INFO, "Cannot get JavaSource for " + selection.getFileObject().getPath());
            return;
        }
        CallHierarchyTasks.postResolveRoot(js, new RootResolver(selection, isCallerGraph), rootCallback);
    }

    static void resolveRoot(JavaSource src, int position, boolean isCallerGraph, Task<Call> rootCallback) {
        RootResolver rr = new RootResolver(position, isCallerGraph);
        CallHierarchyTasks.postResolveRoot(src, rr, rootCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postResolveRoot(JavaSource src, final RootResolver rr, final Task<Call> callback) {
        CallHierarchyTasks.stop();
        Task<Call> task = callback;
        synchronized (task) {
            Task<CompilationController> ct = new Task<CompilationController>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(CompilationController parameter) throws Exception {
                    Task task = callback;
                    synchronized (task) {
                        rr.run(parameter);
                        callback.run((Object)rr.getRoot());
                    }
                }
            };
            final Future rootResolve = ScanUtils.postUserActionTask((JavaSource)src, (Task)ct);
            if (!rootResolve.isDone()) {
                CancellableTask t = new CancellableTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void cancel() {
                        rootResolve.cancel(true);
                        Object object = LOCK;
                        synchronized (object) {
                            if (CURR_TASK != this) {
                                return;
                            }
                        }
                        Call c = Call.createEmpty();
                        c.setCanceled(true);
                        try {
                            callback.run((Object)c);
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CallHierarchyTopComponent.findInstance().setRunningState(false);
                                }
                            });
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }

                    public void run(Object parameter) throws Exception {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
                Object object = LOCK;
                synchronized (object) {
                    CURR_TASK = t;
                }
                try {
                    Call tempNode = Call.createEmpty();
                    callback.run((Object)tempNode);
                    CallHierarchyTopComponent.findInstance().setRunningState(true);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static Call resolveRoot(JavaSource source, RootResolver resolver) {
        Call root = null;
        if (source != null && resolver != null) {
            try {
                ScanUtils.waitUserActionTask((JavaSource)source, (Task)resolver);
                root = resolver.getRoot();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return root;
    }

    private static void notifyRunningTask(boolean isRunning, CancellableTask t) {
    }

    private static abstract class CallTaskBase
    implements Runnable,
    CancellableTask<CompilationController> {
        protected final Call elmDesc;
        private final Runnable resultHandler;
        AtomicBoolean isCanceled = new AtomicBoolean(false);
        protected final List<Call> result = new ArrayList<Call>();

        protected abstract void runTask() throws Exception;

        public CallTaskBase(Call elmDesc, Runnable resultHandler) {
            this.elmDesc = elmDesc;
            this.resultHandler = resultHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyRunning(final boolean isRunning) {
            Object object = LOCK;
            synchronized (object) {
                CURR_TASK = isRunning ? this : null;
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CallHierarchyTopComponent.findInstance().setRunningState(isRunning);
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void cancel() {
            this.isCanceled.set(true);
        }

        protected boolean isCanceled() {
            if (Thread.interrupted()) {
                this.isCanceled.set(true);
            }
            return this.isCanceled.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.notifyRunning(true);
                this.runTask();
                this.elmDesc.setReferences(this.result);
                this.resultHandler.run();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.elmDesc.setCanceled(this.isCanceled());
                Object object = LOCK;
                synchronized (object) {
                    CURR_TASK = null;
                }
                this.notifyRunning(false);
            }
        }
    }

    private static final class CalleeScanner
    extends TreePathScanner<Void, Void> {
        private final CompilationInfo javac;
        private Map<Element, OccurrencesDesc> refs = new HashMap<Element, OccurrencesDesc>();
        private int elmCounter = 0;
        private boolean incomplete;

        public CalleeScanner(CompilationInfo javac) {
            this.javac = javac;
        }

        public List<OccurrencesDesc> getOccurrences() {
            return OccurrencesDesc.extract(this.refs);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
            this.resolvePath(this.getCurrentPath());
            return (Void)super.visitMethodInvocation(node, p);
        }

        @Override
        public Void visitNewClass(NewClassTree node, Void p) {
            this.resolvePath(this.getCurrentPath());
            return (Void)super.visitNewClass(node, p);
        }

        private void resolvePath(TreePath tpath) {
            Element resolved = this.javac.getTrees().getElement(tpath);
            if (this.javac.getElementUtilities().isErroneous(resolved) && SourceUtils.isScanInProgress()) {
                this.incomplete = true;
                return;
            }
            if (!(resolved == null || this.javac.getElementUtilities().isSynthetic(resolved) || resolved.getKind() != ElementKind.METHOD && resolved.getKind() != ElementKind.CONSTRUCTOR)) {
                this.addRef(resolved, tpath);
            }
        }

        private void addRef(Element ref, TreePath occurrence) {
            OccurrencesDesc desc = this.refs.get(ref);
            if (desc == null) {
                desc = new OccurrencesDesc(occurrence, ref, this.elmCounter++);
                this.refs.put(ref, desc);
            }
            desc.occurrences.add(occurrence);
        }
    }

    private static final class CalleesTask
    extends CallTaskBase {
        public CalleesTask(Call element, Runnable resultHandler) {
            super(element, resultHandler);
        }

        @Override
        protected void runTask() throws Exception {
            JavaSource js = JavaSource.forFileObject((FileObject)this.elmDesc.getSourceToQuery().getFileObject());
            if (js != null) {
                Future control = ScanUtils.postUserActionTask((JavaSource)js, (Task)this);
                control.get();
            }
        }

        public void run(CompilationController javac) throws Exception {
            if (this.isCanceled()) {
                this.elmDesc.setCanceled(true);
                return;
            }
            javac.toPhase(JavaSource.Phase.RESOLVED);
            TreePath resolved = this.elmDesc.getSourceToQuery().resolve((CompilationInfo)javac);
            if (resolved == null) {
                return;
            }
            Element resolvedElm = javac.getTrees().getElement(resolved);
            resolved = javac.getTrees().getPath(resolvedElm);
            if (resolved == null) {
                return;
            }
            CalleeScanner scanner = new CalleeScanner((CompilationInfo)javac);
            scanner.scan(resolved, null);
            this.elmDesc.setIncomplete(scanner.incomplete);
            for (OccurrencesDesc occurDesc : scanner.getOccurrences()) {
                if (this.isCanceled()) {
                    this.elmDesc.setCanceled(true);
                    return;
                }
                this.result.add(Call.createUsage((CompilationInfo)javac, occurDesc.selection, occurDesc.elm, this.elmDesc, occurDesc.occurrences));
            }
        }
    }

    private static final class CallersTask
    extends CallTaskBase {
        private final boolean includeTest;
        private final boolean searchAll;

        public CallersTask(Call elmDesc, Runnable resultHandler, boolean includeTest, boolean searchAll) {
            super(elmDesc, resultHandler);
            this.includeTest = includeTest;
            this.searchAll = searchAll;
        }

        @Override
        public void runTask() throws Exception {
            TreePathHandle sourceToQuery = this.elmDesc.getSourceToQuery();
            ClasspathInfo cpInfo = this.searchAll ? RefactoringUtils.getClasspathInfoFor(true, sourceToQuery.getFileObject()) : RefactoringUtils.getClasspathInfoFor(false, this.elmDesc.selection.getFileObject());
            Set<FileObject> relevantFiles = null;
            if (!this.isCanceled()) {
                relevantFiles = JavaWhereUsedQueryPlugin.getRelevantFiles(sourceToQuery, cpInfo, false, false, false, true, null, this.isCanceled);
                if (SourceUtils.isScanInProgress()) {
                    this.elmDesc.setIncomplete(true);
                }
            }
            if (!this.isCanceled()) {
                this.processFiles(relevantFiles, (Task<CompilationController>)this, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyRunning(final boolean isRunning) {
            Object object = LOCK;
            synchronized (object) {
                CURR_TASK = isRunning ? this : null;
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CallHierarchyTopComponent.findInstance().setRunningState(isRunning);
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void run(CompilationController javac) throws Exception {
            if (javac.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                return;
            }
            Element wanted = this.elmDesc.getSourceToQuery().resolveElement((CompilationInfo)javac);
            if (wanted == null) {
                return;
            }
            FindUsagesVisitor findVisitor = new FindUsagesVisitor(javac, false);
            findVisitor.scan(javac.getCompilationUnit(), wanted);
            Collection<TreePath> usages = findVisitor.getUsages();
            HashMap<Element, OccurrencesDesc> refs = new HashMap<Element, OccurrencesDesc>();
            int order = 0;
            for (TreePath treePath : usages) {
                ExpressionTree exp;
                TreePath declarationPath = CallersTask.resolveDeclarationContext(treePath);
                if (declarationPath == null) continue;
                Element elm = null;
                if (declarationPath.getLeaf().getKind() != Tree.Kind.BLOCK) {
                    elm = javac.getTrees().getElement(declarationPath);
                } else {
                    Element enclosing = javac.getTrees().getElement(declarationPath.getParentPath());
                    BlockTree block = (BlockTree)declarationPath.getLeaf();
                    elm = new InitializerElement(enclosing, block.isStatic());
                }
                if (elm == null || this.elmDesc.declaration != null && elm == this.elmDesc.declaration.resolveElement((CompilationInfo)javac) && treePath.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT && (exp = ((MemberSelectTree)treePath.getLeaf()).getExpression()).getKind() == Tree.Kind.IDENTIFIER && "super".contentEquals(((IdentifierTree)exp).getName())) continue;
                OccurrencesDesc occurDesc = (OccurrencesDesc)refs.get(elm);
                if (occurDesc == null) {
                    occurDesc = new OccurrencesDesc(declarationPath, elm, order++);
                    refs.put(elm, occurDesc);
                }
                occurDesc.occurrences.add(treePath);
            }
            ArrayList<Call> usageDescs = new ArrayList<Call>(refs.size());
            for (OccurrencesDesc occurDesc : OccurrencesDesc.extract(refs)) {
                Call newDesc = Call.createUsage((CompilationInfo)javac, occurDesc.selection, occurDesc.elm, this.elmDesc, occurDesc.occurrences);
                usageDescs.add(newDesc);
            }
            this.result.addAll(usageDescs);
        }

        private static TreePath resolveDeclarationContext(TreePath usage) {
            block5: for (TreePath declaration = usage; declaration != null; declaration = declaration.getParentPath()) {
                switch (declaration.getLeaf().getKind()) {
                    case BLOCK: {
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)declaration.getParentPath().getLeaf().getKind())) continue block5;
                        return declaration;
                    }
                    case METHOD: {
                        return declaration;
                    }
                    case VARIABLE: {
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)declaration.getParentPath().getLeaf().getKind())) continue block5;
                        return declaration;
                    }
                }
            }
            return null;
        }

        private Iterable<? extends List<FileObject>> groupByRoot(Iterable<? extends FileObject> data) {
            HashMap<FileObject, LinkedList<FileObject>> result = new HashMap<FileObject, LinkedList<FileObject>>();
            for (FileObject fileObject : data) {
                FileObject root;
                if (this.isCanceled()) {
                    return Collections.emptyList();
                }
                ClassPath cp = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                if (cp == null || (root = cp.findOwnerRoot(fileObject)) == null || !this.includeTest && UnitTestForSourceQuery.findSources((FileObject)root).length > 0) continue;
                LinkedList<FileObject> subr = (LinkedList<FileObject>)result.get(root);
                if (subr == null) {
                    subr = new LinkedList<FileObject>();
                    result.put(root, subr);
                }
                subr.add(fileObject);
            }
            return result.values();
        }

        protected final void processFiles(Set<FileObject> files, Task<CompilationController> task, ClasspathInfo info) throws IOException {
            Iterable<? extends List<FileObject>> work = this.groupByRoot(files);
            for (List<FileObject> list : work) {
                if (this.isCanceled()) {
                    return;
                }
                JavaSource javaSource = JavaSource.create((ClasspathInfo)(info == null ? ClasspathInfo.create((FileObject)list.get(0)) : info), list);
                javaSource.runUserActionTask(task, true);
            }
        }
    }

    private static final class InitializerElement
    implements Element {
        private static final Set<Modifier> STATICM = EnumSet.of(Modifier.STATIC);
        private final boolean isStatic;
        private final Element enclosing;

        public InitializerElement(Element enclosing, boolean isStatic) {
            this.isStatic = isStatic;
            this.enclosing = enclosing;
        }

        @Override
        public TypeMirror asType() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public ElementKind getKind() {
            return this.isStatic ? ElementKind.STATIC_INIT : ElementKind.INSTANCE_INIT;
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Modifier> getModifiers() {
            return this.isStatic ? STATICM : Collections.emptySet();
        }

        @Override
        public Name getSimpleName() {
            return null;
        }

        @Override
        public Element getEnclosingElement() {
            return this.enclosing;
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return Collections.emptyList();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class OccurrencesDesc
    implements Comparable<OccurrencesDesc> {
        final List<TreePath> occurrences = new ArrayList<TreePath>();
        final Element elm;
        final TreePath selection;
        final int order;

        public OccurrencesDesc(TreePath selection, Element elm, int order) {
            this.order = order;
            this.elm = elm;
            this.selection = selection;
        }

        @Override
        public int compareTo(OccurrencesDesc o) {
            return this.order - o.order;
        }

        public static List<OccurrencesDesc> extract(Map<Element, OccurrencesDesc> refs) {
            List<OccurrencesDesc> l;
            int size = refs.size();
            if (size > 0) {
                l = new ArrayList<OccurrencesDesc>(size);
                l.addAll(refs.values());
                Collections.sort(l);
            } else {
                l = Collections.emptyList();
            }
            return l;
        }
    }

    private static final class RootResolver
    implements Task<CompilationController> {
        private int offset = -1;
        private TreePathHandle tHandle;
        private final boolean isCallerGraph;
        private Call root;

        public RootResolver(TreePathHandle tHandle, boolean isCallerGraph) {
            this.tHandle = tHandle;
            this.isCallerGraph = isCallerGraph;
        }

        public RootResolver(int offset, boolean isCallerGraph) {
            this.offset = offset;
            this.isCallerGraph = isCallerGraph;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(CompilationController javac) throws Exception {
            TreePath tpath = null;
            Element method = null;
            RootResolver rootResolver = this;
            synchronized (rootResolver) {
                CURR_TASK = null;
            }
            javac.toPhase(JavaSource.Phase.RESOLVED);
            for (tpath = this.tHandle == null ? javac.getTreeUtilities().pathFor(this.offset) : this.tHandle.resolve((CompilationInfo)javac); tpath != null; tpath = tpath.getParentPath()) {
                Tree.Kind kind = tpath.getLeaf().getKind();
                if (kind != Tree.Kind.METHOD && kind != Tree.Kind.METHOD_INVOCATION && kind != Tree.Kind.MEMBER_SELECT) continue;
                method = ScanUtils.checkElement((CompilationInfo)javac, (Element)javac.getTrees().getElement(tpath));
                if (method != null && (method.getKind() == ElementKind.METHOD || method.getKind() == ElementKind.CONSTRUCTOR)) break;
                method = null;
            }
            if (method != null) {
                this.root = Call.createRoot((CompilationInfo)javac, tpath, method, this.isCallerGraph);
            }
        }

        public Call getRoot() {
            return this.root;
        }
    }
}

