/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.callhierarchy;

import java.util.HashSet;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyModel;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyTopComponent;
import org.netbeans.modules.refactoring.java.ui.JavaRefactoringGlobalAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class CallHierarchyAction
extends JavaRefactoringGlobalAction {
    public CallHierarchyAction() {
        super(NbBundle.getMessage(CallHierarchyAction.class, (String)"CTL_CallHierarchyAction"), ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/callhierarchy.png", (boolean)true));
    }

    @Override
    public void performAction(Lookup context) {
        CallHierarchyTopComponent win = CallHierarchyTopComponent.findInstance();
        win.open();
        win.requestActive();
        win.reset();
        win.setModel(CallHierarchyModel.create(context, win.getScopes(), win.getHierarchyType()));
    }

    @Override
    protected boolean enable(Lookup context) {
        HashSet nodes = new HashSet(context.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        if (n.getLookup().lookup(TreePathHandle.class) != null) {
            return true;
        }
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob == null) {
            return false;
        }
        FileObject fo = dob.getPrimaryFile();
        return JavaRefactoringUtils.isRefactorable(fo);
    }

    protected boolean asynchronous() {
        return false;
    }
}

