/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.text;

public class PrinterBuffer {
    private static final String EOL = System.getProperty("line.separator", "\n");
    private StringBuffer buffer = new StringBuffer();
    private String indentText = "    ";
    private int indentLevel = 0;

    public String getIndentText() {
        return this.indentText;
    }

    public void setIndentText(String indentText) {
        this.indentText = indentText;
    }

    public PrinterBuffer append(boolean b) {
        this.buffer.append(b);
        return this;
    }

    public PrinterBuffer append(char c) {
        this.buffer.append(c);
        return this;
    }

    public PrinterBuffer append(char[] str, int offset, int len) {
        this.buffer.append(str, offset, len);
        return this;
    }

    public PrinterBuffer append(char[] s) {
        this.buffer.append(s);
        return this;
    }

    public PrinterBuffer append(double d) {
        this.buffer.append(d);
        return this;
    }

    public PrinterBuffer append(float f) {
        this.buffer.append(f);
        return this;
    }

    public PrinterBuffer append(int i) {
        this.buffer.append(i);
        return this;
    }

    public PrinterBuffer append(long l) {
        this.buffer.append(l);
        return this;
    }

    public PrinterBuffer append(Object obj) {
        this.buffer.append(obj);
        return this;
    }

    public PrinterBuffer append(String s) {
        this.buffer.append(s);
        return this;
    }

    public PrinterBuffer indent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.buffer.append(this.getIndentText());
        }
        return this;
    }

    public PrinterBuffer eol() {
        this.buffer.append(EOL);
        return this;
    }

    public void raiseIndent() {
        ++this.indentLevel;
    }

    public void lowerIndent() {
        --this.indentLevel;
    }

    public int length() {
        return this.buffer.length();
    }

    public String toString() {
        return this.buffer.toString();
    }
}

