/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.text;

import java.util.HashMap;
import java.util.Map;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Compiler;

public class MaximumCapacityPatternCache
implements PatternCache {
    PatternCompiler compiler;
    Map<String, Pattern> map = new HashMap<String, Pattern>();

    public MaximumCapacityPatternCache() {
        this((PatternCompiler)new Perl5Compiler());
    }

    public MaximumCapacityPatternCache(PatternCompiler compiler) {
        this.compiler = compiler;
    }

    public Pattern addPattern(String expression) throws MalformedPatternException {
        Pattern result = this.map.get(expression);
        if (result == null) {
            result = this.compiler.compile(expression);
            this.map.put(expression, result);
        }
        return result;
    }

    public Pattern addPattern(String expression, int options) throws MalformedPatternException {
        Pattern result = this.map.get(expression);
        if (result == null) {
            result = this.compiler.compile(expression, options);
            this.map.put(expression, result);
        }
        return result;
    }

    public Pattern getPattern(String expression) throws MalformedCachePatternException {
        Pattern result = this.map.get(expression);
        if (result == null) {
            try {
                result = this.compiler.compile(expression);
            }
            catch (MalformedPatternException ex) {
                throw new MalformedCachePatternException(ex.getMessage());
            }
            this.map.put(expression, result);
        }
        return result;
    }

    public Pattern getPattern(String expression, int options) throws MalformedCachePatternException {
        Pattern result = this.map.get(expression);
        if (result == null) {
            try {
                result = this.compiler.compile(expression, options);
            }
            catch (MalformedPatternException ex) {
                throw new MalformedCachePatternException(ex.getMessage());
            }
            this.map.put(expression, result);
        }
        return result;
    }

    public int size() {
        return this.map.size();
    }

    public int capacity() {
        return 20;
    }
}

