/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.CollectionMeasurement;
import com.jeantessier.metrics.ContextAccumulatorMeasurement;
import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.MetricsConfiguration;
import com.jeantessier.metrics.NameListMeasurement;
import com.jeantessier.metrics.Printer;
import com.jeantessier.metrics.StatisticalMeasurement;
import com.jeantessier.metrics.SubMetricsAccumulatorMeasurement;
import java.io.PrintWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPrinter
extends Printer {
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final String DEFAULT_DTD_PREFIX = "http://depfind.sourceforge.net/dtd";
    private MetricsConfiguration configuration;

    public XMLPrinter(PrintWriter out, MetricsConfiguration configuration) {
        this(out, configuration, DEFAULT_ENCODING, DEFAULT_DTD_PREFIX);
    }

    public XMLPrinter(PrintWriter out, MetricsConfiguration configuration, String encoding, String dtdPrefix) {
        super(out);
        this.configuration = configuration;
        this.appendHeader(encoding, dtdPrefix);
    }

    private void appendHeader(String encoding, String dtdPrefix) {
        this.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\" ?>").eol();
        this.eol();
        this.append("<!DOCTYPE metrics SYSTEM \"").append(dtdPrefix).append("/metrics.dtd\">").eol();
        this.eol();
    }

    @Override
    public void visitMetrics(Metrics metrics) {
        this.indent().append("<metrics>").eol();
        this.raiseIndent();
        this.visitProjectMetrics(metrics);
        this.lowerIndent();
        this.indent().append("</metrics>").eol();
    }

    private void visitProjectMetrics(Metrics metrics) {
        if (this.isShowEmptyMetrics() || this.isShowHiddenMeasurements() || !metrics.isEmpty()) {
            this.indent().append("<project>").eol();
            this.raiseIndent();
            this.indent().append("<name>").append(metrics.getName()).append("</name>").eol();
            this.visitMeasurements(metrics, this.configuration.getProjectMeasurements());
            for (Metrics subMetrics : metrics.getSubMetrics()) {
                this.visitGroupMetrics(subMetrics);
            }
            this.lowerIndent();
            this.indent().append("</project>").eol();
        }
    }

    private void visitGroupMetrics(Metrics metrics) {
        if (this.isShowEmptyMetrics() || this.isShowHiddenMeasurements() || !metrics.isEmpty()) {
            this.indent().append("<group>").eol();
            this.raiseIndent();
            this.indent().append("<name>").append(metrics.getName()).append("</name>").eol();
            this.visitMeasurements(metrics, this.configuration.getGroupMeasurements());
            for (Metrics subMetrics : metrics.getSubMetrics()) {
                this.visitClassMetrics(subMetrics);
            }
            this.lowerIndent();
            this.indent().append("</group>").eol();
        }
    }

    private void visitClassMetrics(Metrics metrics) {
        if (this.isShowEmptyMetrics() || this.isShowHiddenMeasurements() || !metrics.isEmpty()) {
            this.indent().append("<class>").eol();
            this.raiseIndent();
            this.indent().append("<name>").append(metrics.getName()).append("</name>").eol();
            this.visitMeasurements(metrics, this.configuration.getClassMeasurements());
            for (Metrics subMetrics : metrics.getSubMetrics()) {
                this.visitMethodMetrics(subMetrics);
            }
            this.lowerIndent();
            this.indent().append("</class>").eol();
        }
    }

    private void visitMethodMetrics(Metrics metrics) {
        if (this.isShowEmptyMetrics() || this.isShowHiddenMeasurements() || !metrics.isEmpty()) {
            this.indent().append("<method>").eol();
            this.raiseIndent();
            this.indent().append("<name>").append(metrics.getName()).append("</name>").eol();
            this.visitMeasurements(metrics, this.configuration.getMethodMeasurements());
            this.lowerIndent();
            this.indent().append("</method>").eol();
        }
    }

    private void visitMeasurements(Metrics metrics, List<MeasurementDescriptor> descriptors) {
        for (MeasurementDescriptor descriptor : descriptors) {
            if (!this.isShowHiddenMeasurements() && !descriptor.isVisible()) continue;
            metrics.getMeasurement(descriptor.getShortName()).accept(this);
        }
    }

    @Override
    public void visitStatisticalMeasurement(StatisticalMeasurement measurement) {
        this.indent().append("<measurement>").eol();
        this.raiseIndent();
        this.indent().append("<short-name>").append(measurement.getShortName()).append("</short-name>").eol();
        this.indent().append("<long-name>").append(measurement.getLongName()).append("</long-name>").eol();
        this.indent().append("<value>").append(measurement.doubleValue()).append("</value>").eol();
        this.indent().append("<minimum>").append(measurement.getMinimum()).append("</minimum>").eol();
        this.indent().append("<median>").append(measurement.getMedian()).append("</median>").eol();
        this.indent().append("<average>").append(measurement.getAverage()).append("</average>").eol();
        this.indent().append("<standard-deviation>").append(measurement.getStandardDeviation()).append("</standard-deviation>").eol();
        this.indent().append("<maximum>").append(measurement.getMaximum()).append("</maximum>").eol();
        this.indent().append("<sum>").append(measurement.getSum()).append("</sum>").eol();
        this.indent().append("<nb-data-points>").append(measurement.getNbDataPoints()).append("</nb-data-points>").eol();
        this.lowerIndent();
        this.indent().append("</measurement>").eol();
    }

    @Override
    public void visitContextAccumulatorMeasurement(ContextAccumulatorMeasurement measurement) {
        this.visitCollectionMeasurement(measurement);
    }

    @Override
    public void visitNameListMeasurement(NameListMeasurement measurement) {
        this.visitCollectionMeasurement(measurement);
    }

    @Override
    public void visitSubMetricsAccumulatorMeasurement(SubMetricsAccumulatorMeasurement measurement) {
        this.visitCollectionMeasurement(measurement);
    }

    protected void visitCollectionMeasurement(CollectionMeasurement measurement) {
        this.indent().append("<measurement>").eol();
        this.raiseIndent();
        this.indent().append("<short-name>").append(measurement.getShortName()).append("</short-name>").eol();
        this.indent().append("<long-name>").append(measurement.getLongName()).append("</long-name>").eol();
        this.indent().append("<value>").append(measurement.getValue()).append("</value>").eol();
        this.indent().append("<members>").eol();
        this.raiseIndent();
        for (String member : measurement.getValues()) {
            this.indent().append("<member>").append((Object)member).append("</member>").eol();
        }
        this.lowerIndent();
        this.indent().append("</members>").eol();
        this.lowerIndent();
        this.indent().append("</measurement>").eol();
    }

    @Override
    protected void visitMeasurement(Measurement measurement) {
        this.indent().append("<measurement>").eol();
        this.raiseIndent();
        this.indent().append("<short-name>").append(measurement.getShortName()).append("</short-name>").eol();
        this.indent().append("<long-name>").append(measurement.getLongName()).append("</long-name>").eol();
        this.indent().append("<value>").append(measurement.getValue()).append("</value>").eol();
        this.lowerIndent();
        this.indent().append("</measurement>").eol();
    }
}

