/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.CollectionMeasurement;
import com.jeantessier.metrics.ContextAccumulatorMeasurement;
import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.NameListMeasurement;
import com.jeantessier.metrics.Printer;
import com.jeantessier.metrics.RatioMeasurement;
import com.jeantessier.metrics.StatisticalMeasurement;
import com.jeantessier.metrics.SubMetricsAccumulatorMeasurement;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextPrinter
extends Printer {
    private static final NumberFormat valueFormat = new DecimalFormat("#.##");
    private static final NumberFormat ratioFormat = new DecimalFormat("#%");
    private List<MeasurementDescriptor> descriptors;
    private boolean expandCollectionMeasurements;
    private Metrics currentMetrics = null;

    public TextPrinter(PrintWriter out, List<MeasurementDescriptor> descriptors) {
        super(out);
        this.descriptors = descriptors;
    }

    public boolean isExpandCollectionMeasurements() {
        return this.expandCollectionMeasurements;
    }

    public void setExpandCollectionMeasurements(boolean expandCollectionMeasurements) {
        this.expandCollectionMeasurements = expandCollectionMeasurements;
    }

    @Override
    public void visitMetrics(Metrics metrics) {
        if (this.isShowEmptyMetrics() || this.isShowHiddenMeasurements() || !metrics.isEmpty()) {
            this.currentMetrics = metrics;
            this.indent().append(metrics.getName()).eol();
            this.raiseIndent();
            for (MeasurementDescriptor descriptor : this.descriptors) {
                if (!this.isShowHiddenMeasurements() && !descriptor.isVisible()) continue;
                metrics.getMeasurement(descriptor.getShortName()).accept(this);
            }
            this.lowerIndent();
            this.eol();
        }
    }

    @Override
    public void visitStatisticalMeasurement(StatisticalMeasurement measurement) {
        this.indent().append(measurement.getLongName()).append(" (").append(measurement.getShortName()).append("): ").append(valueFormat.format(measurement.doubleValue()));
        try {
            RatioMeasurement ratio = (RatioMeasurement)this.currentMetrics.getMeasurement(measurement.getShortName() + "R");
            this.append(" (").append(ratioFormat.format(ratio.getValue())).append(")");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.append(" ").append(measurement);
        this.eol();
    }

    @Override
    public void visitRatioMeasurement(RatioMeasurement measurement) {
        if (!measurement.getShortName().endsWith("R")) {
            super.visitRatioMeasurement(measurement);
        }
    }

    @Override
    public void visitContextAccumulatorMeasurement(ContextAccumulatorMeasurement measurement) {
        super.visitContextAccumulatorMeasurement(measurement);
        this.visitCollectionMeasurement(measurement);
    }

    @Override
    public void visitNameListMeasurement(NameListMeasurement measurement) {
        super.visitNameListMeasurement(measurement);
        this.visitCollectionMeasurement(measurement);
    }

    @Override
    public void visitSubMetricsAccumulatorMeasurement(SubMetricsAccumulatorMeasurement measurement) {
        super.visitSubMetricsAccumulatorMeasurement(measurement);
        this.visitCollectionMeasurement(measurement);
    }

    protected void visitCollectionMeasurement(CollectionMeasurement measurement) {
        if (this.isExpandCollectionMeasurements()) {
            this.raiseIndent();
            for (String value : measurement.getValues()) {
                this.indent().append(value).eol();
            }
            this.lowerIndent();
        }
    }

    @Override
    protected void visitMeasurement(Measurement measurement) {
        this.indent().append(measurement.getLongName()).append(" (").append(measurement.getShortName()).append("): ").append(valueFormat.format(measurement.getValue()));
        try {
            RatioMeasurement ratio = (RatioMeasurement)this.currentMetrics.getMeasurement(measurement.getShortName() + "R");
            this.append(" (").append(ratioFormat.format(ratio.getValue())).append(")");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.eol();
    }
}

