/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.MeasurementBase;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.MeasurementVisitor;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.StatisticalMeasurement;
import java.io.BufferedReader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class RatioMeasurement
extends MeasurementBase {
    private String baseName;
    private int baseDispose;
    private String dividerName;
    private int dividerDispose;
    private double value = 0.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RatioMeasurement(MeasurementDescriptor descriptor, Metrics context, String initText) {
        super(descriptor, context, initText);
        try {
            BufferedReader in = new BufferedReader(new StringReader(initText));
            Perl5Util perl5Util = RatioMeasurement.perl();
            synchronized (perl5Util) {
                String disposeText;
                this.baseName = in.readLine().trim();
                if (RatioMeasurement.perl().match("/(.*)\\s+(dispose_\\w+)$/i", this.baseName)) {
                    this.baseName = RatioMeasurement.perl().group(1);
                    disposeText = RatioMeasurement.perl().group(2);
                    this.baseDispose = disposeText.equalsIgnoreCase("DISPOSE_IGNORE") ? 0 : (disposeText.equalsIgnoreCase("DISPOSE_MINIMUM") ? 1 : (disposeText.equalsIgnoreCase("DISPOSE_MEDIAN") ? 2 : (disposeText.equalsIgnoreCase("DISPOSE_AVERAGE") ? 3 : (disposeText.equalsIgnoreCase("DISPOSE_STANDARD_DEVIATION") ? 4 : (disposeText.equalsIgnoreCase("DISPOSE_MAXIMUM") ? 5 : (disposeText.equalsIgnoreCase("DISPOSE_SUM") ? 6 : (disposeText.equalsIgnoreCase("DISPOSE_NB_DATA_POINTS") ? 7 : 0)))))));
                } else {
                    this.baseDispose = 0;
                }
                this.dividerName = in.readLine().trim();
                if (RatioMeasurement.perl().match("/(.*)\\s+(dispose_\\w+)$/i", this.dividerName)) {
                    this.dividerName = RatioMeasurement.perl().group(1);
                    disposeText = RatioMeasurement.perl().group(2);
                    this.dividerDispose = disposeText.equalsIgnoreCase("DISPOSE_IGNORE") ? 0 : (disposeText.equalsIgnoreCase("DISPOSE_MINIMUM") ? 1 : (disposeText.equalsIgnoreCase("DISPOSE_MEDIAN") ? 2 : (disposeText.equalsIgnoreCase("DISPOSE_AVERAGE") ? 3 : (disposeText.equalsIgnoreCase("DISPOSE_STANDARD_DEVIATION") ? 4 : (disposeText.equalsIgnoreCase("DISPOSE_MAXIMUM") ? 5 : (disposeText.equalsIgnoreCase("DISPOSE_SUM") ? 6 : (disposeText.equalsIgnoreCase("DISPOSE_NB_DATA_POINTS") ? 7 : 0)))))));
                } else {
                    this.dividerDispose = 0;
                }
            }
            in.close();
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass()).debug((Object)("Cannot initialize with \"" + initText + "\""), (Throwable)ex);
            this.baseName = null;
            this.dividerName = null;
        }
    }

    public String getBaseName() {
        return this.baseName;
    }

    public int getBaseDispose() {
        return this.baseDispose;
    }

    public String getDividerName() {
        return this.dividerName;
    }

    public int getDividerDispose() {
        return this.dividerDispose;
    }

    public void accept(MeasurementVisitor visitor) {
        visitor.visitRatioMeasurement(this);
    }

    public boolean isEmpty() {
        if (!this.isCached()) {
            this.compute();
        }
        return super.isEmpty();
    }

    protected double compute() {
        if (!this.isCached()) {
            this.value = Double.NaN;
            if (this.getContext() != null && this.getBaseName() != null && this.getDividerName() != null) {
                StatisticalMeasurement stats;
                Measurement base = this.getContext().getMeasurement(this.getBaseName());
                Measurement divider = this.getContext().getMeasurement(this.getDividerName());
                double baseValue = Double.NaN;
                double dividerValue = Double.NaN;
                if (base instanceof StatisticalMeasurement) {
                    stats = (StatisticalMeasurement)base;
                    switch (this.getBaseDispose()) {
                        case 1: {
                            baseValue = stats.getMinimum();
                            break;
                        }
                        case 2: {
                            baseValue = stats.getMedian();
                            break;
                        }
                        case 3: {
                            baseValue = stats.getAverage();
                            break;
                        }
                        case 4: {
                            baseValue = stats.getStandardDeviation();
                            break;
                        }
                        case 5: {
                            baseValue = stats.getMaximum();
                            break;
                        }
                        case 6: {
                            baseValue = stats.getSum();
                            break;
                        }
                        case 7: {
                            baseValue = stats.getNbDataPoints();
                            break;
                        }
                        default: {
                            baseValue = stats.doubleValue();
                            break;
                        }
                    }
                } else if (base != null) {
                    baseValue = base.doubleValue();
                }
                if (divider instanceof StatisticalMeasurement) {
                    stats = (StatisticalMeasurement)divider;
                    switch (this.getDividerDispose()) {
                        case 1: {
                            dividerValue = stats.getMinimum();
                            break;
                        }
                        case 2: {
                            dividerValue = stats.getMedian();
                            break;
                        }
                        case 3: {
                            dividerValue = stats.getAverage();
                            break;
                        }
                        case 4: {
                            dividerValue = stats.getStandardDeviation();
                            break;
                        }
                        case 5: {
                            dividerValue = stats.getMaximum();
                            break;
                        }
                        case 6: {
                            dividerValue = stats.getSum();
                            break;
                        }
                        case 7: {
                            dividerValue = stats.getNbDataPoints();
                            break;
                        }
                        default: {
                            dividerValue = stats.doubleValue();
                            break;
                        }
                    }
                } else if (divider != null) {
                    dividerValue = divider.doubleValue();
                }
                this.value = baseValue / dividerValue;
            }
            this.setEmpty(Double.isNaN(this.value) || Double.isInfinite(this.value));
            this.setCached(true);
        }
        return this.value;
    }
}

