/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.CollectionMeasurement;
import com.jeantessier.metrics.MeasurementBase;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.MeasurementVisitor;
import com.jeantessier.metrics.Metrics;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameListMeasurement
extends MeasurementBase
implements CollectionMeasurement {
    private Collection<String> values;

    public NameListMeasurement(MeasurementDescriptor descriptor, Metrics context, String initText) {
        super(descriptor, context, initText);
        if (initText != null) {
            if (initText.trim().equalsIgnoreCase("list")) {
                this.values = new LinkedList<String>();
            } else if (initText.trim().equalsIgnoreCase("set")) {
                this.values = new HashSet<String>();
            } else {
                Logger.getLogger(this.getClass()).debug((Object)("Cannot initialize with \"" + initText + "\", using default value of SET instead"));
                this.values = new HashSet<String>();
            }
        } else {
            Logger.getLogger(this.getClass()).debug((Object)"Cannot initialize with null text, using default value of SET instead");
            this.values = new HashSet<String>();
        }
    }

    @Override
    public void add(Object object) {
        if (object instanceof String) {
            this.values.add((String)object);
        }
    }

    @Override
    public void accept(MeasurementVisitor visitor) {
        visitor.visitNameListMeasurement(this);
    }

    @Override
    public Number getValue() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    protected double compute() {
        return this.values.size();
    }

    @Override
    public Collection<String> getValues() {
        return Collections.unmodifiableCollection(this.values);
    }
}

