/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Deprecated_attribute;
import com.jeantessier.classreader.ExceptionHandler;
import com.jeantessier.classreader.FieldRef_info;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.InnerClass;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.InterfaceMethodRef_info;
import com.jeantessier.classreader.LineNumber;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.MethodRef_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.SignatureHelper;
import com.jeantessier.classreader.Synthetic_attribute;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.VisitorBase;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.MetricsEvent;
import com.jeantessier.metrics.MetricsFactory;
import com.jeantessier.metrics.MetricsListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricsGatherer
extends VisitorBase {
    private String projectName;
    private MetricsFactory factory;
    private Collection<String> scope = null;
    private Collection<String> filter = null;
    private Metrics currentProject;
    private Metrics currentGroup;
    private Metrics currentClass;
    private Metrics currentMethod;
    private int sloc;
    private boolean isSynthetic;
    private HashSet<MetricsListener> metricsListeners = new HashSet();

    public MetricsGatherer(String projectName, MetricsFactory factory) {
        this.projectName = projectName;
        this.factory = factory;
        this.setCurrentProject(this.getMetricsFactory().createProjectMetrics(this.getProjectName()));
    }

    public String getProjectName() {
        return this.projectName;
    }

    public MetricsFactory getMetricsFactory() {
        return this.factory;
    }

    public void setScopeIncludes(Collection<String> scope) {
        this.scope = scope;
    }

    public void setFilterIncludes(Collection<String> filter) {
        this.filter = filter;
    }

    private Metrics getCurrentProject() {
        return this.currentProject;
    }

    private void setCurrentProject(Metrics currentProject) {
        this.currentProject = currentProject;
    }

    private Metrics getCurrentGroup() {
        return this.currentGroup;
    }

    private void setCurrentGroup(Metrics currentGroup) {
        this.currentGroup = currentGroup;
    }

    private Metrics getCurrentClass() {
        return this.currentClass;
    }

    private void setCurrentClass(Metrics currentClass) {
        this.currentClass = currentClass;
    }

    private Metrics getCurrentMethod() {
        return this.currentMethod;
    }

    private void setCurrentMethod(Metrics currentMethod) {
        this.currentMethod = currentMethod;
    }

    @Override
    public void visitClassfiles(Collection<Classfile> classfiles) {
        this.fireBeginSession(classfiles.size());
        for (Classfile classfile : classfiles) {
            classfile.accept(this);
        }
        this.fireEndSession();
    }

    @Override
    public void visitClassfile(Classfile classfile) {
        Logger.getLogger(this.getClass()).debug((Object)"VisitClassfile():");
        Logger.getLogger(this.getClass()).debug((Object)("    class = \"" + classfile.getClassName() + "\""));
        this.fireBeginClass(classfile);
        this.setCurrentMethod(null);
        this.setCurrentClass(this.getMetricsFactory().createClassMetrics(classfile.getClassName()));
        this.setCurrentGroup(this.getCurrentClass().getParent());
        this.setCurrentProject(this.getCurrentGroup().getParent());
        this.getMetricsFactory().includeClassMetrics(this.getCurrentClass());
        this.getCurrentProject().addToMeasurement("P", this.getCurrentGroup().getName());
        if ((classfile.getAccessFlag() & 1) != 0) {
            this.getCurrentProject().addToMeasurement("PuC");
            this.getCurrentGroup().addToMeasurement("PuC");
        }
        if ((classfile.getAccessFlag() & 0x10) != 0) {
            this.getCurrentProject().addToMeasurement("FC");
            this.getCurrentGroup().addToMeasurement("FC");
        }
        if ((classfile.getAccessFlag() & 0x200) != 0) {
            this.getCurrentProject().addToMeasurement("I");
            this.getCurrentGroup().addToMeasurement("I");
        }
        if ((classfile.getAccessFlag() & 0x400) != 0) {
            this.getCurrentProject().addToMeasurement("AC");
            this.getCurrentGroup().addToMeasurement("AC");
        }
        if (classfile.getSuperclassIndex() != 0) {
            classfile.getRawSuperclass().accept(this);
            Classfile superclass = classfile.getLoader().getClassfile(classfile.getSuperclassName());
            if (superclass != null) {
                this.getMetricsFactory().createClassMetrics(superclass.getClassName()).addToMeasurement("SUB");
            }
            this.getCurrentClass().addToMeasurement("DOI", this.computeDepthOfInheritance(superclass));
        }
        for (Class_info class_info : classfile.getAllInterfaces()) {
            class_info.accept(this);
        }
        for (Field_info field : classfile.getAllFields()) {
            field.accept(this);
        }
        for (Method_info method : classfile.getAllMethods()) {
            method.accept(this);
        }
        this.sloc = 1;
        this.isSynthetic = false;
        for (Attribute_info attribute : classfile.getAttributes()) {
            attribute.accept(this);
        }
        if (!this.isSynthetic) {
            this.getCurrentClass().addToMeasurement("class SLOC", this.sloc);
        }
        this.fireEndClass(classfile, this.getCurrentClass());
    }

    @Override
    public void visitClass_info(Class_info entry) {
        Logger.getLogger(this.getClass()).debug((Object)"VisitClass_info():");
        Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + entry.getName() + "\""));
        if (entry.getName().startsWith("[")) {
            this.addClassDependencies(this.processDescriptor(entry.getName()));
        } else {
            this.addClassDependency(entry.getName());
        }
    }

    @Override
    public void visitFieldRef_info(FieldRef_info entry) {
        Logger.getLogger(this.getClass()).debug((Object)"VisitFieldRef_info():");
        Logger.getLogger(this.getClass()).debug((Object)("    class = \"" + entry.getClassName() + "\""));
        Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + entry.getRawNameAndType().getName() + "\""));
        Logger.getLogger(this.getClass()).debug((Object)("    type = \"" + entry.getRawNameAndType().getType() + "\""));
        entry.getRawClass().accept(this);
        this.addClassDependencies(this.processDescriptor(entry.getRawNameAndType().getType()));
    }

    @Override
    public void visitMethodRef_info(MethodRef_info entry) {
        Logger.getLogger(this.getClass()).debug((Object)"VisitMethodRef_info():");
        Logger.getLogger(this.getClass()).debug((Object)("    class = \"" + entry.getClassName() + "\""));
        Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + entry.getRawNameAndType().getName() + "\""));
        Logger.getLogger(this.getClass()).debug((Object)("    type = \"" + entry.getRawNameAndType().getType() + "\""));
        this.addMethodDependency(entry.getFullSignature());
        this.addClassDependencies(this.processDescriptor(entry.getRawNameAndType().getType()));
    }

    @Override
    public void visitInterfaceMethodRef_info(InterfaceMethodRef_info entry) {
        Logger.getLogger(this.getClass()).debug((Object)"VisitInterfaceMethodRef_info():");
        Logger.getLogger(this.getClass()).debug((Object)("    class = \"" + entry.getClassName() + "\""));
        Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + entry.getRawNameAndType().getName() + "\""));
        Logger.getLogger(this.getClass()).debug((Object)("    type = \"" + entry.getRawNameAndType().getType() + "\""));
        this.addMethodDependency(entry.getFullSignature());
        this.addClassDependencies(this.processDescriptor(entry.getRawNameAndType().getType()));
    }

    @Override
    public void visitField_info(Field_info entry) {
        this.getCurrentClass().addToMeasurement("A");
        Logger.getLogger(this.getClass()).debug((Object)("VisitField_info(" + entry.getFullSignature() + ")"));
        Logger.getLogger(this.getClass()).debug((Object)("Current class: " + this.getCurrentClass().getName()));
        Logger.getLogger(this.getClass()).debug((Object)("Access flag: " + entry.getAccessFlag()));
        Logger.getLogger(this.getClass()).debug((Object)("Public: " + (entry.getAccessFlag() & 1)));
        Logger.getLogger(this.getClass()).debug((Object)("Private: " + (entry.getAccessFlag() & 2)));
        Logger.getLogger(this.getClass()).debug((Object)("Protected: " + (entry.getAccessFlag() & 4)));
        Logger.getLogger(this.getClass()).debug((Object)("Static: " + (entry.getAccessFlag() & 8)));
        if ((entry.getAccessFlag() & 1) != 0) {
            this.getCurrentClass().addToMeasurement("PuA");
        } else if ((entry.getAccessFlag() & 2) != 0) {
            this.getCurrentClass().addToMeasurement("PriA");
        } else if ((entry.getAccessFlag() & 4) != 0) {
            this.getCurrentClass().addToMeasurement("ProA");
        } else {
            this.getCurrentClass().addToMeasurement("PaA");
        }
        if ((entry.getAccessFlag() & 8) != 0) {
            this.getCurrentClass().addToMeasurement("SA");
        }
        if ((entry.getAccessFlag() & 0x10) != 0) {
            this.getCurrentClass().addToMeasurement("FA");
        }
        if ((entry.getAccessFlag() & 0x40) != 0) {
            this.getCurrentClass().addToMeasurement("VA");
        }
        if ((entry.getAccessFlag() & 0x80) != 0) {
            this.getCurrentClass().addToMeasurement("TA");
        }
        this.sloc = 1;
        this.isSynthetic = false;
        super.visitField_info(entry);
        if (!this.isSynthetic) {
            this.getCurrentClass().addToMeasurement("class SLOC", this.sloc);
        }
        this.addClassDependencies(this.processDescriptor(entry.getDescriptor()));
    }

    @Override
    public void visitMethod_info(Method_info entry) {
        this.fireBeginMethod(entry);
        this.setCurrentMethod(this.getMetricsFactory().createMethodMetrics(entry.getFullSignature()));
        this.getMetricsFactory().includeMethodMetrics(this.getCurrentMethod());
        Logger.getLogger(this.getClass()).debug((Object)("VisitMethod_info(" + entry.getFullSignature() + ")"));
        Logger.getLogger(this.getClass()).debug((Object)("Current class: " + this.getCurrentClass().getName()));
        Logger.getLogger(this.getClass()).debug((Object)("Access flag: " + entry.getAccessFlag()));
        Logger.getLogger(this.getClass()).debug((Object)("Public: " + (entry.getAccessFlag() & 1)));
        Logger.getLogger(this.getClass()).debug((Object)("Private: " + (entry.getAccessFlag() & 2)));
        Logger.getLogger(this.getClass()).debug((Object)("Protected: " + (entry.getAccessFlag() & 4)));
        Logger.getLogger(this.getClass()).debug((Object)("Static: " + (entry.getAccessFlag() & 8)));
        this.sloc = 0;
        this.isSynthetic = false;
        if ((entry.getAccessFlag() & 1) != 0) {
            this.getCurrentClass().addToMeasurement("PuM");
        } else if ((entry.getAccessFlag() & 2) != 0) {
            this.getCurrentClass().addToMeasurement("ProM");
        } else if ((entry.getAccessFlag() & 4) != 0) {
            this.getCurrentClass().addToMeasurement("ProM");
        } else {
            this.getCurrentClass().addToMeasurement("PaM");
        }
        if ((entry.getAccessFlag() & 8) != 0) {
            this.getCurrentClass().addToMeasurement("SM");
        }
        if ((entry.getAccessFlag() & 0x10) != 0) {
            this.getCurrentClass().addToMeasurement("FM");
        }
        if ((entry.getAccessFlag() & 0x20) != 0) {
            this.getCurrentClass().addToMeasurement("SynchM");
        }
        if ((entry.getAccessFlag() & 0x100) != 0) {
            this.getCurrentClass().addToMeasurement("NM");
        }
        if ((entry.getAccessFlag() & 0x400) != 0) {
            this.getCurrentClass().addToMeasurement("AM");
            this.sloc = 1;
        }
        this.getCurrentMethod().addToMeasurement("PARAM", SignatureHelper.getParameterCount(entry.getDescriptor()));
        super.visitMethod_info(entry);
        if (!this.isSynthetic) {
            this.getCurrentMethod().addToMeasurement("SLOC", this.sloc);
        }
        this.addClassDependencies(this.processDescriptor(entry.getDescriptor()));
        this.fireEndMethod(entry, this.getCurrentMethod());
    }

    @Override
    public void visitSynthetic_attribute(Synthetic_attribute attribute) {
        Visitable owner = attribute.getOwner();
        this.isSynthetic = true;
        if (owner instanceof Classfile) {
            this.getCurrentProject().addToMeasurement("SynthC");
            this.getCurrentGroup().addToMeasurement("SynthC");
        } else if (owner instanceof Field_info) {
            this.getCurrentClass().addToMeasurement("SynthA");
        } else if (owner instanceof Method_info) {
            this.getCurrentClass().addToMeasurement("SynthM");
        } else {
            Logger.getLogger(this.getClass()).warn((Object)("Synthetic attribute on unknown Visitable: " + owner.getClass().getName()));
        }
    }

    @Override
    public void visitDeprecated_attribute(Deprecated_attribute attribute) {
        Visitable owner = attribute.getOwner();
        if (owner instanceof Classfile) {
            this.getCurrentProject().addToMeasurement("DC");
            this.getCurrentGroup().addToMeasurement("DC");
        } else if (owner instanceof Field_info) {
            this.getCurrentClass().addToMeasurement("DA");
        } else if (owner instanceof Method_info) {
            this.getCurrentClass().addToMeasurement("DM");
        } else {
            Logger.getLogger(this.getClass()).warn((Object)("Deprecated attribute on unknown Visitable: " + owner.getClass().getName()));
        }
    }

    @Override
    public void visitInstruction(Instruction helper) {
        super.visitInstruction(helper);
        switch (helper.getOpcode()) {
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                helper.getIndexedConstantPoolEntry().accept(this);
                break;
            }
        }
    }

    @Override
    public void visitExceptionHandler(ExceptionHandler helper) {
        if (helper.getCatchTypeIndex() != 0) {
            helper.getRawCatchType().accept(this);
        }
    }

    @Override
    public void visitInnerClass(InnerClass helper) {
        if (helper.getInnerClassInfoIndex() != helper.getInnerClasses().getClassfile().getClassIndex() && helper.getInnerClassInfo().startsWith(helper.getInnerClasses().getClassfile().getClassName())) {
            this.getCurrentProject().addToMeasurement("IC");
            this.getCurrentGroup().addToMeasurement("IC");
            this.getCurrentClass().addToMeasurement("IC");
            if ((helper.getAccessFlag() & 1) != 0) {
                this.getCurrentProject().addToMeasurement("PuIC");
                this.getCurrentGroup().addToMeasurement("PuIC");
                this.getCurrentClass().addToMeasurement("PuIC");
            } else if ((helper.getAccessFlag() & 2) != 0) {
                this.getCurrentProject().addToMeasurement("PriIC");
                this.getCurrentGroup().addToMeasurement("PriIC");
                this.getCurrentClass().addToMeasurement("PriIC");
            } else if ((helper.getAccessFlag() & 4) != 0) {
                this.getCurrentProject().addToMeasurement("ProIC");
                this.getCurrentGroup().addToMeasurement("ProIC");
                this.getCurrentClass().addToMeasurement("ProIC");
            } else {
                this.getCurrentProject().addToMeasurement("PaIC");
                this.getCurrentGroup().addToMeasurement("PaIC");
                this.getCurrentClass().addToMeasurement("PaIC");
            }
            if ((helper.getAccessFlag() & 8) != 0) {
                this.getCurrentProject().addToMeasurement("SIC");
                this.getCurrentGroup().addToMeasurement("SIC");
                this.getCurrentClass().addToMeasurement("SIC");
            }
            if ((helper.getAccessFlag() & 0x10) != 0) {
                this.getCurrentProject().addToMeasurement("FIC");
                this.getCurrentGroup().addToMeasurement("FIC");
                this.getCurrentClass().addToMeasurement("FIC");
            }
            if ((helper.getAccessFlag() & 0x400) != 0) {
                this.getCurrentProject().addToMeasurement("AIC");
                this.getCurrentGroup().addToMeasurement("AIC");
                this.getCurrentClass().addToMeasurement("AIC");
            }
        }
    }

    @Override
    public void visitLineNumber(LineNumber helper) {
        ++this.sloc;
    }

    @Override
    public void visitLocalVariable(LocalVariable helper) {
        this.getCurrentMethod().addToMeasurement("LVAR");
        this.addClassDependencies(this.processDescriptor(helper.getDescriptor()));
    }

    private int computeDepthOfInheritance(Classfile classfile) {
        int result = 1;
        if (classfile != null && classfile.getSuperclassIndex() != 0) {
            Classfile superclass = classfile.getLoader().getClassfile(classfile.getSuperclassName());
            result += this.computeDepthOfInheritance(superclass);
        }
        return result;
    }

    private Collection<String> processDescriptor(String str) {
        int startPos;
        LinkedList<String> result = new LinkedList<String>();
        Logger.getLogger(this.getClass()).debug((Object)("ProcessDescriptor: " + str));
        int currentPos = 0;
        while ((startPos = str.indexOf(76, currentPos)) != -1) {
            int endPos = str.indexOf(59, startPos);
            if (endPos != -1) {
                String classname = SignatureHelper.path2ClassName(str.substring(startPos + 1, endPos));
                result.add(classname);
                currentPos = endPos + 1;
                continue;
            }
            currentPos = startPos + 1;
        }
        Logger.getLogger(this.getClass()).debug((Object)("ProcessDescriptor: " + result));
        return result;
    }

    private void addClassDependencies(Collection<String> classnames) {
        for (String classname : classnames) {
            this.addClassDependency(classname);
        }
    }

    private void addClassDependency(String name) {
        Logger.getLogger(this.getClass()).debug((Object)("AddClassDependency(\"" + name + "\") ..."));
        if (!this.getCurrentClass().getName().equals(name) && this.isInFilter(name)) {
            Metrics other = this.getMetricsFactory().createClassMetrics(name);
            if (this.getCurrentMethod() != null && this.isInScope(this.getCurrentMethod().getName())) {
                Logger.getLogger(this.getClass()).debug((Object)("AddClassDependency " + this.getCurrentMethod().getName() + " -> " + name + " ..."));
                if (this.getCurrentClass().getParent().equals(other.getParent())) {
                    Logger.getLogger(this.getClass()).debug((Object)"Intra-Package ...");
                    this.getCurrentMethod().addToMeasurement("OIPC", other.getName());
                    other.addToMeasurement("IIPM", this.getCurrentMethod().getName());
                } else {
                    Logger.getLogger(this.getClass()).debug((Object)"Extra-Package ...");
                    this.getCurrentMethod().addToMeasurement("OEPC", other.getName());
                    other.addToMeasurement("IEPM", this.getCurrentMethod().getName());
                }
            } else if (this.isInScope(this.getCurrentClass().getName())) {
                Logger.getLogger(this.getClass()).debug((Object)("AddClassDependency " + this.getCurrentClass().getName() + " -> " + name + " ..."));
                if (this.getCurrentClass().getParent().equals(other.getParent())) {
                    Logger.getLogger(this.getClass()).debug((Object)"Intra-Package ...");
                    this.getCurrentClass().addToMeasurement("OIP", other.getName());
                    other.addToMeasurement("IIP", this.getCurrentClass().getName());
                } else {
                    Logger.getLogger(this.getClass()).debug((Object)"Extra-Package ...");
                    this.getCurrentClass().addToMeasurement("OEP", other.getName());
                    other.addToMeasurement("IEP", this.getCurrentClass().getName());
                }
            }
        }
    }

    private void addMethodDependency(String name) {
        Logger.getLogger(this.getClass()).debug((Object)("AddMethodDependency " + this.getCurrentMethod().getName() + " -> " + name + " ..."));
        if (!this.getCurrentMethod().getName().equals(name) && this.isInScope(this.getCurrentMethod().getName()) && this.isInFilter(name)) {
            Metrics other = this.getMetricsFactory().createMethodMetrics(name);
            if (this.getCurrentClass().equals(other.getParent())) {
                Logger.getLogger(this.getClass()).debug((Object)"Intra-Class ...");
                this.getCurrentMethod().addToMeasurement("OICF", other.getName());
                other.addToMeasurement("IICM", this.getCurrentMethod().getName());
            } else if (this.getCurrentGroup().equals(other.getParent().getParent())) {
                Logger.getLogger(this.getClass()).debug((Object)"Intra-Package ...");
                this.getCurrentMethod().addToMeasurement("OIPF", other.getName());
                other.addToMeasurement("IIPM", this.getCurrentMethod().getName());
            } else {
                Logger.getLogger(this.getClass()).debug((Object)"Extra-Package ...");
                this.getCurrentMethod().addToMeasurement("OEPF", other.getName());
                other.addToMeasurement("IEPM", this.getCurrentMethod().getName());
            }
        }
    }

    private boolean isInScope(String name) {
        boolean result = true;
        if (this.scope != null) {
            result = this.scope.contains(name);
        }
        return result;
    }

    private boolean isInFilter(String name) {
        boolean result = true;
        if (this.filter != null) {
            result = this.filter.contains(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetricsListener(MetricsListener listener) {
        HashSet<MetricsListener> hashSet = this.metricsListeners;
        synchronized (hashSet) {
            this.metricsListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetricsListener(MetricsListener listener) {
        HashSet<MetricsListener> hashSet = this.metricsListeners;
        synchronized (hashSet) {
            this.metricsListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBeginSession(int size) {
        HashSet listeners;
        MetricsEvent event = new MetricsEvent((Object)this, size);
        HashSet<MetricsListener> hashSet = this.metricsListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.metricsListeners.clone();
        }
        for (MetricsListener listener : listeners) {
            listener.beginSession(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBeginClass(Classfile classfile) {
        HashSet listeners;
        MetricsEvent event = new MetricsEvent((Object)this, classfile);
        HashSet<MetricsListener> hashSet = this.metricsListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.metricsListeners.clone();
        }
        for (MetricsListener listener : listeners) {
            listener.beginClass(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBeginMethod(Method_info method) {
        HashSet listeners;
        MetricsEvent event = new MetricsEvent((Object)this, method);
        HashSet<MetricsListener> hashSet = this.metricsListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.metricsListeners.clone();
        }
        for (MetricsListener listener : listeners) {
            listener.beginMethod(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEndMethod(Method_info method, Metrics metrics) {
        HashSet listeners;
        MetricsEvent event = new MetricsEvent((Object)this, method, metrics);
        HashSet<MetricsListener> hashSet = this.metricsListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.metricsListeners.clone();
        }
        for (MetricsListener listener : listeners) {
            listener.endMethod(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEndClass(Classfile classfile, Metrics metrics) {
        HashSet listeners;
        MetricsEvent event = new MetricsEvent((Object)this, classfile, metrics);
        HashSet<MetricsListener> hashSet = this.metricsListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.metricsListeners.clone();
        }
        for (MetricsListener listener : listeners) {
            listener.endClass(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEndSession() {
        HashSet listeners;
        MetricsEvent event = new MetricsEvent(this);
        HashSet<MetricsListener> hashSet = this.metricsListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.metricsListeners.clone();
        }
        for (MetricsListener listener : listeners) {
            listener.endSession(event);
        }
    }
}

