/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.NullMeasurement;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metrics {
    public static final String PACKAGES = "P";
    public static final String CLASSES = "C";
    public static final String PUBLIC_CLASSES = "PuC";
    public static final String FINAL_CLASSES = "FC";
    public static final String ABSTRACT_CLASSES = "AC";
    public static final String SYNTHETIC_CLASSES = "SynthC";
    public static final String INTERFACES = "I";
    public static final String DEPRECATED_CLASSES = "DC";
    public static final String STATIC_CLASSES = "SC";
    public static final String PUBLIC_METHODS = "PuM";
    public static final String PROTECTED_METHODS = "ProM";
    public static final String PRIVATE_METHODS = "ProM";
    public static final String PACKAGE_METHODS = "PaM";
    public static final String FINAL_METHODS = "FM";
    public static final String ABSTRACT_METHODS = "AM";
    public static final String DEPRECATED_METHODS = "DM";
    public static final String SYNTHETIC_METHODS = "SynthM";
    public static final String STATIC_METHODS = "SM";
    public static final String SYNCHRONIZED_METHODS = "SynchM";
    public static final String NATIVE_METHODS = "NM";
    public static final String TRIVIAL_METHODS = "TM";
    public static final String ATTRIBUTES = "A";
    public static final String PUBLIC_ATTRIBUTES = "PuA";
    public static final String PROTECTED_ATTRIBUTES = "ProA";
    public static final String PRIVATE_ATTRIBUTES = "PriA";
    public static final String PACKAGE_ATTRIBUTES = "PaA";
    public static final String FINAL_ATTRIBUTES = "FA";
    public static final String DEPRECATED_ATTRIBUTES = "DA";
    public static final String SYNTHETIC_ATTRIBUTES = "SynthA";
    public static final String STATIC_ATTRIBUTES = "SA";
    public static final String TRANSIENT_ATTRIBUTES = "TA";
    public static final String VOLATILE_ATTRIBUTES = "VA";
    public static final String INNER_CLASSES = "IC";
    public static final String PUBLIC_INNER_CLASSES = "PuIC";
    public static final String PROTECTED_INNER_CLASSES = "ProIC";
    public static final String PRIVATE_INNER_CLASSES = "PriIC";
    public static final String PACKAGE_INNER_CLASSES = "PaIC";
    public static final String ABSTRACT_INNER_CLASSES = "AIC";
    public static final String FINAL_INNER_CLASSES = "FIC";
    public static final String STATIC_INNER_CLASSES = "SIC";
    public static final String DEPTH_OF_INHERITANCE = "DOI";
    public static final String SUBCLASSES = "SUB";
    public static final String CLASS_SLOC = "class SLOC";
    public static final String SLOC = "SLOC";
    public static final String PARAMETERS = "PARAM";
    public static final String LOCAL_VARIABLES = "LVAR";
    public static final String INBOUND_INTRA_PACKAGE_DEPENDENCIES = "IIP";
    public static final String INBOUND_EXTRA_PACKAGE_DEPENDENCIES = "IEP";
    public static final String OUTBOUND_INTRA_PACKAGE_DEPENDENCIES = "OIP";
    public static final String OUTBOUND_EXTRA_PACKAGE_DEPENDENCIES = "OEP";
    public static final String INBOUND_INTRA_CLASS_METHOD_DEPENDENCIES = "IICM";
    public static final String INBOUND_INTRA_PACKAGE_METHOD_DEPENDENCIES = "IIPM";
    public static final String INBOUND_EXTRA_PACKAGE_METHOD_DEPENDENCIES = "IEPM";
    public static final String OUTBOUND_INTRA_CLASS_FEATURE_DEPENDENCIES = "OICF";
    public static final String OUTBOUND_INTRA_PACKAGE_FEATURE_DEPENDENCIES = "OIPF";
    public static final String OUTBOUND_INTRA_PACKAGE_CLASS_DEPENDENCIES = "OIPC";
    public static final String OUTBOUND_EXTRA_PACKAGE_FEATURE_DEPENDENCIES = "OEPF";
    public static final String OUTBOUND_EXTRA_PACKAGE_CLASS_DEPENDENCIES = "OEPC";
    public static final String GROUP_NAME_CHARACTER_COUNT = "GNCC";
    public static final String GROUP_NAME_WORD_COUNT = "GNWC";
    public static final String CLASS_NAME_CHARACTER_COUNT = "CNCC";
    public static final String CLASS_NAME_WORD_COUNT = "CNWC";
    public static final String METHOD_NAME_CHARACTER_COUNT = "MNCC";
    public static final String METHOD_NAME_WORD_COUNT = "MNWC";
    private static final Measurement NULL_MEASUREMENT = new NullMeasurement();
    private Metrics parent;
    private String name;
    private Map<String, Measurement> measurements = new TreeMap<String, Measurement>();
    private Map<String, Metrics> submetrics = new TreeMap<String, Metrics>();

    public Metrics(String name) {
        this(null, name);
    }

    public Metrics(Metrics parent, String name) {
        this.parent = parent;
        this.name = name;
        if (parent == null) {
            Logger.getLogger(this.getClass()).debug((Object)("Created top-level metrics \"" + name + "\""));
        } else {
            Logger.getLogger(this.getClass()).debug((Object)("Created metrics \"" + name + "\" under \"" + parent.getName() + "\""));
        }
    }

    public Metrics getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    void track(Measurement measurement) {
        this.track(measurement.getShortName(), measurement);
    }

    void track(String name, Measurement measurement) {
        this.measurements.put(name, measurement);
    }

    public void addToMeasurement(String name) {
        this.addToMeasurement(name, 1);
    }

    public void addToMeasurement(String name, int delta) {
        this.getMeasurement(name).add(delta);
    }

    public void addToMeasurement(String name, long delta) {
        this.getMeasurement(name).add(delta);
    }

    public void addToMeasurement(String name, float delta) {
        this.getMeasurement(name).add(delta);
    }

    public void addToMeasurement(String name, double delta) {
        this.getMeasurement(name).add(delta);
    }

    public void addToMeasurement(String name, Object delta) {
        this.getMeasurement(name).add(delta);
    }

    public Measurement getMeasurement(String name) {
        Measurement result = this.measurements.get(name);
        if (result == null) {
            result = NULL_MEASUREMENT;
            Logger.getLogger(this.getClass()).info((Object)("Null measurement \"" + name + "\" on \"" + this.getName() + "\""));
        }
        return result;
    }

    public boolean hasMeasurement(String name) {
        return this.measurements.get(name) != null;
    }

    public Collection<String> getMeasurementNames() {
        return Collections.unmodifiableCollection(this.measurements.keySet());
    }

    public Metrics addSubMetrics(Metrics metrics) {
        return this.submetrics.put(metrics.getName(), metrics);
    }

    public Collection<Metrics> getSubMetrics() {
        return Collections.unmodifiableCollection(this.submetrics.values());
    }

    public boolean isEmpty() {
        boolean result = true;
        Iterator<Measurement> i = this.measurements.values().iterator();
        while (result && i.hasNext()) {
            Measurement measurement = i.next();
            if (!measurement.getDescriptor().isVisible()) continue;
            result = measurement.isEmpty();
        }
        Iterator<Metrics> j = this.submetrics.values().iterator();
        while (result && j.hasNext()) {
            result = j.next().isEmpty();
        }
        return result;
    }

    public boolean isInRange() {
        boolean result = true;
        Iterator<Measurement> i = this.measurements.values().iterator();
        while (result && i.hasNext()) {
            result = i.next().isInRange();
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName()).append(" ").append(this.getName()).append(" with [");
        Iterator<String> i = this.getMeasurementNames().iterator();
        while (i.hasNext()) {
            String name = i.next();
            Measurement measure = this.getMeasurement(name);
            result.append("\"").append(name).append("\"(").append(measure.getClass().getName()).append(")");
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }
}

