/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.text.MaximumCapacityPatternCache;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.perl.Perl5Util;

public abstract class MeasurementBase
implements Measurement {
    private static final Perl5Util perl = new Perl5Util((PatternCache)new MaximumCapacityPatternCache());
    private MeasurementDescriptor descriptor = null;
    private Metrics context = null;
    private boolean cached = false;
    private boolean empty = true;

    protected static Perl5Util perl() {
        return perl;
    }

    public MeasurementBase(MeasurementDescriptor descriptor, Metrics context, String initText) {
        this.descriptor = descriptor;
        this.context = context;
    }

    public MeasurementDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Metrics getContext() {
        return this.context;
    }

    protected boolean isCached() {
        return this.cached;
    }

    protected void setCached(boolean cached) {
        this.cached = cached && this.getDescriptor().isCached();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    protected void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public String getShortName() {
        return this.getDescriptor().getShortName();
    }

    public String getLongName() {
        return this.getDescriptor().getLongName();
    }

    public Number getValue() {
        return this.compute();
    }

    public int intValue() {
        return (int)this.compute();
    }

    public long longValue() {
        return (long)this.compute();
    }

    public float floatValue() {
        return (float)this.compute();
    }

    public double doubleValue() {
        return this.compute();
    }

    public boolean isInRange() {
        boolean result = true;
        if (this.getDescriptor() != null) {
            Comparable lowerThreshold = this.getDescriptor().getLowerThreshold();
            Comparable upperThreshold = this.getDescriptor().getUpperThreshold();
            if (result && lowerThreshold != null) {
                if (lowerThreshold instanceof String) {
                    try {
                        result = Double.parseDouble((String)((Object)lowerThreshold)) <= this.compute();
                    }
                    catch (NumberFormatException ex) {}
                } else if (lowerThreshold instanceof Number) {
                    result = ((Number)((Object)lowerThreshold)).doubleValue() <= this.compute();
                } else {
                    boolean bl = result = lowerThreshold.compareTo(this.getValue()) <= 0;
                }
            }
            if (result && upperThreshold != null) {
                if (upperThreshold instanceof String) {
                    try {
                        result = Double.parseDouble((String)((Object)upperThreshold)) >= this.compute();
                    }
                    catch (NumberFormatException ex) {}
                } else {
                    result = upperThreshold instanceof Number ? ((Number)((Object)upperThreshold)).doubleValue() >= this.compute() : upperThreshold.compareTo(this.getValue()) >= 0;
                }
            }
        }
        return result;
    }

    public void add(Object object) {
    }

    public void add(int i) {
    }

    public void add(long l) {
    }

    public void add(float f) {
    }

    public void add(double d) {
    }

    protected abstract double compute();

    public String toString() {
        return this.getValue().toString();
    }
}

