/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.MeasurementBase;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.MeasurementVisitor;
import com.jeantessier.metrics.Metrics;

public class CounterMeasurement
extends MeasurementBase {
    private double value;

    public CounterMeasurement(MeasurementDescriptor descriptor, Metrics context, String initText) {
        super(descriptor, context, initText);
        try {
            if (initText != null) {
                this.value = Double.parseDouble(initText);
            }
        }
        catch (NumberFormatException ex) {
            this.value = 0.0;
        }
    }

    public void add(Object object) {
        this.value = object instanceof Number ? (this.value += ((Number)object).doubleValue()) : (this.value += 1.0);
        this.setEmpty(false);
    }

    public void add(int i) {
        this.value += (double)i;
        this.setEmpty(false);
    }

    public void add(long l) {
        this.value += (double)l;
        this.setEmpty(false);
    }

    public void add(float f) {
        this.value += (double)f;
        this.setEmpty(false);
    }

    public void add(double d) {
        this.value += d;
        this.setEmpty(false);
    }

    public void accept(MeasurementVisitor visitor) {
        visitor.visitCounterMeasurement(this);
    }

    protected double compute() {
        return this.value;
    }
}

