/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.jeantessier.diff.ConstructorDifferences;
import com.jeantessier.diff.DeprecatableDifferences;
import com.jeantessier.diff.FieldDifferences;
import com.jeantessier.diff.MethodDifferences;
import com.jeantessier.diff.PackageDifferences;
import com.jeantessier.diff.ProjectDifferences;
import com.jeantessier.diff.Visitor;

public abstract class VisitorBase
implements Visitor {
    private int deprecatableLevel = 0;
    private boolean[] deprecated = new boolean[4];
    private boolean[] undeprecated = new boolean[4];

    private void raiseDeprecatableLevel() {
        ++this.deprecatableLevel;
    }

    private void lowerDeprecatableLevel() {
        --this.deprecatableLevel;
    }

    public boolean isDeprecated() {
        return this.deprecated[this.deprecatableLevel];
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated[this.deprecatableLevel] = deprecated;
    }

    public boolean isUndeprecated() {
        return this.undeprecated[this.deprecatableLevel];
    }

    public void setUndeprecated(boolean undeprecated) {
        this.undeprecated[this.deprecatableLevel] = undeprecated;
    }

    public void visitProjectDifferences(ProjectDifferences differences) {
    }

    public void visitPackageDifferences(PackageDifferences differences) {
    }

    public void visitFieldDifferences(FieldDifferences differences) {
    }

    public void visitConstructorDifferences(ConstructorDifferences differences) {
    }

    public void visitMethodDifferences(MethodDifferences differences) {
    }

    public void visitDeprecatableDifferences(DeprecatableDifferences differences) {
        this.raiseDeprecatableLevel();
        this.setDeprecated(differences.isNewDeprecation());
        this.setUndeprecated(differences.isRemovedDeprecation());
        differences.getComponent().accept(this);
        this.lowerDeprecatableLevel();
    }
}

