/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.jeantessier.diff.Differences;
import com.jeantessier.diff.RemovableDifferences;
import com.jeantessier.diff.Visitor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageDifferences
extends RemovableDifferences {
    private Collection<Differences> classDifferences = new LinkedList<Differences>();

    PackageDifferences(String name, Map oldPackage, Map newPackage) {
        super(name);
        if (oldPackage != null && !oldPackage.isEmpty()) {
            this.setOldDeclaration(name);
        }
        if (newPackage != null && !newPackage.isEmpty()) {
            this.setNewDeclaration(name);
        }
        if (this.isModified()) {
            Logger.getLogger(this.getClass()).debug((Object)(this.getName() + " declaration has been modified."));
        } else {
            Logger.getLogger(this.getClass()).debug((Object)(this.getName() + " declaration has not been modified."));
        }
    }

    public Collection<Differences> getClassDifferences() {
        return this.classDifferences;
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.getClassDifferences().size() != 0;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitPackageDifferences(this);
    }
}

