/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;

public class ListDocumentedElements {
    private static String tagName = null;
    private static Collection<String> validValues = new HashSet<String>();
    private static Collection<String> invalidValues = new HashSet<String>();
    private static PrintWriter out = new PrintWriter(new OutputStreamWriter(System.out));

    public static boolean start(RootDoc root) {
        ListDocumentedElements.process(root.specifiedPackages());
        ListDocumentedElements.process((ProgramElementDoc[])root.classes());
        out.close();
        return true;
    }

    public static int optionLength(String option) {
        int result = 0;
        if (option.equals("-tag")) {
            result = 2;
        } else if (option.equals("-valid")) {
            result = 2;
        } else if (option.equals("-invalid")) {
            result = 2;
        } else if (option.equals("-out")) {
            result = 2;
        }
        return result;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        boolean valid = true;
        for (int i = 0; valid && i < options.length; ++i) {
            if (options[i][0].equals("-tag")) {
                if (tagName == null) {
                    tagName = options[i][1];
                    continue;
                }
                reporter.printError("Only one -tag option allowed.");
                valid = false;
                continue;
            }
            if (options[i][0].equals("-valid")) {
                validValues.add(options[i][1]);
                continue;
            }
            if (options[i][0].equals("-invalid")) {
                invalidValues.add(options[i][1]);
                continue;
            }
            if (!options[i][0].equals("-out")) continue;
            try {
                out = new PrintWriter(new FileWriter(options[i][1]));
                continue;
            }
            catch (IOException ex) {
                reporter.printError("Could not open output file \"" + options[i][1] + "\": " + ex);
                valid = false;
            }
        }
        boolean bl = valid = valid && tagName != null;
        if (!valid) {
            reporter.printError("Usage: javadoc -tag mytag [-valid value]* [-invalid value]* -doclet ListPublicElements ...");
        }
        return valid;
    }

    private static void process(PackageDoc[] docs) {
        for (PackageDoc doc : docs) {
            ListDocumentedElements.process(doc);
        }
    }

    private static void process(PackageDoc doc) {
        out.print(doc.name());
        out.println(" [P]");
    }

    private static void process(ProgramElementDoc[] docs) {
        for (ProgramElementDoc doc : docs) {
            ListDocumentedElements.process(doc);
        }
    }

    private static void process(ProgramElementDoc doc) {
        boolean isVisible = !doc.name().equals("<clinit>");
        Tag[] tags = doc.tags(tagName);
        if (isVisible) {
            if (!validValues.isEmpty()) {
                isVisible = false;
                for (Tag tag : tags) {
                    if (!validValues.contains(tag.text())) continue;
                    isVisible = true;
                }
            } else if (!invalidValues.isEmpty()) {
                for (Tag tag : tags) {
                    if (!invalidValues.contains(tag.text())) continue;
                    isVisible = false;
                }
            }
        }
        if (isVisible) {
            out.print(doc.qualifiedName());
            if (doc instanceof ConstructorDoc) {
                out.print(".");
                out.print(doc.name());
            }
            if (doc instanceof ExecutableMemberDoc) {
                out.print(((ExecutableMemberDoc)doc).signature());
            }
            if (doc instanceof ClassDoc) {
                out.println(" [C]");
                ListDocumentedElements.process((ProgramElementDoc[])((ClassDoc)doc).fields());
                ListDocumentedElements.process((ProgramElementDoc[])((ClassDoc)doc).constructors());
                ListDocumentedElements.process((ProgramElementDoc[])((ClassDoc)doc).methods());
                ListDocumentedElements.process((ProgramElementDoc[])((ClassDoc)doc).innerClasses());
            } else {
                out.println(" [F]");
            }
        }
    }
}

