/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.jeantessier.text.PrinterBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.oro.text.perl.Perl5Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDiffPrinter {
    public static final boolean DEFAULT_COMPRESS = false;
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final String DEFAULT_DTD_PREFIX = "http://depfind.sourceforge.net/dtd";
    private static final Perl5Util perl = new Perl5Util();
    private PrinterBuffer buffer = new PrinterBuffer();
    private boolean compress;
    private String name = "";
    private String oldVersion = "";
    private String newVersion = "";
    private Collection<String> removed = new TreeSet<String>();
    private Collection<String> added = new TreeSet<String>();

    public ListDiffPrinter() {
        this(false, DEFAULT_ENCODING, DEFAULT_DTD_PREFIX);
    }

    public ListDiffPrinter(boolean compress) {
        this(compress, DEFAULT_ENCODING, DEFAULT_DTD_PREFIX);
    }

    public ListDiffPrinter(String encoding, String dtdPrefix) {
        this(false, encoding, dtdPrefix);
    }

    public ListDiffPrinter(boolean compress, String encoding, String dtdPrefix) {
        this.compress = compress;
        this.appendHeader(encoding, dtdPrefix);
    }

    public void setIndentText(String indentText) {
        this.buffer.setIndentText(indentText);
    }

    private void appendHeader(String encoding, String dtdPrefix) {
        this.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\" ?>").eol();
        this.eol();
        this.append("<!DOCTYPE list-diff SYSTEM \"").append(dtdPrefix).append("/list-diff.dtd\">").eol();
        this.eol();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOldVersion() {
        return this.oldVersion;
    }

    public void setOldVersion(String oldVersion) {
        this.oldVersion = oldVersion;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(String newVersion) {
        this.newVersion = newVersion;
    }

    public Collection<String> getRemoved() {
        return Collections.unmodifiableCollection(this.removed);
    }

    public void remove(String line) {
        this.removed.add(line);
    }

    public Collection<String> getAdded() {
        return Collections.unmodifiableCollection(this.added);
    }

    public void add(String line) {
        this.added.add(line);
    }

    protected ListDiffPrinter append(boolean b) {
        this.buffer.append(b);
        return this;
    }

    protected ListDiffPrinter append(char c) {
        this.buffer.append(c);
        return this;
    }

    protected ListDiffPrinter append(char[] str, int offset, int len) {
        this.buffer.append(str, offset, len);
        return this;
    }

    protected ListDiffPrinter append(char[] str) {
        this.buffer.append(str);
        return this;
    }

    protected ListDiffPrinter append(double d) {
        this.buffer.append(d);
        return this;
    }

    protected ListDiffPrinter append(float f) {
        this.buffer.append(f);
        return this;
    }

    protected ListDiffPrinter append(int i) {
        this.buffer.append(i);
        return this;
    }

    protected ListDiffPrinter append(long l) {
        this.buffer.append(l);
        return this;
    }

    protected ListDiffPrinter append(Object obj) {
        this.buffer.append(obj);
        return this;
    }

    protected ListDiffPrinter append(String str) {
        this.buffer.append(str);
        return this;
    }

    protected ListDiffPrinter indent() {
        this.buffer.indent();
        return this;
    }

    protected ListDiffPrinter eol() {
        this.buffer.eol();
        return this;
    }

    protected void raiseIndent() {
        this.buffer.raiseIndent();
    }

    protected void lowerIndent() {
        this.buffer.lowerIndent();
    }

    public String toString() {
        this.indent().append("<list-diff>").eol();
        this.raiseIndent();
        this.indent().append("<name>").append(this.getName()).append("</name>").eol();
        this.indent().append("<old>").append(this.getOldVersion()).append("</old>").eol();
        this.indent().append("<new>").append(this.getNewVersion()).append("</new>").eol();
        this.indent().append("<removed>").eol();
        this.raiseIndent();
        this.printLines(this.compress ? this.compress(this.getRemoved()) : this.getRemoved());
        this.lowerIndent();
        this.indent().append("</removed>").eol();
        this.indent().append("<added>").eol();
        this.raiseIndent();
        this.printLines(this.compress ? this.compress(this.getAdded()) : this.getAdded());
        this.lowerIndent();
        this.indent().append("</added>").eol();
        this.lowerIndent();
        this.indent().append("</list-diff>").eol();
        return this.buffer.toString();
    }

    private void printLines(Collection<String> lines) {
        for (String line : lines) {
            int pos = line.lastIndexOf(" [");
            if (pos != -1) {
                this.indent().append("<line>").append(line.substring(0, pos)).append("</line>").eol();
                continue;
            }
            this.indent().append("<line>").append(line).append("</line>").eol();
        }
    }

    private Collection<String> compress(Collection<String> lines) {
        TreeSet<String> result = new TreeSet<String>();
        for (String line : lines) {
            boolean add = true;
            if (line.endsWith(" [C]")) {
                String packageName = this.extractPackageName(line);
                add = !lines.contains(packageName + " [P]");
            } else if (line.endsWith(" [F]")) {
                String className = this.extractClassName(line);
                String packageName = this.extractPackageName(className);
                boolean bl = add = !lines.contains(packageName + " [P]") && !lines.contains(className + " [C]");
            }
            if (!add) continue;
            result.add(line);
        }
        return result;
    }

    private String extractPackageName(String className) {
        String result = "";
        int pos = className.lastIndexOf(46);
        if (pos != -1) {
            result = className.substring(0, pos);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractClassName(String featureName) {
        String result = "";
        Perl5Util perl5Util = perl;
        synchronized (perl5Util) {
            if (perl.match("/^(.*)\\.[^\\.]*\\(.*\\)/", featureName)) {
                result = perl.group(1);
            } else if (perl.match("/^(.*)\\.[\\^.]*/", featureName)) {
                result = perl.group(1);
            }
        }
        return result;
    }
}

