/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.diff.DifferenceStrategy;
import com.jeantessier.diff.DifferenceStrategyDecorator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class ListBasedDifferenceStrategy
extends DifferenceStrategyDecorator {
    private Collection allowedElements = new HashSet();

    public ListBasedDifferenceStrategy(DifferenceStrategy delegate, String filename) throws IOException {
        super(delegate);
        this.load(filename);
    }

    public ListBasedDifferenceStrategy(DifferenceStrategy delegate, File file) throws IOException {
        super(delegate);
        this.load(file);
    }

    public ListBasedDifferenceStrategy(DifferenceStrategy delegate, BufferedReader in) throws IOException {
        super(delegate);
        this.load(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String filename) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename));
            this.load(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            this.load(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void load(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if (line.length() <= 0) continue;
            int pos = (line = line.trim()).lastIndexOf(" [");
            if (pos != -1) {
                this.allowedElements.add(line.substring(0, pos));
                continue;
            }
            this.allowedElements.add(line);
        }
    }

    public boolean isPackageAllowed(String name) {
        return this.isAllowed(name);
    }

    public boolean isClassAllowed(String name) {
        return this.isAllowed(name);
    }

    public boolean isFeatureAllowed(String name) {
        return this.isAllowed(name);
    }

    public boolean isAllowed(String name) {
        return this.allowedElements.contains(name);
    }

    public boolean isPackageDifferent(Map oldPackage, Map newPackage) {
        boolean result;
        Map nonEmptyPackage = oldPackage.isEmpty() ? newPackage : oldPackage;
        String className = (String)nonEmptyPackage.keySet().iterator().next();
        String packageName = "";
        int pos = className.lastIndexOf(46);
        if (pos != -1) {
            packageName = className.substring(0, pos);
        }
        if (result = this.isPackageAllowed(packageName)) {
            result = super.isPackageDifferent(oldPackage, newPackage);
        }
        return result;
    }

    public boolean isClassDifferent(Classfile oldClass, Classfile newClass) {
        Classfile classfile = oldClass != null ? oldClass : newClass;
        boolean result = this.isClassAllowed(classfile.getClassName());
        if (result) {
            result = super.isClassDifferent(oldClass, newClass);
        }
        return result;
    }

    public boolean isFieldDifferent(Field_info oldField, Field_info newField) {
        Field_info field = oldField != null ? oldField : newField;
        boolean result = this.isFeatureAllowed(field.getFullSignature());
        if (result) {
            result = super.isFieldDifferent(oldField, newField);
        }
        return result;
    }

    public boolean isMethodDifferent(Method_info oldMethod, Method_info newMethod) {
        Method_info method = oldMethod != null ? oldMethod : newMethod;
        boolean result = this.isFeatureAllowed(method.getFullSignature());
        if (result) {
            result = super.isMethodDifferent(oldMethod, newMethod);
        }
        return result;
    }
}

