/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Feature_info;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.PackageMapper;
import com.jeantessier.diff.APIDifferenceStrategy;
import com.jeantessier.diff.ClassDifferences;
import com.jeantessier.diff.CodeDifferenceStrategy;
import com.jeantessier.diff.CodeDifferences;
import com.jeantessier.diff.ConstructorDifferences;
import com.jeantessier.diff.DeprecatableDifferences;
import com.jeantessier.diff.DifferenceStrategy;
import com.jeantessier.diff.Differences;
import com.jeantessier.diff.FeatureDifferences;
import com.jeantessier.diff.FieldDifferences;
import com.jeantessier.diff.InterfaceDifferences;
import com.jeantessier.diff.MethodDifferences;
import com.jeantessier.diff.PackageDifferences;
import com.jeantessier.diff.ProjectDifferences;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferencesFactory {
    private Classfile oldClass;
    private Classfile newClass;
    private DifferenceStrategy strategy;

    DifferencesFactory() {
        this(new APIDifferenceStrategy(new CodeDifferenceStrategy()));
    }

    public DifferencesFactory(DifferenceStrategy strategy) {
        this.strategy = strategy;
    }

    public Differences createProjectDifferences(String name, String oldVersion, PackageMapper oldPackages, String newVersion, PackageMapper newPackages) {
        Logger.getLogger(this.getClass()).debug((Object)("Begin " + name + " (" + oldVersion + " -> " + newVersion + ")"));
        ProjectDifferences projectDifferences = new ProjectDifferences(name, oldVersion, newVersion);
        Logger.getLogger(this.getClass()).debug((Object)"      Collecting packages ...");
        TreeSet<String> packageNames = new TreeSet<String>();
        packageNames.addAll(oldPackages.getPackageNames());
        packageNames.addAll(newPackages.getPackageNames());
        Logger.getLogger(this.getClass()).debug((Object)"      Diff'ing packages ...");
        for (String packageName : packageNames) {
            Map newPackage;
            Map oldPackage = oldPackages.getPackage(packageName);
            if (oldPackage == null) {
                oldPackage = Collections.EMPTY_MAP;
            }
            if ((newPackage = newPackages.getPackage(packageName)) == null) {
                newPackage = Collections.EMPTY_MAP;
            }
            if (!this.strategy.isPackageDifferent(oldPackage, newPackage)) continue;
            projectDifferences.getPackageDifferences().add(this.createPackageDifferences(packageName, oldPackage, newPackage));
        }
        Logger.getLogger(this.getClass()).debug((Object)("End   " + name + " (" + oldVersion + " -> " + newVersion + ")"));
        return projectDifferences;
    }

    public Differences createPackageDifferences(String name, Map<String, Classfile> oldPackage, Map<String, Classfile> newPackage) {
        Logger.getLogger(this.getClass()).debug((Object)("Begin " + name));
        PackageDifferences packageDifferences = new PackageDifferences(name, oldPackage, newPackage);
        if (oldPackage != null && !oldPackage.isEmpty() && newPackage != null && !newPackage.isEmpty()) {
            Logger.getLogger(this.getClass()).debug((Object)"      Diff'ing classes ...");
            TreeSet<String> classNames = new TreeSet<String>();
            classNames.addAll(oldPackage.keySet());
            classNames.addAll(newPackage.keySet());
            for (String className : classNames) {
                Classfile newClass;
                Classfile oldClass = oldPackage.get(className);
                if (!this.strategy.isClassDifferent(oldClass, newClass = newPackage.get(className))) continue;
                packageDifferences.getClassDifferences().add(this.createClassDifferences(className, oldClass, newClass));
            }
            Logger.getLogger(this.getClass()).debug((Object)("      " + name + " has " + packageDifferences.getClassDifferences().size() + " class(es) that changed."));
        }
        Logger.getLogger(this.getClass()).debug((Object)("End   " + name));
        return packageDifferences;
    }

    public Differences createClassDifferences(String name, Classfile oldClass, Classfile newClass) {
        Logger.getLogger(this.getClass()).debug((Object)("Begin " + name));
        ClassDifferences classDifferences = oldClass != null && oldClass.isInterface() || newClass != null && newClass.isInterface() ? new InterfaceDifferences(name, oldClass, newClass) : new ClassDifferences(name, oldClass, newClass);
        if (!classDifferences.isRemoved() && !classDifferences.isNew() && this.strategy.isDeclarationModified(oldClass, newClass)) {
            classDifferences.setDeclarationModified(true);
        }
        Differences result = classDifferences;
        this.oldClass = oldClass;
        this.newClass = newClass;
        if (oldClass != null && newClass != null) {
            Logger.getLogger(this.getClass()).debug((Object)"      Collecting fields ...");
            TreeMap<String, String> fieldLevel = new TreeMap<String, String>();
            for (Field_info field : oldClass.getAllFields()) {
                fieldLevel.put(field.getName(), field.getFullSignature());
            }
            for (Field_info field : newClass.getAllFields()) {
                fieldLevel.put(field.getName(), field.getFullSignature());
            }
            Logger.getLogger(this.getClass()).debug((Object)"      Diff'ing fields ...");
            for (String fieldName : fieldLevel.keySet()) {
                Field_info newField;
                String fieldFullName = (String)fieldLevel.get(fieldName);
                Field_info oldField = oldClass.getField(fieldName);
                if (!this.strategy.isFieldDifferent(oldField, newField = newClass.getField(fieldName))) continue;
                classDifferences.getFeatureDifferences().add(this.createFeatureDifferences(fieldFullName, oldField, newField));
            }
            Logger.getLogger(this.getClass()).debug((Object)"      Collecting methods ...");
            TreeMap<String, String> methodLevel = new TreeMap<String, String>();
            for (Method_info method : oldClass.getAllMethods()) {
                methodLevel.put(method.getSignature(), method.getFullSignature());
            }
            for (Method_info method : newClass.getAllMethods()) {
                methodLevel.put(method.getSignature(), method.getFullSignature());
            }
            Logger.getLogger(this.getClass()).debug((Object)"      Diff'ing methods ...");
            for (String methodName : methodLevel.keySet()) {
                Method_info newMethod;
                String methodFullName = (String)methodLevel.get(methodName);
                Method_info oldMethod = oldClass.getMethod(methodName);
                if (!this.strategy.isMethodDifferent(oldMethod, newMethod = newClass.getMethod(methodName))) continue;
                classDifferences.getFeatureDifferences().add(this.createFeatureDifferences(methodFullName, oldMethod, newMethod));
            }
            Logger.getLogger(this.getClass()).debug((Object)(name + " has " + classDifferences.getFeatureDifferences().size() + " feature(s) that changed."));
            if (oldClass.isDeprecated() != newClass.isDeprecated()) {
                result = new DeprecatableDifferences(result, oldClass, newClass);
            }
        }
        Logger.getLogger(this.getClass()).debug((Object)("End   " + name));
        return result;
    }

    public Differences createFeatureDifferences(String name, Feature_info oldFeature, Feature_info newFeature) {
        FeatureDifferences featureDifferences;
        Logger.getLogger(this.getClass()).debug((Object)("Begin " + name));
        if (oldFeature instanceof Field_info || newFeature instanceof Field_info) {
            featureDifferences = new FieldDifferences(name, (Field_info)oldFeature, (Field_info)newFeature);
            if (!featureDifferences.isRemoved() && !featureDifferences.isNew() && this.strategy.isConstantValueDifferent(((Field_info)oldFeature).getConstantValue(), ((Field_info)newFeature).getConstantValue())) {
                ((FieldDifferences)featureDifferences).setConstantValueDifference(true);
            }
            if (featureDifferences.isRemoved() && this.newClass.locateField(name) != null) {
                featureDifferences.setInherited(true);
            }
        } else {
            Method_info attempt;
            featureDifferences = oldFeature instanceof Method_info && ((Method_info)oldFeature).isConstructor() || newFeature instanceof Method_info && ((Method_info)newFeature).isConstructor() ? new ConstructorDifferences(name, (Method_info)oldFeature, (Method_info)newFeature) : new MethodDifferences(name, (Method_info)oldFeature, (Method_info)newFeature);
            if (!featureDifferences.isRemoved() && !featureDifferences.isNew() && this.strategy.isCodeDifferent(((Method_info)oldFeature).getCode(), ((Method_info)newFeature).getCode())) {
                ((CodeDifferences)featureDifferences).setCodeDifference(true);
            }
            if (featureDifferences.isRemoved() && (attempt = this.newClass.locateMethod(name)) != null && oldFeature.getClassfile().isInterface() == attempt.getClassfile().isInterface()) {
                featureDifferences.setInherited(true);
            }
        }
        Differences result = featureDifferences;
        if (oldFeature != null && newFeature != null && oldFeature.isDeprecated() != newFeature.isDeprecated()) {
            result = new DeprecatableDifferences(result, oldFeature, newFeature);
        }
        Logger.getLogger(this.getClass()).debug((Object)("End   " + name));
        return result;
    }
}

