/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.diff.ClassDifferences;
import com.jeantessier.diff.CodeDifferences;
import com.jeantessier.diff.ConstructorDifferences;
import com.jeantessier.diff.Differences;
import com.jeantessier.diff.FeatureDifferences;
import com.jeantessier.diff.FieldDifferences;
import com.jeantessier.diff.InterfaceDifferences;
import com.jeantessier.diff.MethodDifferences;
import com.jeantessier.diff.Printer;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class ClassReport
extends Printer
implements Comparable {
    private ClassDifferences differences;
    private Collection<FeatureDifferences> removedFields = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> removedConstructors = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> removedMethods = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> deprecatedFields = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> deprecatedConstructors = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> deprecatedMethods = new TreeSet<FeatureDifferences>();
    private Collection<FieldDifferences> modifiedFields = new TreeSet<FieldDifferences>();
    private Collection<CodeDifferences> modifiedConstructors = new TreeSet<CodeDifferences>();
    private Collection<CodeDifferences> modifiedMethods = new TreeSet<CodeDifferences>();
    private Collection<FeatureDifferences> undeprecatedFields = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> undeprecatedConstructors = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> undeprecatedMethods = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> newFields = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> newConstructors = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> newMethods = new TreeSet<FeatureDifferences>();

    public void visitClassDifferences(ClassDifferences differences) {
        this.differences = differences;
        for (Differences featureDifference : differences.getFeatureDifferences()) {
            featureDifference.accept(this);
        }
    }

    public void visitInterfaceDifferences(InterfaceDifferences differences) {
        this.differences = differences;
        for (Differences featureDifference : differences.getFeatureDifferences()) {
            featureDifference.accept(this);
        }
    }

    public void visitFieldDifferences(FieldDifferences differences) {
        if (differences.isRemoved()) {
            this.removedFields.add(differences);
        }
        if (differences.isModified()) {
            this.modifiedFields.add(differences);
        }
        if (differences.isNew()) {
            this.newFields.add(differences);
        }
        if (this.isDeprecated()) {
            this.deprecatedFields.add(differences);
        }
        if (this.isUndeprecated()) {
            this.undeprecatedFields.add(differences);
        }
    }

    public void visitConstructorDifferences(ConstructorDifferences differences) {
        if (differences.isRemoved()) {
            this.removedConstructors.add(differences);
        }
        if (differences.isModified()) {
            this.modifiedConstructors.add(differences);
        }
        if (differences.isNew()) {
            this.newConstructors.add(differences);
        }
        if (this.isDeprecated()) {
            this.deprecatedConstructors.add(differences);
        }
        if (this.isUndeprecated()) {
            this.undeprecatedConstructors.add(differences);
        }
    }

    public void visitMethodDifferences(MethodDifferences differences) {
        if (differences.isRemoved()) {
            this.removedMethods.add(differences);
        }
        if (differences.isModified()) {
            this.modifiedMethods.add(differences);
        }
        if (differences.isNew()) {
            this.newMethods.add(differences);
        }
        if (this.isDeprecated()) {
            this.deprecatedMethods.add(differences);
        }
        if (this.isUndeprecated()) {
            this.undeprecatedMethods.add(differences);
        }
    }

    public String toString() {
        this.raiseIndent();
        this.raiseIndent();
        this.indent().append("<class>").eol();
        this.raiseIndent();
        this.indent().append("<name>").append(this.differences.getName()).append("</name>").eol();
        if (this.differences.isDeclarationModified()) {
            this.indent().append("<modified-declaration>").eol();
            this.raiseIndent();
            this.indent().append("<old-declaration").append(this.breakdownDeclaration(this.differences.getOldClass())).append(">").append(this.differences.getOldDeclaration()).append("</old-declaration>").eol();
            this.indent().append("<new-declaration").append(this.breakdownDeclaration(this.differences.getNewClass())).append(">").append(this.differences.getNewDeclaration()).append("</new-declaration>").eol();
            this.lowerIndent();
            this.indent().append("</modified-declaration>").eol();
        }
        if (this.removedFields.size() != 0) {
            this.indent().append("<removed-fields>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.removedFields) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Field_info)featureDifferences.getOldFeature())).append(featureDifferences.isInherited() ? " inherited=\"yes\"" : "").append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</removed-fields>").eol();
        }
        if (this.removedConstructors.size() != 0) {
            this.indent().append("<removed-constructors>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.removedConstructors) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getOldFeature())).append(featureDifferences.isInherited() ? " inherited=\"yes\"" : "").append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</removed-constructors>").eol();
        }
        if (this.removedMethods.size() != 0) {
            this.indent().append("<removed-methods>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.removedMethods) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getOldFeature())).append(featureDifferences.isInherited() ? " inherited=\"yes\"" : "").append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</removed-methods>").eol();
        }
        if (this.deprecatedFields.size() != 0) {
            this.indent().append("<deprecated-fields>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.deprecatedFields) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Field_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</deprecated-fields>").eol();
        }
        if (this.deprecatedConstructors.size() != 0) {
            this.indent().append("<deprecated-constructors>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.deprecatedConstructors) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</deprecated-constructors>").eol();
        }
        if (this.deprecatedMethods.size() != 0) {
            this.indent().append("<deprecated-methods>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.deprecatedMethods) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</deprecated-methods>").eol();
        }
        if (this.modifiedFields.size() != 0) {
            this.indent().append("<modified-fields>").eol();
            this.raiseIndent();
            for (FieldDifferences fieldDifferences : this.modifiedFields) {
                this.indent().append("<feature>").eol();
                this.raiseIndent();
                this.indent().append("<name>").append(fieldDifferences.getName()).append("</name>").eol();
                this.indent().append("<modified-declaration>").eol();
                this.raiseIndent();
                Field_info oldField = (Field_info)fieldDifferences.getOldFeature();
                Field_info newField = (Field_info)fieldDifferences.getNewFeature();
                if (fieldDifferences.isConstantValueDifference()) {
                    this.indent().append("<old-declaration").append(this.breakdownDeclaration(oldField)).append(">").append(oldField.getFullDeclaration()).append("</old-declaration>").eol();
                    this.indent().append("<new-declaration").append(this.breakdownDeclaration(newField)).append(">").append(newField.getFullDeclaration()).append("</new-declaration>").eol();
                } else {
                    this.indent().append("<old-declaration").append(this.breakdownDeclaration(oldField)).append(">").append(oldField.getDeclaration()).append("</old-declaration>").eol();
                    this.indent().append("<new-declaration").append(this.breakdownDeclaration(newField)).append(">").append(newField.getDeclaration()).append("</new-declaration>").eol();
                }
                this.lowerIndent();
                this.indent().append("</modified-declaration>").eol();
                this.lowerIndent();
                this.indent().append("</feature>").eol();
            }
            this.lowerIndent();
            this.indent().append("</modified-fields>").eol();
        }
        if (this.modifiedConstructors.size() != 0) {
            this.indent().append("<modified-constructors>").eol();
            this.raiseIndent();
            for (CodeDifferences codeDifferences : this.modifiedConstructors) {
                this.indent().append("<feature>").eol();
                this.raiseIndent();
                this.indent().append("<name>").append(codeDifferences.getName()).append("</name>").eol();
                if (!codeDifferences.getOldDeclaration().equals(codeDifferences.getNewDeclaration())) {
                    this.indent().append("<modified-declaration>").eol();
                    this.raiseIndent();
                    this.indent().append("<old-declaration").append(this.breakdownDeclaration((Method_info)codeDifferences.getOldFeature())).append(">").append(codeDifferences.getOldDeclaration()).append("</old-declaration>").eol();
                    this.indent().append("<new-declaration").append(this.breakdownDeclaration((Method_info)codeDifferences.getNewFeature())).append(">").append(codeDifferences.getNewDeclaration()).append("</new-declaration>").eol();
                    this.lowerIndent();
                    this.indent().append("</modified-declaration>").eol();
                }
                if (codeDifferences.isCodeDifference()) {
                    this.indent().append("<modified-code").append(this.breakdownDeclaration((Method_info)codeDifferences.getNewFeature())).append(">").append(codeDifferences.getNewDeclaration()).append("</modified-code>").eol();
                }
                this.lowerIndent();
                this.indent().append("</feature>").eol();
            }
            this.lowerIndent();
            this.indent().append("</modified-constructors>").eol();
        }
        if (this.modifiedMethods.size() != 0) {
            this.indent().append("<modified-methods>").eol();
            this.raiseIndent();
            for (CodeDifferences codeDifferences : this.modifiedMethods) {
                this.indent().append("<feature>").eol();
                this.raiseIndent();
                this.indent().append("<name>").append(codeDifferences.getName()).append("</name>").eol();
                if (!codeDifferences.getOldDeclaration().equals(codeDifferences.getNewDeclaration())) {
                    this.indent().append("<modified-declaration>").eol();
                    this.raiseIndent();
                    this.indent().append("<old-declaration").append(this.breakdownDeclaration((Method_info)codeDifferences.getOldFeature())).append(">").append(codeDifferences.getOldDeclaration()).append("</old-declaration>").eol();
                    this.indent().append("<new-declaration").append(this.breakdownDeclaration((Method_info)codeDifferences.getNewFeature())).append(">").append(codeDifferences.getNewDeclaration()).append("</new-declaration>").eol();
                    this.lowerIndent();
                    this.indent().append("</modified-declaration>").eol();
                }
                if (codeDifferences.isCodeDifference()) {
                    this.indent().append("<modified-code").append(this.breakdownDeclaration((Method_info)codeDifferences.getNewFeature())).append(">").append(codeDifferences.getNewDeclaration()).append("</modified-code>").eol();
                }
                this.lowerIndent();
                this.indent().append("</feature>").eol();
            }
            this.lowerIndent();
            this.indent().append("</modified-methods>").eol();
        }
        if (this.undeprecatedFields.size() != 0) {
            this.indent().append("<undeprecated-fields>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.undeprecatedFields) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Field_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</undeprecated-fields>").eol();
        }
        if (this.undeprecatedConstructors.size() != 0) {
            this.indent().append("<undeprecated-constructors>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.undeprecatedConstructors) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</undeprecated-constructors>").eol();
        }
        if (this.undeprecatedMethods.size() != 0) {
            this.indent().append("<undeprecated-methods>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.undeprecatedMethods) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</undeprecated-methods>").eol();
        }
        if (this.newFields.size() != 0) {
            this.indent().append("<new-fields>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.newFields) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Field_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getNewDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</new-fields>").eol();
        }
        if (this.newConstructors.size() != 0) {
            this.indent().append("<new-constructors>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.newConstructors) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getNewDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</new-constructors>").eol();
        }
        if (this.newMethods.size() != 0) {
            this.indent().append("<new-methods>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.newMethods) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getNewDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</new-methods>").eol();
        }
        this.lowerIndent();
        this.indent().append("</class>").eol();
        return super.toString();
    }

    private String breakdownDeclaration(Classfile element) {
        StringBuffer result = new StringBuffer();
        if (element != null) {
            if (element.isPublic()) {
                result.append(" visibility=\"public\"");
            }
            if (element.isPackage()) {
                result.append(" visibility=\"package\"");
            }
            if (element.isFinal()) {
                result.append(" final=\"yes\"");
            }
            if (element.isSuper()) {
                result.append(" super=\"yes\"");
            }
            if (element.isSynthetic()) {
                result.append(" synthetic=\"yes\"");
            }
            if (element.isDeprecated()) {
                result.append(" deprecated=\"yes\"");
            }
            result.append(" name=\"").append(element.getClassName()).append("\"");
            if (element.isInterface()) {
                result.append(" interface=\"yes\"");
                result.append(" extends=\"");
                Iterator<Class_info> i = element.getAllInterfaces().iterator();
                while (i.hasNext()) {
                    result.append(i.next());
                    if (!i.hasNext()) continue;
                    result.append(", ");
                }
                result.append("\"");
            } else {
                if (element.isAbstract()) {
                    result.append(" abstract=\"yes\"");
                }
                result.append(" extends=\"").append(element.getSuperclassName()).append("\"");
                result.append(" implements=\"");
                Iterator<Class_info> i = element.getAllInterfaces().iterator();
                while (i.hasNext()) {
                    result.append(i.next());
                    if (!i.hasNext()) continue;
                    result.append(", ");
                }
                result.append("\"");
            }
        }
        return result.toString();
    }

    private String breakdownDeclaration(Field_info element) {
        StringBuffer result = new StringBuffer();
        if (element != null) {
            if (element.isPublic()) {
                result.append(" visibility=\"public\"");
            }
            if (element.isProtected()) {
                result.append(" visibility=\"protected\"");
            }
            if (element.isPackage()) {
                result.append(" visibility=\"package\"");
            }
            if (element.isPrivate()) {
                result.append(" visibility=\"private\"");
            }
            if (element.isStatic()) {
                result.append(" static=\"yes\"");
            }
            if (element.isFinal()) {
                result.append(" final=\"yes\"");
            }
            if (element.isVolatile()) {
                result.append(" volatile=\"yes\"");
            }
            if (element.isTransient()) {
                result.append(" transient=\"yes\"");
            }
            if (element.isSynthetic()) {
                result.append(" synthetic=\"yes\"");
            }
            if (element.isDeprecated()) {
                result.append(" deprecated=\"yes\"");
            }
            result.append(" type=\"").append(element.getType()).append("\"");
            result.append(" name=\"").append(element.getName()).append("\"");
            result.append(" signature=\"").append(element.getSignature()).append("\"");
            result.append(" full-signature=\"").append(element.getFullSignature()).append("\"");
            if (element.getConstantValue() != null) {
                result.append(" value=\"").append(element.getConstantValue().getRawValue()).append("\"");
            }
        }
        return result.toString();
    }

    private String breakdownDeclaration(Method_info element) {
        StringBuffer result = new StringBuffer();
        if (element != null) {
            if (element.isPublic()) {
                result.append(" visibility=\"public\"");
            }
            if (element.isProtected()) {
                result.append(" visibility=\"protected\"");
            }
            if (element.isPackage()) {
                result.append(" visibility=\"package\"");
            }
            if (element.isPrivate()) {
                result.append(" visibility=\"private\"");
            }
            if (element.isStatic()) {
                result.append(" static=\"yes\"");
            }
            if (element.isFinal()) {
                result.append(" final=\"yes\"");
            }
            if (element.isSynchronized()) {
                result.append(" synchronized=\"yes\"");
            }
            if (element.isNative()) {
                result.append(" native=\"yes\"");
            }
            if (element.isAbstract()) {
                result.append(" abstract=\"yes\"");
            }
            if (element.isStrict()) {
                result.append(" strict=\"yes\"");
            }
            if (element.isSynthetic()) {
                result.append(" synthetic=\"yes\"");
            }
            if (element.isDeprecated()) {
                result.append(" deprecated=\"yes\"");
            }
            if (!element.getName().equals("<init>") && !element.getName().equals("<clinit>")) {
                result.append(" return-type=\"").append(element.getReturnType()).append("\"");
            }
            result.append(" signature=\"").append(element.getSignature()).append("\"");
            result.append(" full-signature=\"").append(element.getFullSignature()).append("\"");
            result.append(" throws=\"");
            Iterator i = element.getExceptions().iterator();
            while (i.hasNext()) {
                result.append(i.next());
                if (!i.hasNext()) continue;
                result.append(", ");
            }
            result.append("\"");
        }
        return result.toString();
    }

    public int compareTo(Object other) {
        int result = 0;
        if (!(other instanceof ClassReport)) {
            throw new ClassCastException("Unable to compare ClassReport to " + other.getClass().getName());
        }
        result = this.differences.compareTo(((ClassReport)other).differences);
        return result;
    }
}

