/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Deprecatable;
import com.jeantessier.classreader.Feature_info;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.diff.DifferenceStrategy;
import com.jeantessier.diff.DifferenceStrategyDecorator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class APIDifferenceStrategy
extends DifferenceStrategyDecorator {
    public APIDifferenceStrategy(DifferenceStrategy delegate) {
        super(delegate);
    }

    public boolean isClassDifferent(Classfile oldClass, Classfile newClass) {
        return this.isRemoved(oldClass, newClass) || this.isNew(oldClass, newClass) || this.isClassModified(oldClass, newClass);
    }

    protected boolean isClassModified(Classfile oldClass, Classfile newClass) {
        return this.isDeclarationModified(oldClass, newClass) || this.isDeprecationModified(oldClass, newClass) || this.checkForDifferentFeatures(oldClass, newClass);
    }

    public boolean isDeclarationModified(Classfile oldClass, Classfile newClass) {
        return !oldClass.getDeclaration().equals(newClass.getDeclaration());
    }

    private boolean checkForDifferentFeatures(Classfile oldClass, Classfile newClass) {
        return this.checkForDifferentFields(oldClass, newClass) || this.checkForDifferentMethods(oldClass, newClass);
    }

    private boolean checkForDifferentFields(Classfile oldClass, Classfile newClass) {
        boolean result = false;
        HashSet<String> fieldNameSet = new HashSet<String>();
        Iterator<Field_info> fields = oldClass.getAllFields().iterator();
        while (fields.hasNext()) {
            fieldNameSet.add(fields.next().getName());
        }
        fields = newClass.getAllFields().iterator();
        while (fields.hasNext()) {
            fieldNameSet.add(fields.next().getName());
        }
        Iterator fieldNames = fieldNameSet.iterator();
        while (!result && fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            Field_info oldField = oldClass.getField(fieldName);
            Field_info newField = newClass.getField(fieldName);
            result = this.isFieldDifferent(oldField, newField);
        }
        return result;
    }

    private boolean checkForDifferentMethods(Classfile oldClass, Classfile newClass) {
        boolean result = false;
        HashSet<String> methodSignatureSet = new HashSet<String>();
        Iterator<Method_info> methods = oldClass.getAllMethods().iterator();
        while (methods.hasNext()) {
            methodSignatureSet.add(methods.next().getSignature());
        }
        methods = newClass.getAllMethods().iterator();
        while (methods.hasNext()) {
            methodSignatureSet.add(methods.next().getSignature());
        }
        Iterator methodSignatures = methodSignatureSet.iterator();
        while (!result && methodSignatures.hasNext()) {
            String methodSignature = (String)methodSignatures.next();
            Method_info oldMethod = oldClass.getMethod(methodSignature);
            Method_info newMethod = newClass.getMethod(methodSignature);
            result = this.isMethodDifferent(oldMethod, newMethod);
        }
        return result;
    }

    public boolean isFieldDifferent(Field_info oldField, Field_info newField) {
        return this.isRemoved(oldField, newField) || this.isNew(oldField, newField) || this.isDeprecationModified(oldField, newField) || this.isDeclarationModified(oldField, newField) || this.isConstantValueDifferent(oldField.getConstantValue(), newField.getConstantValue());
    }

    public boolean isMethodDifferent(Method_info oldMethod, Method_info newMethod) {
        return this.isRemoved(oldMethod, newMethod) || this.isNew(oldMethod, newMethod) || this.isDeprecationModified(oldMethod, newMethod) || this.isDeclarationModified(oldMethod, newMethod) || this.isCodeDifferent(oldMethod.getCode(), newMethod.getCode());
    }

    protected boolean isRemoved(Object oldElement, Object newElement) {
        return oldElement != null && newElement == null;
    }

    protected boolean isDeprecationModified(Deprecatable oldItem, Deprecatable newItem) {
        return oldItem.isDeprecated() != newItem.isDeprecated();
    }

    private boolean isDeclarationModified(Feature_info oldFeature, Feature_info newFeature) {
        return !oldFeature.getDeclaration().equals(newFeature.getDeclaration());
    }

    protected boolean isNew(Object oldElement, Object newElement) {
        return oldElement == null && newElement != null;
    }

    public boolean isPackageDifferent(Map oldPackage, Map newPackage) {
        return this.isPackageRemoved(oldPackage, newPackage) || this.isPackageNew(oldPackage, newPackage) || this.isPackageModified(oldPackage, newPackage);
    }

    protected boolean isPackageRemoved(Map oldPackage, Map newPackage) {
        return !oldPackage.isEmpty() && newPackage.isEmpty();
    }

    protected boolean isPackageNew(Map oldPackage, Map newPackage) {
        return oldPackage.isEmpty() && !newPackage.isEmpty();
    }

    protected boolean isPackageModified(Map oldPackage, Map newPackage) {
        return oldPackage.size() != newPackage.size() || this.checkForDifferentClasses(oldPackage, newPackage);
    }

    private boolean checkForDifferentClasses(Map oldPackage, Map newPackage) {
        boolean result = false;
        HashSet classNames = new HashSet();
        classNames.addAll(oldPackage.keySet());
        classNames.addAll(newPackage.keySet());
        Iterator i = classNames.iterator();
        while (!result && i.hasNext()) {
            String className = (String)i.next();
            Classfile oldClass = (Classfile)oldPackage.get(className);
            Classfile newClass = (Classfile)newPackage.get(className);
            result = this.isClassDifferent(oldClass, newClass);
        }
        return result;
    }
}

