/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.webwork;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.ClassfileLoaderEventSource;
import com.jeantessier.classreader.ModifiedOnlyDispatcher;
import com.jeantessier.classreader.Monitor;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.dependency.CodeDependencyCollector;
import com.jeantessier.dependency.DeletingVisitor;
import com.jeantessier.dependency.LinkMaximizer;
import com.jeantessier.dependency.LinkMinimizer;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependencyfinder.NullPrintWriter;
import com.jeantessier.dependencyfinder.webwork.ActionBase;
import com.jeantessier.dependencyfinder.webwork.VerboseListener;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.servlet.http.HttpServletResponse;
import org.apache.oro.text.perl.Perl5Util;

public class ExtractAction
extends ActionBase
implements ServletResponseAware {
    private boolean update;
    private PrintWriter out = new NullPrintWriter();

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean getUpdate() {
        return this.update;
    }

    public void setServletResponse(HttpServletResponse response) {
        try {
            this.out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String execute() throws Exception {
        return "success";
    }

    public String doDefault() {
        return "input";
    }

    public String doUpdate() {
        Date start = new Date();
        this.extractGraph();
        Date stop = new Date();
        double duration = (double)(stop.getTime() - start.getTime()) / 1000.0;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.application.put("updateStart", formatter.format(start));
        this.application.put("updateDuration", duration);
        this.application.remove("loadStart");
        this.application.remove("loadDuration");
        return "success";
    }

    public String doExtract() {
        Date start = new Date();
        this.dispatcher = new ModifiedOnlyDispatcher(ClassfileLoaderEventSource.DEFAULT_DISPATCHER);
        this.factory = new NodeFactory();
        CodeDependencyCollector collector = new CodeDependencyCollector(this.factory);
        DeletingVisitor deletingVisitor = new DeletingVisitor(this.factory);
        this.monitor = new Monitor(collector, deletingVisitor);
        this.extractGraph();
        Date stop = new Date();
        double duration = (double)(stop.getTime() - start.getTime()) / 1000.0;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.application.put("dispatcher", this.dispatcher);
        this.application.put("factory", this.factory);
        this.application.put("monitor", this.monitor);
        this.application.put("extractStart", formatter.format(start));
        this.application.put("extractDuration", duration);
        this.application.remove("updateStart");
        this.application.remove("updateDuration");
        this.application.remove("loadStart");
        this.application.remove("loadDuration");
        return "success";
    }

    private void extractGraph() {
        Perl5Util perl = new Perl5Util();
        LinkedList<String> sources = new LinkedList<String>();
        perl.split(sources, "/,\\s*/", this.source);
        VerboseListener listener = new VerboseListener(this.out);
        TransientClassfileLoader loader = new TransientClassfileLoader(this.dispatcher);
        ((ClassfileLoader)loader).addLoadListener(listener);
        ((ClassfileLoader)loader).addLoadListener(this.monitor);
        loader.load(sources);
        if ("maximize".equalsIgnoreCase(this.mode)) {
            listener.print("Maximizing ...");
            new LinkMaximizer().traverseNodes(this.factory.getPackages().values());
        } else if ("minimize".equalsIgnoreCase(this.mode)) {
            listener.print("Minimizing ...");
            new LinkMinimizer().traverseNodes(this.factory.getPackages().values());
        }
    }
}

