/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.dependency.DependencyEvent;
import com.jeantessier.dependency.DependencyListener;
import com.jeantessier.dependency.LinkMaximizer;
import com.jeantessier.dependency.LinkMinimizer;
import com.jeantessier.dependency.NodeLoader;
import com.jeantessier.dependencyfinder.gui.DependencyFinder;
import com.jeantessier.dependencyfinder.gui.XMLFileFilter;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.ProgressMonitorInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class OpenFileAction
extends AbstractAction
implements Runnable,
DependencyListener {
    private DependencyFinder model;
    private File file;

    public OpenFileAction(DependencyFinder model) {
        this.model = model;
        this.putValue("LongDescription", "Load dependency graph from XML file");
        this.putValue("Name", "Open");
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/openfile.gif")));
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new XMLFileFilter());
        int returnValue = chooser.showOpenDialog(this.model);
        if (returnValue == 0) {
            this.file = chooser.getSelectedFile();
            new Thread(this).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.model.setNewDependencyGraph();
        this.model.addInputFile(this.file);
        try {
            Date start = new Date();
            String filename = this.file.getCanonicalPath();
            NodeLoader loader = new NodeLoader(this.model.getNodeFactory());
            loader.addDependencyListener(this);
            this.model.getStatusLine().showInfo("Loading " + filename + " ...");
            ProgressMonitorInputStream in = new ProgressMonitorInputStream(this.model, "Reading " + filename, new FileInputStream(filename));
            in.getProgressMonitor().setMillisToDecideToPopup(0);
            loader.load(in);
            this.model.setTitle("Dependency Finder - " + filename);
            if (this.model.getMaximize()) {
                this.model.getStatusLine().showInfo("Maximizing ...");
                new LinkMaximizer().traverseNodes(this.model.getPackages());
            } else if (this.model.getMinimize()) {
                this.model.getStatusLine().showInfo("Minimizing ...");
                new LinkMinimizer().traverseNodes(this.model.getPackages());
            }
            Date stop = new Date();
            this.model.getStatusLine().showInfo("Done (" + (double)(stop.getTime() - start.getTime()) / 1000.0 + " secs).");
        }
        catch (SAXException ex) {
            this.model.getStatusLine().showError("Cannot parse: " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        catch (ParserConfigurationException ex) {
            this.model.getStatusLine().showError("Cannot parse: " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        catch (IOException ex) {
            this.model.getStatusLine().showError("Cannot load: " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        finally {
            if (this.model.getPackages() == null) {
                this.model.setTitle("Dependency Finder");
            }
        }
    }

    public void beginSession(DependencyEvent event) {
    }

    public void beginClass(DependencyEvent event) {
        this.model.getStatusLine().showInfo("Loading dependencies for " + event.getClassName() + " ...");
    }

    public void dependency(DependencyEvent event) {
    }

    public void endClass(DependencyEvent event) {
    }

    public void endSession(DependencyEvent event) {
    }
}

