/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.commandline.CommandLine;
import com.jeantessier.commandline.CommandLineUsage;
import com.jeantessier.commandline.NullParameterStrategy;
import com.jeantessier.dependencyfinder.gui.AboutAction;
import com.jeantessier.dependencyfinder.gui.ExitAction;
import com.jeantessier.dependencyfinder.gui.FilterActionListener;
import com.jeantessier.dependencyfinder.gui.MeasurementTableCellRenderer;
import com.jeantessier.dependencyfinder.gui.MetricsExtractAction;
import com.jeantessier.dependencyfinder.gui.NewMetricsAction;
import com.jeantessier.dependencyfinder.gui.OOMetricsTableModel;
import com.jeantessier.dependencyfinder.gui.StatusLine;
import com.jeantessier.dependencyfinder.gui.TableHeaderListener;
import com.jeantessier.dependencyfinder.gui.WindowKiller;
import com.jeantessier.metrics.MetricsConfigurationLoader;
import com.jeantessier.metrics.MetricsFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class OOMetrics
extends JFrame {
    private static final TableCellRenderer RENDERER = new MeasurementTableCellRenderer();
    private MetricsFactory factory;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenu helpMenu = new JMenu();
    private JToolBar toolbar = new JToolBar();
    private JTextArea projectArea = new JTextArea();
    private JButton filterButton = new JButton("Filter:");
    private JTextField filterField = new JTextField("//");
    private StatusLine statusLine = new StatusLine(420);
    private JProgressBar progressBar = new JProgressBar();
    private OOMetricsTableModel groupsModel;
    private OOMetricsTableModel classesModel;
    private OOMetricsTableModel methodsModel;
    private File inputFile = new File(".");

    public OOMetrics(MetricsFactory factory) {
        this.factory = factory;
        this.setSize(new Dimension(800, 600));
        this.setTitle("OO Metrics");
        this.setIconImage(new ImageIcon(this.getClass().getResource("icons/logoicon.gif")).getImage());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowKiller());
        this.groupsModel = new OOMetricsTableModel(factory.getConfiguration().getGroupMeasurements());
        this.classesModel = new OOMetricsTableModel(factory.getConfiguration().getClassMeasurements());
        this.methodsModel = new OOMetricsTableModel(factory.getConfiguration().getMethodMeasurements());
        this.buildMenus();
        this.buildUI();
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception ex) {
            Logger.getLogger(OOMetrics.class).error((Object)"Unable to set look and feel", (Throwable)ex);
        }
        this.statusLine.showInfo("Ready.");
    }

    MetricsFactory getMetricsFactory() {
        return this.factory;
    }

    void setMetricsFactory(MetricsFactory factory) {
        this.factory = factory;
    }

    JTextArea getProjectArea() {
        return this.projectArea;
    }

    OOMetricsTableModel getGroupsModel() {
        return this.groupsModel;
    }

    OOMetricsTableModel getClassesModel() {
        return this.classesModel;
    }

    OOMetricsTableModel getMethodsModel() {
        return this.methodsModel;
    }

    File getInputFile() {
        return this.inputFile;
    }

    void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    JTextComponent getFilterField() {
        return this.filterField;
    }

    StatusLine getStatusLine() {
        return this.statusLine;
    }

    JProgressBar getProgressBar() {
        return this.progressBar;
    }

    private void buildMenus() {
        this.buildFileMenu();
        this.buildHelpMenu();
        this.setJMenuBar(this.menuBar);
    }

    private void buildFileMenu() {
        this.menuBar.add(this.fileMenu);
        this.fileMenu.setText("File");
        AbstractAction action = new MetricsExtractAction(this);
        JMenuItem menuItem = this.fileMenu.add(action);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        menuItem.setMnemonic('e');
        JButton button = this.toolbar.add(action);
        button.setToolTipText((String)action.getValue("LongDescription"));
        this.toolbar.addSeparator();
        this.fileMenu.addSeparator();
        action = new NewMetricsAction(this);
        menuItem = this.fileMenu.add(action);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        menuItem.setMnemonic('n');
        button = this.toolbar.add(action);
        button.setToolTipText((String)action.getValue("LongDescription"));
        this.toolbar.addSeparator();
        this.fileMenu.addSeparator();
        action = new ExitAction(this);
        menuItem = this.fileMenu.add(action);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menuItem.setMnemonic('x');
        this.setJMenuBar(this.menuBar);
    }

    private void buildHelpMenu() {
        this.menuBar.add(this.helpMenu);
        this.helpMenu.setText("Help");
        AboutAction action = new AboutAction(this);
        JMenuItem menuItem = this.helpMenu.add(action);
        menuItem.setMnemonic('a');
    }

    private void buildUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildControlPanel(), "North");
        this.getContentPane().add((Component)this.buildResultPanel(), "Center");
        this.getContentPane().add((Component)this.buildStatusPanel(), "South");
    }

    private JComponent buildControlPanel() {
        return this.toolbar;
    }

    private JComponent buildResultPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        result.add((Component)new JSplitPane(0, this.buildProjectPanel(), this.buildChartsPanel()), "Center");
        result.add((Component)this.buildFilterPanel(), "South");
        return result;
    }

    private JComponent buildProjectPanel() {
        JScrollPane result = new JScrollPane(this.projectArea);
        this.projectArea.setEditable(false);
        return result;
    }

    private JComponent buildChartsPanel() {
        JTabbedPane result = new JTabbedPane();
        result.addTab("Groups", this.buildGroupsChartPanel());
        result.addTab("Classes", this.buildClassesChartPanel());
        result.addTab("Methods", this.buildMethodsChartPanel());
        return result;
    }

    private JComponent buildGroupsChartPanel() {
        return this.buildChartPanel(this.getGroupsModel());
    }

    private JComponent buildClassesChartPanel() {
        return this.buildChartPanel(this.getClassesModel());
    }

    private JComponent buildMethodsChartPanel() {
        return this.buildChartPanel(this.getMethodsModel());
    }

    private JComponent buildChartPanel(OOMetricsTableModel model) {
        JTable table = new JTable(model);
        table.setAutoResizeMode(0);
        table.setRowSelectionAllowed(true);
        table.setDefaultRenderer(Object.class, RENDERER);
        table.setShowHorizontalLines(false);
        table.setShowVerticalLines(false);
        TableHeaderListener listener = new TableHeaderListener(table, model);
        table.getTableHeader().addMouseListener(listener);
        table.getTableHeader().addMouseMotionListener(listener);
        JScrollPane result = new JScrollPane(table);
        return result;
    }

    private JComponent buildFilterPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        result.add((Component)this.filterButton, "West");
        result.add((Component)this.filterField, "Center");
        this.filterButton.addActionListener(new FilterActionListener(this));
        return result;
    }

    private JComponent buildStatusPanel() {
        JPanel result = new JPanel();
        Dimension size = this.getProgressBar().getPreferredSize();
        size.width = 100;
        this.getProgressBar().setPreferredSize(size);
        this.getProgressBar().setBorder(BorderFactory.createBevelBorder(1));
        result.setLayout(new BorderLayout());
        result.add((Component)this.getStatusLine(), "Center");
        result.add((Component)this.getProgressBar(), "East");
        return result;
    }

    public static void showError(CommandLineUsage clu, String msg) {
        System.err.println(msg);
        OOMetrics.showError(clu);
    }

    public static void showError(CommandLineUsage clu) {
        System.err.println(clu);
    }

    public static void main(String[] args) throws Exception {
        CommandLine commandLine = new CommandLine(new NullParameterStrategy());
        commandLine.addSingleValueSwitch("default-configuration", true);
        commandLine.addSingleValueSwitch("configuration");
        commandLine.addToggleSwitch("validate");
        commandLine.addToggleSwitch("help");
        CommandLineUsage usage = new CommandLineUsage("OOMetrics");
        commandLine.accept(usage);
        try {
            commandLine.parse(args);
        }
        catch (IllegalArgumentException ex) {
            OOMetrics.showError(usage, ex.toString());
            System.exit(1);
        }
        if (commandLine.getToggleSwitch("help")) {
            OOMetrics.showError(usage);
            System.exit(1);
        }
        MetricsFactory factory = commandLine.isPresent("configuration") ? new MetricsFactory("Project", new MetricsConfigurationLoader(commandLine.getToggleSwitch("validate")).load(commandLine.getSingleSwitch("configuration"))) : new MetricsFactory("Project", new MetricsConfigurationLoader(commandLine.getToggleSwitch("validate")).load(commandLine.getSingleSwitch("default-configuration")));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        OOMetrics model = new OOMetrics(factory);
        model.setVisible(true);
    }
}

