/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.dependencyfinder.gui.OOMetrics;
import com.jeantessier.metrics.Metrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.JOptionPane;
import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.Perl5Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterActionListener
implements Runnable,
ActionListener {
    private static final Perl5Util perl = new Perl5Util();
    private OOMetrics model;

    public FilterActionListener(OOMetrics model) {
        this.model = model;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        new Thread(this).start();
    }

    @Override
    public void run() {
        try {
            Date start = new Date();
            this.model.getStatusLine().showInfo("Filtering ...");
            this.model.getGroupsModel().updateMetrics(this.getFilterMetrics(this.model.getMetricsFactory().getGroupMetrics()));
            this.model.getClassesModel().updateMetrics(this.getFilterMetrics(this.model.getMetricsFactory().getClassMetrics()));
            this.model.getMethodsModel().updateMetrics(this.getFilterMetrics(this.model.getMetricsFactory().getMethodMetrics()));
            Date stop = new Date();
            this.model.getStatusLine().showInfo("Done (" + (double)(stop.getTime() - start.getTime()) / 1000.0 + " secs).");
            this.model.setTitle("OO Metrics - Extractor");
        }
        catch (MalformedPerl5PatternException ex) {
            JOptionPane.showMessageDialog(this.model, ex.getMessage(), "Malformed pattern", 0);
            this.model.getStatusLine().showInfo("Ready.");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.model, ex.getMessage(), "Error", 0);
            this.model.getStatusLine().showInfo("Ready.");
        }
    }

    private Collection<Metrics> getFilterMetrics(Collection<Metrics> metricsList) {
        ArrayList<Metrics> result = new ArrayList<Metrics>(metricsList.size());
        for (Metrics metrics : metricsList) {
            if (!perl.match(this.model.getFilterField().getText(), metrics.getName())) continue;
            result.add(metrics);
        }
        return result;
    }
}

