/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.dependencyfinder.gui.DependencyFinder;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.oro.text.perl.MalformedPerl5PatternException;

public class DependencyQueryAction
extends AbstractAction
implements Runnable {
    private DependencyFinder model = null;

    public DependencyQueryAction(DependencyFinder model) {
        this.model = model;
        this.putValue("LongDescription", "Show dependency graph");
        this.putValue("Name", "Dependency");
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/dependency-query.gif")));
    }

    public void actionPerformed(ActionEvent e) {
        new Thread(this).start();
    }

    public void run() {
        try {
            this.model.getStatusLine().showInfo("Processing dependency query ...");
            Date start = new Date();
            this.model.clearDependencyResult();
            this.model.doDependencyQuery();
            Date stop = new Date();
            this.model.getStatusLine().showInfo("Dependency query done (" + (double)(stop.getTime() - start.getTime()) / 1000.0 + " secs).");
        }
        catch (MalformedPerl5PatternException ex) {
            JOptionPane.showMessageDialog(this.model, ex.getMessage(), "Malformed pattern", 0);
            this.model.getStatusLine().showInfo("Ready.");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.model, ex.getMessage(), "Error", 0);
            this.model.getStatusLine().showInfo("Ready.");
        }
    }
}

