/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.classreader.SymbolGatherer;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependencyfinder.cli.Command;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSymbols
extends Command {
    public ListSymbols() throws CommandLineException {
        super("ListSymbols");
    }

    @Override
    protected void showSpecificUsage(PrintStream out) {
        out.println();
        out.println("If no files are specified, it processes the current directory.");
        out.println();
    }

    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.getCommandLine().addToggleSwitch("class-names");
        this.getCommandLine().addToggleSwitch("field-names");
        this.getCommandLine().addToggleSwitch("method-names");
        this.getCommandLine().addToggleSwitch("local-names");
    }

    @Override
    protected Collection<CommandLineException> parseCommandLine(String[] args) {
        Collection<CommandLineException> exceptions = super.parseCommandLine(args);
        if (!(this.getCommandLine().isPresent("class-names") || this.getCommandLine().isPresent("field-names") || this.getCommandLine().isPresent("method-names") || this.getCommandLine().isPresent("local-names"))) {
            this.getCommandLine().getSwitch("class-names").setValue(true);
            this.getCommandLine().getSwitch("field-names").setValue(true);
            this.getCommandLine().getSwitch("method-names").setValue(true);
            this.getCommandLine().getSwitch("local-names").setValue(true);
        }
        return exceptions;
    }

    @Override
    protected void doProcessing() throws Exception {
        List<String> parameters = this.getCommandLine().getParameters();
        if (parameters.size() == 0) {
            parameters.add(".");
        }
        SymbolGatherer collector = new SymbolGatherer();
        collector.setCollectingClassNames(this.getCommandLine().getToggleSwitch("class-names"));
        collector.setCollectingFieldNames(this.getCommandLine().getToggleSwitch("field-names"));
        collector.setCollectingMethodNames(this.getCommandLine().getToggleSwitch("method-names"));
        collector.setCollectingLocalNames(this.getCommandLine().getToggleSwitch("local-names"));
        TransientClassfileLoader loader = new TransientClassfileLoader();
        ((ClassfileLoader)loader).addLoadListener(new LoadListenerVisitorAdapter(collector));
        ((ClassfileLoader)loader).addLoadListener(this.getVerboseListener());
        loader.load(parameters);
        for (String symbol : collector.getCollection()) {
            this.out.println(symbol);
        }
    }

    public static void main(String[] args) throws Exception {
        new ListSymbols().run(args);
    }
}

