/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependencyfinder.cli.Command;
import com.jeantessier.diff.ListDiffPrinter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.TreeSet;

public class ListDiff
extends Command {
    public ListDiff() throws CommandLineException {
        super("ListDiff");
    }

    protected void showSpecificUsage(PrintStream out) {
        out.println();
        out.println("Defaults is text output to the console.");
        out.println();
    }

    public static void main(String[] args) throws Exception {
        new ListDiff().run(args);
    }

    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput("utf-8", "http://depfind.sourceforge.net/dtd");
        this.getCommandLine().addSingleValueSwitch("name");
        this.getCommandLine().addSingleValueSwitch("old-label");
        this.getCommandLine().addSingleValueSwitch("old", true);
        this.getCommandLine().addSingleValueSwitch("new-label");
        this.getCommandLine().addSingleValueSwitch("new", true);
        this.getCommandLine().addToggleSwitch("compress");
    }

    protected void doProcessing() throws Exception {
        String line;
        this.getVerboseListener().print("Loading old list ...");
        TreeSet<String> oldAPI = new TreeSet<String>();
        BufferedReader oldIn = new BufferedReader(new FileReader(this.getCommandLine().getSingleSwitch("old")));
        while ((line = oldIn.readLine()) != null) {
            oldAPI.add(line);
        }
        this.getVerboseListener().print("Loading new list ...");
        TreeSet<String> newAPI = new TreeSet<String>();
        BufferedReader newIn = new BufferedReader(new FileReader(this.getCommandLine().getSingleSwitch("new")));
        while ((line = newIn.readLine()) != null) {
            newAPI.add(line);
        }
        ListDiffPrinter printer = new ListDiffPrinter(this.getCommandLine().getToggleSwitch("compress"), this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix"));
        printer.setName(this.getCommandLine().getSingleSwitch("name"));
        printer.setOldVersion(this.getCommandLine().getSingleSwitch("old-label"));
        printer.setNewVersion(this.getCommandLine().getSingleSwitch("new-label"));
        if (this.getCommandLine().isPresent("indent-text")) {
            printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        this.getVerboseListener().print("Computing removed elements ...");
        for (String name : oldAPI) {
            if (newAPI.contains(name)) continue;
            printer.remove(name);
        }
        this.getVerboseListener().print("Computing added elements ...");
        for (String name : newAPI) {
            if (oldAPI.contains(name)) continue;
            printer.add(name);
        }
        this.getVerboseListener().print("Printing results ...");
        this.out.print(printer);
    }
}

