/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.AggregatingClassfileLoader;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.PackageMapper;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependencyfinder.cli.DiffCommand;
import com.jeantessier.diff.DifferenceStrategy;
import com.jeantessier.diff.Differences;
import com.jeantessier.diff.DifferencesFactory;
import com.jeantessier.diff.ListBasedDifferenceStrategy;
import com.jeantessier.diff.Report;
import org.apache.log4j.Logger;

public class JarJarDiff
extends DiffCommand {
    public JarJarDiff() throws CommandLineException {
        super("JarJarDiff");
    }

    protected void doProcessing() throws Exception {
        PackageMapper oldPackages = new PackageMapper();
        AggregatingClassfileLoader oldJar = new AggregatingClassfileLoader();
        ((ClassfileLoader)oldJar).addLoadListener(oldPackages);
        ((ClassfileLoader)oldJar).addLoadListener(this.getVerboseListener());
        oldJar.load(this.getCommandLine().getMultipleSwitch("old"));
        PackageMapper newPackages = new PackageMapper();
        AggregatingClassfileLoader newJar = new AggregatingClassfileLoader();
        ((ClassfileLoader)newJar).addLoadListener(newPackages);
        ((ClassfileLoader)newJar).addLoadListener(this.getVerboseListener());
        newJar.load(this.getCommandLine().getMultipleSwitch("new"));
        DifferenceStrategy baseStrategy = this.getBaseStrategy(this.getCommandLine().getToggleSwitch("code"));
        DifferenceStrategy strategy = this.getStrategy(this.getCommandLine().getSingleSwitch("level"), baseStrategy);
        if (this.getCommandLine().isPresent("filter")) {
            strategy = new ListBasedDifferenceStrategy(strategy, this.getCommandLine().getSingleSwitch("filter"));
        }
        Logger.getLogger(this.getClass()).info((Object)"Comparing ...");
        this.getVerboseListener().print("Comparing ...");
        String name = this.getCommandLine().getSingleSwitch("name");
        String oldLabel = this.getCommandLine().isPresent("old-label") ? this.getCommandLine().getSingleSwitch("old-label") : this.getCommandLine().getMultipleSwitch("old").toString();
        String newLabel = this.getCommandLine().isPresent("new-label") ? this.getCommandLine().getSingleSwitch("new-label") : this.getCommandLine().getMultipleSwitch("new").toString();
        DifferencesFactory factory = new DifferencesFactory(strategy);
        Differences differences = factory.createProjectDifferences(name, oldLabel, oldPackages, newLabel, newPackages);
        Logger.getLogger(this.getClass()).info((Object)"Printing results ...");
        this.getVerboseListener().print("Printing results ...");
        Report printer = new Report(this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix"));
        if (this.getCommandLine().isPresent("indent-text")) {
            printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        differences.accept(printer);
        this.out.print(printer);
    }

    public static void main(String[] args) throws Exception {
        new JarJarDiff().run(args);
    }
}

