/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependencyfinder.cli.Command;
import com.jeantessier.diff.APIDifferenceStrategy;
import com.jeantessier.diff.CodeDifferenceStrategy;
import com.jeantessier.diff.DifferenceStrategy;
import com.jeantessier.diff.IncompatibleDifferenceStrategy;
import com.jeantessier.diff.NoDifferenceStrategy;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public abstract class DiffCommand
extends Command {
    public static final String API_STRATEGY = "api";
    public static final String INCOMPATIBLE_STRATEGY = "incompatible";
    public static final String DEFAULT_LEVEL = "api";

    public DiffCommand(String name) throws CommandLineException {
        super(name);
    }

    protected void showSpecificUsage(PrintStream out) {
        out.println();
        out.println("Defaults is text output to the console.");
        out.println();
    }

    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput("utf-8", "http://depfind.sourceforge.net/dtd");
        this.getCommandLine().addSingleValueSwitch("name");
        this.getCommandLine().addMultipleValuesSwitch("old", true);
        this.getCommandLine().addSingleValueSwitch("old-label");
        this.getCommandLine().addMultipleValuesSwitch("new", true);
        this.getCommandLine().addSingleValueSwitch("new-label");
        this.getCommandLine().addSingleValueSwitch("filter");
        this.getCommandLine().addToggleSwitch("code");
        this.getCommandLine().addSingleValueSwitch("level", "api");
    }

    protected DifferenceStrategy getStrategy(String level, DifferenceStrategy baseStrategy) {
        DifferenceStrategy result;
        if ("api".equals(level)) {
            result = new APIDifferenceStrategy(baseStrategy);
        } else if (INCOMPATIBLE_STRATEGY.equals(level)) {
            result = new IncompatibleDifferenceStrategy(baseStrategy);
        } else {
            try {
                try {
                    Constructor<?> constructor = Class.forName(level).getConstructor(DifferenceStrategy.class);
                    result = (DifferenceStrategy)constructor.newInstance(baseStrategy);
                }
                catch (NoSuchMethodException ex) {
                    result = (DifferenceStrategy)Class.forName(level).newInstance();
                }
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(this.getClass()).error((Object)("Unknown level \"" + level + "\", using default level \"" + "api" + "\""), (Throwable)ex);
                result = this.getDefaultStrategy(baseStrategy);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(this.getClass()).error((Object)("Unknown level \"" + level + "\", using default level \"" + "api" + "\""), (Throwable)ex);
                result = this.getDefaultStrategy(baseStrategy);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(this.getClass()).error((Object)("Unknown level \"" + level + "\", using default level \"" + "api" + "\""), (Throwable)ex);
                result = this.getDefaultStrategy(baseStrategy);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(this.getClass()).error((Object)("Unknown level \"" + level + "\", using default level \"" + "api" + "\""), (Throwable)ex);
                result = this.getDefaultStrategy(baseStrategy);
            }
            catch (ClassCastException ex) {
                Logger.getLogger(this.getClass()).error((Object)("Unknown level \"" + level + "\", using default level \"" + "api" + "\""), (Throwable)ex);
                result = this.getDefaultStrategy(baseStrategy);
            }
        }
        return result;
    }

    protected DifferenceStrategy getBaseStrategy(boolean useCode) {
        DifferenceStrategy result = useCode ? new CodeDifferenceStrategy() : new NoDifferenceStrategy();
        return result;
    }

    private DifferenceStrategy getDefaultStrategy(DifferenceStrategy strategy) {
        return new APIDifferenceStrategy(strategy);
    }
}

