/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.commandline.AtLeastParameterStrategy;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.commandline.ParameterStrategy;
import com.jeantessier.dependency.GraphCopier;
import com.jeantessier.dependency.GraphSummarizer;
import com.jeantessier.dependency.LinkMaximizer;
import com.jeantessier.dependency.LinkMinimizer;
import com.jeantessier.dependency.NodeLoader;
import com.jeantessier.dependency.Printer;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.SelectiveTraversalStrategy;
import com.jeantessier.dependency.TextPrinter;
import com.jeantessier.dependency.XMLPrinter;
import com.jeantessier.dependencyfinder.cli.Command;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyReporter
extends Command {
    public DependencyReporter() throws CommandLineException {
        super("DependencyReporter");
    }

    @Override
    protected void showSpecificUsage(PrintStream out) {
        out.println();
        out.println("Default is text output to the console.");
        out.println();
    }

    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput("utf-8", "http://depfind.sourceforge.net/dtd");
        this.populateCommandLineSwitchesForScoping();
        this.populateCommandLineSwitchesForFiltering();
        this.getCommandLine().addAliasSwitch("p2p", "package-scope", "package-filter");
        this.getCommandLine().addAliasSwitch("c2p", "class-scope", "package-filter");
        this.getCommandLine().addAliasSwitch("c2c", "class-scope", "class-filter");
        this.getCommandLine().addAliasSwitch("f2f", "feature-scope", "feature-filter");
        this.getCommandLine().addAliasSwitch("includes", "scope-includes", "filter-includes");
        this.getCommandLine().addAliasSwitch("excludes", "scope-excludes", "filter-excludes");
        this.getCommandLine().addToggleSwitch("show-inbounds");
        this.getCommandLine().addToggleSwitch("show-outbounds");
        this.getCommandLine().addToggleSwitch("show-empty-nodes");
        this.getCommandLine().addToggleSwitch("xml");
        this.getCommandLine().addToggleSwitch("validate");
        this.getCommandLine().addToggleSwitch("minimize");
        this.getCommandLine().addToggleSwitch("maximize");
        this.getCommandLine().addToggleSwitch("copy-only");
    }

    @Override
    protected ParameterStrategy getParameterStrategy() {
        return new AtLeastParameterStrategy(1);
    }

    @Override
    protected Collection<CommandLineException> parseCommandLine(String[] args) {
        Collection<CommandLineException> exceptions = super.parseCommandLine(args);
        exceptions.addAll(this.validateCommandLineForScoping());
        exceptions.addAll(this.validateCommandLineForFiltering());
        if (this.getCommandLine().getToggleSwitch("maximize") && this.getCommandLine().getToggleSwitch("minimize")) {
            exceptions.add(new CommandLineException("Only one of -maximize or -minimize is allowed"));
        }
        return exceptions;
    }

    @Override
    protected void doProcessing() throws Exception {
        SelectionCriteria scopeCriteria = this.getScopeCriteria();
        SelectionCriteria filterCriteria = this.getFilterCriteria();
        GraphCopier copier = this.getCommandLine().getToggleSwitch("copy-only") || this.getCommandLine().getToggleSwitch("maximize") ? new GraphCopier(new SelectiveTraversalStrategy(scopeCriteria, filterCriteria)) : new GraphSummarizer(scopeCriteria, filterCriteria);
        for (String filename : this.getCommandLine().getParameters()) {
            Logger.getLogger(DependencyReporter.class).info((Object)("Reading " + filename));
            this.getVerboseListener().print("Reading " + filename);
            Collection<Object> packages = Collections.emptyList();
            if (filename.endsWith(".xml")) {
                NodeLoader loader = new NodeLoader(this.getCommandLine().getToggleSwitch("validate"));
                loader.addDependencyListener(this.getVerboseListener());
                packages = loader.load(filename).getPackages().values();
            }
            Logger.getLogger(DependencyReporter.class).info((Object)("Read in " + packages.size() + " package(s) from \"" + filename + "\"."));
            if (this.getCommandLine().getToggleSwitch("maximize")) {
                new LinkMaximizer().traverseNodes(packages);
            } else if (this.getCommandLine().getToggleSwitch("minimize")) {
                new LinkMinimizer().traverseNodes(packages);
            }
            copier.traverseNodes(packages);
        }
        Logger.getLogger(DependencyReporter.class).info((Object)("Reporting " + copier.getScopeFactory().getPackages().values().size() + " package(s) ..."));
        this.getVerboseListener().print("Printing the graph ...");
        Printer printer = this.getCommandLine().isPresent("xml") ? new XMLPrinter(this.out, this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix")) : new TextPrinter(this.out);
        if (this.getCommandLine().isPresent("indent-text")) {
            printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        if (this.getCommandLine().isPresent("show-inbounds") || this.getCommandLine().isPresent("show-outbounds") || this.getCommandLine().isPresent("show-empty-nodes")) {
            printer.setShowInbounds(this.getCommandLine().isPresent("show-inbounds"));
            printer.setShowOutbounds(this.getCommandLine().isPresent("show-outbounds"));
            printer.setShowEmptyNodes(this.getCommandLine().isPresent("show-empty-nodes"));
        }
        printer.traverseNodes(copier.getScopeFactory().getPackages().values());
    }

    public static void main(String[] args) throws Exception {
        new DependencyReporter().run(args);
    }
}

