/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.commandline.AtLeastParameterStrategy;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.commandline.ParameterStrategy;
import com.jeantessier.dependency.MetricsGatherer;
import com.jeantessier.dependency.MetricsReport;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.NodeLoader;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.SelectiveTraversalStrategy;
import com.jeantessier.dependencyfinder.cli.Command;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyMetrics
extends Command {
    public DependencyMetrics() throws CommandLineException {
        super("DependencyMetrics");
    }

    @Override
    protected void showSpecificUsage(PrintStream out) {
        out.println();
        out.println("If no files are specified, it processes the current directory.");
        out.println();
        out.println("If file is a directory, it is recusively scanned for files");
        out.println("ending in \".class\".");
        out.println();
        out.println("Default is text output to the console.");
        out.println();
    }

    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForScoping();
        this.populateCommandLineSwitchesForFiltering();
        this.getCommandLine().addAliasSwitch("p2p", "package-scope", "package-filter");
        this.getCommandLine().addAliasSwitch("c2p", "class-scope", "package-filter");
        this.getCommandLine().addAliasSwitch("c2c", "class-scope", "class-filter");
        this.getCommandLine().addAliasSwitch("f2f", "feature-scope", "feature-filter");
        this.getCommandLine().addAliasSwitch("includes", "scope-includes", "filter-includes");
        this.getCommandLine().addAliasSwitch("excludes", "scope-excludes", "filter-excludes");
        this.getCommandLine().addToggleSwitch("list");
        this.getCommandLine().addToggleSwitch("chart-classes-per-package");
        this.getCommandLine().addToggleSwitch("chart-features-per-class");
        this.getCommandLine().addToggleSwitch("chart-inbounds-per-package");
        this.getCommandLine().addToggleSwitch("chart-outbounds-per-package");
        this.getCommandLine().addToggleSwitch("chart-inbounds-per-class");
        this.getCommandLine().addToggleSwitch("chart-outbounds-per-class");
        this.getCommandLine().addToggleSwitch("chart-inbounds-per-feature");
        this.getCommandLine().addToggleSwitch("chart-outbounds-per-feature");
        this.getCommandLine().addAliasSwitch("chart-inbounds", "chart-inbounds-per-package", "chart-inbounds-per-class", "chart-inbounds-per-feature");
        this.getCommandLine().addAliasSwitch("chart-outbounds", "chart-outbounds-per-package", "chart-outbounds-per-class", "chart-outbounds-per-feature");
        this.getCommandLine().addAliasSwitch("chart-packages", "chart-classes-per-package", "chart-inbounds-per-package", "chart-outbounds-per-package");
        this.getCommandLine().addAliasSwitch("chart-classes", "chart-features-per-class", "chart-inbounds-per-class", "chart-outbounds-per-class");
        this.getCommandLine().addAliasSwitch("chart-features", "chart-inbounds-per-feature", "chart-outbounds-per-feature");
        this.getCommandLine().addAliasSwitch("chart-all", "chart-classes-per-package", "chart-features-per-class", "chart-inbounds-per-package", "chart-outbounds-per-package", "chart-inbounds-per-class", "chart-outbounds-per-class", "chart-inbounds-per-feature", "chart-outbounds-per-feature");
        this.getCommandLine().addToggleSwitch("validate");
    }

    @Override
    protected ParameterStrategy getParameterStrategy() {
        return new AtLeastParameterStrategy(1);
    }

    @Override
    protected Collection<CommandLineException> parseCommandLine(String[] args) {
        Collection<CommandLineException> exceptions = super.parseCommandLine(args);
        exceptions.addAll(this.validateCommandLineForScoping());
        exceptions.addAll(this.validateCommandLineForFiltering());
        return exceptions;
    }

    @Override
    public void doProcessing() throws Exception {
        NodeFactory factory = new NodeFactory();
        for (String filename : this.getCommandLine().getParameters()) {
            Logger.getLogger(this.getClass()).info((Object)("Reading " + filename));
            this.getVerboseListener().print("Reading " + filename);
            if (filename.endsWith(".xml")) {
                NodeLoader loader = new NodeLoader(factory, this.getCommandLine().getToggleSwitch("validate"));
                loader.addDependencyListener(this.getVerboseListener());
                loader.load(filename);
            }
            Logger.getLogger(this.getClass()).info((Object)("Read \"" + filename + "\"."));
        }
        MetricsReport reporter = new MetricsReport(this.out);
        reporter.setListingElements(this.getCommandLine().getToggleSwitch("list"));
        reporter.setChartingClassesPerPackage(this.getCommandLine().getToggleSwitch("chart-classes-per-package"));
        reporter.setChartingFeaturesPerClass(this.getCommandLine().getToggleSwitch("chart-features-per-class"));
        reporter.setChartingInboundsPerPackage(this.getCommandLine().getToggleSwitch("chart-inbounds-per-package"));
        reporter.setChartingOutboundsPerPackage(this.getCommandLine().getToggleSwitch("chart-outbounds-per-package"));
        reporter.setChartingInboundsPerClass(this.getCommandLine().getToggleSwitch("chart-inbounds-per-class"));
        reporter.setChartingOutboundsPerClass(this.getCommandLine().getToggleSwitch("chart-outbounds-per-class"));
        reporter.setChartingInboundsPerFeature(this.getCommandLine().getToggleSwitch("chart-inbounds-per-feature"));
        reporter.setChartingOutboundsPerFeature(this.getCommandLine().getToggleSwitch("chart-outbounds-per-feature"));
        SelectionCriteria scopeCriteria = this.getScopeCriteria();
        SelectionCriteria filterCriteria = this.getFilterCriteria();
        Logger.getLogger(this.getClass()).info((Object)("Reporting on " + factory.getPackages().size() + " package(s) ..."));
        this.getVerboseListener().print("Reporting on " + factory.getPackages().size() + " package(s) ...");
        MetricsGatherer metrics = new MetricsGatherer(new SelectiveTraversalStrategy(scopeCriteria, filterCriteria));
        metrics.traverseNodes(factory.getPackages().values());
        reporter.process(metrics);
    }

    public static void main(String[] args) throws Exception {
        new DependencyMetrics().run(args);
    }
}

