/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.commandline.AtLeastParameterStrategy;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.commandline.ParameterStrategy;
import com.jeantessier.dependency.CycleDetector;
import com.jeantessier.dependency.CyclePrinter;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.NodeLoader;
import com.jeantessier.dependency.TextCyclePrinter;
import com.jeantessier.dependency.XMLCyclePrinter;
import com.jeantessier.dependencyfinder.cli.Command;
import com.jeantessier.dependencyfinder.cli.DependencyMetrics;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyCycles
extends Command {
    public DependencyCycles() throws CommandLineException {
        super("DependencyCycles");
    }

    @Override
    protected void showSpecificUsage(PrintStream out) {
        out.println();
        out.println("Default is text output to the console.");
        out.println();
    }

    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput("utf-8", "http://depfind.sourceforge.net/dtd");
        this.populateCommandLineSwitchesForStartCondition();
        this.getCommandLine().addSingleValueSwitch("maximum-cycle-length");
        this.getCommandLine().addToggleSwitch("xml");
        this.getCommandLine().addToggleSwitch("validate");
    }

    @Override
    protected ParameterStrategy getParameterStrategy() {
        return new AtLeastParameterStrategy(1);
    }

    @Override
    protected Collection<CommandLineException> parseCommandLine(String[] args) {
        Collection<CommandLineException> exceptions = super.parseCommandLine(args);
        exceptions.addAll(this.validateCommandLineForScoping());
        return exceptions;
    }

    @Override
    protected void doProcessing() throws Exception {
        NodeFactory factory = new NodeFactory();
        for (String filename : this.getCommandLine().getParameters()) {
            Logger.getLogger(DependencyMetrics.class).info((Object)("Reading " + filename));
            this.getVerboseListener().print("Reading " + filename);
            if (filename.endsWith(".xml")) {
                NodeLoader loader = new NodeLoader(factory, this.getCommandLine().getToggleSwitch("validate"));
                loader.addDependencyListener(this.getVerboseListener());
                loader.load(filename);
            }
            Logger.getLogger(DependencyMetrics.class).info((Object)("Read \"" + filename + "\"."));
        }
        CycleDetector detector = new CycleDetector(this.getStartCriteria());
        if (this.getCommandLine().isPresent("maximum-cycle-length")) {
            detector.setMaximumCycleLength(Integer.parseInt(this.getCommandLine().getSingleSwitch("maximum-cycle-length")));
        }
        detector.traverseNodes(factory.getPackages().values());
        this.getVerboseListener().print("Printing the graph ...");
        CyclePrinter printer = this.getCommandLine().isPresent("xml") ? new XMLCyclePrinter(this.out, this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix")) : new TextCyclePrinter(this.out);
        if (this.getCommandLine().isPresent("indent-text")) {
            printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        printer.visitCycles(detector.getCycles());
    }

    public static void main(String[] args) throws Exception {
        new DependencyCycles().run(args);
    }
}

